/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.mwpm;

import de.cgerlach.macmahon.mwpm.ExploredMatrix;
import de.cgerlach.macmahon.mwpm.Graph;
import de.cgerlach.macmahon.mwpm.Knoten;
import de.cgerlach.macmahon.mwpm.MatrixColumn;
import de.cgerlach.macmahon.mwpm.Tree;
import de.cgerlach.macmahon.mwpm.Vertex;

public class MaximumWeightPerfectMatchingAlgorithm {
    public static boolean s_debug = false;
    public static final int ALG_INNER = 2;
    public static final int ALG_OUTER = 4;
    public static final int ALG_NOEDGE = 0;
    public static final int ALG_NOVERTEX = -1;
    public static final int ALG_HUNGARIAN = 1;
    public static final int ALG_A = 2;
    public static final int ALG_B = 3;
    public static final int ALG_C = 4;
    public static final int ALG_MAPS = 5;
    public static final int ALG_L = 6;
    public static final long MAXWEIGHTRANGE = 0x3FFFFFFFL;
    public static final long MAXWEIGHT = 0xFFFFFFFL;
    private ExploredMatrix m_exploredMatrix = null;
    private MatrixColumn[] m_weightMatrix = null;
    private Graph m_graph = null;
    private int m_maxPlayer = -1;
    private int m_maxBlossoms = -1;
    private int m_maxVertices = -1;

    public void initialize(int number) {
        this.m_maxPlayer = number;
        this.m_maxBlossoms = this.m_maxPlayer >> 1;
        this.m_maxVertices = this.m_maxPlayer + this.m_maxBlossoms + 2;
        this.m_weightMatrix = new MatrixColumn[this.m_maxPlayer];
        int i = 0;
        while (i < this.m_maxPlayer) {
            this.m_weightMatrix[i] = new MatrixColumn(this.m_maxPlayer);
            ++i;
        }
        this.m_exploredMatrix = new ExploredMatrix(this.m_maxPlayer, this.m_maxVertices);
        this.m_graph = new Graph(this.m_maxPlayer, this.m_maxVertices);
    }

    public void setCosts(int i, int j, long costs) {
        this.m_weightMatrix[i].m_c[j] = costs;
        this.m_weightMatrix[j].m_c[i] = costs;
    }

    public long getCosts(int i, int j) {
        return this.m_weightMatrix[i].m_c[j];
    }

    public void updateExploredMatrix(Tree tree) {
        this.m_exploredMatrix.clearExploredMatrix(this.m_graph.getFirstBlossom(), this.m_graph.getLastBlossom());
        Knoten pos = tree.m_root;
        while (pos != null) {
            Knoten pos2 = pos.m_firstChild;
            while (pos2 != null) {
                this.m_exploredMatrix.setExplored(pos.m_label, pos2.m_label);
                pos2 = pos2.m_nextSibling;
            }
            pos = tree.nextKnoten(pos);
        }
    }

    public void augmentGraph() {
        int j;
        int i = this.m_graph.getFirstBlossom();
        while (i < this.m_graph.getLastBlossom()) {
            if (this.m_graph.m_vertexList[i] != null) {
                j = 0;
                while (j < this.m_graph.getNumberOfPlayers()) {
                    this.m_graph.m_vertexList[i].m_edges[j] = 0;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_graph.getNumberOfPlayers()) {
            j = i + 1;
            while (j < this.m_graph.getNumberOfPlayers()) {
                long summe = 0L;
                int k = this.m_graph.getFirstBlossom();
                while (k < this.m_graph.getLastBlossom()) {
                    if (this.m_graph.m_vertexList[k] != null) {
                        int l = 0;
                        boolean foundi = false;
                        boolean foundj = false;
                        while (this.m_graph.m_vertexList[k].m_blossom.m_v[l] != -1) {
                            if (this.m_graph.m_vertexList[k].m_blossom.m_v[l] == i) {
                                foundi = true;
                                if (foundj) break;
                            }
                            if (this.m_graph.m_vertexList[k].m_blossom.m_v[l] == j) {
                                foundj = true;
                                if (foundi) break;
                            }
                            ++l;
                        }
                        if (foundi && foundj) {
                            summe += this.m_graph.m_vertexList[k].m_alpha;
                        }
                    }
                    ++k;
                }
                if (this.m_graph.m_vertexList[i].m_alpha + this.m_graph.m_vertexList[j].m_alpha + summe == this.m_weightMatrix[i].m_c[j]) {
                    this.m_graph.addEdge(i, j);
                } else {
                    this.m_graph.deleteEdge(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void makePairing() {
        if (s_debug) {
            System.out.println("*** MaximumWeightPerfectMatching.makePairing() ***");
            System.out.println("CostMatrix");
            int y = -1;
            while (y < this.m_maxPlayer) {
                Object row = "";
                int x = -1;
                while (x < this.m_maxPlayer) {
                    row = (String)row + " ";
                    if (y == -1) {
                        number = x == -1 ? "" : "" + x;
                        while (((String)number).length() < 10) {
                            number = " " + (String)number;
                        }
                        row = (String)row + (String)number;
                    } else {
                        number = x == -1 ? "" + y : "" + this.getCosts(y, x);
                        while (((String)number).length() < 10) {
                            number = " " + (String)number;
                        }
                        row = (String)row + (String)number;
                    }
                    ++x;
                }
                System.out.println((String)row);
                ++y;
            }
        }
        Tree tree = new Tree();
        int i = 0;
        while (i < this.m_maxPlayer) {
            Vertex vertex = new Vertex(this.m_maxPlayer);
            vertex.m_vertex = i++;
            this.m_graph.addVertex(vertex);
        }
        i = 0;
        while (i < this.m_graph.getNumberOfPlayers()) {
            long maxweight = -1L;
            int j = 0;
            while (j < this.m_graph.getNumberOfPlayers()) {
                if (i != j && (maxweight < this.m_weightMatrix[i].m_c[j] || maxweight < 0L)) {
                    maxweight = this.m_weightMatrix[i].m_c[j];
                }
                ++j;
            }
            this.m_graph.m_vertexList[i].m_alpha = maxweight >> 1;
            ++i;
        }
        this.augmentGraph();
        block7: while (true) {
            int action;
            this.m_exploredMatrix.clearExploredMatrix(this.m_graph.getFirstBlossom(), this.m_graph.getLastBlossom());
            this.m_graph.removeAllLabels();
            i = 0;
            while (i < this.m_graph.getNumberOfPlayers()) {
                if (!this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_pseudoVertex && this.m_graph.m_vertexList[i].m_matched == -1 && this.m_graph.m_vertexList[i].m_alpha > 0L) break;
                ++i;
            }
            if (i == this.m_graph.getNumberOfPlayers()) break;
            tree.makeEmpty();
            Knoten knoten = new Knoten();
            knoten.m_label = i;
            tree.addChild(null, knoten);
            this.m_graph.m_vertexList[i].m_flags = 4;
            do {
                if ((action = this.mAugmentingPathSearch(tree)) == 3) {
                    this.m_graph.shrinkBlossom(tree);
                    this.updateExploredMatrix(tree);
                }
                if (action == 1 && (action = this.hungarianTreeProc(tree)) == 4) continue block7;
            } while (action != 2);
            this.m_graph.augmentPath(tree);
        }
        i = this.m_graph.getFirstBlossom();
        while (i < this.m_graph.getLastBlossom()) {
            if (this.m_graph.m_vertexList[i] != null && this.m_graph.m_vertexList[i].m_outermost) {
                this.m_graph.expandBlossom(i);
                i = this.m_graph.getFirstBlossom();
                continue;
            }
            ++i;
        }
        if (s_debug) {
            System.out.println("**********");
            System.out.println("Matching Found:");
            int x = 0;
            while (x < this.m_maxPlayer) {
                if (this.getMatchedVertex(x) < 0 || this.getMatchedVertex(x) > x) {
                    String p1 = "" + x;
                    while (p1.length() < 4) {
                        p1 = " " + p1;
                    }
                    String p2 = "" + this.getMatchedVertex(x);
                    while (p2.length() < 4) {
                        p2 = " " + p2;
                    }
                    System.out.println(p1 + " - " + p2);
                }
                ++x;
            }
        }
    }

    public int mAugmentingPathSearch(Tree tree) {
        Knoten pos;
        int i = 0;
        int j = 0;
        if (tree.m_continueHere == null) {
            pos = tree.nextKnoten(null);
        } else {
            pos = tree.m_continueHere;
            tree.m_continueHere = null;
        }
        while (true) {
            Knoten AChild;
            boolean ende = false;
            while (!ende && pos != null) {
                if ((this.m_graph.m_vertexList[pos.m_label].m_flags & 4) > 0) {
                    i = 0;
                    while (i < this.m_graph.getNumberOfPlayers()) {
                        if (pos.m_label != this.m_graph.m_vertexList[i].m_vertex && this.m_graph.existEdge(pos.m_label, this.m_graph.m_vertexList[i].m_vertex) != 0 && !this.m_exploredMatrix.isExplored(pos.m_label, this.m_graph.m_vertexList[i].m_vertex)) {
                            ende = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (ende) continue;
                pos = tree.nextKnoten(pos);
            }
            if (pos == null) {
                return 1;
            }
            this.m_exploredMatrix.setExplored(pos.m_label, this.m_graph.m_vertexList[i].m_vertex);
            if (this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_matched == -1 && (this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 2) == 0 && (this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 4) == 0) {
                AChild = new Knoten();
                AChild.m_label = this.m_graph.m_vertexList[i].m_vertex;
                tree.addChild(pos, AChild);
                tree.m_endOfPath = AChild;
                return 2;
            }
            if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 4) > 0) {
                tree.m_endOfPath = pos;
                tree.m_blossomed = this.m_graph.m_vertexList[i].m_vertex;
                return 3;
            }
            if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 2) != 0) continue;
            j = this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_matched;
            AChild = new Knoten();
            AChild.m_label = this.m_graph.m_vertexList[i].m_vertex;
            tree.addChild(pos, AChild);
            Knoten BChild = new Knoten();
            BChild.m_label = this.m_graph.m_vertexList[j].m_vertex;
            tree.addChild(AChild, BChild);
            this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags |= 2;
            this.m_graph.m_vertexList[this.m_graph.m_vertexList[j].m_vertex].m_flags |= 4;
        }
    }

    public int hungarianTreeProc(Tree tree) {
        long delta;
        int j;
        int MinD3Edge_Player1 = 0;
        int MinD3Edge_Player2 = 0;
        int MinD4Edge_Player1 = 0;
        int MinD4Edge_Player2 = 0;
        long mindelta1 = -1L;
        long mindelta2 = -1L;
        long mindelta3 = -1L;
        long mindelta4 = -1L;
        int i = this.m_graph.getFirstBlossom();
        while (i < this.m_graph.getLastBlossom()) {
            if (this.m_graph.m_vertexList[i] != null && (this.m_graph.m_vertexList[i].m_flags & 2) > 0 && this.m_graph.m_vertexList[i].m_outermost && (mindelta1 > this.m_graph.m_vertexList[i].m_alpha || mindelta1 < 0L)) {
                mindelta1 = this.m_graph.m_vertexList[i].m_alpha;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_graph.getNumberOfPlayers()) {
            if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 4) > 0) {
                j = 0;
                while (j < this.m_graph.getNumberOfPlayers()) {
                    if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[j].m_vertex].m_flags & 2) <= 0 && (this.m_graph.m_vertexList[this.m_graph.m_vertexList[j].m_vertex].m_flags & 4) <= 0 && (mindelta3 > this.m_graph.m_vertexList[i].m_alpha + this.m_graph.m_vertexList[j].m_alpha - this.m_weightMatrix[i].m_c[j] || mindelta3 < 0L)) {
                        mindelta3 = this.m_graph.m_vertexList[i].m_alpha + this.m_graph.m_vertexList[j].m_alpha - this.m_weightMatrix[i].m_c[j];
                        MinD3Edge_Player1 = i;
                        MinD3Edge_Player2 = j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_graph.getNumberOfPlayers()) {
            if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 4) > 0) {
                j = 0;
                while (j < this.m_graph.getNumberOfPlayers()) {
                    if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[j].m_vertex].m_flags & 4) > 0 && this.m_graph.m_vertexList[i].m_vertex != this.m_graph.m_vertexList[j].m_vertex && (mindelta4 > this.m_graph.m_vertexList[i].m_alpha + this.m_graph.m_vertexList[j].m_alpha - this.m_weightMatrix[i].m_c[j] || mindelta4 < 0L)) {
                        mindelta4 = this.m_graph.m_vertexList[i].m_alpha + this.m_graph.m_vertexList[j].m_alpha - this.m_weightMatrix[i].m_c[j];
                        MinD4Edge_Player1 = i;
                        MinD4Edge_Player2 = j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        long delta1 = mindelta1 >= 0L ? mindelta1 >> 1 : -1L;
        long delta2 = mindelta2 >= 0L ? mindelta2 : -1L;
        long delta3 = mindelta3 >= 0L ? mindelta3 : -1L;
        long delta4 = mindelta4 >= 0L ? mindelta4 >> 1 : -1L;
        long mindelta = -1L;
        if (delta1 >= 0L && (mindelta > delta1 || mindelta < 0L)) {
            mindelta = delta1;
        }
        if (delta2 >= 0L && (mindelta > delta2 || mindelta < 0L)) {
            mindelta = delta2;
        }
        if (delta3 >= 0L && (mindelta > delta3 || mindelta < 0L)) {
            mindelta = delta3;
        }
        if (delta4 >= 0L && (mindelta > delta4 || mindelta < 0L)) {
            mindelta = delta4;
        }
        if ((delta = mindelta) < 0L) {
            return 5;
        }
        i = 0;
        while (i < this.m_graph.getNumberOfPlayers()) {
            if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 4) > 0) {
                this.m_graph.m_vertexList[i].m_alpha -= delta;
            }
            if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 2) > 0) {
                this.m_graph.m_vertexList[i].m_alpha += delta;
            }
            ++i;
        }
        i = this.m_graph.getFirstBlossom();
        while (i < this.m_graph.getLastBlossom()) {
            if (this.m_graph.m_vertexList[i] != null && this.m_graph.m_vertexList[i].m_outermost && (this.m_graph.m_vertexList[i].m_flags & 4) > 0) {
                this.m_graph.m_vertexList[i].m_alpha += delta << 1;
            }
            if (this.m_graph.m_vertexList[i] != null && this.m_graph.m_vertexList[i].m_outermost && (this.m_graph.m_vertexList[i].m_flags & 2) > 0) {
                this.m_graph.m_vertexList[i].m_alpha -= delta << 1;
            }
            ++i;
        }
        if (delta == delta1) {
            i = this.m_graph.getFirstBlossom();
            while (i < this.m_graph.getLastBlossom()) {
                if (this.m_graph.m_vertexList[i] != null && this.m_graph.m_vertexList[i].m_outermost && (this.m_graph.m_vertexList[i].m_flags & 2) > 0 && this.m_graph.m_vertexList[i].m_alpha == 0L) {
                    this.m_graph.expandBlossomwithTree(tree, i);
                }
                ++i;
            }
            this.updateExploredMatrix(tree);
        }
        if (delta == delta2) {
            i = tree.m_root.m_label;
            while (this.m_graph.m_vertexList[i].m_pseudoVertex) {
                i = this.m_graph.m_vertexList[i].m_blossom.m_b[0];
            }
            if (this.m_graph.m_vertexList[i].m_alpha != 0L) {
                Knoten pos = tree.nextKnoten(tree.m_root);
                while (pos != null) {
                    if (this.m_graph.m_vertexList[pos.m_label].m_alpha == 0L) {
                        tree.m_endOfPath = pos;
                        break;
                    }
                    pos = tree.nextKnoten(pos);
                }
                if (pos != null) {
                    this.m_graph.augmentPath(tree);
                }
            }
        }
        if (delta > 0L) {
            i = 0;
            while (i < this.m_graph.getNumberOfPlayers()) {
                if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[i].m_vertex].m_flags & 2) > 0) {
                    j = 0;
                    while (j < this.m_graph.getNumberOfPlayers()) {
                        if ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[j].m_vertex].m_flags & 4) == 0 && this.m_graph.m_vertexList[i].m_vertex != this.m_graph.m_vertexList[j].m_vertex && this.m_graph.existEdge(i, j) != 0 && ((this.m_graph.m_vertexList[this.m_graph.m_vertexList[j].m_vertex].m_flags & 2) <= 0 || j >= i)) {
                            this.m_graph.deleteEdge(i, j);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (delta == delta3 || delta == delta4) {
            if (delta == delta3) {
                this.m_graph.addEdge(MinD3Edge_Player1, MinD3Edge_Player2);
                tree.m_continueHere = tree.findKnoten(this.m_graph.m_vertexList[MinD3Edge_Player1].m_vertex);
            } else {
                this.m_graph.addEdge(MinD4Edge_Player1, MinD4Edge_Player2);
                tree.m_continueHere = tree.findKnoten(this.m_graph.m_vertexList[MinD4Edge_Player1].m_vertex);
            }
        }
        if (delta == delta2) {
            this.m_graph.removeAllLabels();
            return 4;
        }
        return 5;
    }

    public int getMatchedVertex(int i) {
        return this.m_graph.getMatchedVertex(i);
    }
}

