/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.mwpm;

import de.cgerlach.macmahon.mwpm.Knoten;
import de.cgerlach.macmahon.mwpm.Tree;
import de.cgerlach.macmahon.mwpm.Vertex;

public class Graph {
    public Vertex[] m_vertexList;
    public int m_numberOfPlayers;
    private int m_firstBlossom;
    private int m_lastBlossom;
    private int m_maxPlayer;
    private int m_maxVertices;

    public Graph(int maxPlayer, int maxVertices) {
        this.m_maxPlayer = maxPlayer;
        this.m_maxVertices = maxVertices;
        this.m_vertexList = new Vertex[this.m_maxVertices];
        this.makeEmpty();
        this.m_lastBlossom = this.m_firstBlossom = maxPlayer;
        this.m_numberOfPlayers = 0;
    }

    public void makeEmpty() {
        int i = 0;
        while (i < this.m_maxVertices) {
            this.m_vertexList[i] = null;
            ++i;
        }
    }

    public void addVertex(Vertex vertex) {
        this.m_vertexList[vertex.m_vertex] = vertex;
        if (vertex.m_vertex >= this.m_numberOfPlayers) {
            this.m_numberOfPlayers = vertex.m_vertex + 1;
        }
    }

    public void addEdge(int vertex1, int vertex2) {
        this.m_vertexList[vertex1].m_edges[vertex2] = 1;
        this.m_vertexList[vertex2].m_edges[vertex1] = 1;
        int v = this.m_vertexList[vertex1].m_containedInBlossom;
        while (v != -1) {
            int n = vertex2;
            this.m_vertexList[v].m_edges[n] = this.m_vertexList[v].m_edges[n] + 1;
            v = this.m_vertexList[v].m_containedInBlossom;
        }
        v = this.m_vertexList[vertex2].m_containedInBlossom;
        while (v != -1) {
            int n = vertex1;
            this.m_vertexList[v].m_edges[n] = this.m_vertexList[v].m_edges[n] + 1;
            v = this.m_vertexList[v].m_containedInBlossom;
        }
    }

    void deleteEdge(int vertex1, int vertex2) {
        this.m_vertexList[vertex1].m_edges[vertex2] = 0;
        this.m_vertexList[vertex2].m_edges[vertex1] = 0;
        int v = this.m_vertexList[vertex1].m_containedInBlossom;
        while (v != -1) {
            int n = vertex2;
            this.m_vertexList[v].m_edges[n] = this.m_vertexList[v].m_edges[n] - 1;
            v = this.m_vertexList[v].m_containedInBlossom;
        }
        v = this.m_vertexList[vertex2].m_containedInBlossom;
        while (v != -1) {
            int n = vertex1;
            this.m_vertexList[v].m_edges[n] = this.m_vertexList[v].m_edges[n] - 1;
            v = this.m_vertexList[v].m_containedInBlossom;
        }
    }

    int getVertexNumber(Vertex vertex) {
        if (!vertex.m_pseudoVertex) {
            return vertex.m_vertex;
        }
        int i = this.m_firstBlossom;
        while (i < this.m_lastBlossom) {
            if (this.m_vertexList[i] == vertex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int existEdge(int vertex1, int vertex2) {
        if (this.m_vertexList[vertex1].m_pseudoVertex) {
            if (!this.m_vertexList[vertex2].m_pseudoVertex) {
                return this.m_vertexList[vertex1].m_edges[vertex2];
            }
            int i = 0;
            while (this.m_vertexList[vertex1].m_blossom.m_v[i] != -1) {
                if (this.existEdge(this.m_vertexList[vertex1].m_blossom.m_v[i], vertex2) > 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        return this.m_vertexList[vertex2].m_edges[vertex1];
    }

    void shrinkBlossom(Tree t) {
        int j;
        Knoten[] halfcicle1 = new Knoten[this.m_maxPlayer];
        Knoten[] halfcicle2 = new Knoten[this.m_maxPlayer];
        Vertex blossom = new Vertex(this.m_maxPlayer);
        blossom.makeBlossom();
        int theblossom = this.m_firstBlossom;
        while (this.m_vertexList[theblossom] != null) {
            ++theblossom;
        }
        if (theblossom >= this.m_lastBlossom) {
            this.m_lastBlossom = theblossom + 1;
        }
        this.m_vertexList[theblossom] = blossom;
        blossom.m_vertex = theblossom;
        blossom.m_pseudoVertex = true;
        blossom.m_flags = 4;
        blossom.m_alpha = 0L;
        blossom.m_outermost = true;
        blossom.m_containedInBlossom = -1;
        Knoten x1 = t.m_endOfPath;
        Knoten x2 = t.findKnoten(t.m_blossomed);
        Knoten pos1 = x1;
        Knoten pos2 = x2;
        halfcicle1[0] = pos1;
        halfcicle2[0] = pos2;
        int hc1pos = 1;
        int hc2pos = 1;
        while (pos1 != t.m_root) {
            halfcicle1[hc1pos] = pos1 = pos1.m_parent;
            ++hc1pos;
        }
        while (pos2 != t.m_root) {
            halfcicle2[hc2pos] = pos2 = pos2.m_parent;
            ++hc2pos;
        }
        --hc1pos;
        --hc2pos;
        while (hc1pos >= 0 && hc2pos >= 0 && halfcicle1[hc1pos] == halfcicle2[hc2pos]) {
            --hc1pos;
            --hc2pos;
        }
        int blossompos = 0;
        ++hc2pos;
        blossom.m_blossom.m_b[blossompos] = halfcicle1[++hc1pos].m_label;
        int i = hc1pos - 1;
        while (i >= 0) {
            blossom.m_blossom.m_b[++blossompos] = halfcicle1[i].m_label;
            --i;
        }
        i = 0;
        while (i < hc2pos) {
            blossom.m_blossom.m_b[++blossompos] = halfcicle2[i].m_label;
            ++i;
        }
        int vertexpos = 0;
        i = 0;
        while (i <= blossompos) {
            this.m_vertexList[blossom.m_blossom.m_b[i]].m_outermost = false;
            this.m_vertexList[blossom.m_blossom.m_b[i]].m_containedInBlossom = theblossom;
            if (this.m_vertexList[blossom.m_blossom.m_b[i]].m_pseudoVertex) {
                j = 0;
                while (j < this.m_numberOfPlayers) {
                    if (this.m_vertexList[j] != null && this.m_vertexList[j].m_vertex == blossom.m_blossom.m_b[i]) {
                        this.m_vertexList[j].m_vertex = theblossom;
                        blossom.m_blossom.m_v[vertexpos] = j;
                        ++vertexpos;
                    }
                    ++j;
                }
            } else {
                this.m_vertexList[blossom.m_blossom.m_b[i]].m_vertex = theblossom;
                blossom.m_blossom.m_v[vertexpos] = blossom.m_blossom.m_b[i];
                ++vertexpos;
            }
            ++i;
        }
        i = 0;
        while (i <= blossompos) {
            if (i == 0) {
                Knoten pos = t.findKnoten(blossom.m_blossom.m_b[i]);
                pos.m_label = theblossom;
            } else {
                t.delKnoten(t.findKnoten(blossom.m_blossom.m_b[i]));
            }
            ++i;
        }
        i = 0;
        while (this.m_vertexList[theblossom].m_blossom.m_v[i] != -1) {
            j = 0;
            while (j < this.m_numberOfPlayers) {
                if (this.m_vertexList[j] != null && this.m_vertexList[j].m_vertex != theblossom) {
                    int n = j;
                    blossom.m_edges[n] = blossom.m_edges[n] + this.m_vertexList[blossom.m_blossom.m_v[i]].m_edges[j];
                }
                ++j;
            }
            ++i;
        }
        blossom.m_matched = this.m_vertexList[blossom.m_blossom.m_b[0]].m_matched;
        if (blossom.m_matched != -1) {
            this.m_vertexList[blossom.m_matched].m_matched = blossom.m_vertex;
        }
        this.m_vertexList[blossom.m_blossom.m_b[0]].m_matched = -1;
    }

    void augmentPath(Tree t) {
        int[] path = new int[this.m_maxPlayer];
        Knoten pos = t.m_endOfPath;
        int pathpos = 0;
        while (pos != t.m_root) {
            path[pathpos] = pos.m_label;
            pos = pos.m_parent;
            ++pathpos;
        }
        path[pathpos] = pos.m_label;
        while (pathpos >= 0) {
            if (pathpos > 0) {
                this.m_vertexList[path[pathpos]].m_matched = path[pathpos - 1];
                this.m_vertexList[path[pathpos - 1]].m_matched = path[pathpos];
                --pathpos;
                --pathpos;
                continue;
            }
            this.m_vertexList[path[pathpos]].m_matched = -1;
            --pathpos;
        }
    }

    void expandBlossom(int theblossom) {
        int j;
        int[] path1 = new int[this.m_maxPlayer];
        int i = 0;
        while (this.m_vertexList[theblossom].m_blossom.m_b[i] != -1) {
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_vertex = this.m_vertexList[theblossom].m_blossom.m_b[i];
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_outermost = true;
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_containedInBlossom = -1;
            if (this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_pseudoVertex) {
                int ablossom = this.m_vertexList[theblossom].m_blossom.m_b[i];
                j = 0;
                while (this.m_vertexList[ablossom].m_blossom.m_v[j] != -1) {
                    this.m_vertexList[this.m_vertexList[ablossom].m_blossom.m_v[j]].m_vertex = ablossom;
                    ++j;
                }
            }
            ++i;
        }
        i = this.m_vertexList[theblossom].m_matched;
        if (i != -1) {
            if (this.existEdge(i, this.m_vertexList[theblossom].m_blossom.m_b[0]) != 0) {
                this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[0]].m_matched = i;
                this.m_vertexList[i].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[0];
            } else {
                j = 1;
                while (this.m_vertexList[theblossom].m_blossom.m_b[j] != -1) {
                    if (this.existEdge(this.m_vertexList[theblossom].m_blossom.m_b[j], i) > 0) break;
                    ++j;
                }
                if (this.m_vertexList[theblossom].m_blossom.m_b[j] != -1) {
                    int k = this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[j]].m_matched;
                    int dir = k == this.m_vertexList[theblossom].m_blossom.m_b[j - 1] ? -1 : 1;
                    this.m_vertexList[i].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[j];
                    this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[j]].m_matched = i;
                    int p1 = 0;
                    path1[p1] = this.m_vertexList[theblossom].m_blossom.m_b[j];
                    int count = 0;
                    while (this.m_vertexList[theblossom].m_blossom.m_b[count] != -1) {
                        ++count;
                    }
                    --count;
                    k = j + dir;
                    while (true) {
                        path1[++p1] = this.m_vertexList[theblossom].m_blossom.m_b[k];
                        i = k + dir;
                        if (i < 0) {
                            i = count;
                        }
                        if (i > count) {
                            i = 0;
                        }
                        path1[++p1] = this.m_vertexList[theblossom].m_blossom.m_b[i];
                        this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[k]].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[i];
                        this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[k];
                        if (i == 0) break;
                        k = i + dir;
                    }
                }
            }
        }
        this.m_vertexList[theblossom] = null;
        if (theblossom == this.m_lastBlossom - 1) {
            while (this.m_lastBlossom > this.m_firstBlossom && this.m_vertexList[this.m_lastBlossom - 1] == null) {
                --this.m_lastBlossom;
            }
        }
    }

    void expandBlossomwithTree(Tree t, int theblossom) {
        int count;
        int dir;
        int k;
        int j;
        int[] path1 = new int[this.m_maxPlayer];
        int i = 0;
        int MatchInBlossom = -1;
        while (this.m_vertexList[theblossom].m_blossom.m_b[i] != -1) {
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_vertex = this.m_vertexList[theblossom].m_blossom.m_b[i];
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_outermost = true;
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_containedInBlossom = -1;
            this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_flags &= 0xFFFFFFF9;
            if (this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_pseudoVertex) {
                int ablossom = this.m_vertexList[theblossom].m_blossom.m_b[i];
                j = 0;
                while (this.m_vertexList[ablossom].m_blossom.m_v[j] != -1) {
                    this.m_vertexList[this.m_vertexList[ablossom].m_blossom.m_v[j]].m_vertex = this.m_vertexList[theblossom].m_blossom.m_b[i];
                    ++j;
                }
            }
            ++i;
        }
        i = this.m_vertexList[theblossom].m_matched;
        if (i != -1) {
            if (this.existEdge(i, this.m_vertexList[theblossom].m_blossom.m_b[0]) != 0) {
                this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[0]].m_matched = i;
                this.m_vertexList[i].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[0];
                MatchInBlossom = 0;
            } else {
                j = 1;
                while (this.m_vertexList[theblossom].m_blossom.m_b[j] != -1) {
                    if (this.existEdge(this.m_vertexList[theblossom].m_blossom.m_b[j], i) != 0) break;
                    ++j;
                }
                if (this.m_vertexList[theblossom].m_blossom.m_b[j] != -1) {
                    k = this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[j]].m_matched;
                    dir = k == this.m_vertexList[theblossom].m_blossom.m_b[j - 1] ? -1 : 1;
                    this.m_vertexList[i].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[j];
                    this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[j]].m_matched = i;
                    MatchInBlossom = j;
                    int p1 = 0;
                    path1[p1] = this.m_vertexList[theblossom].m_blossom.m_b[j];
                    count = 0;
                    while (this.m_vertexList[theblossom].m_blossom.m_b[count] != -1) {
                        ++count;
                    }
                    --count;
                    k = j + dir;
                    while (true) {
                        path1[++p1] = this.m_vertexList[theblossom].m_blossom.m_b[k];
                        i = k + dir;
                        if (i < 0) {
                            i = count;
                        }
                        if (i > count) {
                            i = 0;
                        }
                        path1[++p1] = this.m_vertexList[theblossom].m_blossom.m_b[i];
                        this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[k]].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[i];
                        this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[i]].m_matched = this.m_vertexList[theblossom].m_blossom.m_b[k];
                        if (i == 0) break;
                        k = i + dir;
                    }
                }
            }
        }
        Knoten pos = t.findKnoten(theblossom);
        Knoten x1neighbour = pos.m_parent;
        Knoten x2neighbour = pos.m_firstChild;
        count = 0;
        while (this.m_vertexList[theblossom].m_blossom.m_b[count] != -1) {
            ++count;
        }
        --count;
        if (this.existEdge(x2neighbour.m_label, this.m_vertexList[theblossom].m_blossom.m_b[MatchInBlossom]) != 0) {
            k = 0;
            while (this.existEdge(this.m_vertexList[theblossom].m_blossom.m_b[k], x1neighbour.m_label) == 0) {
                ++k;
            }
            boolean augment = true;
            i = k + 1;
            if (i > count) {
                i = 0;
            }
            dir = this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[k]].m_matched == this.m_vertexList[theblossom].m_blossom.m_b[i] ? 1 : -1;
            while (true) {
                Knoten aKnoten = new Knoten();
                aKnoten.m_label = this.m_vertexList[theblossom].m_blossom.m_b[k];
                if (augment) {
                    augment = false;
                    this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[k]].m_flags |= 2;
                } else {
                    augment = true;
                    this.m_vertexList[this.m_vertexList[theblossom].m_blossom.m_b[k]].m_flags |= 4;
                }
                t.insertKnoten(pos, aKnoten, x2neighbour);
                pos = aKnoten;
                if (k == MatchInBlossom) break;
                if ((k += dir) > count) {
                    k = 0;
                }
                if (k >= 0) continue;
                k = count;
            }
            t.delKnoten(t.findKnoten(theblossom));
        }
        this.m_vertexList[theblossom] = null;
        if (theblossom == this.m_lastBlossom - 1) {
            while (this.m_lastBlossom > this.m_firstBlossom && this.m_vertexList[this.m_lastBlossom - 1] == null) {
                --this.m_lastBlossom;
            }
        }
    }

    void removeAllLabels() {
        int i = 0;
        while (i < this.m_numberOfPlayers) {
            this.m_vertexList[i].m_flags &= 0xFFFFFFF9;
            ++i;
        }
        i = this.m_firstBlossom;
        while (i < this.m_lastBlossom) {
            if (this.m_vertexList[i] != null) {
                this.m_vertexList[i].m_flags &= 0xFFFFFFF9;
            }
            ++i;
        }
    }

    int getMatchedVertex(int i) {
        return this.m_vertexList[i].m_matched;
    }

    public int getNumberOfPlayers() {
        return this.m_numberOfPlayers;
    }

    public int getFirstBlossom() {
        return this.m_firstBlossom;
    }

    public int getLastBlossom() {
        return this.m_lastBlossom;
    }
}

