/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.resources.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Walllist
extends XmlPersistentObject {
    public static final SortCriterionDescriptor SCD_SCORE = new SortCriterionDescriptor("Score", Messages.getString("Walllist.SortCriterionScoreLongName"), Messages.getString("Walllist.SortCriterionScoreExplanation"), false, false, false);
    public static final SortCriterionDescriptor SCD_SCOREX = new SortCriterionDescriptor("ScoreX", Messages.getString("Walllist.SortCriterionScoreXLongName"), Messages.getString("Walllist.SortCriterionScoreXExplanation"), false, false, true);
    public static final SortCriterionDescriptor SCD_SOS = new SortCriterionDescriptor("SOS", Messages.getString("Walllist.SortCriterionSOSLongName"), Messages.getString("Walllist.SortCriterionSOSExplanation"), false, true, true);
    public static final SortCriterionDescriptor SCD_SOSOS = new SortCriterionDescriptor("SOSOS", Messages.getString("Walllist.SortCriterionSOSOSLongName"), Messages.getString("Walllist.SortCriterionSOSOSExplanation"), false, true, true);
    public static final SortCriterionDescriptor SCD_NUMBEROFWINS = new SortCriterionDescriptor("Points", Messages.getString("Walllist.SortCriterionPointsLongName"), Messages.getString("Walllist.SortCriterionPointsExplanation"), false, false, false);
    public static final SortCriterionDescriptor SCD_SODOS = new SortCriterionDescriptor("SODOS", Messages.getString("Walllist.SortCriterionSODOSLongName"), Messages.getString("Walllist.SortCriterionSODOSExplanation"), false, true, true);
    public static final SortCriterionDescriptor SCD_SORP = new SortCriterionDescriptor("SORP", Messages.getString("Walllist.SortCriterionSORPLongName"), Messages.getString("Walllist.SortCriterionSORPExplanation"), false, false, true);
    public static final SortCriterionDescriptor SCD_GO_RANK = new SortCriterionDescriptor("Rank", Messages.getString("Walllist.SortCriterionRankLongName"), Messages.getString("Walllist.SortCriterionRankExplanation"), true, false, false);
    public static final SortCriterionDescriptor SCD_NAME = new SortCriterionDescriptor("Name", Messages.getString("Walllist.SortCriterionNameLongName"), Messages.getString("Walllist.SortCriterionNameExplanation"), true, false, false);
    public static final SortCriterionDescriptor SCD_RATING = new SortCriterionDescriptor("Rating", Messages.getString("Walllist.SortCriterionRatingLongName"), Messages.getString("Walllist.SortCriterionRatingExplanation"), true, false, false);
    public static final SortCriterionDescriptor SCD_ID = new SortCriterionDescriptor("ID", "ID", "internal ID", true, false, false);
    public static final SortCriterionDescriptor[] s_availableSortCriteria = new SortCriterionDescriptor[]{SCD_SCORE, SCD_SCOREX, SCD_SOS, SCD_SOSOS, SCD_NUMBEROFWINS, SCD_SODOS, SCD_SORP};
    public static final SortCriterionDescriptor[] s_allSortCriteria = new SortCriterionDescriptor[]{SCD_SCORE, SCD_SCOREX, SCD_SOS, SCD_SOSOS, SCD_NUMBEROFWINS, SCD_SODOS, SCD_SORP, SCD_GO_RANK, SCD_RATING, SCD_NAME, SCD_ID};
    public static final int WEAK_SORT_CRITERIA_RANK_NAME_ID = 1;
    public static final int WEAK_SORT_CRITERIA_NAME_ID = 2;
    public static final int WEAK_SORT_CRITERIA_ID = 3;
    public static final int DEFAULT_FONTSIZE = 12;
    public static final String COLUMNNAME_PLACE = Messages.getString("Walllist.ColumnNamePlace");
    public static final String COLUMNNAME_NAME = Messages.getString("Walllist.ColumnNameName");
    public static final String COLUMNNAME_CLUB = Messages.getString("Walllist.ColumnNameClub");
    public static final String COLUMNNAME_LEVEL = Messages.getString("Walllist.ColumnNameLevel");
    public static final String COLUMNNAME_RATING = Messages.getString("Walllist.ColumnNameRating");
    public static final int XML_VERSION = 3;
    public static final String XML_TAGNAME = "Walllist";
    private Tournament m_tournament;
    private List<Participant> m_walllist;
    private List<WalllistChangeListener> m_changeListener = new ArrayList<WalllistChangeListener>();
    private List<SortCriterionDescriptor> m_sortCriteria;
    private int m_weakSortCriteria = 1;
    private int m_sortBlocked = 0;
    private boolean m_showCountry = true;
    private boolean m_showClub = true;
    private boolean m_showClubEgdName = false;
    private boolean m_showClubAbbreviateName = true;
    private boolean m_showLevels = true;
    private boolean m_shortNotationForLevel = false;
    private boolean m_showBarMembership = true;
    private boolean m_showRatings = true;
    private boolean m_markPreliminaryRegisteredParticipants = true;
    private boolean m_markResultsByReferree = true;
    private boolean m_showColors = false;
    private boolean m_showHandicap = true;
    private boolean m_showWarningMissingPairing = true;
    private int m_fontsize = 12;
    private int m_nameColumnWidth = 0;
    private int m_clubColumnWidth = 0;
    private boolean m_clubColumnAlignmentCenter = true;

    public static SortCriterionDescriptor getSortCriterionDescriptorByShortName(String shortName) {
        int i = 0;
        while (i < s_availableSortCriteria.length) {
            if (s_allSortCriteria[i].getShortName().equals(shortName)) {
                return s_allSortCriteria[i];
            }
            ++i;
        }
        return null;
    }

    public Walllist() {
        this.m_walllist = new ArrayList<Participant>();
        this.m_sortCriteria = new ArrayList<SortCriterionDescriptor>();
    }

    public Walllist(Tournament tournament) {
        this();
        this.m_sortCriteria.add(SCD_SCOREX);
        this.m_sortCriteria.add(SCD_SOS);
        this.m_sortCriteria.add(SCD_SOSOS);
        this.m_sortCriteria.add(SCD_GO_RANK);
        this.m_sortCriteria.add(SCD_NAME);
        this.setTournament(tournament);
    }

    public void setTournament(Tournament tournament) {
        assert (this.m_tournament == null);
        this.m_tournament = tournament;
        this.m_walllist.clear();
        this.m_walllist.addAll(this.m_tournament.getParticipants());
        this.doSort();
    }

    public void addChangeListener(WalllistChangeListener changeListener) {
        this.m_changeListener.add(changeListener);
    }

    public void removeChangeListener(WalllistChangeListener changeListener) {
        this.m_changeListener.remove(changeListener);
    }

    public List<Participant> getWalllist() {
        return this.m_walllist;
    }

    public void blockSort() {
        ++this.m_sortBlocked;
    }

    public void doSort() {
        if (this.m_sortBlocked == 0) {
            Collections.sort(this.m_walllist);
            int place = 1;
            Participant previousParticipant = null;
            for (Participant participant : this.m_walllist) {
                participant.setPlace(place);
                if (previousParticipant == null) {
                    participant.setPlaceShared(false);
                } else {
                    participant.setPlaceShared(previousParticipant.compareTo(participant, true) == 0);
                }
                previousParticipant = participant;
                ++place;
            }
            this.fireWalllistChanged();
        }
    }

    public void fireWalllistChanged() {
        for (WalllistChangeListener changeListener : this.m_changeListener) {
            changeListener.walllistChanged();
        }
    }

    public int getClubColumnWidth() {
        return this.m_clubColumnWidth;
    }

    public boolean getClubColumnAlignmentCenter() {
        return this.m_clubColumnAlignmentCenter;
    }

    public int getFontsize() {
        return this.m_fontsize;
    }

    public boolean getMarkPreliminaryRegisteredParticipants() {
        return this.m_markPreliminaryRegisteredParticipants;
    }

    public boolean getMarkResultsByReferree() {
        return this.m_markResultsByReferree;
    }

    public int getNameColumnWidth() {
        return this.m_nameColumnWidth;
    }

    public Participant getParticipantAt(int index) {
        return this.m_walllist.get(index);
    }

    public int getParticipantCount() {
        return this.m_walllist.size();
    }

    public boolean getShortNotationForLevel() {
        return this.m_shortNotationForLevel;
    }

    public boolean getShowBarMembership() {
        return this.m_showBarMembership;
    }

    public boolean getShowBarMembershipVisible() {
        return this.m_showBarMembership && (this.m_tournament.getUpperMacMahonBar() || this.m_tournament.getLowerMacMahonBar());
    }

    public boolean getShowClub() {
        return this.m_showClub;
    }

    public boolean getShowClubAbbreviateName() {
        return this.m_showClubAbbreviateName;
    }

    public boolean getShowClubEgdName() {
        return this.m_showClubEgdName;
    }

    public boolean getShowColors() {
        return this.m_showColors;
    }

    public boolean getShowCountry() {
        return this.m_showCountry;
    }

    public boolean getShowHandicap() {
        return this.m_showHandicap;
    }

    public boolean getShowLevels() {
        return this.m_showLevels;
    }

    public boolean getShowRatings() {
        return this.m_showRatings;
    }

    public boolean getShowWarningMissingPairing() {
        return this.m_showWarningMissingPairing;
    }

    public List<SortCriterionDescriptor> getSortCriteria() {
        return this.m_sortCriteria;
    }

    public SortCriterionDescriptor getSortCriteriaAtIndex(int index) {
        return this.m_sortCriteria.get(index);
    }

    public List<SortCriterionDescriptor> getSortCriteriaAvailable() {
        ArrayList<SortCriterionDescriptor> sortCriteriaAvailable = new ArrayList<SortCriterionDescriptor>();
        int i = 0;
        while (i < s_availableSortCriteria.length) {
            if (this.m_sortCriteria.indexOf(s_availableSortCriteria[i]) < 0) {
                sortCriteriaAvailable.add(s_availableSortCriteria[i]);
            }
            ++i;
        }
        return sortCriteriaAvailable;
    }

    public int getWeakSortCriteria() {
        return this.m_weakSortCriteria;
    }

    public void importSettings(Walllist other) {
        this.blockSort();
        this.setShowCountry(other.m_showCountry);
        this.setShowClub(other.m_showClub);
        this.setShowClubEgdName(other.m_showClubEgdName);
        this.setShowClubAbbreviateName(other.m_showClubAbbreviateName);
        this.setShowLevels(other.m_showLevels);
        this.setShortNotationForLevel(other.m_shortNotationForLevel);
        this.setShowBarMembership(other.m_showBarMembership);
        this.setShowRatings(other.m_showRatings);
        this.setMarkResultsByReferree(other.m_markResultsByReferree);
        this.setShowColors(other.m_showColors);
        this.setShowHandicap(other.m_showHandicap);
        this.setShowWarningMissingPairing(other.m_showWarningMissingPairing);
        this.setFontsize(other.m_fontsize);
        this.setNameColumnWidth(other.m_nameColumnWidth);
        this.setClubColumnWidth(other.m_clubColumnWidth);
        this.setClubColumnAlignmentCenter(other.m_clubColumnAlignmentCenter);
        this.setWeakSortCriteria(other.m_weakSortCriteria);
        this.setSortCriteria(other.getSortCriteria());
        this.unblockSort();
    }

    public void participantAdded(Participant participant) {
        this.m_walllist.add(participant);
        for (WalllistChangeListener changeListener : this.m_changeListener) {
            changeListener.walllistParticipantAdded(participant);
        }
        this.doSort();
    }

    public void participantRemoved(Participant participant) {
        this.m_walllist.remove(participant);
        for (WalllistChangeListener changeListener : this.m_changeListener) {
            changeListener.walllistParticipantRemoved(participant);
        }
        this.doSort();
    }

    public void setClubColumnWidth(int clubColumnWidth) {
        this.m_clubColumnWidth = clubColumnWidth;
    }

    public void setClubColumnAlignmentCenter(boolean clubColumnAlignmentCenter) {
        this.m_clubColumnAlignmentCenter = clubColumnAlignmentCenter;
    }

    public void setFontsize(int fontsize) {
        if (fontsize <= 0) {
            fontsize = 12;
        }
        this.m_fontsize = fontsize;
    }

    public void setMarkPreliminaryRegisteredParticipants(boolean markPreliminaryRegisteredParticipants) {
        this.m_markPreliminaryRegisteredParticipants = markPreliminaryRegisteredParticipants;
    }

    public void setMarkResultsByReferree(boolean markResultsByReferree) {
        this.m_markResultsByReferree = markResultsByReferree;
    }

    public void setNameColumnWidth(int nameColumnWidth) {
        this.m_nameColumnWidth = nameColumnWidth;
    }

    public void setShortNotationForLevel(boolean shortNotationForLevel) {
        this.m_shortNotationForLevel = shortNotationForLevel;
    }

    public void setShowBarMembership(boolean showBarMembership) {
        this.m_showBarMembership = showBarMembership;
    }

    private void buildAllClubDisplayStrings() {
        int i = 0;
        while (i < this.m_walllist.size()) {
            this.m_walllist.get(i).buildClubDisplayStringWalllist();
            ++i;
        }
    }

    public void setShowClub(boolean showClub) {
        if (this.m_showClub != showClub) {
            this.m_showClub = showClub;
            this.buildAllClubDisplayStrings();
        }
    }

    public void setShowClubAbbreviateName(boolean showClubAbbreviateName) {
        if (this.m_showClubAbbreviateName != showClubAbbreviateName) {
            this.m_showClubAbbreviateName = showClubAbbreviateName;
            this.buildAllClubDisplayStrings();
        }
    }

    public void setShowClubEgdName(boolean showClubEgdName) {
        if (this.m_showClubEgdName != showClubEgdName) {
            this.m_showClubEgdName = showClubEgdName;
            this.buildAllClubDisplayStrings();
        }
    }

    public void setShowColors(boolean showColors) {
        this.m_showColors = showColors;
    }

    public void setShowCountry(boolean showCountry) {
        if (this.m_showCountry != showCountry) {
            this.m_showCountry = showCountry;
            this.buildAllClubDisplayStrings();
        }
    }

    public void setShowHandicap(boolean showHandicap) {
        this.m_showHandicap = showHandicap;
    }

    public void setShowLevels(boolean showLevels) {
        this.m_showLevels = showLevels;
    }

    public void setShowRatings(boolean showRatings) {
        this.m_showRatings = showRatings;
    }

    public void setShowWarningMissingPairing(boolean showWarningMissingPairing) {
        this.m_showWarningMissingPairing = showWarningMissingPairing;
    }

    public void setSortCriteria(List<SortCriterionDescriptor> sortCriteria) {
        if (this.m_weakSortCriteria == 1 && !sortCriteria.contains(SCD_GO_RANK)) {
            sortCriteria.add(SCD_GO_RANK);
        }
        if (!(this.m_weakSortCriteria != 1 && this.m_weakSortCriteria != 2 || sortCriteria.contains(SCD_NAME))) {
            sortCriteria.add(SCD_NAME);
        }
        if (!sortCriteria.contains(SCD_ID)) {
            sortCriteria.add(SCD_ID);
        }
        if (!this.m_sortCriteria.equals(sortCriteria)) {
            this.m_sortCriteria = sortCriteria;
            this.doSort();
        }
    }

    public void setWeakSortCriteria(int weakSortCriteria) {
        this.m_weakSortCriteria = weakSortCriteria;
    }

    public void unblockSort() {
        if (this.m_sortBlocked > 0) {
            --this.m_sortBlocked;
            this.doSort();
        }
    }

    @Override
    public void xmlRead(Element we) throws MacMahonException {
        super.xmlRead(we);
        this.m_showCountry = this.xmlReadBooleanElement(we, "ShowCountry");
        this.m_showClub = this.xmlReadBooleanElement(we, "ShowClub");
        this.m_showClubEgdName = this.xmlReadBooleanElement(we, "ShowClubEgdName");
        this.m_showClubAbbreviateName = this.xmlReadBooleanElement(we, "ShowClubAbbreviateName");
        if (this.xmlVersion() >= 2) {
            this.m_showLevels = this.xmlReadBooleanElement(we, "ShowLevels");
        }
        this.m_shortNotationForLevel = this.xmlReadBooleanElement(we, "ShortNotationForLevel");
        this.m_showBarMembership = this.xmlReadBooleanElement(we, "ShowBarMembership");
        this.m_showRatings = this.xmlReadBooleanElement(we, "ShowRatings");
        if (this.xmlVersion() >= 2) {
            this.m_markPreliminaryRegisteredParticipants = this.xmlReadBooleanElement(we, "MarkPreliminaryRegisteredParticipants");
        }
        this.m_markResultsByReferree = this.xmlReadBooleanElement(we, "MarkResultsByReferree");
        this.m_showColors = this.xmlReadBooleanElement(we, "ShowColors");
        this.m_showHandicap = this.xmlReadBooleanElement(we, "ShowHandicap");
        this.m_showWarningMissingPairing = this.xmlReadBooleanElement(we, "ShowWarningMissingPairing");
        this.m_fontsize = this.xmlReadIntegerElement(we, "Fontsize");
        this.m_nameColumnWidth = this.xmlReadIntegerElement(we, "NameColumnWidth");
        this.m_clubColumnWidth = this.xmlReadIntegerElement(we, "ClubColumnWidth");
        this.m_clubColumnAlignmentCenter = this.xmlReadBooleanElement(we, "ClubColumnAlignmentCenter");
        if (this.xmlVersion() >= 3) {
            this.m_weakSortCriteria = this.xmlReadIntegerElement(we, "WeakSortCriteria");
        }
        ArrayList<SortCriterionDescriptor> sortCriteria = new ArrayList<SortCriterionDescriptor>();
        List<XmlPersistentObject> sortCriteriaXml = this.xmlReadPersistentObjects(we, "SortCriterionDescriptor", SortCriterionDescriptor.class);
        Iterator<XmlPersistentObject> it = sortCriteriaXml.iterator();
        while (it.hasNext()) {
            SortCriterionDescriptor criterion = Walllist.getSortCriterionDescriptorByShortName(((SortCriterionDescriptor)it.next()).getShortName());
            if (criterion == null) continue;
            sortCriteria.add(criterion);
        }
        this.setSortCriteria(sortCriteria);
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 3;
    }

    @Override
    protected void xmlWrite(Element we, Document document) {
        super.xmlWrite(we, document);
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowCountry", this.m_showCountry));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowClub", this.m_showClub));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowClubEgdName", this.m_showClubEgdName));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowClubAbbreviateName", this.m_showClubAbbreviateName));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowLevels", this.m_showLevels));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShortNotationForLevel", this.m_shortNotationForLevel));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowBarMembership", this.m_showBarMembership));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowRatings", this.m_showRatings));
        we.appendChild(this.xmlCreateBooleanElement(document, "MarkPreliminaryRegisteredParticipants", this.m_markPreliminaryRegisteredParticipants));
        we.appendChild(this.xmlCreateBooleanElement(document, "MarkResultsByReferree", this.m_markResultsByReferree));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowColors", this.m_showColors));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowHandicap", this.m_showHandicap));
        we.appendChild(this.xmlCreateBooleanElement(document, "ShowWarningMissingPairing", this.m_showWarningMissingPairing));
        we.appendChild(this.xmlCreateIntegerElement(document, "Fontsize", this.m_fontsize));
        we.appendChild(this.xmlCreateIntegerElement(document, "NameColumnWidth", this.m_nameColumnWidth));
        we.appendChild(this.xmlCreateIntegerElement(document, "ClubColumnWidth", this.m_clubColumnWidth));
        we.appendChild(this.xmlCreateBooleanElement(document, "ClubColumnAlignmentCenter", this.m_clubColumnAlignmentCenter));
        we.appendChild(this.xmlCreateIntegerElement(document, "WeakSortCriteria", this.m_weakSortCriteria));
        for (SortCriterionDescriptor criterion : this.m_sortCriteria) {
            if (criterion.isWeak()) continue;
            we.appendChild(criterion.xmlWrite(document));
        }
    }

    public static class SortCriterionDescriptor
    extends XmlPersistentObject {
        public static final int XML_VERSION = 2;
        public static final String XML_TAGNAME = "SortCriterionDescriptor";
        private String m_shortName;
        private String m_longName;
        private String m_explanation;
        private boolean m_weak;
        private boolean m_allowedForSeeding;
        private boolean m_walllistColumn;

        public SortCriterionDescriptor() {
        }

        public SortCriterionDescriptor(String shortName, String longName, String explanation, boolean weak, boolean allowedForSeeding, boolean walllistColumn) {
            this.m_shortName = shortName;
            this.m_longName = longName;
            this.m_explanation = explanation;
            this.m_weak = weak;
            this.m_allowedForSeeding = allowedForSeeding;
            this.m_walllistColumn = walllistColumn;
        }

        public String getShortName() {
            return this.m_shortName;
        }

        public String getLongName() {
            return this.m_longName;
        }

        public String getExplanation() {
            return this.m_explanation;
        }

        public boolean isAllowedForSeeding() {
            return this.m_allowedForSeeding;
        }

        public boolean isWalllistColumn() {
            return this.m_walllistColumn;
        }

        public boolean isWeak() {
            return this.m_weak;
        }

        public String toString() {
            return this.getLongName();
        }

        @Override
        public void xmlRead(Element scde) throws MacMahonException {
            super.xmlRead(scde);
            this.m_shortName = this.xmlReadTextElement(scde, "ShortName");
        }

        @Override
        public String xmlTagName() {
            return XML_TAGNAME;
        }

        @Override
        protected int xmlTypeVersion() {
            return 2;
        }

        @Override
        protected void xmlWrite(Element scde, Document document) {
            super.xmlWrite(scde, document);
            scde.appendChild(this.xmlCreateTextElement(document, "ShortName", this.m_shortName));
        }
    }

    public static interface WalllistChangeListener {
        public void walllistParticipantAdded(Participant var1);

        public void walllistParticipantRemoved(Participant var1);

        public void walllistChanged();
    }
}

