/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.resources.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnwantedPairing
extends XmlPersistentObject
implements Comparable<UnwantedPairing> {
    public static final int XML_VERSION = 1;
    public static final String XML_TAGNAME = "UnwantedPairing";
    private Participant m_participantOne;
    private Participant m_participantTwo;
    private boolean m_forbidden;
    private int m_participantOneId;
    private int m_participantTwoId;

    public UnwantedPairing() {
    }

    public UnwantedPairing(Participant participantOne, Participant participantTwo, boolean forbidden) {
        if (participantOne == participantTwo) {
            throw new IllegalArgumentException("An UnwantedPairing requires two different participants.");
        }
        this.m_participantOne = participantOne;
        this.m_participantTwo = participantTwo;
        this.m_forbidden = forbidden;
    }

    public boolean getForbidden() {
        return this.m_forbidden;
    }

    public boolean matchesParticipants(Participant participantOne, Participant participantTwo) {
        return this.m_participantOne == participantOne && this.m_participantTwo == participantTwo || this.m_participantOne == participantTwo && this.m_participantTwo == participantOne;
    }

    public boolean matchesParticipant(Participant participant) {
        return this.m_participantOne == participant || this.m_participantTwo == participant;
    }

    public void setForbidden(boolean forbidden) {
        this.m_forbidden = forbidden;
    }

    public void setTournament(Tournament tournament) {
        this.m_participantOne = tournament.getParticipantById(this.m_participantOneId);
        this.m_participantTwo = tournament.getParticipantById(this.m_participantTwoId);
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 1;
    }

    @Override
    public void xmlRead(Element te) throws MacMahonException {
        super.xmlRead(te);
        this.m_participantOneId = this.xmlReadIntegerElement(te, "ParticipantOne");
        this.m_participantTwoId = this.xmlReadIntegerElement(te, "ParticipantTwo");
        this.m_forbidden = this.xmlReadBooleanElement(te, "Forbidden");
    }

    @Override
    public void xmlWrite(Element te, Document document) {
        super.xmlWrite(te, document);
        te.appendChild(this.xmlCreateIntegerElement(document, "ParticipantOne", this.m_participantOne.getId()));
        te.appendChild(this.xmlCreateIntegerElement(document, "ParticipantTwo", this.m_participantTwo.getId()));
        te.appendChild(this.xmlCreateBooleanElement(document, "Forbidden", this.m_forbidden));
    }

    @Override
    public int compareTo(UnwantedPairing other) {
        int compare;
        Participant tauscher;
        if (this.m_participantOne.compareTo(this.m_participantTwo) > 0) {
            tauscher = this.m_participantOne;
            this.m_participantOne = this.m_participantTwo;
            this.m_participantTwo = tauscher;
        }
        if (other.m_participantOne.compareTo(other.m_participantTwo) > 0) {
            tauscher = other.m_participantOne;
            other.m_participantOne = other.m_participantTwo;
            other.m_participantTwo = tauscher;
        }
        return (compare = this.m_participantOne.compareTo(other.m_participantOne)) == 0 ? this.m_participantTwo.compareTo(other.m_participantTwo) : compare;
    }

    public String toString() {
        return this.m_participantOne.getPairingDisplayString() + " - " + this.m_participantTwo.getPairingDisplayString() + (this.m_forbidden ? Messages.getString("UnwantedPairing.ForbiddenMarkerText") : "");
    }
}

