/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Pairing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TournamentRound
extends XmlPersistentObject {
    public static final int XML_VERSION = 2;
    public static final String XML_TAGNAME = "TournamentRound";
    private int m_roundNumber;
    private List<Pairing> m_pairings;
    private Date m_lastUpdated;
    private int m_sortBlocked = 0;
    private List<LastUpdatedListener> m_lastUpdatedListener = new ArrayList<LastUpdatedListener>();

    public TournamentRound() {
        this.m_pairings = new ArrayList<Pairing>();
        this.m_lastUpdated = new Date();
    }

    public TournamentRound(int roundNumber) {
        this();
        this.m_roundNumber = roundNumber;
    }

    public void markUpdated() {
        this.m_lastUpdated = new Date();
        for (LastUpdatedListener lastUpdatedListener : this.m_lastUpdatedListener) {
            lastUpdatedListener.tournamentRoundLastUpdatedChanged(this);
        }
    }

    public void registerLastUpdatedListener(LastUpdatedListener lastUpdatedListener) {
        this.m_lastUpdatedListener.add(lastUpdatedListener);
    }

    public void unregisterLastUpdatedListener(LastUpdatedListener lastUpdatedListener) {
        this.m_lastUpdatedListener.remove(lastUpdatedListener);
    }

    public void addPairing(Pairing pairing) {
        this.m_pairings.add(pairing);
        this.markUpdated();
        this.doSort();
    }

    public void blockSort() {
        ++this.m_sortBlocked;
    }

    public void doSort() {
        if (this.m_sortBlocked == 0) {
            Collections.sort(this.m_pairings);
            int boardNumber = 1;
            for (Pairing pairing : this.m_pairings) {
                if (pairing.isBoardNumberFixed()) {
                    boardNumber = pairing.getBoardNumber();
                } else {
                    pairing.setBoardNumberBySort(boardNumber, false);
                }
                ++boardNumber;
            }
        }
    }

    public void dropPairing() {
        this.blockSort();
        while (!this.m_pairings.isEmpty()) {
            this.m_pairings.get(0).delete();
        }
        this.unblockSort();
    }

    public int fixBoardNumbers() {
        this.blockSort();
        int affectedCount = 0;
        int i = 0;
        while (i < this.m_pairings.size()) {
            if (!this.m_pairings.get(i).isBoardNumberFixed()) {
                this.m_pairings.get(i).setBoardNumber(this.m_pairings.get(i).getBoardNumber(), true);
                ++affectedCount;
            }
            ++i;
        }
        this.unblockSort();
        return affectedCount;
    }

    public Date getLastUpdated() {
        return this.m_lastUpdated;
    }

    public Pairing getPairingAt(int index) {
        return this.m_pairings.get(index);
    }

    public List<Pairing> getPairings() {
        return this.m_pairings;
    }

    public int getRoundNumber() {
        return this.m_roundNumber;
    }

    public void removePairing(Pairing pairing) {
        this.m_pairings.remove(pairing);
        this.markUpdated();
        this.doSort();
    }

    public void unblockSort() {
        if (this.m_sortBlocked > 0) {
            --this.m_sortBlocked;
            this.doSort();
        }
    }

    public int unfixBoardNumbers() {
        this.blockSort();
        int affectedCount = 0;
        int i = 0;
        while (i < this.m_pairings.size()) {
            if (this.m_pairings.get(i).isBoardNumberFixed()) {
                this.m_pairings.get(i).setBoardNumber(this.m_pairings.get(i).getBoardNumber(), false);
                ++affectedCount;
            }
            ++i;
        }
        this.unblockSort();
        return affectedCount;
    }

    @Override
    public void xmlRead(Element tre) throws MacMahonException {
        super.xmlRead(tre);
        this.m_roundNumber = this.xmlReadIntegerElement(tre, "RoundNumber");
        Date lastUpdated = this.xmlVersion() > 1 ? this.xmlReadDateElement(tre, "LastUpdated") : new Date();
        List<XmlPersistentObject> pairings = this.xmlReadPersistentObjects(tre, "Pairing", Pairing.class);
        Iterator<XmlPersistentObject> itPairings = pairings.iterator();
        this.blockSort();
        while (itPairings.hasNext()) {
            Pairing pairing = (Pairing)itPairings.next();
            this.addPairing(pairing);
        }
        this.m_lastUpdated = lastUpdated;
        this.unblockSort();
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 2;
    }

    @Override
    protected void xmlWrite(Element tre, Document document) {
        super.xmlWrite(tre, document);
        tre.appendChild(this.xmlCreateIntegerElement(document, "RoundNumber", this.m_roundNumber));
        tre.appendChild(this.xmlCreateDateElement(document, "LastUpdated", this.m_lastUpdated));
        int i = 0;
        while (i < this.m_pairings.size()) {
            tre.appendChild(this.m_pairings.get(i).xmlWrite(document));
            ++i;
        }
    }

    public static interface LastUpdatedListener {
        public void tournamentRoundLastUpdatedChanged(TournamentRound var1);
    }
}

