/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.gui.WalllistTable;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.GoPlayer;
import de.cgerlach.macmahon.model.IndividualParticipant;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.TournamentRound;
import de.cgerlach.macmahon.model.UnwantedPairing;
import de.cgerlach.macmahon.model.Walllist;
import de.cgerlach.macmahon.mwpm.MaximumWeightPerfectMatchingAlgorithm;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Tournament
extends XmlPersistentObject {
    public static final int XML_VERSION = 9;
    public static final String XML_TAGNAME = "Tournament";
    public static final int PAIRINGS_DEFAULT_FONTSIZE = 12;
    public static final String EXPORT_COLUMN_DELIMITER_TAB = "\t";
    public static final String EXPORT_COLUMN_DELIMITER_SEMIKOLON = ";";
    public static final String EXPORT_COLUMN_DELIMITER_PIPE = "|";
    public static final String EXPORT_COLUMN_DELIMITER_FIXEDFORMAT = "f";
    public static final String[] IMPORT_EXPORT_ENCODINGS = new String[]{"UTF-8", "ISO-8859-1", "ISO-8859-15"};
    public static final String PAIRING_COLUMNNAME_BOARD = Messages.getString("Tournament.PairingColumnnameBoard");
    public static final String PAIRING_COLUMNNAME_BLACK = Messages.getString("Tournament.PairingColumnnameBlack");
    public static final String PAIRING_COLUMNNAME_WHITE = Messages.getString("Tournament.PairingColumnnameWhite");
    public static final String PAIRING_COLUMNNAME_RESULT = Messages.getString("Tournament.PairingColumnnameResult");
    public static final String PAIRING_COLUMNNAME_HANDICAP = Messages.getString("Tournament.PairingColumnnameHandicap");
    public static final String ROUND = Messages.getString("Tournament.Round");
    public static final String BEFORE_ROUND = Messages.getString("Tournament.BeforeRound");
    public static final String AFTER_ROUND = Messages.getString("Tournament.AfterRound");
    private String m_name;
    private String m_description;
    private boolean m_defaultAsianName = false;
    private Hashtable<String, Country> m_countries;
    private List<Country> m_countriesSorted;
    private int m_sortCountriesBlocked = 0;
    private Country m_defaultCountry;
    private Country m_defaultNationality;
    private List<Participant> m_participants;
    private int m_nextParticipantId = 1;
    private Walllist m_walllist;
    private boolean m_ratingAllowed = false;
    private boolean m_ratingDeterminesRank = false;
    private int m_ratingLowestOneDanRating = 2050;
    private boolean m_ratingDeterminesStartScore = false;
    private boolean m_upperMacMahonBar = false;
    private GoLevel m_upperMacMahonBarLevel;
    private int m_upperMacMahonBarRating;
    private boolean m_lowerMacMahonBar = false;
    private GoLevel m_lowerMacMahonBarLevel;
    private boolean m_byeShouldResultInZeroSOSetc = false;
    private boolean m_halfScoreGroupsRoundDown = false;
    private boolean m_halfScoreGroupsRoundDownNotJigo = true;
    private int m_numberOfRounds = 5;
    private int m_currentRoundNumber = 1;
    private boolean m_takeCurrentRoundInAccount = false;
    private TournamentRound[] m_rounds;
    private List<UnwantedPairing> m_unwantedPairings;
    private boolean m_preliminaryDefaultRegistration = false;
    private boolean m_onlineEgdSupport = true;
    private boolean m_onlineEgdSupportByPin = false;
    private boolean m_handicapUsed = true;
    private boolean m_handicapBelow = true;
    private GoLevel m_handicapBelowLevel;
    private boolean m_handicapByLevel = false;
    private boolean m_handicapAdjustment = true;
    private int m_handicapAdjustmentValue = -2;
    private boolean m_handicapLimit = true;
    private int m_handicapLimitValue = 9;
    private boolean m_handicapIncludeInTieBreakers = true;
    private boolean m_allowJigo = false;
    private int m_boardsize = 19;
    private boolean m_pairingsMarkFixedBoardnumbers = true;
    private boolean m_pairingsMarkMissingResults = true;
    private boolean m_pairingsMarkWinner = true;
    private boolean m_pairingsMarkUnwantedPairings = true;
    private boolean m_pairingsShowLevels = true;
    private boolean m_pairingsShortNotationForLevel = false;
    private boolean m_pairingsShowScores = false;
    private boolean m_pairingsShowHandicaps = true;
    private int m_pairingsFontsize = 12;
    private int m_pairingsBlackColumnWidth = 0;
    private int m_pairingsWhiteColumnWidth = 0;
    private double m_pairingsSplitPaneResizeWeight = 0.7144298688193744;
    private String m_importEncoding = "UTF-8";
    private String m_exportColumnDelimiter = "f";
    private boolean m_exportWalllistShowTournamentTitle = true;
    private String m_exportEncoding = "UTF-8";
    private String m_versionCreated;
    private String m_versionSaved;
    private boolean m_makePairingTopGroup = true;
    private boolean m_makePairingTopGroupEverywhere = false;
    private boolean m_makePairingTopGroupStrictlyByTopBar = false;
    private boolean m_makePairingTopGroupByNumberOfPlayersAuto = true;
    private int m_makePairingTopGroupByNumberOfPlayers = 0;
    private boolean m_makePairingTopGroupSeeding = true;
    private Walllist.SortCriterionDescriptor m_makePairingSeedingPlacementCriterion = Walllist.SCD_SOS;
    private boolean m_makePairingTopGroupSeedingByRating = false;
    private int m_makePairingTopGroupSeedingByRatingRound = 2;
    private boolean m_makePairingOutsideTopGroupSameCountry = true;
    private boolean m_makePairingOutsideTopGroupSameClub = true;
    private boolean m_makePairingOutsideTopGroupSameNationality = false;
    private boolean m_makePairingOutsideTopGroupStrengthDifference = true;
    private int m_makePairingOutsideTopGroupStrengthDifferenceValue = 3;
    private boolean m_makePairingOutsideTopGroupColorBalance = true;
    private boolean m_makePairingOutsideTopGroupWeakOddMan = true;
    private boolean m_makePairingOutsideTopGroupSeeding = false;
    private String m_printWalllistFont = "SansSerif";
    private int m_printWalllistFontsize = 9;
    private int m_printWalllistIndentationTop = 0;
    private int m_printWalllistIndentationLeft = 0;
    private int m_printWalllistColumnDistance = 2;
    private boolean m_printWalllistAbbreviateName = true;
    private int m_printWalllistAbbreviateNameLength = 28;
    private String m_printPairingsFont = "SansSerif";
    private int m_printPairingsFontsize = 10;
    private int m_printPairingsIndentationTop = 0;
    private int m_printPairingsIndentationLeft = 0;
    private int m_printPairingsColumnDistance = 3;
    private boolean m_printPairingsAbbreviateName = true;
    private int m_printPairingsAbbreviateNameLength = 35;
    private String m_filepath;
    private static final long ALG_PLAYEDBEFORE_WEIGHT = 0xFFFFFFFL;
    private static final long ALG_SAMEGROUP_WEIGHT = 10000L;
    private static final double ALG_SAMEGROUP_POWER = 2.0;
    private static final long ALG_ODDMAN_WEIGHT = 100L;
    private static final long ALG_SEEDING_WEIGHT = 10L;
    private static final long ALG_COUNTRY_WEIGHT = 20L;
    private static final long ALG_CLUB_WEIGHT = 80L;
    private static final long ALG_NATIONALITY_WEIGHT = 20L;
    private static final long ALG_AVOID_STRENGTH_DIFFERENCE_WEIGHT = 80L;
    private static final long ALG_COLOR_WEIGHT = 50L;
    private static final long ALG_NOTTOP_ODDMAN_WEIGHT = 70L;

    public static String getCenteredString(String string, int length) {
        while (((String)string).length() < length) {
            string = (length - ((String)string).length()) % 2 == 0 ? (String)string + " " : " " + (String)string;
        }
        return string;
    }

    public Tournament() {
        this.m_countries = new Hashtable();
        this.m_countriesSorted = new ArrayList<Country>();
        this.m_participants = new ArrayList<Participant>();
        this.m_walllist = new Walllist(this);
        try {
            this.m_lowerMacMahonBarLevel = new GoLevel(35, false, false);
            this.m_upperMacMahonBarLevel = new GoLevel(9, true, false);
            this.m_handicapBelowLevel = new GoLevel(1, true, false);
        }
        catch (MacMahonException macMahonException) {
            // empty catch block
        }
        this.m_rounds = new TournamentRound[this.m_numberOfRounds];
        int i = 0;
        while (i < this.m_numberOfRounds) {
            this.m_rounds[i] = new TournamentRound(i + 1);
            ++i;
        }
        this.m_unwantedPairings = new ArrayList<UnwantedPairing>();
    }

    public void addCountry(Country country) {
        this.m_countries.put(country.getInternetCode(), country);
        this.m_countriesSorted.add(country);
        this.doSortCountries();
    }

    public void addParticipant(Participant participant) {
        if (participant.getId() == 0) {
            participant.setId(this.m_nextParticipantId);
            ++this.m_nextParticipantId;
        } else if (participant.getId() >= this.m_nextParticipantId) {
            this.m_nextParticipantId = participant.getId() + 1;
        }
        this.m_participants.add(participant);
        this.m_walllist.participantAdded(participant);
    }

    public void blockSortCountries() {
        ++this.m_sortCountriesBlocked;
    }

    public void buildParticipantScores() {
        this.m_walllist.blockSort();
        this.getCurrentRound().blockSort();
        for (Participant participant : this.m_participants) {
            participant.buildScore();
            participant.buildScorex();
            participant.buildNumberOfWins();
            participant.buildSos();
            participant.buildSosos();
            participant.buildSodos();
            participant.buildSorp();
        }
        this.m_walllist.unblockSort();
        this.getCurrentRound().unblockSort();
    }

    public Pairing createForcedPairing(Participant p1, Participant p2) {
        return this.createPairing(p1, p2, true, new Date());
    }

    public Pairing createForcedPairingWithBye(Participant participant) {
        return this.createPairingWithBye(participant, true, new Date());
    }

    public Pairing createPairing(Participant p1, Participant p2, boolean forcedPairing, Date creationTime) {
        Participant white;
        Participant black;
        int handicap = 0;
        boolean p1IsBlack = false;
        if (this.m_handicapUsed && (!this.m_handicapBelow || this.m_handicapBelowLevel.compareTo(p1.getGoLevel()) > 0 && this.m_handicapBelowLevel.compareTo(p2.getGoLevel()) > 0)) {
            if (this.m_handicapByLevel) {
                handicap = p1.getGoLevel().getScoreDifferenceTo(p2.getGoLevel());
                if (p1.getGoLevel().compareTo(p2.getGoLevel()) < 0) {
                    p1IsBlack = true;
                }
            } else {
                handicap = Math.abs(p1.getScore() - p2.getScore()) >> 2;
                if (p1.getScore() < p2.getScore()) {
                    p1IsBlack = true;
                }
            }
            if (handicap > 0 && this.m_handicapAdjustment) {
                handicap += this.m_handicapAdjustmentValue;
            }
            if (handicap < 0) {
                handicap = 0;
            }
            if (this.m_handicapLimit && handicap > this.m_handicapLimitValue) {
                handicap = this.m_handicapLimitValue;
            }
        }
        if (handicap == 0) {
            double v2;
            int p1black = p1.getNumberOfTimesBlack();
            int p1white = p1.getNumberOfTimesWhite();
            int p2black = p2.getNumberOfTimesBlack();
            int p2white = p2.getNumberOfTimesWhite();
            double v1 = 2.0 * (Math.pow(0.5 - (double)(p1black + 1) / (double)(p1black + 1 + p1white), 2.0) + Math.pow(0.5 - (double)p2black / (double)(p2black + p2white + 1), 2.0));
            if (v1 == (v2 = 2.0 * (Math.pow(0.5 - (double)p1black / (double)(p1black + p1white + 1), 2.0) + Math.pow(0.5 - (double)(p2black + 1) / (double)(p2black + 1 + p2white), 2.0)))) {
                if (Math.random() < 0.5) {
                    black = p1;
                    white = p2;
                } else {
                    black = p2;
                    white = p1;
                }
            } else if (v1 < v2) {
                black = p1;
                white = p2;
            } else {
                black = p2;
                white = p1;
            }
        } else if (p1IsBlack) {
            black = p1;
            white = p2;
        } else {
            black = p2;
            white = p1;
        }
        Pairing newPairing = new Pairing(this, this.getCurrentRound(), black, white, handicap, this.m_allowJigo, false, forcedPairing, creationTime);
        black.setPairingInRound(newPairing, this.m_currentRoundNumber);
        white.setPairingInRound(newPairing, this.m_currentRoundNumber);
        this.getCurrentRound().addPairing(newPairing);
        this.m_walllist.doSort();
        return newPairing;
    }

    public Pairing createPairingWithBye(Participant participant, boolean forcedPairing, Date creationTime) {
        Pairing pairing = this.createPairingWithByeInRound(participant, this.getCurrentRoundNumber(), forcedPairing, creationTime);
        this.m_walllist.doSort();
        return pairing;
    }

    private Pairing createPairingWithByeInRound(Participant participant, int round, boolean forcedPairing, Date creationTime) {
        Pairing newPairing = new Pairing(this, this.getRound(round), participant, null, 0, false, true, forcedPairing, creationTime);
        participant.setPairingInRound(newPairing, round);
        this.getRound(round).addPairing(newPairing);
        return newPairing;
    }

    public void createUnwantedPairing(Participant participantOne, Participant participantTwo, boolean forbidden) {
        UnwantedPairing unwantedPairing = this.getUnwantedPairing(participantOne, participantTwo);
        if (unwantedPairing == null) {
            UnwantedPairing newUnwantedPairing = new UnwantedPairing(participantOne, participantTwo, forbidden);
            this.m_unwantedPairings.add(newUnwantedPairing);
        } else {
            unwantedPairing.setForbidden(forbidden);
        }
    }

    public void createUnwantedPairings(List<Participant> participants, boolean forbidden) {
        for (Participant participantOne : participants) {
            for (Participant participantTwo : participants) {
                if (participantOne == participantTwo) continue;
                this.createUnwantedPairing(participantOne, participantTwo, forbidden);
            }
        }
    }

    public void clubNameChanged(Club club) {
        for (Participant participant : this.m_participants) {
            if (!(participant instanceof IndividualParticipant) || ((IndividualParticipant)participant).getGoPlayer().getClub() != club) continue;
            ((IndividualParticipant)participant).getGoPlayer().buildClubDisplayStringWalllist();
        }
    }

    public void deleteParticipant(Participant participant) {
        assert (participant.isDeletable());
        this.m_participants.remove(participant);
        this.m_walllist.participantRemoved(participant);
        Iterator<UnwantedPairing> unwantedPairingsIterator = this.m_unwantedPairings.iterator();
        while (unwantedPairingsIterator.hasNext()) {
            UnwantedPairing unwantedPairing = unwantedPairingsIterator.next();
            if (!unwantedPairing.matchesParticipant(participant)) continue;
            unwantedPairingsIterator.remove();
        }
    }

    public void deletePreliminaryRegisteredParticipants() {
        this.m_walllist.blockSort();
        Iterator<Participant> iterator = this.m_participants.iterator();
        while (iterator.hasNext()) {
            Participant participant = iterator.next();
            if (!participant.getPreliminaryRegistration()) continue;
            iterator.remove();
            this.m_walllist.participantRemoved(participant);
        }
        this.m_walllist.unblockSort();
    }

    public void deleteUnwantedPairings(List<UnwantedPairing> unwantedPairings) {
        this.m_unwantedPairings.removeAll(unwantedPairings);
    }

    private void doSortCountries() {
        if (this.m_sortCountriesBlocked == 0) {
            Collections.sort(this.m_countriesSorted);
        }
    }

    public void dropPairing() {
        this.m_walllist.blockSort();
        this.getCurrentRound().dropPairing();
        if (this.takeCurrentRoundInAccount()) {
            this.buildParticipantScores();
        }
        this.m_walllist.unblockSort();
    }

    public UnwantedPairing getUnwantedPairing(Participant participantOne, Participant participantTwo) {
        for (UnwantedPairing unwantedPairing : this.m_unwantedPairings) {
            if (!unwantedPairing.matchesParticipants(participantOne, participantTwo)) continue;
            return unwantedPairing;
        }
        return null;
    }

    public void exportCurrentPairing(Writer out) throws IOException {
        String delimiter = this.getExportColumnDelimiter();
        boolean fixedFormat = delimiter.equals(EXPORT_COLUMN_DELIMITER_FIXEDFORMAT);
        out.write(this.getNameRoundDisplayString());
        out.write("\r\n");
        Object headerFixedFormatString = "";
        Object fixedFormatString = "";
        ArrayList<String> headerFixedFormatValues = new ArrayList<String>();
        int boardLength = 6;
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + "%-" + boardLength + "." + boardLength + "s";
            fixedFormatString = (String)fixedFormatString + "%" + (boardLength - 2) + "." + (boardLength - 2) + "s  ";
            headerFixedFormatValues.add(PAIRING_COLUMNNAME_BOARD);
        } else {
            out.write(PAIRING_COLUMNNAME_BOARD);
        }
        int nameLength = 42;
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + " %-" + nameLength + "." + nameLength + "s";
            fixedFormatString = (String)fixedFormatString + " %-" + nameLength + "." + nameLength + "s";
            headerFixedFormatValues.add(PAIRING_COLUMNNAME_BLACK);
        } else {
            out.write(delimiter);
            out.write(PAIRING_COLUMNNAME_BLACK);
        }
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + "   %-" + nameLength + "." + nameLength + "s";
            fixedFormatString = (String)fixedFormatString + " - %-" + nameLength + "." + nameLength + "s";
            headerFixedFormatValues.add(PAIRING_COLUMNNAME_WHITE);
        } else {
            out.write(delimiter);
            out.write(PAIRING_COLUMNNAME_WHITE);
        }
        int resultLength = 7;
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + " %-" + resultLength + "." + resultLength + "s";
            fixedFormatString = (String)fixedFormatString + " %-" + resultLength + "." + resultLength + "s";
            headerFixedFormatValues.add(PAIRING_COLUMNNAME_RESULT);
        } else {
            out.write(delimiter);
            out.write(PAIRING_COLUMNNAME_RESULT);
        }
        int handicapLength = 25;
        if (this.getPairingsShowHandicaps()) {
            if (fixedFormat) {
                headerFixedFormatString = (String)headerFixedFormatString + " %-" + handicapLength + "." + handicapLength + "s";
                fixedFormatString = (String)fixedFormatString + " %-" + handicapLength + "." + handicapLength + "s";
                headerFixedFormatValues.add(PAIRING_COLUMNNAME_HANDICAP);
            } else {
                out.write(delimiter);
                out.write(PAIRING_COLUMNNAME_HANDICAP);
            }
        }
        if (fixedFormat) {
            out.write(String.format((String)headerFixedFormatString, headerFixedFormatValues.toArray()));
        }
        out.write("\r\n");
        List<Pairing> pairings = this.getCurrentRound().getPairings();
        int i = 0;
        while (i < pairings.size()) {
            String whiteValue;
            Pairing pairing = pairings.get(i);
            ArrayList<String> fixedFormatValues = new ArrayList<String>();
            if (fixedFormat) {
                fixedFormatValues.add(Integer.toString(pairing.getBoardNumber()));
            } else {
                out.write(Integer.toString(pairing.getBoardNumber()));
            }
            String blackValue = pairing.getBlack().getPairingDisplayString();
            if (this.getExportEncoding().equals("ISO-8859-15")) {
                blackValue = blackValue.replaceAll("\u00bd", ",5");
            }
            if (fixedFormat) {
                fixedFormatValues.add(blackValue);
            } else {
                out.write(delimiter);
                out.write(blackValue);
            }
            String string = whiteValue = pairing.isPairingWithBye() ? Pairing.BYE : pairing.getWhite().getPairingDisplayString();
            if (this.getExportEncoding().equals("ISO-8859-15")) {
                whiteValue = whiteValue.replaceAll("\u00bd", ",5");
            }
            if (fixedFormat) {
                fixedFormatValues.add(whiteValue);
            } else {
                out.write(delimiter);
                out.write(whiteValue);
            }
            String resultValue = pairing.getResultDisplayString();
            if (this.getExportEncoding().equals("ISO-8859-15")) {
                resultValue = resultValue.replaceAll("\u00bd", "=");
            }
            if (fixedFormat) {
                fixedFormatValues.add(resultValue);
            } else {
                out.write(delimiter);
                out.write(resultValue);
            }
            if (this.getPairingsShowHandicaps()) {
                String handicapValue = pairing.getHandicapDisplayString();
                if (handicapValue != null && this.getExportEncoding().equals("ISO-8859-15")) {
                    handicapValue = handicapValue.replaceAll("\u00bd", ",5");
                }
                if (fixedFormat) {
                    fixedFormatValues.add(handicapValue == null ? "" : handicapValue);
                } else {
                    out.write(delimiter);
                    out.write(handicapValue == null ? "" : handicapValue);
                }
            }
            if (fixedFormat) {
                out.write(String.format((String)fixedFormatString, fixedFormatValues.toArray()));
            }
            out.write("\r\n");
            ++i;
        }
    }

    public void exportForEGD(Writer out) throws IOException {
        String name = this.getName();
        if (name != null && name.length() > 0) {
            out.write("; EV[");
            out.write(name);
            out.write("]");
            out.write("\r\n");
        }
        int i = 0;
        while (i < this.getWalllist().getParticipantCount()) {
            Participant participant = this.getWalllist().getParticipantAt(i);
            out.write(Integer.toString(participant.getPlace()));
            out.write(EXPORT_COLUMN_DELIMITER_TAB);
            out.write(participant.getNameExportForEGD());
            out.write(EXPORT_COLUMN_DELIMITER_TAB);
            out.write(participant.getGoLevel().getShortDisplayString());
            out.write(EXPORT_COLUMN_DELIMITER_TAB);
            if (participant instanceof IndividualParticipant) {
                IndividualParticipant individualParticipant = (IndividualParticipant)participant;
                Country country = individualParticipant.getGoPlayer().getCountry();
                if (country == null) {
                    out.write("xx");
                    out.write(EXPORT_COLUMN_DELIMITER_TAB);
                    out.write("xxxx");
                } else {
                    out.write(country.getInternetCode());
                    out.write(EXPORT_COLUMN_DELIMITER_TAB);
                    Club club = individualParticipant.getGoPlayer().getClub();
                    if (club == null) {
                        out.write("xxxx");
                    } else if (club.getEgdName() == null) {
                        out.write(club.getName().length() > 4 ? club.getName().substring(0, 4) : club.getName());
                    } else {
                        out.write(club.getEgdName());
                    }
                }
            } else {
                out.write("xx");
                out.write(EXPORT_COLUMN_DELIMITER_TAB);
                out.write("xxxx");
            }
            out.write(EXPORT_COLUMN_DELIMITER_TAB);
            out.write(participant.getScoreDisplayString().replace('\u00bd', '='));
            out.write(EXPORT_COLUMN_DELIMITER_TAB);
            out.write(participant.getNumberOfWinsDisplayString().replace('\u00bd', '='));
            for (Walllist.SortCriterionDescriptor sortCriterion : this.getWalllist().getSortCriteria()) {
                if (sortCriterion == Walllist.SCD_SCOREX) {
                    out.write(EXPORT_COLUMN_DELIMITER_TAB);
                    out.write(participant.getScorexDisplayString().replace('\u00bd', '='));
                    continue;
                }
                if (sortCriterion == Walllist.SCD_SOS) {
                    out.write(EXPORT_COLUMN_DELIMITER_TAB);
                    out.write(participant.getSosDisplayString().replace('\u00bd', '='));
                    continue;
                }
                if (sortCriterion == Walllist.SCD_SOSOS) {
                    out.write(EXPORT_COLUMN_DELIMITER_TAB);
                    out.write(participant.getSososDisplayString().replace('\u00bd', '='));
                    continue;
                }
                if (sortCriterion != Walllist.SCD_SODOS) continue;
                out.write(EXPORT_COLUMN_DELIMITER_TAB);
                out.write(participant.getSodosDisplayString().replace('\u00bd', '='));
            }
            int round = 1;
            while (round <= this.getCurrentRoundNumber()) {
                out.write(EXPORT_COLUMN_DELIMITER_TAB);
                Pairing pairing = participant.getPairingInRound(round);
                if (pairing == null || pairing == Pairing.NOT_PLAYING) {
                    out.write("0=");
                } else if (pairing.isPairingWithBye()) {
                    out.write("0+");
                } else {
                    out.write(Integer.toString(pairing.getOpponent(participant).getPlace()));
                    out.write(pairing.getWalllistResult(participant, false, false, true, true));
                }
                ++round;
            }
            out.write("\r\n");
            ++i;
        }
    }

    public void exportStatistics(Writer out) throws IOException {
        HashMap<Country, CountryStatistics> countryStatisticsMap = new HashMap<Country, CountryStatistics>();
        HashMap<Club, ClubStatistics> clubStatisticsMap = new HashMap<Club, ClubStatistics>();
        HashMap<GoLevel, GoLevelStatistics> goLevelStatisticsMap = new HashMap<GoLevel, GoLevelStatistics>();
        int countryDisplayNameMaxLength = 7;
        int countryNumberOfPlayersMax = 9999;
        int clubDisplayNameMaxLength = 4;
        int clubNumberOfPlayersMax = 9999;
        int goLevelDisplayNameMaxLength = 4;
        int goLevelNumberOfPlayersMax = 9999;
        int[] winStats = new int[(this.getNumberOfRounds() << 1) + 1];
        int i = 0;
        while (i < winStats.length) {
            winStats[i] = 0;
            ++i;
        }
        boolean includeWinStats = false;
        boolean halfPointsExist = false;
        for (Participant participant : this.m_participants) {
            GoLevel goLevel;
            Club club;
            Country country = participant.getCountry();
            if (country != null) {
                CountryStatistics countryStatistics = (CountryStatistics)countryStatisticsMap.get(country);
                if (countryStatistics == null) {
                    countryStatistics = new CountryStatistics(country);
                    countryStatisticsMap.put(country, countryStatistics);
                    int countryDisplayNameLength = country.toString().length();
                    if (countryDisplayNameLength > countryDisplayNameMaxLength) {
                        countryDisplayNameMaxLength = countryDisplayNameLength;
                    }
                }
                countryStatistics.processParticipant(participant);
                if (countryStatistics.m_numberOfPlayers > countryNumberOfPlayersMax) {
                    countryNumberOfPlayersMax = countryStatistics.m_numberOfPlayers;
                }
            }
            if ((club = participant.getClub()) != null) {
                ClubStatistics clubStatistics = (ClubStatistics)clubStatisticsMap.get(club);
                if (clubStatistics == null) {
                    clubStatistics = new ClubStatistics(club);
                    clubStatisticsMap.put(club, clubStatistics);
                    int clubDisplayNameLength = club.toString().length();
                    if (clubDisplayNameLength > clubDisplayNameMaxLength) {
                        clubDisplayNameMaxLength = clubDisplayNameLength;
                    }
                }
                clubStatistics.processParticipant(participant);
                if (clubStatistics.m_numberOfPlayers > clubNumberOfPlayersMax) {
                    clubNumberOfPlayersMax = clubStatistics.m_numberOfPlayers;
                }
            }
            if ((goLevel = participant.getGoLevel()) != null) {
                GoLevelStatistics goLevelStatistics = (GoLevelStatistics)goLevelStatisticsMap.get(goLevel);
                if (goLevelStatistics == null) {
                    goLevelStatistics = new GoLevelStatistics(goLevel);
                    goLevelStatisticsMap.put(goLevel, goLevelStatistics);
                    int goLevelDisplayLength = goLevel.getDisplayString().length();
                    if (goLevelDisplayLength > goLevelDisplayNameMaxLength) {
                        goLevelDisplayNameMaxLength = goLevelDisplayLength;
                    }
                }
                goLevelStatistics.processParticipant(participant);
                if (goLevelStatistics.m_numberOfPlayers > goLevelNumberOfPlayersMax) {
                    goLevelNumberOfPlayersMax = goLevelStatistics.m_numberOfPlayers;
                }
            }
            if (!participant.hasPlayedCompleteTournament()) continue;
            includeWinStats = true;
            if ((participant.getNumberOfWins() & 1) == 1) {
                halfPointsExist = true;
            }
            int n = participant.getNumberOfWins();
            winStats[n] = winStats[n] + 1;
        }
        out.write(this.getNameRoundDisplayString());
        out.write(" - ");
        out.write("Statistics");
        out.write("\r\n");
        boolean explanationRequired = false;
        if (!countryStatisticsMap.isEmpty()) {
            out.write("\r\n");
            out.write("\r\n");
            ArrayList countryStatisticsList = new ArrayList(countryStatisticsMap.values());
            Collections.sort(countryStatisticsList);
            int countryNumberOfPlayersDisplayLength = Integer.toString(countryNumberOfPlayersMax).length();
            String countryStatisticsFormat = "%-" + countryDisplayNameMaxLength + "." + countryDisplayNameMaxLength + "s %" + countryNumberOfPlayersDisplayLength + "s/%-" + countryNumberOfPlayersDisplayLength + "s %5.5s %6.6s";
            out.write("Statistics by country:");
            out.write("\r\n");
            out.write("\r\n");
            out.write(String.format(countryStatisticsFormat, "Country", "comp", "all", "games", "win %"));
            out.write("\r\n");
            for (CountryStatistics countryStatistics : countryStatisticsList) {
                out.write(String.format(countryStatisticsFormat, countryStatistics.m_country.toString(), Integer.toString(countryStatistics.m_numberOfPlayersCompleteTournament), Integer.toString(countryStatistics.m_numberOfPlayers), Integer.toString(countryStatistics.m_numberOfGamesPlayed), countryStatistics.m_numberOfGamesPlayed == 0 ? "-" : String.format("%2d%%", Math.round(100.0 * (double)countryStatistics.m_numberOfWins / 2.0 / (double)countryStatistics.m_numberOfGamesPlayed))));
                out.write("\r\n");
            }
            explanationRequired = true;
        }
        if (!clubStatisticsMap.isEmpty()) {
            out.write("\r\n");
            out.write("\r\n");
            ArrayList clubStatisticsList = new ArrayList(clubStatisticsMap.values());
            Collections.sort(clubStatisticsList);
            int clubNumberOfPlayersDisplayLength = Integer.toString(clubNumberOfPlayersMax).length();
            String clubStatisticsFormat = "%-" + countryDisplayNameMaxLength + "." + countryDisplayNameMaxLength + "s %-" + clubDisplayNameMaxLength + "." + clubDisplayNameMaxLength + "s %" + clubNumberOfPlayersDisplayLength + "s/%-" + clubNumberOfPlayersDisplayLength + "s %5.5s %6.6s";
            out.write("Statistics by club:");
            out.write("\r\n");
            out.write("\r\n");
            out.write(String.format(clubStatisticsFormat, "Country", "Club", "comp", "all", "games", "win %"));
            out.write("\r\n");
            for (ClubStatistics clubStatistics : clubStatisticsList) {
                out.write(String.format(clubStatisticsFormat, clubStatistics.m_club.getCountry().toString(), clubStatistics.m_club.toString(), Integer.toString(clubStatistics.m_numberOfPlayersCompleteTournament), Integer.toString(clubStatistics.m_numberOfPlayers), Integer.toString(clubStatistics.m_numberOfGamesPlayed), clubStatistics.m_numberOfGamesPlayed == 0 ? "-" : String.format("%2d%%", Math.round(100.0 * (double)clubStatistics.m_numberOfWins / 2.0 / (double)clubStatistics.m_numberOfGamesPlayed))));
                out.write("\r\n");
            }
            explanationRequired = true;
        }
        if (!goLevelStatisticsMap.isEmpty()) {
            out.write("\r\n");
            out.write("\r\n");
            ArrayList goLevelStatisticsList = new ArrayList(goLevelStatisticsMap.values());
            Collections.sort(goLevelStatisticsList);
            int goLevelNumberOfPlayersDisplayLength = Integer.toString(goLevelNumberOfPlayersMax).length();
            String goLevelStatisticsFormat = "%-" + goLevelDisplayNameMaxLength + "." + goLevelDisplayNameMaxLength + "s %" + goLevelNumberOfPlayersDisplayLength + "s/%-" + goLevelNumberOfPlayersDisplayLength + "s %5.5s %6.6s";
            out.write("Statistics by Rank:");
            out.write("\r\n");
            out.write("\r\n");
            out.write(String.format(goLevelStatisticsFormat, "Rank", "comp", "all", "games", "win %"));
            out.write("\r\n");
            ListIterator goLevelStatisticsIterator = goLevelStatisticsList.listIterator(goLevelStatisticsList.size());
            GoLevelStatistics goLevelStatistics = (GoLevelStatistics)goLevelStatisticsIterator.previous();
            GoLevelStatistics previousGoLevelStatistics = null;
            while (true) {
                out.write(String.format(goLevelStatisticsFormat, goLevelStatistics.m_goLevel.getDisplayString(), Integer.toString(goLevelStatistics.m_numberOfPlayersCompleteTournament), Integer.toString(goLevelStatistics.m_numberOfPlayers), Integer.toString(goLevelStatistics.m_numberOfGamesPlayed), goLevelStatistics.m_numberOfGamesPlayed == 0 ? "-" : String.format("%2d%%", Math.round(100.0 * (double)goLevelStatistics.m_numberOfWins / 2.0 / (double)goLevelStatistics.m_numberOfGamesPlayed))));
                out.write("\r\n");
                GoLevel nextGoLevel = goLevelStatistics.m_goLevel.decreaseOneLevel();
                if (previousGoLevelStatistics == null && goLevelStatisticsIterator.hasPrevious()) {
                    previousGoLevelStatistics = (GoLevelStatistics)goLevelStatisticsIterator.previous();
                }
                if (previousGoLevelStatistics == null) break;
                if (nextGoLevel.compareTo(previousGoLevelStatistics.m_goLevel) > 0) {
                    goLevelStatistics = new GoLevelStatistics(nextGoLevel);
                    continue;
                }
                goLevelStatistics = previousGoLevelStatistics;
                previousGoLevelStatistics = null;
            }
            explanationRequired = true;
        }
        if (includeWinStats) {
            out.write("\r\n");
            out.write("\r\n");
            out.write("Distribution of wins (there are only those players in this statistic who played all rounds):");
            out.write("\r\n");
            out.write("\r\n");
            String winStatisticsFormat = "%4.4s %4.4s";
            out.write(String.format(winStatisticsFormat, "Wins", "#"));
            out.write("\r\n");
            int i2 = winStats.length - 1;
            while (i2 >= 0) {
                if (halfPointsExist || (i2 & 1) == 0) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Integer.toString(i2 >> 1) + ((i2 & 1) == 1 ? (this.getExportEncoding().equals("ISO-8859-15") ? ",5" : "\u00bd") : (this.getExportEncoding().equals("ISO-8859-15") ? "  " : " "));
                    objectArray[1] = Integer.toString(winStats[i2]);
                    out.write(String.format(winStatisticsFormat, objectArray));
                    out.write("\r\n");
                }
                --i2;
            }
        }
        if (explanationRequired) {
            out.write("\r\n");
            out.write("\r\n");
            out.write("Legend:");
            out.write("\r\n");
            out.write("comp = participants who played all rounds of the tournament");
            out.write("\r\n");
            out.write("all = all participants even if they didn't play any round");
            out.write("\r\n");
            out.write("games = participations of players in games (each game is counted twice except when a bye is envolved)");
            out.write("\r\n");
        }
    }

    public void exportWalllist(Writer out) throws IOException {
        String delimiter = this.getExportColumnDelimiter();
        boolean fixedFormat = delimiter.equals(EXPORT_COLUMN_DELIMITER_FIXEDFORMAT);
        if (this.getExportWalllistShowTournamentTitle()) {
            out.write(this.getNameRoundDisplayString());
            out.write("\r\n");
        }
        Object headerFixedFormatString = "";
        Object fixedFormatString = "";
        ArrayList<String> headerFixedFormatValues = new ArrayList<String>();
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + "%-5.5s";
            fixedFormatString = (String)fixedFormatString + "%5.5s";
            headerFixedFormatValues.add(Walllist.COLUMNNAME_PLACE);
        } else {
            out.write(Walllist.COLUMNNAME_PLACE);
            out.write(delimiter);
        }
        int nameLength = 36;
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + " %-" + nameLength + "." + nameLength + "s";
            fixedFormatString = (String)fixedFormatString + " %-" + nameLength + "." + nameLength + "s";
            headerFixedFormatValues.add(Walllist.COLUMNNAME_NAME);
        } else {
            out.write(Walllist.COLUMNNAME_NAME);
        }
        boolean clubs = false;
        if (this.m_walllist.getShowCountry() || this.m_walllist.getShowClub()) {
            clubs = true;
            if (fixedFormat) {
                int clubLength = this.getWalllist().getShowClub() ? (this.getWalllist().getShowClubAbbreviateName() ? (this.getWalllist().getShowCountry() ? 7 : 4) : 16) : 2;
                headerFixedFormatString = (String)headerFixedFormatString + " %-" + clubLength + "." + clubLength + "s";
                fixedFormatString = (String)fixedFormatString + " %-" + clubLength + "." + clubLength + "s";
                headerFixedFormatValues.add(Walllist.COLUMNNAME_CLUB);
            } else {
                out.write(delimiter);
                out.write(Walllist.COLUMNNAME_CLUB);
            }
        }
        boolean levels = false;
        int levelLength = 0;
        if (this.m_walllist.getShowLevels()) {
            levels = true;
            if (fixedFormat) {
                levelLength = this.m_walllist.getShortNotationForLevel() ? 5 : 6;
                headerFixedFormatString = (String)headerFixedFormatString + " %" + levelLength + "." + levelLength + "s";
                fixedFormatString = (String)fixedFormatString + " %" + levelLength + "." + levelLength + "s";
                headerFixedFormatValues.add(Walllist.COLUMNNAME_LEVEL);
            } else {
                out.write(delimiter);
                out.write(Walllist.COLUMNNAME_LEVEL);
            }
        }
        boolean ratings = false;
        if (this.getRatingAllowed() && this.m_walllist.getShowRatings()) {
            ratings = true;
            if (fixedFormat) {
                headerFixedFormatString = (String)headerFixedFormatString + " %-6.6s";
                fixedFormatString = (String)fixedFormatString + "  %4.4s ";
                headerFixedFormatValues.add(Walllist.COLUMNNAME_RATING);
            } else {
                out.write(delimiter);
                out.write(Walllist.COLUMNNAME_RATING);
            }
        }
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + " %-5.5s";
            fixedFormatString = (String)fixedFormatString + " %5.5s";
            headerFixedFormatValues.add(Walllist.SCD_SCORE.getLongName());
        } else {
            out.write(delimiter);
            out.write(Walllist.SCD_SCORE.getLongName());
        }
        int roundLength = Integer.toString(this.m_participants.size()).length() + 1;
        if (this.getWalllist().getMarkResultsByReferree()) {
            ++roundLength;
        }
        if (this.getWalllist().getShowColors() || this.getWalllist().getShowHandicap()) {
            roundLength += 2;
        }
        if (this.getWalllist().getShowHandicap()) {
            roundLength += 2;
        }
        roundLength = Math.max(Integer.toString(this.getNumberOfRounds()).length(), roundLength);
        int round = 1;
        while (round <= this.getCurrentRoundNumber()) {
            if (fixedFormat) {
                headerFixedFormatString = (String)headerFixedFormatString + " %-" + roundLength + "." + roundLength + "s";
                fixedFormatString = (String)fixedFormatString + " %" + roundLength + "." + roundLength + "s";
                headerFixedFormatValues.add(Tournament.getCenteredString(Integer.toString(round), roundLength));
            } else {
                out.write(delimiter);
                out.write(Integer.toString(round));
            }
            ++round;
        }
        if (fixedFormat) {
            headerFixedFormatString = (String)headerFixedFormatString + " %-6.6s";
            fixedFormatString = (String)fixedFormatString + " %6.6s";
            headerFixedFormatValues.add(Tournament.getCenteredString(Walllist.SCD_NUMBEROFWINS.getLongName(), 6));
        } else {
            out.write(delimiter);
            out.write(Walllist.SCD_NUMBEROFWINS.getLongName());
        }
        int sortCriterionLength = this.getExportEncoding().equals("ISO-8859-15") ? 8 : 6;
        for (Walllist.SortCriterionDescriptor sortCriterion : this.getWalllist().getSortCriteria()) {
            if (!sortCriterion.isWalllistColumn()) continue;
            if (fixedFormat) {
                headerFixedFormatString = (String)headerFixedFormatString + " %-" + sortCriterionLength + "." + sortCriterionLength + "s";
                fixedFormatString = (String)fixedFormatString + " %" + sortCriterionLength + "." + sortCriterionLength + "s";
                headerFixedFormatValues.add(Tournament.getCenteredString(sortCriterion.getLongName(), sortCriterionLength));
                continue;
            }
            out.write(delimiter);
            out.write(sortCriterion.getLongName());
        }
        if (fixedFormat) {
            out.write(String.format((String)headerFixedFormatString, headerFixedFormatValues.toArray()));
        }
        out.write("\r\n");
        int i = 0;
        while (i < this.getWalllist().getParticipantCount()) {
            ArrayList<Object> fixedFormatValues = new ArrayList<Object>();
            Participant participant = this.getWalllist().getParticipantAt(i);
            if (fixedFormat) {
                String placeValue = participant.isPlaceShared() ? "(" + Integer.toString(participant.getPlace()) + ")" : Integer.toString(participant.getPlace()) + " ";
                fixedFormatValues.add(placeValue);
            } else if (participant.isPlaceShared()) {
                out.write("(");
                out.write(Integer.toString(participant.getPlace()));
                out.write(")");
            } else {
                out.write(Integer.toString(participant.getPlace()));
            }
            if (fixedFormat) {
                fixedFormatValues.add(participant.getName());
            } else {
                out.write(delimiter);
                out.write(participant.getName());
            }
            if (clubs) {
                String clubDisplayString = participant.getClubDisplayStringWalllist();
                if (fixedFormat) {
                    fixedFormatValues.add(clubDisplayString == null ? "" : clubDisplayString);
                } else {
                    out.write(delimiter);
                    if (clubDisplayString != null) {
                        out.write(clubDisplayString);
                    }
                }
            }
            if (levels) {
                String levelValue = participant.getGoLevel() == null ? "?" : (this.m_walllist.getShortNotationForLevel() ? participant.getGoLevel().getShortDisplayString() : participant.getGoLevel().getWalllistDisplayString());
                if (fixedFormat) {
                    fixedFormatValues.add(Tournament.getCenteredString(levelValue, levelLength));
                } else {
                    out.write(delimiter);
                    out.write(levelValue);
                }
            }
            if (ratings) {
                String ratingValue = Integer.toString(participant.getRating());
                if (fixedFormat) {
                    fixedFormatValues.add(ratingValue);
                } else {
                    out.write(delimiter);
                    out.write(ratingValue);
                }
            }
            String scoreValue = this.formatScoreValue(participant.getScoreDisplayString(), fixedFormat);
            if (fixedFormat) {
                fixedFormatValues.add(scoreValue);
            } else {
                out.write(delimiter);
                out.write(scoreValue);
            }
            int round2 = 1;
            while (round2 <= this.getCurrentRoundNumber()) {
                Pairing pairing = participant.getPairingInRound(round2);
                if (fixedFormat) {
                    String roundValue = pairing == null ? Tournament.getCenteredString("?", roundLength) : pairing.getWalllistString(participant, true, roundLength);
                    fixedFormatValues.add(roundValue);
                } else {
                    out.write(delimiter);
                    if (pairing == null) {
                        out.write("?");
                    } else {
                        out.write(pairing.getWalllistString(participant, false, 0));
                    }
                }
                ++round2;
            }
            String winsValue = this.formatScoreValue(participant.getNumberOfWinsDisplayString(), fixedFormat);
            if (fixedFormat) {
                fixedFormatValues.add(winsValue + " ");
            } else {
                out.write(delimiter);
                out.write(winsValue);
            }
            for (Walllist.SortCriterionDescriptor sortCriterion : this.getWalllist().getSortCriteria()) {
                if (!sortCriterion.isWalllistColumn()) continue;
                String value = null;
                if (sortCriterion == Walllist.SCD_SCOREX) {
                    value = participant.getScorexDisplayString();
                } else if (sortCriterion == Walllist.SCD_SOS) {
                    value = participant.getSosDisplayString();
                } else if (sortCriterion == Walllist.SCD_SOSOS) {
                    value = participant.getSososDisplayString();
                } else if (sortCriterion == Walllist.SCD_SODOS) {
                    value = participant.getSodosDisplayString();
                } else if (sortCriterion == Walllist.SCD_SORP) {
                    value = participant.getSorpDisplayString();
                }
                if (value != null) {
                    value = this.formatScoreValue(value, fixedFormat);
                }
                if (fixedFormat) {
                    fixedFormatValues.add(value == null ? "" : value);
                    continue;
                }
                out.write(delimiter);
                if (value == null) continue;
                out.write(value);
            }
            if (fixedFormat) {
                out.write(String.format((String)fixedFormatString, fixedFormatValues.toArray()));
            }
            out.write("\r\n");
            ++i;
        }
    }

    public Country findCountry(String internetCode) {
        return this.m_countries.get(internetCode.toLowerCase());
    }

    private String formatScoreValue(String scoreValue, boolean fixedFormat) {
        if (fixedFormat) {
            if (this.getExportEncoding().equals("ISO-8859-15")) {
                scoreValue = ((String)scoreValue).endsWith("\u00bc") ? ((String)scoreValue).substring(0, ((String)scoreValue).length() - 1) + ",25" : (((String)scoreValue).endsWith("\u00bd") ? ((String)scoreValue).substring(0, ((String)scoreValue).length() - 1) + ",5 " : (((String)scoreValue).endsWith("\u00be") ? ((String)scoreValue).substring(0, ((String)scoreValue).length() - 1) + ",75" : (String)scoreValue + "   "));
            } else if (!(((String)scoreValue).endsWith("\u00bc") || ((String)scoreValue).endsWith("\u00bd") || ((String)scoreValue).endsWith("\u00be"))) {
                scoreValue = (String)scoreValue + " ";
            }
        } else if (this.getExportEncoding().equals("ISO-8859-15")) {
            scoreValue = ((String)scoreValue).replaceAll("\u00bc", ",25");
            scoreValue = ((String)scoreValue).replaceAll("\u00bd", ",5");
            scoreValue = ((String)scoreValue).replaceAll("\u00be", ",75");
        }
        return scoreValue;
    }

    public boolean getAllowJigo() {
        return this.m_allowJigo;
    }

    public int getBoardsize() {
        return this.m_boardsize;
    }

    public boolean getByeShouldResultInZeroSOSetc() {
        return this.m_byeShouldResultInZeroSOSetc;
    }

    public List<Country> getCountries() {
        return this.m_countriesSorted;
    }

    public int[] getCountScoreGroupSizesInRound(int round) {
        int[] countScoreGroupSizes = new int[100];
        int i = 0;
        while (i < countScoreGroupSizes.length) {
            countScoreGroupSizes[i] = 0;
            ++i;
        }
        for (Participant participant : this.m_participants) {
            if (participant.getPairingInRound(round) == Pairing.NOT_PLAYING) continue;
            int score = participant.getScoreAfterRound(round - 1);
            if (score >= countScoreGroupSizes.length) {
                int[] newCountScoreGroupSizes = new int[Math.max(countScoreGroupSizes.length + 100, score + 1)];
                int i2 = 0;
                while (i2 < newCountScoreGroupSizes.length) {
                    newCountScoreGroupSizes[i2] = 0;
                    ++i2;
                }
                System.arraycopy(countScoreGroupSizes, 0, newCountScoreGroupSizes, 0, countScoreGroupSizes.length);
                countScoreGroupSizes = newCountScoreGroupSizes;
            }
            int n = score;
            countScoreGroupSizes[n] = countScoreGroupSizes[n] + 1;
        }
        return countScoreGroupSizes;
    }

    public TournamentRound getCurrentRound() {
        return this.m_rounds[this.m_currentRoundNumber - 1];
    }

    public int getCurrentRoundNumber() {
        return this.m_currentRoundNumber;
    }

    public boolean getDefaultAsianName() {
        return this.m_defaultAsianName;
    }

    public Country getDefaultCountry() {
        return this.m_defaultCountry;
    }

    public Country getDefaultNationality() {
        return this.m_defaultNationality;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getExportColumnDelimiter() {
        if (this.m_exportColumnDelimiter == null) {
            this.m_exportColumnDelimiter = EXPORT_COLUMN_DELIMITER_TAB;
        }
        return this.m_exportColumnDelimiter;
    }

    public String getImportEncoding() {
        return this.m_importEncoding;
    }

    public String getExportEncoding() {
        return this.m_exportEncoding;
    }

    public boolean getExportWalllistShowTournamentTitle() {
        return this.m_exportWalllistShowTournamentTitle;
    }

    public String getFilepath() {
        return this.m_filepath;
    }

    public boolean getHalfScoreGroupsRoundDown() {
        return this.m_halfScoreGroupsRoundDown;
    }

    public boolean getHalfScoreGroupsRoundDownNotJigo() {
        return this.m_halfScoreGroupsRoundDownNotJigo;
    }

    public boolean getHandicapBelow() {
        return this.m_handicapBelow;
    }

    public GoLevel getHandicapBelowLevel() {
        return this.m_handicapBelowLevel;
    }

    public boolean getHandicapByLevel() {
        return this.m_handicapByLevel;
    }

    public boolean getHandicapLimit() {
        return this.m_handicapLimit;
    }

    public int getHandicapLimitValue() {
        return this.m_handicapLimitValue;
    }

    public boolean getHandicapAdjustment() {
        return this.m_handicapAdjustment;
    }

    public int getHandicapAdjustmentValue() {
        return this.m_handicapAdjustmentValue;
    }

    public boolean getHandicapIncludeInTieBreakers() {
        return this.m_handicapIncludeInTieBreakers;
    }

    public boolean getHandicapUsed() {
        return this.m_handicapUsed;
    }

    public List<Participant> getJokerParticipantsFreeInRound(int round) {
        ArrayList<Participant> jokerParticipants = new ArrayList<Participant>();
        int i = 0;
        while (i < this.m_participants.size()) {
            if (this.m_participants.get(i).getJoker() && this.m_participants.get(i).getPairingInRound(this.m_currentRoundNumber) == null) {
                jokerParticipants.add(this.m_participants.get(i));
            }
            ++i;
        }
        return jokerParticipants;
    }

    public List<Participant> getJokerParticipantsNotPlayingInRound(int round) {
        ArrayList<Participant> jokerParticipants = new ArrayList<Participant>();
        int i = 0;
        while (i < this.m_participants.size()) {
            if (this.m_participants.get(i).getJoker() && !this.m_participants.get(i).getPreliminaryRegistration() && this.m_participants.get(i).getPairingInRound(this.m_currentRoundNumber) == Pairing.NOT_PLAYING) {
                jokerParticipants.add(this.m_participants.get(i));
            }
            ++i;
        }
        return jokerParticipants;
    }

    public boolean getLowerMacMahonBar() {
        return this.m_lowerMacMahonBar;
    }

    public GoLevel getLowerMacMahonBarLevel() {
        return this.m_lowerMacMahonBarLevel;
    }

    public boolean getMakePairingOutsideTopGroupColorBalance() {
        return this.m_makePairingOutsideTopGroupColorBalance;
    }

    public boolean getMakePairingOutsideTopGroupSameClub() {
        return this.m_makePairingOutsideTopGroupSameClub;
    }

    public boolean getMakePairingOutsideTopGroupSameCountry() {
        return this.m_makePairingOutsideTopGroupSameCountry;
    }

    public boolean getMakePairingOutsideTopGroupSameNationality() {
        return this.m_makePairingOutsideTopGroupSameNationality;
    }

    public boolean getMakePairingOutsideTopGroupSeeding() {
        return this.m_makePairingOutsideTopGroupSeeding;
    }

    public boolean getMakePairingOutsideTopGroupStrengthDifference() {
        return this.m_makePairingOutsideTopGroupStrengthDifference;
    }

    public int getMakePairingOutsideTopGroupStrengthDifferenceValue() {
        return this.m_makePairingOutsideTopGroupStrengthDifferenceValue;
    }

    public boolean getMakePairingOutsideTopGroupWeakOddMan() {
        return this.m_makePairingOutsideTopGroupWeakOddMan;
    }

    public Walllist.SortCriterionDescriptor getMakePairingSeedingPlacementCriterion() {
        return this.m_makePairingSeedingPlacementCriterion;
    }

    public boolean getMakePairingTopGroup() {
        return this.m_makePairingTopGroup;
    }

    public boolean getMakePairingTopGroupEverywhere() {
        return this.m_makePairingTopGroupEverywhere;
    }

    public boolean getMakePairingTopGroupSeeding() {
        return this.m_makePairingTopGroupSeeding;
    }

    public boolean getMakePairingTopGroupSeedingByRating() {
        return this.m_makePairingTopGroupSeedingByRating;
    }

    public int getMakePairingTopGroupSeedingByRatingRound() {
        return this.m_makePairingTopGroupSeedingByRatingRound;
    }

    public boolean getMakePairingTopGroupStrictlyByTopBar() {
        return this.m_makePairingTopGroupStrictlyByTopBar;
    }

    public boolean getMakePairingTopGroupByNumberOfPlayersAuto() {
        return this.m_makePairingTopGroupByNumberOfPlayersAuto;
    }

    public int getMakePairingTopGroupByNumberOfPlayers() {
        return this.m_makePairingTopGroupByNumberOfPlayers;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameDisplayString() {
        if (this.m_name == null) {
            return Messages.getString("Tournament.UnnamedTournament");
        }
        return this.m_name;
    }

    public String getNameRoundDisplayString() {
        return this.getNameDisplayString() + " - " + (this.takeCurrentRoundInAccount() ? AFTER_ROUND : BEFORE_ROUND).replaceAll("%1%", Integer.toString(this.getCurrentRoundNumber()));
    }

    public int getNumberOfFreeParticipantsInRound(int round) {
        int numberOfFreeParticipants = 0;
        int i = 0;
        while (i < this.m_participants.size()) {
            if (this.m_participants.get(i).getPairingInRound(this.m_currentRoundNumber) == null) {
                ++numberOfFreeParticipants;
            }
            ++i;
        }
        return numberOfFreeParticipants;
    }

    public int getNumberOfRounds() {
        return this.m_numberOfRounds;
    }

    public boolean getOnlineEgdSupport() {
        return this.m_onlineEgdSupport;
    }

    public boolean getOnlineEgdSupportByPin() {
        return this.m_onlineEgdSupportByPin;
    }

    public int getPairingsBlackColumnWidth() {
        return this.m_pairingsBlackColumnWidth;
    }

    public double getPairingsSplitPaneResizeWeight() {
        return this.m_pairingsSplitPaneResizeWeight;
    }

    public int getPairingsWhiteColumnWidth() {
        return this.m_pairingsWhiteColumnWidth;
    }

    public int getPairingsFontsize() {
        return this.m_pairingsFontsize;
    }

    public boolean getPairingsMarkFixedBoardnumbers() {
        return this.m_pairingsMarkFixedBoardnumbers;
    }

    public boolean getPairingsMarkMissingResults() {
        return this.m_pairingsMarkMissingResults;
    }

    public boolean getPairingsMarkWinner() {
        return this.m_pairingsMarkWinner;
    }

    public boolean getPairingsMarkUnwantedPairings() {
        return this.m_pairingsMarkUnwantedPairings;
    }

    public boolean getPairingsShortNotationForLevel() {
        return this.m_pairingsShortNotationForLevel;
    }

    public boolean getPairingsShowHandicaps() {
        return this.m_pairingsShowHandicaps;
    }

    public boolean getPairingsShowLevels() {
        return this.m_pairingsShowLevels;
    }

    public boolean getPairingsShowScores() {
        return this.m_pairingsShowScores;
    }

    public Participant getParticipantById(int id) {
        for (Participant participant : this.m_participants) {
            if (participant.getId() != id) continue;
            return participant;
        }
        return null;
    }

    public List<Participant> getParticipants() {
        return this.m_participants;
    }

    public boolean getDefaultPreliminaryRegistration() {
        return this.m_preliminaryDefaultRegistration;
    }

    public boolean getPrintPairingsAbbreviateName() {
        return this.m_printPairingsAbbreviateName;
    }

    public int getPrintPairingsAbbreviateNameLength() {
        return this.m_printPairingsAbbreviateNameLength;
    }

    public int getPrintPairingsColumnDistance() {
        return this.m_printPairingsColumnDistance;
    }

    public String getPrintPairingsFont() {
        return this.m_printPairingsFont;
    }

    public int getPrintPairingsFontsize() {
        return this.m_printPairingsFontsize;
    }

    public int getPrintPairingsIndentationLeft() {
        return this.m_printPairingsIndentationLeft;
    }

    public int getPrintPairingsIndentationTop() {
        return this.m_printPairingsIndentationTop;
    }

    public boolean getPrintWalllistAbbreviateName() {
        return this.m_printWalllistAbbreviateName;
    }

    public int getPrintWalllistAbbreviateNameLength() {
        return this.m_printWalllistAbbreviateNameLength;
    }

    public int getPrintWalllistColumnDistance() {
        return this.m_printWalllistColumnDistance;
    }

    public String getPrintWalllistFont() {
        return this.m_printWalllistFont;
    }

    public int getPrintWalllistFontsize() {
        return this.m_printWalllistFontsize;
    }

    public int getPrintWalllistIndentationLeft() {
        return this.m_printWalllistIndentationLeft;
    }

    public int getPrintWalllistIndentationTop() {
        return this.m_printWalllistIndentationTop;
    }

    public boolean getRatingAllowed() {
        return this.m_ratingAllowed;
    }

    public boolean getRatingDeterminesRank() {
        return this.m_ratingDeterminesRank;
    }

    public boolean getRatingDeterminesStartScore() {
        return this.m_ratingDeterminesStartScore;
    }

    public int getRatingLowestOneDanRating() {
        return this.m_ratingLowestOneDanRating;
    }

    public TournamentRound getRound(int round) {
        return this.m_rounds[round - 1];
    }

    public int getTopGroupScoreForRound(int round) {
        int topGroupScore;
        block11: {
            topGroupScore = -1;
            if (!this.m_makePairingTopGroup) break block11;
            if (this.m_makePairingTopGroupEverywhere) {
                topGroupScore = 0;
            } else if (this.m_makePairingTopGroupStrictlyByTopBar) {
                for (Participant participant : this.m_participants) {
                    if (participant.getPairingInRound(round) == Pairing.NOT_PLAYING || !participant.isUpperBarMember()) continue;
                    int participantScore = participant.getScoreAfterRound(round - 1);
                    if (topGroupScore >= 0 && topGroupScore <= participantScore) continue;
                    topGroupScore = participantScore;
                }
            } else {
                int topGroupNumberOfPlayers;
                int[] scoreGroupSizes = this.getCountScoreGroupSizesInRound(round);
                if (this.m_makePairingTopGroupByNumberOfPlayersAuto) {
                    topGroupNumberOfPlayers = 0;
                    for (Participant participant : this.m_participants) {
                        if (participant.getPairingInRound(round) == Pairing.NOT_PLAYING || !participant.isUpperBarMember()) continue;
                        ++topGroupNumberOfPlayers;
                    }
                } else {
                    topGroupNumberOfPlayers = this.m_makePairingTopGroupByNumberOfPlayers;
                }
                if (topGroupNumberOfPlayers == 0) {
                    topGroupScore = -1;
                } else {
                    topGroupScore = scoreGroupSizes.length;
                    while (topGroupNumberOfPlayers > 0 && topGroupScore > 0) {
                        topGroupNumberOfPlayers -= scoreGroupSizes[--topGroupScore];
                    }
                }
            }
        }
        return topGroupScore;
    }

    public boolean getUpperMacMahonBar() {
        return this.m_upperMacMahonBar;
    }

    public GoLevel getUpperMacMahonBarLevel() {
        return this.m_upperMacMahonBarLevel;
    }

    public int getUpperMacMahonBarRating() {
        return this.m_upperMacMahonBarRating;
    }

    public List<UnwantedPairing> getUnwantedPairings() {
        return this.m_unwantedPairings;
    }

    public String getVersionCreated() {
        return this.m_versionCreated;
    }

    public String getVersionSaved() {
        return this.m_versionSaved;
    }

    public Walllist getWalllist() {
        return this.m_walllist;
    }

    public void importDefaultCountriesAndClubs() {
        Country country;
        this.blockSortCountries();
        int i = 0;
        while (i < Country.INTERNET_COUNTRY_CODES.length) {
            country = new Country(Country.INTERNET_COUNTRY_CODES[i][0], Country.INTERNET_COUNTRY_CODES[i][1]);
            this.addCountry(country);
            country.blockSortClubs();
            ++i;
        }
        this.unblockSortCountries();
        i = 0;
        while (i < Club.DEFAULT_CLUB_DATA.length) {
            country = this.findCountry(Club.DEFAULT_CLUB_DATA[i][0]);
            Club club = new Club(country, Club.DEFAULT_CLUB_DATA[i][1], Club.DEFAULT_CLUB_DATA[i][2]);
            country.addClub(club);
            ++i;
        }
        i = 0;
        while (i < this.m_countriesSorted.size()) {
            this.m_countriesSorted.get(i).unblockSortClubs();
            ++i;
        }
    }

    public void importSettings(Tournament other) throws MacMahonException {
        this.m_walllist.blockSort();
        this.setNumberOfRounds(other.getNumberOfRounds());
        this.setName(other.m_name);
        this.setDescription(other.m_description);
        this.setDefaultAsianName(other.m_defaultAsianName);
        this.setRatingAllowed(other.m_ratingAllowed);
        this.setRatingLowestOneDanRating(other.m_ratingLowestOneDanRating);
        this.setRatingDeterminesRank(other.m_ratingDeterminesRank);
        this.setRatingDeterminesStartScore(other.m_ratingDeterminesStartScore);
        this.setLowerMacMahonBar(other.m_lowerMacMahonBar);
        this.setLowerMacMahonBarLevel(other.m_lowerMacMahonBarLevel);
        this.setUpperMacMahonBar(other.m_upperMacMahonBar);
        this.setUpperMacMahonBarLevel(other.m_upperMacMahonBarLevel);
        this.setUpperMacMahonBarRating(other.m_upperMacMahonBarRating);
        this.setByeShouldResultInZeroSOSetc(other.m_byeShouldResultInZeroSOSetc);
        this.setHalfScoreGroupsRoundDown(other.m_halfScoreGroupsRoundDown);
        this.setHalfScoreGroupsRoundDownNotJigo(other.m_halfScoreGroupsRoundDownNotJigo);
        this.setPreliminaryDefaultRegistration(other.m_preliminaryDefaultRegistration);
        this.setOnlineEgdSupport(other.m_onlineEgdSupport);
        this.setOnlineEgdSupportByPin(other.m_onlineEgdSupportByPin);
        this.setHandicapUsed(other.m_handicapUsed);
        this.setHandicapBelow(other.m_handicapBelow);
        this.setHandicapBelowLevel(other.m_handicapBelowLevel);
        this.setHandicapByLevel(other.m_handicapByLevel);
        this.setHandicapAdjustment(other.m_handicapAdjustment);
        this.setHandicapAdjustmentValue(other.m_handicapAdjustmentValue);
        this.setHandicapLimit(other.m_handicapLimit);
        this.setHandicapLimitValue(other.m_handicapLimitValue);
        this.setHandicapIncludeInTieBreakers(other.m_handicapIncludeInTieBreakers);
        this.setAllowJigo(other.m_allowJigo);
        this.setBoardsize(other.m_boardsize);
        this.setPairingsMarkFixedBoardnumbers(other.m_pairingsMarkFixedBoardnumbers);
        this.setPairingsMarkMissingResults(other.m_pairingsMarkMissingResults);
        this.setPairingsMarkWinner(other.m_pairingsMarkWinner);
        this.setPairingsShowLevels(other.m_pairingsShowLevels);
        this.setPairingsShortNotationForLevel(other.m_pairingsShortNotationForLevel);
        this.setPairingsShowScores(other.m_pairingsShowScores);
        this.setPairingsShowHandicaps(other.m_pairingsShowHandicaps);
        this.setPairingsFontsize(other.m_pairingsFontsize);
        this.setPairingsBlackColumnWidth(other.m_pairingsBlackColumnWidth);
        this.setPairingsWhiteColumnWidth(other.m_pairingsWhiteColumnWidth);
        this.setImportEncoding(other.m_importEncoding);
        this.setExportColumnDelimiter(other.m_exportColumnDelimiter);
        this.setExportWalllistShowTournamentTitle(other.m_exportWalllistShowTournamentTitle);
        this.setExportEncoding(other.m_exportEncoding);
        this.setMakePairingTopGroup(other.m_makePairingTopGroup);
        this.setMakePairingTopGroupEverywhere(other.m_makePairingTopGroupEverywhere);
        this.setMakePairingTopGroupStrictlyByTopBar(other.m_makePairingTopGroupStrictlyByTopBar);
        this.setMakePairingTopGroupByNumberOfPlayersAuto(other.m_makePairingTopGroupByNumberOfPlayersAuto);
        this.setMakePairingTopGroupByNumberOfPlayers(other.m_makePairingTopGroupByNumberOfPlayers);
        this.setMakePairingTopGroupSeeding(other.m_makePairingTopGroupSeeding);
        this.setMakePairingSeedingPlacementCriterion(other.m_makePairingSeedingPlacementCriterion);
        this.setMakePairingTopGroupSeedingByRating(other.m_makePairingTopGroupSeedingByRating);
        this.setMakePairingTopGroupSeedingByRatingRound(other.m_makePairingTopGroupSeedingByRatingRound);
        this.setMakePairingOutsideTopGroupSameCountry(other.m_makePairingOutsideTopGroupSameCountry);
        this.setMakePairingOutsideTopGroupSameClub(other.m_makePairingOutsideTopGroupSameClub);
        this.setMakePairingOutsideTopGroupSameNationality(other.m_makePairingOutsideTopGroupSameNationality);
        this.setMakePairingOutsideTopGroupStrengthDifference(other.m_makePairingOutsideTopGroupStrengthDifference);
        this.setMakePairingOutsideTopGroupStrengthDifferenceValue(other.m_makePairingOutsideTopGroupStrengthDifferenceValue);
        this.setMakePairingOutsideTopGroupColorBalance(other.m_makePairingOutsideTopGroupColorBalance);
        this.setMakePairingOutsideTopGroupWeakOddMan(other.m_makePairingOutsideTopGroupWeakOddMan);
        this.setMakePairingOutsideTopGroupSeeding(other.m_makePairingOutsideTopGroupSeeding);
        this.setPrintWalllistFont(other.m_printWalllistFont);
        this.setPrintWalllistFontsize(other.m_printWalllistFontsize);
        this.setPrintWalllistIndentationTop(other.m_printWalllistIndentationTop);
        this.setPrintWalllistIndentationLeft(other.m_printWalllistIndentationLeft);
        this.setPrintWalllistColumnDistance(other.m_printWalllistColumnDistance);
        this.setPrintWalllistAbbreviateName(other.m_printWalllistAbbreviateName);
        this.setPrintWalllistAbbreviateNameLength(other.m_printWalllistAbbreviateNameLength);
        this.setPrintPairingsFont(other.m_printWalllistFont);
        this.setPrintPairingsFontsize(other.m_printPairingsFontsize);
        this.setPrintPairingsIndentationTop(other.m_printPairingsIndentationTop);
        this.setPrintPairingsIndentationLeft(other.m_printPairingsIndentationLeft);
        this.setPrintPairingsColumnDistance(other.m_printPairingsColumnDistance);
        this.setPrintPairingsAbbreviateName(other.m_printPairingsAbbreviateName);
        this.setPrintPairingsAbbreviateNameLength(other.m_printPairingsAbbreviateNameLength);
        this.m_walllist.importSettings(other.m_walllist);
        if (other.getDefaultCountry() != null) {
            this.setDefaultCountry(this.findCountry(other.getDefaultCountry().getInternetCode()));
        }
        this.buildParticipantScores();
        this.m_walllist.unblockSort();
    }

    public String makePairing() throws MacMahonException {
        ArrayList<Participant> participants = new ArrayList<Participant>(this.m_participants.size());
        for (Participant participant : this.m_participants) {
            if (!participant.isFreeInCurrentRound()) continue;
            participants.add(participant);
        }
        return this.makePairing(participants, false);
    }

    public String makePairing(List<Participant> participants, boolean forcedPairing) throws MacMahonException {
        int highestScore;
        for (Participant participant : participants) {
            if (!participant.isFreeInCurrentRound()) {
                throw new RuntimeException(Messages.getString("Tournament.ParticipantMustBeFreeToPlay"));
            }
            if (participant.isValid()) continue;
            throw new MacMahonException(Messages.getString("MacMahonApplication.ParticipantNotValidExceptionMessage", participant.getName()));
        }
        int createdPairingsCount = 0;
        int createdPairingsWithByeCount = 0;
        int topGroupScore = this.getTopGroupScoreForRound(this.m_currentRoundNumber);
        this.m_walllist.blockSort();
        this.getCurrentRound().blockSort();
        boolean oldTakeCurrentRoundInAccount = this.m_takeCurrentRoundInAccount;
        this.setTakeCurrentRoundInAccount(false);
        IndividualParticipant participantBye = null;
        if ((participants.size() & 1) == 1) {
            GoPlayer byePlayer = new GoPlayer(this);
            byePlayer.setGoLevel(new GoLevel(35, false, false));
            participantBye = new IndividualParticipant(this, byePlayer);
            participants.add(participantBye);
        }
        Collections.shuffle(participants);
        int minScore = -1;
        int i = 0;
        while (i < participants.size()) {
            if (minScore < 0 || participants.get(i).getScore() < minScore) {
                minScore = participants.get(i).getScore();
            }
            ++i;
        }
        int lowestScore = minScore > 0 ? minScore >> 1 : 0;
        int maxScore = -1;
        int i2 = 0;
        while (i2 < participants.size()) {
            if (maxScore < 0 || participants.get(i2).getScore() > maxScore) {
                maxScore = participants.get(i2).getScore();
            }
            ++i2;
        }
        int n = highestScore = maxScore > 0 ? maxScore >> 1 : 0;
        if (lowestScore >= 0 && highestScore >= 0) {
            SecondCriteriaIndexOfGroup[] secondCriteriaIndicesOfGroups = new SecondCriteriaIndexOfGroup[highestScore + 1];
            int i3 = lowestScore;
            while (i3 < secondCriteriaIndicesOfGroups.length) {
                secondCriteriaIndicesOfGroups[i3] = new SecondCriteriaIndexOfGroup();
                ++i3;
            }
            Walllist.SortCriterionDescriptor secondCriterion = null;
            secondCriterion = this.getMakePairingTopGroupSeedingByRating() && this.getCurrentRoundNumber() <= this.getMakePairingTopGroupSeedingByRatingRound() ? Walllist.SCD_RATING : this.getMakePairingSeedingPlacementCriterion();
            int score = lowestScore;
            while (score <= highestScore) {
                long v = 0L;
                long summe = 0L;
                int n2 = 0;
                long minSCI = -1L;
                long maxSCI = -1L;
                int playerIndex = 0;
                while (playerIndex < participants.size()) {
                    if (participants.get(playerIndex).getScore() == score << 1) {
                        v = secondCriterion == Walllist.SCD_SOS ? (long)participants.get(playerIndex).getSos() : (secondCriterion == Walllist.SCD_SOSOS ? (long)participants.get(playerIndex).getSosos() : (secondCriterion == Walllist.SCD_SODOS ? (long)participants.get(playerIndex).getSodos() : (secondCriterion == Walllist.SCD_RATING ? (long)participants.get(playerIndex).getRating() : 0L)));
                        summe += v;
                        ++n2;
                        if (v < minSCI || minSCI < 0L) {
                            minSCI = v;
                        }
                        if (v > maxSCI || maxSCI < 0L) {
                            maxSCI = v;
                        }
                        secondCriteriaIndicesOfGroups[score].m_placeList.add(playerIndex);
                    }
                    ++playerIndex;
                }
                secondCriteriaIndicesOfGroups[score].m_minIndex = minSCI;
                secondCriteriaIndicesOfGroups[score].m_maxIndex = maxSCI;
                secondCriteriaIndicesOfGroups[score].m_numberOfPlayersInThisGroup = n2;
                secondCriteriaIndicesOfGroups[score].m_middleIndex = secondCriteriaIndicesOfGroups[score].m_numberOfPlayersInThisGroup > 0 ? (long)((int)Math.round((double)summe / (double)secondCriteriaIndicesOfGroups[score].m_numberOfPlayersInThisGroup)) : -1L;
                ++score;
            }
            MaximumWeightPerfectMatchingAlgorithm algorithm = new MaximumWeightPerfectMatchingAlgorithm();
            algorithm.initialize(participants.size());
            int i4 = 0;
            while (i4 < participants.size()) {
                Participant pi = participants.get(i4);
                int j = i4 + 1;
                while (j < participants.size()) {
                    int group;
                    Participant pj = participants.get(j);
                    long summe = 0L;
                    int alreadyPlayed = pi == participantBye ? pj.getAlreadyPlayedWithBye() : (pj == participantBye ? pi.getAlreadyPlayedWithBye() : pi.getAlreadyPlayed(pj));
                    UnwantedPairing unwantedPairing = this.getUnwantedPairing(pi, pj);
                    if ((alreadyPlayed > 0 || unwantedPairing != null && unwantedPairing.getForbidden()) && (summe += 0xFFFFFFFL) > 0xFFFFFFFL) {
                        summe = 0xFFFFFFFL;
                    }
                    if ((summe += Math.round(Math.pow(Math.abs(pi.getScore() - pj.getScore()) + (unwantedPairing != null && !unwantedPairing.getForbidden() ? 8 : 0) + (pi == participantBye || pj == participantBye ? 4 : 0) >> 1, 2.0)) * 10000L) > 0xFFFFFFFL) {
                        summe = 0xFFFFFFFL;
                    }
                    if (pi != participantBye && pj != participantBye && (topGroupScore < 0 || pi.getScore() < topGroupScore && pj.getScore() < topGroupScore)) {
                        if (pi instanceof IndividualParticipant && pj instanceof IndividualParticipant) {
                            if (this.m_makePairingOutsideTopGroupSameCountry && ((IndividualParticipant)pi).getGoPlayer().getCountry() != null && ((IndividualParticipant)pi).getGoPlayer().getCountry() == ((IndividualParticipant)pj).getGoPlayer().getCountry() && (summe += 20L) > 0xFFFFFFFL) {
                                summe = 0xFFFFFFFL;
                            }
                            if (this.m_makePairingOutsideTopGroupSameClub && ((IndividualParticipant)pi).getGoPlayer().getClub() != null && ((IndividualParticipant)pi).getGoPlayer().getClub() == ((IndividualParticipant)pj).getGoPlayer().getClub() && (summe += 80L) > 0xFFFFFFFL) {
                                summe = 0xFFFFFFFL;
                            }
                            if (this.m_makePairingOutsideTopGroupSameNationality && ((IndividualParticipant)pi).getGoPlayer().getNationality() != null && ((IndividualParticipant)pi).getGoPlayer().getNationality() == ((IndividualParticipant)pj).getGoPlayer().getNationality() && (summe += 20L) > 0xFFFFFFFL) {
                                summe = 0xFFFFFFFL;
                            }
                        }
                        if (this.m_makePairingOutsideTopGroupStrengthDifference && pi.getGoLevel().getScoreDifferenceTo(pj.getGoLevel()) >= this.m_makePairingOutsideTopGroupStrengthDifferenceValue && (summe += 80L) > 0xFFFFFFFL) {
                            summe = 0xFFFFFFFL;
                        }
                        if (this.m_makePairingOutsideTopGroupColorBalance) {
                            double v2;
                            int p1black = pi.getNumberOfTimesBlack();
                            int p1white = pi.getNumberOfTimesWhite();
                            int p2black = pj.getNumberOfTimesBlack();
                            int p2white = pj.getNumberOfTimesWhite();
                            double v1 = 2.0 * (Math.pow(0.5 - (double)(p1black + 1) / (double)(p1black + 1 + p1white), 2.0) + Math.pow(0.5 - (double)p2black / (double)(p2black + p2white + 1), 2.0));
                            double bestColorValue = Math.min(v1, v2 = 2.0 * (Math.pow(0.5 - (double)p1black / (double)(p1black + p1white + 1), 2.0) + Math.pow(0.5 - (double)(p2black + 1) / (double)(p2black + 1 + p2white), 2.0)));
                            if ((summe += Math.round(bestColorValue * 50.0)) > 0xFFFFFFFL) {
                                summe = 0xFFFFFFFL;
                            }
                        }
                    }
                    if (this.m_makePairingTopGroupSeeding && (this.m_makePairingOutsideTopGroupSeeding || topGroupScore >= 0 && (pi != participantBye && pi.getScore() >= topGroupScore || pj != participantBye && pj.getScore() >= topGroupScore)) && pi != participantBye && pj != participantBye && pi.getScore() == pj.getScore() && (summe += (long)Math.abs(secondCriteriaIndicesOfGroups[group = pi.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pi, secondCriterion) + secondCriteriaIndicesOfGroups[group].getSecondCriteriaIndexOfPlayer(pj, secondCriterion) - 100) * 10L) > 0xFFFFFFFL) {
                        summe = 0xFFFFFFFL;
                    }
                    if (this.m_makePairingTopGroupSeeding) {
                        long oddmanvalue = 0L;
                        if (pi == participantBye && pj.getScore() > 0) {
                            oddmanvalue = 100 - secondCriteriaIndicesOfGroups[pj.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pj, secondCriterion);
                        } else if (pj == participantBye && pi.getScore() > 0) {
                            oddmanvalue = 100 - secondCriteriaIndicesOfGroups[pi.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pi, secondCriterion);
                        } else if (pi.getScore() != pj.getScore()) {
                            oddmanvalue = pi.getScore() > pj.getScore() ? (long)(100 - secondCriteriaIndicesOfGroups[pi.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pi, secondCriterion) + secondCriteriaIndicesOfGroups[pj.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pj, secondCriterion)) : (long)(100 - secondCriteriaIndicesOfGroups[pj.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pj, secondCriterion) + secondCriteriaIndicesOfGroups[pi.getScore() >> 1].getSecondCriteriaIndexOfPlayer(pi, secondCriterion));
                        }
                        if (!this.m_makePairingOutsideTopGroupWeakOddMan || topGroupScore >= 0 && (pi != participantBye && pi.getScore() >= topGroupScore || pj != participantBye && pj.getScore() >= topGroupScore)) {
                            summe += oddmanvalue * 100L;
                        } else {
                            double doddmanvalue = (double)oddmanvalue / 200.0 * 70.0;
                            summe += Math.round(doddmanvalue);
                        }
                        if (summe > 0xFFFFFFFL) {
                            summe = 0xFFFFFFFL;
                        }
                    }
                    long costs = 0x3FFFFFFFL - (summe >> 2) & 0xFFFFFFFFFFFFFFFCL;
                    algorithm.setCosts(i4, j, costs);
                    ++j;
                }
                ++i4;
            }
            algorithm.makePairing();
            Date creationTime = new Date();
            int i5 = 0;
            while (i5 < participants.size()) {
                Participant p1 = participants.get(i5);
                if (p1 != participantBye && p1.getPairingInRound(this.m_currentRoundNumber) == null) {
                    Participant p2 = participants.get(algorithm.getMatchedVertex(i5));
                    if (p2 == participantBye) {
                        this.createPairingWithBye(p1, forcedPairing, creationTime);
                        ++createdPairingsWithByeCount;
                    } else {
                        this.createPairing(p1, p2, forcedPairing, creationTime);
                        ++createdPairingsCount;
                    }
                }
                ++i5;
            }
        }
        this.setTakeCurrentRoundInAccount(oldTakeCurrentRoundInAccount);
        this.buildParticipantScores();
        this.getCurrentRound().unblockSort();
        this.m_walllist.unblockSort();
        return String.format(Messages.getString("Tournament.CreatedPairingsStatusMessage"), forcedPairing ? Messages.getString("Tournament.ForcedPairing") : Messages.getString("Tournament.MakePairing"), createdPairingsCount, createdPairingsWithByeCount);
    }

    public void removeClub(Club club) {
        for (Participant participant : this.m_participants) {
            if (!(participant instanceof IndividualParticipant) || ((IndividualParticipant)participant).getGoPlayer().getClub() != club) continue;
            ((IndividualParticipant)participant).getGoPlayer().setClub(null);
        }
        club.getCountry().removeClub(club);
    }

    public void setAllowJigo(boolean allowJigo) {
        this.m_allowJigo = allowJigo;
    }

    public void setBoardsize(int boardsize) {
        this.m_boardsize = boardsize;
    }

    public void setByeShouldResultInZeroSOSetc(boolean byeShouldResultInZeroSOSetc) {
        if (this.m_byeShouldResultInZeroSOSetc != byeShouldResultInZeroSOSetc) {
            this.m_byeShouldResultInZeroSOSetc = byeShouldResultInZeroSOSetc;
            this.buildParticipantScores();
        }
    }

    public void setCurrentRoundNumber(int currentRound) {
        if (this.m_currentRoundNumber != currentRound) {
            this.m_currentRoundNumber = currentRound;
            this.buildParticipantScores();
        }
    }

    public void setDefaultAsianName(boolean defaultAsianName) {
        this.m_defaultAsianName = defaultAsianName;
    }

    public void setDefaultCountry(Country defaultCountry) {
        this.m_defaultCountry = defaultCountry;
    }

    public void setDefaultNationality(Country defaultNationality) {
        this.m_defaultNationality = defaultNationality;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setExportColumnDelimiter(String exportColumnDelimiter) {
        this.m_exportColumnDelimiter = exportColumnDelimiter;
    }

    public void setImportEncoding(String importEncoding) {
        this.m_importEncoding = importEncoding;
    }

    public void setExportEncoding(String exportEncoding) {
        this.m_exportEncoding = exportEncoding;
    }

    public void setExportWalllistShowTournamentTitle(boolean exportWalllistShowTournamentTitle) {
        this.m_exportWalllistShowTournamentTitle = exportWalllistShowTournamentTitle;
    }

    public void setFilePath(String filepath) {
        this.m_filepath = filepath;
    }

    public void setHalfScoreGroupsRoundDown(boolean halfScoreGroupsRoundDown) {
        if (this.m_halfScoreGroupsRoundDown != halfScoreGroupsRoundDown) {
            this.m_halfScoreGroupsRoundDown = halfScoreGroupsRoundDown;
            this.buildParticipantScores();
        }
    }

    public void setHalfScoreGroupsRoundDownNotJigo(boolean halfScoreGroupsRoundDownNotJigo) {
        if (this.m_halfScoreGroupsRoundDownNotJigo != halfScoreGroupsRoundDownNotJigo) {
            this.m_halfScoreGroupsRoundDownNotJigo = halfScoreGroupsRoundDownNotJigo;
            this.buildParticipantScores();
        }
    }

    public void setHandicapBelow(boolean handicapBelow) {
        this.m_handicapBelow = handicapBelow;
    }

    public void setHandicapBelowLevel(GoLevel handicapBelowLevel) {
        this.m_handicapBelowLevel = handicapBelowLevel;
    }

    public void setHandicapByLevel(boolean handicapByLevel) {
        this.m_handicapByLevel = handicapByLevel;
    }

    public void setHandicapLimit(boolean handicapLimit) {
        this.m_handicapLimit = handicapLimit;
    }

    public void setHandicapLimitValue(int handicapLimitValue) throws MacMahonException {
        if (handicapLimitValue < 0) {
            throw new MacMahonException(Messages.getString("Tournament.IllegalHandicapLimitMessage", Integer.toString(handicapLimitValue)));
        }
        this.m_handicapLimitValue = handicapLimitValue;
    }

    public void setHandicapAdjustment(boolean handicapAdjustment) {
        this.m_handicapAdjustment = handicapAdjustment;
    }

    public void setHandicapAdjustmentValue(int handicapAdjustmentValue) {
        this.m_handicapAdjustmentValue = handicapAdjustmentValue;
    }

    public void setHandicapIncludeInTieBreakers(boolean handicapIncludeInTieBreakers) {
        if (this.m_handicapIncludeInTieBreakers != handicapIncludeInTieBreakers) {
            this.m_handicapIncludeInTieBreakers = handicapIncludeInTieBreakers;
            this.buildParticipantScores();
        }
    }

    public void setHandicapUsed(boolean handicapUsed) {
        this.m_handicapUsed = handicapUsed;
    }

    public void setLowerMacMahonBar(boolean lowerMacMahonBar) {
        if (this.m_lowerMacMahonBar != lowerMacMahonBar) {
            this.m_lowerMacMahonBar = lowerMacMahonBar;
            this.buildParticipantScores();
        }
    }

    public void setLowerMacMahonBarLevel(GoLevel lowerMacMahonBarLevel) {
        if (!this.m_lowerMacMahonBarLevel.equals(lowerMacMahonBarLevel)) {
            this.m_lowerMacMahonBarLevel = lowerMacMahonBarLevel;
            this.buildParticipantScores();
        }
    }

    public void setMakePairingOutsideTopGroupColorBalance(boolean makePairingOutsideTopGroupColorBalance) {
        this.m_makePairingOutsideTopGroupColorBalance = makePairingOutsideTopGroupColorBalance;
    }

    public void setMakePairingOutsideTopGroupSameClub(boolean makePairingOutsideTopGroupSameClub) {
        this.m_makePairingOutsideTopGroupSameClub = makePairingOutsideTopGroupSameClub;
    }

    public void setMakePairingOutsideTopGroupSameCountry(boolean makePairingOutsideTopGroupSameCountry) {
        this.m_makePairingOutsideTopGroupSameCountry = makePairingOutsideTopGroupSameCountry;
    }

    public void setMakePairingOutsideTopGroupSameNationality(boolean makePairingOutsideTopGroupSameNationality) {
        this.m_makePairingOutsideTopGroupSameNationality = makePairingOutsideTopGroupSameNationality;
    }

    public void setMakePairingOutsideTopGroupSeeding(boolean makePairingOutsideTopGroupSeeding) {
        this.m_makePairingOutsideTopGroupSeeding = makePairingOutsideTopGroupSeeding;
    }

    public void setMakePairingOutsideTopGroupStrengthDifference(boolean makePairingOutsideTopGroupStrengthDifference) {
        this.m_makePairingOutsideTopGroupStrengthDifference = makePairingOutsideTopGroupStrengthDifference;
    }

    public void setMakePairingOutsideTopGroupStrengthDifferenceValue(int makePairingOutsideTopGroupStrengthDifferenceValue) {
        if (makePairingOutsideTopGroupStrengthDifferenceValue <= 0) {
            this.setMakePairingOutsideTopGroupStrengthDifference(false);
            makePairingOutsideTopGroupStrengthDifferenceValue = 0;
        }
        this.m_makePairingOutsideTopGroupStrengthDifferenceValue = makePairingOutsideTopGroupStrengthDifferenceValue;
    }

    public void setMakePairingOutsideTopGroupWeakOddMan(boolean makePairingOutsideTopGroupWeakOddMan) {
        this.m_makePairingOutsideTopGroupWeakOddMan = makePairingOutsideTopGroupWeakOddMan;
    }

    public void setMakePairingSeedingPlacementCriterion(Walllist.SortCriterionDescriptor makePairingSeedingPlacementCriterion) {
        this.m_makePairingSeedingPlacementCriterion = makePairingSeedingPlacementCriterion;
    }

    public void setMakePairingTopGroup(boolean makePairingTopGroup) {
        this.m_makePairingTopGroup = makePairingTopGroup;
    }

    public void setMakePairingTopGroupEverywhere(boolean makePairingTopGroupEverywhere) {
        this.m_makePairingTopGroupEverywhere = makePairingTopGroupEverywhere;
    }

    public void setMakePairingTopGroupSeeding(boolean makePairingTopGroupSeeding) {
        this.m_makePairingTopGroupSeeding = makePairingTopGroupSeeding;
    }

    public void setMakePairingTopGroupSeedingByRating(boolean makePairingTopGroupSeedingByRating) {
        this.m_makePairingTopGroupSeedingByRating = makePairingTopGroupSeedingByRating;
    }

    public void setMakePairingTopGroupSeedingByRatingRound(int makePairingTopGroupSeedingByRatingRound) {
        assert (makePairingTopGroupSeedingByRatingRound >= 0);
        this.m_makePairingTopGroupSeedingByRatingRound = makePairingTopGroupSeedingByRatingRound;
    }

    public void setMakePairingTopGroupStrictlyByTopBar(boolean makePairingTopGroupStrictlyByTopBar) {
        this.m_makePairingTopGroupStrictlyByTopBar = makePairingTopGroupStrictlyByTopBar;
    }

    public void setMakePairingTopGroupByNumberOfPlayersAuto(boolean makePairingTopGroupByNumberOfPlayersAuto) {
        this.m_makePairingTopGroupByNumberOfPlayersAuto = makePairingTopGroupByNumberOfPlayersAuto;
    }

    public void setMakePairingTopGroupByNumberOfPlayers(int makePairingTopGroupByNumberOfPlayers) {
        this.m_makePairingTopGroupByNumberOfPlayers = makePairingTopGroupByNumberOfPlayers;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPairingsBlackColumnWidth(int pairingsBlackColumnWidth) {
        if (pairingsBlackColumnWidth < 0) {
            pairingsBlackColumnWidth = 0;
        }
        this.m_pairingsBlackColumnWidth = pairingsBlackColumnWidth;
    }

    public void setPairingsWhiteColumnWidth(int pairingsWhiteColumnWidth) {
        if (pairingsWhiteColumnWidth < 0) {
            pairingsWhiteColumnWidth = 0;
        }
        this.m_pairingsWhiteColumnWidth = pairingsWhiteColumnWidth;
    }

    public void setPairingsFontsize(int pairingsFontsize) {
        if (pairingsFontsize <= 0) {
            pairingsFontsize = 12;
        }
        this.m_pairingsFontsize = pairingsFontsize;
    }

    public void setPairingsMarkFixedBoardnumbers(boolean pairingsMarkFixedBoardnumbers) {
        this.m_pairingsMarkFixedBoardnumbers = pairingsMarkFixedBoardnumbers;
    }

    public void setPairingsMarkMissingResults(boolean pairingsMarkMissingResults) {
        this.m_pairingsMarkMissingResults = pairingsMarkMissingResults;
    }

    public void setPairingsMarkWinner(boolean pairingsMarkWinner) {
        this.m_pairingsMarkWinner = pairingsMarkWinner;
    }

    public void setPairingsMarkUnwantedPairings(boolean pairingsMarkUnwantedPairings) {
        this.m_pairingsMarkUnwantedPairings = pairingsMarkUnwantedPairings;
    }

    public void setPairingsShortNotationForLevel(boolean pairingsShortNotationForLevel) {
        this.m_pairingsShortNotationForLevel = pairingsShortNotationForLevel;
    }

    public void setPairingsShowHandicaps(boolean pairingsShowHandicaps) {
        this.m_pairingsShowHandicaps = pairingsShowHandicaps;
    }

    public void setPairingsShowLevels(boolean pairingsShowLevels) {
        this.m_pairingsShowLevels = pairingsShowLevels;
    }

    public void setPairingsShowScores(boolean pairingsShowScores) {
        this.m_pairingsShowScores = pairingsShowScores;
    }

    public void setNumberOfRounds(int numberOfRounds) throws MacMahonException {
        if (numberOfRounds < 1) {
            throw new MacMahonException(Messages.getString("Tournament.IllegalNumberOfRoundsMessage", Integer.toString(numberOfRounds)));
        }
        if (this.m_numberOfRounds != numberOfRounds) {
            if (numberOfRounds < this.m_currentRoundNumber) {
                this.setCurrentRoundNumber(numberOfRounds);
            }
            TournamentRound[] newrounds = new TournamentRound[numberOfRounds];
            int i = 0;
            while (i < numberOfRounds) {
                newrounds[i] = i < this.m_numberOfRounds ? this.m_rounds[i] : new TournamentRound(i + 1);
                ++i;
            }
            this.m_rounds = newrounds;
            this.m_numberOfRounds = numberOfRounds;
            Iterator<Participant> iterator = this.m_participants.iterator();
            while (iterator.hasNext()) {
                iterator.next().numberOfRoundsChanged(this.m_numberOfRounds);
            }
        }
    }

    public void setOnlineEgdSupport(boolean onlineEGDSupport) {
        this.m_onlineEgdSupport = onlineEGDSupport;
    }

    public void setOnlineEgdSupportByPin(boolean onlineEGDSupportByPin) {
        this.m_onlineEgdSupportByPin = onlineEGDSupportByPin;
    }

    public void setPreliminaryDefaultRegistration(boolean preliminaryDefaultRegistration) {
        this.m_preliminaryDefaultRegistration = preliminaryDefaultRegistration;
    }

    public void setPrintPairingsAbbreviateName(boolean printPairingsAbbreviateName) {
        this.m_printPairingsAbbreviateName = printPairingsAbbreviateName;
    }

    public void setPrintPairingsAbbreviateNameLength(int printPairingsAbbreviateNameLength) {
        if (printPairingsAbbreviateNameLength < 1) {
            printPairingsAbbreviateNameLength = 1;
        }
        this.m_printPairingsAbbreviateNameLength = printPairingsAbbreviateNameLength;
    }

    public void setPrintPairingsColumnDistance(int printPairingsColumnDistance) {
        if (printPairingsColumnDistance <= 0) {
            printPairingsColumnDistance = 1;
        }
        this.m_printPairingsColumnDistance = printPairingsColumnDistance;
    }

    public void setPrintPairingsFont(String printPairingsFont) {
        this.m_printPairingsFont = printPairingsFont;
    }

    public void setPrintPairingsFontsize(int printPairingsFontsize) {
        if (printPairingsFontsize <= 0) {
            printPairingsFontsize = 1;
        }
        this.m_printPairingsFontsize = printPairingsFontsize;
    }

    public void setPrintPairingsIndentationLeft(int printPairingsIndentationLeft) {
        if (printPairingsIndentationLeft < 0) {
            printPairingsIndentationLeft = 0;
        }
        this.m_printPairingsIndentationLeft = printPairingsIndentationLeft;
    }

    public void setPrintPairingsIndentationTop(int printPairingsIndentationTop) {
        if (printPairingsIndentationTop < 0) {
            printPairingsIndentationTop = 0;
        }
        this.m_printPairingsIndentationTop = printPairingsIndentationTop;
    }

    public void setPrintWalllistAbbreviateName(boolean printWalllistAbbreviateName) {
        this.m_printWalllistAbbreviateName = printWalllistAbbreviateName;
    }

    public void setPrintWalllistAbbreviateNameLength(int printWalllistAbbreviateNameLength) {
        if (printWalllistAbbreviateNameLength < 1) {
            printWalllistAbbreviateNameLength = 1;
        }
        this.m_printWalllistAbbreviateNameLength = printWalllistAbbreviateNameLength;
    }

    public void setPrintWalllistColumnDistance(int printWalllistColumnDistance) {
        if (printWalllistColumnDistance <= 0) {
            printWalllistColumnDistance = 1;
        }
        this.m_printWalllistColumnDistance = printWalllistColumnDistance;
    }

    public void setPrintWalllistFont(String printWalllistFont) {
        this.m_printWalllistFont = printWalllistFont;
    }

    public void setPrintWalllistFontsize(int printWalllistFontsize) {
        if (printWalllistFontsize <= 0) {
            printWalllistFontsize = 1;
        }
        this.m_printWalllistFontsize = printWalllistFontsize;
    }

    public void setPrintWalllistIndentationLeft(int printWalllistIndentationLeft) {
        if (printWalllistIndentationLeft < 0) {
            printWalllistIndentationLeft = 0;
        }
        this.m_printWalllistIndentationLeft = printWalllistIndentationLeft;
    }

    public void setPrintWalllistIndentationTop(int printWalllistIndentationTop) {
        if (printWalllistIndentationTop < 0) {
            printWalllistIndentationTop = 0;
        }
        this.m_printWalllistIndentationTop = printWalllistIndentationTop;
    }

    public void setRatingAllowed(boolean ratingAllowed) {
        if (this.m_ratingAllowed != ratingAllowed) {
            this.m_ratingAllowed = ratingAllowed;
            this.buildParticipantScores();
        }
    }

    public void setRatingDeterminesRank(boolean ratingDeterminesRank) {
        this.m_ratingDeterminesRank = ratingDeterminesRank;
    }

    public void setRatingDeterminesStartScore(boolean ratingDeterminesStartScore) {
        if (this.m_ratingDeterminesStartScore != ratingDeterminesStartScore) {
            this.m_ratingDeterminesStartScore = ratingDeterminesStartScore;
            this.buildParticipantScores();
        }
    }

    public void setRatingLowestOneDanRating(int ratingLowestOneDanRating) {
        this.m_ratingLowestOneDanRating = ratingLowestOneDanRating;
    }

    public void setTakeCurrentRoundInAccount(boolean takeCurrentRoundInAccount) {
        if (this.m_takeCurrentRoundInAccount != takeCurrentRoundInAccount) {
            this.m_takeCurrentRoundInAccount = takeCurrentRoundInAccount;
            this.buildParticipantScores();
        }
    }

    public void setUpperMacMahonBar(boolean upperMacMahonBar) {
        if (this.m_upperMacMahonBar != upperMacMahonBar) {
            this.m_upperMacMahonBar = upperMacMahonBar;
            this.buildParticipantScores();
        }
    }

    public void setUpperMacMahonBarLevel(GoLevel upperMacMahonBarLevel) {
        if (!this.m_upperMacMahonBarLevel.equals(upperMacMahonBarLevel)) {
            this.m_upperMacMahonBarLevel = upperMacMahonBarLevel;
            this.buildParticipantScores();
        }
    }

    public void setUpperMacMahonBarRating(int upperMacMahonBarRating) {
        if (upperMacMahonBarRating < 0) {
            upperMacMahonBarRating = 0;
        }
        if (this.m_upperMacMahonBarRating != upperMacMahonBarRating) {
            this.m_upperMacMahonBarRating = upperMacMahonBarRating;
            this.buildParticipantScores();
        }
    }

    public void setVersionCreated(String versionCreated) {
        this.m_versionCreated = versionCreated;
    }

    public void setVersionSaved(String versionSaved) {
        this.m_versionSaved = versionSaved;
    }

    public boolean takeCurrentRoundInAccount() {
        return this.m_takeCurrentRoundInAccount;
    }

    public void unblockSortCountries() {
        if (this.m_sortCountriesBlocked > 0) {
            --this.m_sortCountriesBlocked;
            this.doSortCountries();
        }
    }

    @Override
    public void xmlRead(Element te) throws MacMahonException {
        String defaultNationality;
        Walllist.SortCriterionDescriptor makePairingSeedingPlacementCriterion;
        Walllist.SortCriterionDescriptor criterion;
        super.xmlRead(te);
        this.setNumberOfRounds(this.xmlReadIntegerElement(te, "NumberOfRounds"));
        this.setCurrentRoundNumber(this.xmlReadIntegerElement(te, "CurrentRoundNumber"));
        this.setTakeCurrentRoundInAccount(this.xmlReadBooleanElement(te, "TakeCurrentRoundInAccount"));
        this.m_name = this.xmlReadTextElement(te, "Name");
        this.m_description = this.xmlReadTextElement(te, "Description");
        this.m_defaultAsianName = this.xmlReadBooleanElement(te, "DefaultAsianName");
        this.m_ratingAllowed = this.xmlReadBooleanElement(te, "RatingAllowed");
        this.m_ratingLowestOneDanRating = this.xmlReadIntegerElement(te, "RatingLowestOneDanRating");
        this.m_ratingDeterminesRank = this.xmlReadBooleanElement(te, "RatingDeterminesRank");
        this.m_ratingDeterminesStartScore = this.xmlReadBooleanElement(te, "RatingDeterminesStartScore");
        this.m_lowerMacMahonBar = this.xmlReadBooleanElement(te, "LowerMacMahonBar");
        this.m_lowerMacMahonBarLevel = new GoLevel(this.xmlReadTextElement(te, "LowerMacMahonBarLevel"));
        this.m_upperMacMahonBar = this.xmlReadBooleanElement(te, "UpperMacMahonBar");
        this.m_upperMacMahonBarLevel = new GoLevel(this.xmlReadTextElement(te, "UpperMacMahonBarLevel"));
        this.m_upperMacMahonBarRating = this.xmlReadIntegerElement(te, "UpperMacMahonBarRating");
        this.m_byeShouldResultInZeroSOSetc = this.xmlReadBooleanElement(te, "ByeShouldResultInZeroSOSetc");
        this.m_halfScoreGroupsRoundDown = this.xmlReadBooleanElement(te, "HalfScoreGroupsRoundDown");
        this.m_halfScoreGroupsRoundDownNotJigo = this.xmlReadBooleanElement(te, "HalfScoreGroupsRoundDownNotJigo");
        this.m_preliminaryDefaultRegistration = this.xmlReadBooleanElement(te, "PreliminaryDefaultRegistration");
        this.m_onlineEgdSupport = this.xmlReadBooleanElement(te, "OnlineEgdSupport");
        this.m_onlineEgdSupportByPin = this.xmlReadBooleanElement(te, "OnlineEgdSupportByPin");
        this.m_handicapUsed = this.xmlReadBooleanElement(te, "HandicapUsed");
        this.m_handicapBelow = this.xmlReadBooleanElement(te, "HandicapBelow");
        this.m_handicapBelowLevel = new GoLevel(this.xmlReadTextElement(te, "HandicapBelowLevel"));
        this.m_handicapByLevel = this.xmlReadBooleanElement(te, "HandicapByLevel");
        this.m_handicapAdjustment = this.xmlReadBooleanElement(te, "HandicapAdjustment");
        this.m_handicapAdjustmentValue = this.xmlReadIntegerElement(te, "HandicapAdjustmentValue");
        this.m_handicapLimit = this.xmlReadBooleanElement(te, "HandicapLimit");
        this.m_handicapLimitValue = this.xmlReadIntegerElement(te, "HandicapLimitValue");
        this.m_handicapIncludeInTieBreakers = this.xmlReadBooleanElement(te, "HandicapIncludeInTieBreakers");
        this.m_allowJigo = this.xmlReadBooleanElement(te, "AllowJigo");
        this.m_boardsize = this.xmlReadIntegerElement(te, "Boardsize");
        if (this.xmlVersion() >= 7) {
            this.m_pairingsMarkFixedBoardnumbers = this.xmlReadBooleanElement(te, "PairingsMarkFixedBoardnumbers");
        }
        if (this.xmlVersion() >= 6) {
            this.m_pairingsMarkMissingResults = this.xmlReadBooleanElement(te, "PairingsMarkMissingResults");
            this.m_pairingsMarkWinner = this.xmlReadBooleanElement(te, "PairingsMarkWinner");
        }
        if (this.xmlVersion() >= 8) {
            this.m_pairingsMarkUnwantedPairings = this.xmlReadBooleanElement(te, "PairingsMarkUnwantedPairings");
        }
        if (this.xmlVersion() >= 3) {
            this.m_pairingsShowLevels = this.xmlReadBooleanElement(te, "PairingsShowLevels");
        }
        this.m_pairingsShortNotationForLevel = this.xmlReadBooleanElement(te, "PairingsShortNotationForLevel");
        this.m_pairingsShowScores = this.xmlReadBooleanElement(te, "PairingsShowScores");
        if (this.xmlVersion() >= 6) {
            this.m_pairingsShowHandicaps = this.xmlReadBooleanElement(te, "PairingsShowHandicaps");
        }
        this.m_pairingsFontsize = this.xmlReadIntegerElement(te, "PairingsFontsize");
        this.m_pairingsBlackColumnWidth = this.xmlReadIntegerElement(te, "PairingsBlackColumnWidth");
        this.m_pairingsWhiteColumnWidth = this.xmlReadIntegerElement(te, "PairingsWhiteColumnWidth");
        if (this.xmlVersion() >= 9) {
            this.m_importEncoding = this.xmlReadTextElement(te, "ImportEncoding");
        }
        this.m_exportColumnDelimiter = this.xmlReadTextElement(te, "ExportColumnDelimiter");
        if (this.xmlVersion() >= 6) {
            this.m_exportWalllistShowTournamentTitle = this.xmlReadBooleanElement(te, "ExportWalllistShowTournamentTitle");
            this.m_exportEncoding = this.xmlReadTextElement(te, "ExportEncoding");
        }
        this.m_versionCreated = this.xmlReadTextElement(te, "VersionCreated");
        this.m_versionSaved = this.xmlReadTextElement(te, "VersionSaved");
        this.m_makePairingTopGroup = this.xmlReadBooleanElement(te, "MakePairingTopGroup");
        this.m_makePairingTopGroupEverywhere = this.xmlReadBooleanElement(te, "MakePairingTopGroupEverywhere");
        this.m_makePairingTopGroupStrictlyByTopBar = this.xmlReadBooleanElement(te, "MakePairingTopGroupStrictlyByTopBar");
        this.m_makePairingTopGroupByNumberOfPlayersAuto = this.xmlReadBooleanElement(te, "MakePairingTopGroupByNumberOfPlayersAuto");
        this.m_makePairingTopGroupByNumberOfPlayers = this.xmlReadIntegerElement(te, "MakePairingTopGroupByNumberOfPlayers");
        if (this.xmlVersion() >= 2) {
            this.m_makePairingTopGroupSeeding = this.xmlReadBooleanElement(te, "MakePairingTopGroupSeeding");
        }
        if (this.xmlVersion() >= 5 && (criterion = (Walllist.SortCriterionDescriptor)this.xmlReadSinglePersistentObject(te, "MakePairingSeedingPlacementCriterion", Walllist.SortCriterionDescriptor.class)) != null && (makePairingSeedingPlacementCriterion = Walllist.getSortCriterionDescriptorByShortName(criterion.getShortName())) != null) {
            this.m_makePairingSeedingPlacementCriterion = makePairingSeedingPlacementCriterion;
        }
        this.m_makePairingTopGroupSeedingByRating = this.xmlReadBooleanElement(te, "MakePairingTopGroupSeedingByRating");
        this.m_makePairingTopGroupSeedingByRatingRound = this.xmlReadIntegerElement(te, "MakePairingTopGroupSeedingByRatingRound");
        this.m_makePairingOutsideTopGroupSameCountry = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupSameCountry");
        this.m_makePairingOutsideTopGroupSameClub = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupSameClub");
        this.m_makePairingOutsideTopGroupSameNationality = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupSameNationality");
        this.m_makePairingOutsideTopGroupStrengthDifference = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupStrengthDifference");
        this.m_makePairingOutsideTopGroupStrengthDifferenceValue = this.xmlReadIntegerElement(te, "MakePairingOutsideTopGroupStrengthDifferenceValue");
        this.m_makePairingOutsideTopGroupColorBalance = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupColorBalance");
        this.m_makePairingOutsideTopGroupWeakOddMan = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupWeakOddMan");
        this.m_makePairingOutsideTopGroupSeeding = this.xmlReadBooleanElement(te, "MakePairingOutsideTopGroupSeeding");
        if (this.xmlVersion() >= 4) {
            this.m_printWalllistFont = this.xmlReadTextElement(te, "PrintWalllistFont");
            this.m_printWalllistFontsize = this.xmlReadIntegerElement(te, "PrintWalllistFontsize");
            this.m_printWalllistIndentationTop = this.xmlReadIntegerElement(te, "PrintWalllistIndentationTop");
            this.m_printWalllistIndentationLeft = this.xmlReadIntegerElement(te, "PrintWalllistIndentationLeft");
            this.m_printWalllistColumnDistance = this.xmlReadIntegerElement(te, "PrintWalllistColumnDistance");
            this.m_printWalllistAbbreviateName = this.xmlReadBooleanElement(te, "PrintWalllistAbbreviateName");
            this.m_printWalllistAbbreviateNameLength = this.xmlReadIntegerElement(te, "PrintWalllistAbbreviateNameLength");
            this.m_printPairingsFont = this.xmlReadTextElement(te, "PrintPairingsFont");
            this.m_printPairingsFontsize = this.xmlReadIntegerElement(te, "PrintPairingsFontsize");
            this.m_printPairingsIndentationTop = this.xmlReadIntegerElement(te, "PrintPairingsIndentationTop");
            this.m_printPairingsIndentationLeft = this.xmlReadIntegerElement(te, "PrintPairingsIndentationLeft");
            this.m_printPairingsColumnDistance = this.xmlReadIntegerElement(te, "PrintPairingsColumnDistance");
            this.m_printPairingsAbbreviateName = this.xmlReadBooleanElement(te, "PrintPairingsAbbreviateName");
            this.m_printPairingsAbbreviateNameLength = this.xmlReadIntegerElement(te, "PrintPairingsAbbreviateNameLength");
        }
        this.m_walllist = (Walllist)this.xmlReadSinglePersistentObject(te, "Walllist", Walllist.class);
        this.m_walllist.setTournament(this);
        if (this.xmlVersion() < 5) {
            for (Walllist.SortCriterionDescriptor criterion2 : this.getWalllist().getSortCriteria()) {
                if (!criterion2.isAllowedForSeeding()) continue;
                this.m_makePairingSeedingPlacementCriterion = criterion2;
                break;
            }
        }
        this.m_walllist.blockSort();
        this.blockSortCountries();
        List<XmlPersistentObject> countries = this.xmlReadPersistentObjects(te, "Country", Country.class);
        Iterator<XmlPersistentObject> itCountries = countries.iterator();
        while (itCountries.hasNext()) {
            this.addCountry((Country)itCountries.next());
        }
        this.unblockSortCountries();
        String defaultCountry = this.xmlReadTextElement(te, "DefaultCountry");
        if (defaultCountry != null) {
            this.m_defaultCountry = this.findCountry(defaultCountry);
        }
        if ((defaultNationality = this.xmlReadTextElement(te, "DefaultNationality")) != null) {
            this.m_defaultNationality = this.findCountry(defaultNationality);
        }
        List<XmlPersistentObject> participants = this.xmlReadPersistentObjects(te, "IndividualParticipant", IndividualParticipant.class);
        for (Participant participant : participants) {
            participant.setTournament(this);
            this.addParticipant(participant);
        }
        List<XmlPersistentObject> list = this.xmlReadPersistentObjects(te, "TournamentRound", TournamentRound.class);
        for (TournamentRound tournamentRound : list) {
            tournamentRound.blockSort();
            this.m_rounds[tournamentRound.getRoundNumber() - 1] = tournamentRound;
            List<Pairing> pairings = tournamentRound.getPairings();
            int i = 0;
            while (i < pairings.size()) {
                pairings.get(i).setTournament(this, tournamentRound.getRoundNumber());
                ++i;
            }
            tournamentRound.unblockSort();
        }
        if (this.xmlVersion() >= 8) {
            List<XmlPersistentObject> list2 = this.xmlReadPersistentObjects(te, "UnwantedPairing", UnwantedPairing.class);
            for (XmlPersistentObject persistentUnwantedPairing : list2) {
                UnwantedPairing unwantedPairing = (UnwantedPairing)persistentUnwantedPairing;
                unwantedPairing.setTournament(this);
                this.m_unwantedPairings.add(unwantedPairing);
            }
        }
        this.buildParticipantScores();
        this.m_walllist.unblockSort();
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 9;
    }

    @Override
    protected void xmlWrite(Element te, Document document) {
        super.xmlWrite(te, document);
        te.appendChild(this.xmlCreateIntegerElement(document, "NumberOfRounds", this.m_numberOfRounds));
        te.appendChild(this.xmlCreateIntegerElement(document, "CurrentRoundNumber", this.m_currentRoundNumber));
        te.appendChild(this.xmlCreateBooleanElement(document, "TakeCurrentRoundInAccount", this.m_takeCurrentRoundInAccount));
        if (this.m_name != null) {
            te.appendChild(this.xmlCreateCDataElement(document, "Name", this.m_name));
        }
        if (this.m_description != null) {
            te.appendChild(this.xmlCreateCDataElement(document, "Description", this.m_description));
        }
        te.appendChild(this.xmlCreateBooleanElement(document, "DefaultAsianName", this.m_defaultAsianName));
        te.appendChild(this.xmlCreateBooleanElement(document, "RatingAllowed", this.m_ratingAllowed));
        te.appendChild(this.xmlCreateIntegerElement(document, "RatingLowestOneDanRating", this.m_ratingLowestOneDanRating));
        te.appendChild(this.xmlCreateBooleanElement(document, "RatingDeterminesRank", this.m_ratingDeterminesRank));
        te.appendChild(this.xmlCreateBooleanElement(document, "RatingDeterminesStartScore", this.m_ratingDeterminesStartScore));
        te.appendChild(this.xmlCreateBooleanElement(document, "LowerMacMahonBar", this.m_lowerMacMahonBar));
        te.appendChild(this.xmlCreateTextElement(document, "LowerMacMahonBarLevel", this.m_lowerMacMahonBarLevel.getShortDisplayString()));
        te.appendChild(this.xmlCreateBooleanElement(document, "UpperMacMahonBar", this.m_upperMacMahonBar));
        te.appendChild(this.xmlCreateTextElement(document, "UpperMacMahonBarLevel", this.m_upperMacMahonBarLevel.getShortDisplayString()));
        te.appendChild(this.xmlCreateIntegerElement(document, "UpperMacMahonBarRating", this.m_upperMacMahonBarRating));
        te.appendChild(this.xmlCreateBooleanElement(document, "ByeShouldResultInZeroSOSetc", this.m_byeShouldResultInZeroSOSetc));
        te.appendChild(this.xmlCreateBooleanElement(document, "HalfScoreGroupsRoundDown", this.m_halfScoreGroupsRoundDown));
        te.appendChild(this.xmlCreateBooleanElement(document, "HalfScoreGroupsRoundDownNotJigo", this.m_halfScoreGroupsRoundDownNotJigo));
        te.appendChild(this.xmlCreateBooleanElement(document, "PreliminaryDefaultRegistration", this.m_preliminaryDefaultRegistration));
        te.appendChild(this.xmlCreateBooleanElement(document, "OnlineEgdSupport", this.m_onlineEgdSupport));
        te.appendChild(this.xmlCreateBooleanElement(document, "OnlineEgdSupportByPin", this.m_onlineEgdSupportByPin));
        te.appendChild(this.xmlCreateBooleanElement(document, "HandicapUsed", this.m_handicapUsed));
        te.appendChild(this.xmlCreateBooleanElement(document, "HandicapBelow", this.m_handicapBelow));
        te.appendChild(this.xmlCreateTextElement(document, "HandicapBelowLevel", this.m_handicapBelowLevel.getShortDisplayString()));
        te.appendChild(this.xmlCreateBooleanElement(document, "HandicapByLevel", this.m_handicapByLevel));
        te.appendChild(this.xmlCreateBooleanElement(document, "HandicapAdjustment", this.m_handicapAdjustment));
        te.appendChild(this.xmlCreateIntegerElement(document, "HandicapAdjustmentValue", this.m_handicapAdjustmentValue));
        te.appendChild(this.xmlCreateBooleanElement(document, "HandicapLimit", this.m_handicapLimit));
        te.appendChild(this.xmlCreateIntegerElement(document, "HandicapLimitValue", this.m_handicapLimitValue));
        te.appendChild(this.xmlCreateBooleanElement(document, "HandicapIncludeInTieBreakers", this.m_handicapIncludeInTieBreakers));
        te.appendChild(this.xmlCreateBooleanElement(document, "AllowJigo", this.m_allowJigo));
        te.appendChild(this.xmlCreateIntegerElement(document, "Boardsize", this.m_boardsize));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsMarkFixedBoardnumbers", this.m_pairingsMarkFixedBoardnumbers));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsMarkMissingResults", this.m_pairingsMarkMissingResults));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsMarkWinner", this.m_pairingsMarkWinner));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsMarkUnwantedPairings", this.m_pairingsMarkUnwantedPairings));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsShowLevels", this.m_pairingsShowLevels));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsShortNotationForLevel", this.m_pairingsShortNotationForLevel));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsShowScores", this.m_pairingsShowScores));
        te.appendChild(this.xmlCreateBooleanElement(document, "PairingsShowHandicaps", this.m_pairingsShowHandicaps));
        te.appendChild(this.xmlCreateIntegerElement(document, "PairingsFontsize", this.m_pairingsFontsize));
        te.appendChild(this.xmlCreateIntegerElement(document, "PairingsBlackColumnWidth", this.m_pairingsBlackColumnWidth));
        te.appendChild(this.xmlCreateIntegerElement(document, "PairingsWhiteColumnWidth", this.m_pairingsWhiteColumnWidth));
        te.appendChild(this.xmlCreateTextElement(document, "ImportEncoding", this.m_importEncoding));
        te.appendChild(this.xmlCreateCDataElement(document, "ExportColumnDelimiter", this.m_exportColumnDelimiter));
        te.appendChild(this.xmlCreateBooleanElement(document, "ExportWalllistShowTournamentTitle", this.m_exportWalllistShowTournamentTitle));
        te.appendChild(this.xmlCreateTextElement(document, "ExportEncoding", this.m_exportEncoding));
        te.appendChild(this.xmlCreateTextElement(document, "VersionCreated", this.m_versionCreated));
        te.appendChild(this.xmlCreateTextElement(document, "VersionSaved", this.m_versionSaved));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingTopGroup", this.m_makePairingTopGroup));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingTopGroupEverywhere", this.m_makePairingTopGroupEverywhere));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingTopGroupStrictlyByTopBar", this.m_makePairingTopGroupStrictlyByTopBar));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingTopGroupByNumberOfPlayersAuto", this.m_makePairingTopGroupByNumberOfPlayersAuto));
        te.appendChild(this.xmlCreateIntegerElement(document, "MakePairingTopGroupByNumberOfPlayers", this.m_makePairingTopGroupByNumberOfPlayers));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingTopGroupSeeding", this.m_makePairingTopGroupSeeding));
        te.appendChild(this.m_makePairingSeedingPlacementCriterion.xmlWrite("MakePairingSeedingPlacementCriterion", document));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingTopGroupSeedingByRating", this.m_makePairingTopGroupSeedingByRating));
        te.appendChild(this.xmlCreateIntegerElement(document, "MakePairingTopGroupSeedingByRatingRound", this.m_makePairingTopGroupSeedingByRatingRound));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupSameCountry", this.m_makePairingOutsideTopGroupSameCountry));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupSameClub", this.m_makePairingOutsideTopGroupSameClub));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupSameNationality", this.m_makePairingOutsideTopGroupSameNationality));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupStrengthDifference", this.m_makePairingOutsideTopGroupStrengthDifference));
        te.appendChild(this.xmlCreateIntegerElement(document, "MakePairingOutsideTopGroupStrengthDifferenceValue", this.m_makePairingOutsideTopGroupStrengthDifferenceValue));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupColorBalance", this.m_makePairingOutsideTopGroupColorBalance));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupWeakOddMan", this.m_makePairingOutsideTopGroupWeakOddMan));
        te.appendChild(this.xmlCreateBooleanElement(document, "MakePairingOutsideTopGroupSeeding", this.m_makePairingOutsideTopGroupSeeding));
        te.appendChild(this.xmlCreateTextElement(document, "PrintWalllistFont", this.m_printWalllistFont));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintWalllistFontsize", this.m_printWalllistFontsize));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintWalllistIndentationTop", this.m_printWalllistIndentationTop));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintWalllistIndentationLeft", this.m_printWalllistIndentationLeft));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintWalllistColumnDistance", this.m_printWalllistColumnDistance));
        te.appendChild(this.xmlCreateBooleanElement(document, "PrintWalllistAbbreviateName", this.m_printWalllistAbbreviateName));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintWalllistAbbreviateNameLength", this.m_printWalllistAbbreviateNameLength));
        te.appendChild(this.xmlCreateTextElement(document, "PrintPairingsFont", this.m_printPairingsFont));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintPairingsFontsize", this.m_printPairingsFontsize));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintPairingsIndentationTop", this.m_printPairingsIndentationTop));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintPairingsIndentationLeft", this.m_printPairingsIndentationLeft));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintPairingsColumnDistance", this.m_printPairingsColumnDistance));
        te.appendChild(this.xmlCreateBooleanElement(document, "PrintPairingsAbbreviateName", this.m_printPairingsAbbreviateName));
        te.appendChild(this.xmlCreateIntegerElement(document, "PrintPairingsAbbreviateNameLength", this.m_printPairingsAbbreviateNameLength));
        te.appendChild(this.m_walllist.xmlWrite(document));
        for (Country country : this.m_countriesSorted) {
            te.appendChild(country.xmlWrite(document));
        }
        if (this.m_defaultCountry != null) {
            te.appendChild(this.xmlCreateTextElement(document, "DefaultCountry", this.m_defaultCountry.getInternetCode()));
        }
        if (this.m_defaultNationality != null) {
            te.appendChild(this.xmlCreateTextElement(document, "DefaultNationality", this.m_defaultNationality.getInternetCode()));
        }
        for (Participant participant : this.m_participants) {
            te.appendChild(participant.xmlWrite(document));
        }
        int i = 0;
        while (i < this.m_rounds.length) {
            te.appendChild(this.m_rounds[i].xmlWrite(document));
            ++i;
        }
        for (UnwantedPairing unwantedPairing : this.m_unwantedPairings) {
            te.appendChild(unwantedPairing.xmlWrite(document));
        }
    }

    public void turRead(InputStream reader) throws IOException, MacMahonException {
        XmlPersistentObject participantTwo;
        int printNotPlaying;
        int pairingOptionsSettingStrategy;
        int pairingOptionsTopGroupNumber;
        int n;
        int handicapReduction;
        int handicapBelowLevel;
        int n2;
        int sortCriterion;
        int winnersUpToPlace;
        ReadTurHelper helper = new ReadTurHelper(reader);
        helper.readClassBegin();
        if (!helper.readString().equals(XML_TAGNAME)) {
            throw new RuntimeException("illegal classname");
        }
        String versionStr = helper.readString();
        int version = versionStr.equals("MacMahon, V1.2") ? 1 : (versionStr.equals("MacMahon, V1.3") ? 2 : (versionStr.equals("MacMahon, V1.4") || versionStr.equals("MacMahon, V1.41") ? 3 : (versionStr.equals("MacMahon, V1.5") ? 4 : (versionStr.equals("MacMahon, V1.6") ? 5 : (versionStr.equals("MacMahon, V1.61") ? 6 : (versionStr.equals("MacMahon, V1.62") ? 7 : (versionStr.equals("MacMahon, V1.63") ? 8 : (versionStr.equals("MacMahon, V2.0") ? 9 : Integer.parseInt(versionStr)))))))));
        if (version == 0) {
            throw new MacMahonException("The TUR-file is saved with a version of MacMahon before V1.2 which is not supported to be opened.");
        }
        this.setName(helper.readString());
        if (version >= 16) {
            this.setDescription(helper.readString());
        }
        if (version >= 17) {
            String saver;
            String creator = helper.readString();
            if (creator.length() > 0) {
                this.setVersionCreated(creator);
            }
            if ((saver = helper.readString()).length() > 0) {
                this.setVersionSaved(saver);
            }
        }
        if (version >= 18) {
            helper.readString();
            helper.readString();
            helper.readString();
            helper.readString();
            helper.readString();
        }
        int tournamentSystem = helper.readInt16();
        this.setNumberOfRounds(helper.readInt16());
        this.setCurrentRoundNumber(helper.readInt16());
        int currentPairingSortStrategy = helper.readInt16();
        int numberOfPlayers = helper.readInt16();
        boolean participantId = false;
        int i = 0;
        while (i < numberOfPlayers) {
            IndividualParticipant participant = new IndividualParticipant();
            participant.turRead(helper);
            if (version >= 3) {
                participant.getGoPlayer().setRating(helper.readInt16());
            }
            if (version >= 11) {
                int n3 = helper.readInt32();
            }
            if (version >= 14) {
                participant.setComment(helper.readString());
            }
            participant.setTournament(this);
            this.addParticipant(participant);
            ++i;
        }
        int defaultPlayerRoundFlags = helper.readInt16();
        int defaultForcedPairingFlags = helper.readInt16();
        int forcedPairingAutoColor = helper.readInt16();
        if (version >= 2) {
            this.setPreliminaryDefaultRegistration(helper.readInt16() == 32);
            winnersUpToPlace = helper.readInt16();
            int n4 = helper.readInt16();
        }
        if (version >= 9) {
            winnersUpToPlace = helper.readInt16();
        }
        if (version >= 11) {
            int numberOfPlaces;
            while ((numberOfPlaces = helper.readInt16()) > 0) {
                int topStrength = helper.readInt16();
                int bottomStrength = helper.readInt16();
                while ((sortCriterion = helper.readInt16()) != 0) {
                }
            }
        }
        this.m_walllist = new Walllist();
        this.m_walllist.setTournament(this);
        this.m_walllist.blockSort();
        ArrayList<Walllist.SortCriterionDescriptor> sortCriteria = new ArrayList<Walllist.SortCriterionDescriptor>();
        boolean noMore = false;
        int i2 = 0;
        while (i2 < 8) {
            sortCriterion = helper.readInt16();
            if (!noMore) {
                if (sortCriterion == 0) {
                    noMore = true;
                } else if (sortCriterion == 1) {
                    sortCriteria.add(Walllist.SCD_SCORE);
                } else if (sortCriterion == 2) {
                    sortCriteria.add(Walllist.SCD_SOS);
                } else if (sortCriterion == 3) {
                    sortCriteria.add(Walllist.SCD_SOSOS);
                } else if (sortCriterion == 4) {
                    sortCriteria.add(Walllist.SCD_SODOS);
                } else if (sortCriterion == 5) {
                    helper.addMessage("Warning: Placement criterion 'CUSS' was used in the tournament but it's not supported by MacMahon 3.");
                } else if (sortCriterion == 6) {
                    helper.addMessage("Warning: Placement criterion 'SOS plus 2 wins' was used in the tournament but it's not supported by MacMahon 3.");
                } else if (sortCriterion == 7) {
                    sortCriteria.add(Walllist.SCD_NUMBEROFWINS);
                }
            }
            ++i2;
        }
        noMore = false;
        boolean weakLevel = false;
        boolean weakName = false;
        int i3 = 0;
        while (i3 < 3) {
            int sortCriterion2 = helper.readInt16();
            if (!noMore) {
                if (sortCriterion2 == 0) {
                    noMore = true;
                } else if (sortCriterion2 == 1) {
                    weakLevel = true;
                } else if (sortCriterion2 == 2) {
                    weakName = true;
                }
            }
            ++i3;
        }
        if (weakLevel && weakName) {
            this.m_walllist.setWeakSortCriteria(1);
        } else if (weakName) {
            this.m_walllist.setWeakSortCriteria(2);
        } else {
            this.m_walllist.setWeakSortCriteria(3);
        }
        this.m_walllist.setSortCriteria(sortCriteria);
        int lowerBar = helper.readInt16();
        int upperBar = helper.readInt16();
        if (tournamentSystem == 0) {
            if (lowerBar > 0) {
                this.setLowerMacMahonBarLevel(new GoLevel(lowerBar, false, false));
            } else {
                this.setLowerMacMahonBarLevel(new GoLevel(1 + lowerBar * -1, true, false));
            }
            this.setLowerMacMahonBar(true);
            if (upperBar > 0) {
                this.setUpperMacMahonBarLevel(new GoLevel(upperBar, false, false));
            } else {
                this.setUpperMacMahonBarLevel(new GoLevel(1 + upperBar * -1, true, false));
            }
            this.setUpperMacMahonBar(true);
        } else {
            this.setLowerMacMahonBarLevel(new GoLevel(1, true, false));
            this.setLowerMacMahonBar(true);
            this.setUpperMacMahonBarLevel(new GoLevel(1, true, false));
            this.setUpperMacMahonBar(true);
        }
        this.setTakeCurrentRoundInAccount(helper.readInt16() != 0);
        int i4 = 0;
        while (i4 < 5) {
            n2 = helper.readInt16();
            ++i4;
        }
        int handicapFlags = helper.readInt16();
        this.setHandicapUsed((handicapFlags & 1) != 1);
        this.setHandicapByLevel((handicapFlags & 4) == 4);
        if ((handicapFlags & 0x10) == 16) {
            helper.addMessage("Warning: individual handicap strategies have been used which is not supported by MacMahon 3.");
        }
        if (version >= 9) {
            n2 = helper.readInt16();
        }
        this.setHandicapBelow((handicapBelowLevel = helper.readInt16()) > -7);
        if (handicapBelowLevel > -7) {
            if (handicapBelowLevel > 0) {
                this.setHandicapBelowLevel(new GoLevel(handicapBelowLevel, false, false));
            } else {
                this.setHandicapBelowLevel(new GoLevel(1 + handicapBelowLevel * -1, true, false));
            }
        }
        this.setHandicapAdjustment((handicapReduction = handicapFlags >> 6) > 0);
        if (handicapReduction > 0) {
            this.setHandicapAdjustmentValue(handicapReduction * -1);
        }
        if ((handicapFlags >> 5 & 1) == 1) {
            helper.addMessage("Warning: handicaps have been reduced by a half stone which is not supported by MacMahon 3.");
        }
        if (version >= 18) {
            this.setHandicapIncludeInTieBreakers(helper.readInt16() != 0);
            this.setHandicapLimit(helper.readInt16() != 0);
            this.setHandicapLimitValue(helper.readInt16() >> 1);
        }
        int startMMSChangeOnStrengthChange = helper.readInt16();
        int meaningOfBelowStrengthHandicap = helper.readInt16();
        if (version >= 19) {
            this.setHalfScoreGroupsRoundDown(helper.readInt16() != 0);
        }
        int pairingOptionsPlayedBefore_Weight = helper.readInt32();
        int pairingOptionsSameGroup_Weight = helper.readInt32();
        int pairingOptionsSameGroupPower = helper.readInt32();
        int pairingOptionsOddMan_Weight = helper.readInt32();
        int pairingOptionsSetting_Weight = helper.readInt32();
        this.setMakePairingOutsideTopGroupSeeding(helper.readInt16() != 0);
        if (version >= 10) {
            int roundWithRating = 0;
            int i5 = 0;
            boolean ende = false;
            while (!ende) {
                int j = helper.readInt16();
                if (j == -3) {
                    ende = true;
                } else if (i5 < 18 && j > 0) {
                    if (roundWithRating == i5) {
                        ++roundWithRating;
                    } else {
                        helper.addMessage("Warning: rating was used for seeding in round '" + Integer.toString(i5 + 1) + "', but with MacMahon 3 it's only possible to use rating for the first n rounds of the tournament.");
                    }
                }
                ++i5;
            }
            if (roundWithRating > 0) {
                this.setMakePairingTopGroupSeedingByRating(true);
                this.setMakePairingTopGroupSeedingByRatingRound(roundWithRating);
            }
        } else if (version >= 3 && version <= 9 && helper.readInt16() != 0) {
            this.setMakePairingTopGroupSeedingByRating(true);
            this.setMakePairingTopGroupSeedingByRatingRound(1);
        }
        int pairingOptionsColor_Weight = helper.readInt32();
        int pairingOptionsCountry_Weight = helper.readInt32();
        int pairingOptionsClub_Weight = helper.readInt32();
        int pairingOptionsStrengthDifference_Weight = helper.readInt32();
        int pairingOptionsUnacceptableDifference = helper.readInt16();
        int pairingOptionsHandicap_Weight = helper.readInt32();
        int pairingOptionsAutoIgnoreAboveMMS = helper.readInt16();
        int pairingOptionsIgnoreAboveMMS = helper.readInt16();
        this.setMakePairingTopGroup(pairingOptionsAutoIgnoreAboveMMS != 0 || pairingOptionsIgnoreAboveMMS != -1);
        if (version >= 4) {
            this.setMakePairingOutsideTopGroupWeakOddMan(helper.readInt16() == 0);
            n = helper.readInt32();
        }
        if (version >= 5) {
            n = helper.readInt16();
        }
        if (version >= 7) {
            int pairingOptionsTopGroupSelection = helper.readInt16();
            pairingOptionsTopGroupNumber = helper.readInt16();
            this.setMakePairingTopGroupStrictlyByTopBar((pairingOptionsTopGroupSelection & 1) == 1);
            this.setMakePairingTopGroupByNumberOfPlayersAuto((pairingOptionsTopGroupSelection & 4) == 0);
            this.setMakePairingTopGroupByNumberOfPlayers(pairingOptionsTopGroupNumber);
        }
        if (version >= 8) {
            pairingOptionsSettingStrategy = helper.readInt16();
            pairingOptionsTopGroupNumber = helper.readInt16();
        }
        if (version >= 6) {
            this.getWalllist().setMarkResultsByReferree(helper.readInt16() != 0);
        }
        if (version >= 17) {
            pairingOptionsSettingStrategy = helper.readInt16();
        }
        if (version >= 20) {
            pairingOptionsSettingStrategy = helper.readInt16();
        }
        if (version >= 8) {
            pairingOptionsSettingStrategy = helper.readInt16();
        }
        if (version >= 11) {
            this.getWalllist().setShowCountry(helper.readInt16() != 0);
        }
        if (version >= 12) {
            printNotPlaying = helper.readInt16();
            pairingOptionsTopGroupNumber = helper.readInt16();
        }
        if (version >= 13) {
            printNotPlaying = helper.readInt16();
        }
        if (version >= 15) {
            int topMargin = helper.readInt32();
            int leftMargin = helper.readInt32();
            int rightMargin = helper.readInt32();
            int n5 = helper.readInt32();
        }
        boolean ende = false;
        ArrayList<Country> countries = new ArrayList<Country>();
        while (!ende) {
            String country = helper.readString();
            if (country.equals("_end")) {
                ende = true;
                continue;
            }
            if (country.length() == 0) {
                country = "__no_name";
            }
            Country newCountry = new Country((country.length() > 2 ? country.substring(0, 2) : country).toLowerCase(), country);
            this.addCountry(newCountry);
            countries.add(newCountry);
        }
        ende = false;
        while (!ende) {
            String club = helper.readString();
            if (!club.equals("_end")) continue;
            ende = true;
        }
        helper.addMessage("Warning: Clubs could not be imported as clubs in MacMahon 3 are not valid without being associated with a country.");
        if (version >= 21) {
            int unwantedPairingsSize = helper.readInt16();
            int i6 = 0;
            while (i6 < unwantedPairingsSize) {
                int unwantedPairings_player1 = helper.readInt16();
                Participant participantOne = this.m_participants.get(unwantedPairings_player1);
                int unwantedPairings_player2 = helper.readInt16();
                participantTwo = this.m_participants.get(unwantedPairings_player2);
                int unwantedPairings_forbidden = helper.readInt16();
                int unwantedPairings_upToRound = helper.readInt16();
                this.createUnwantedPairing(participantOne, (Participant)participantTwo, unwantedPairings_forbidden > 0);
                ++i6;
            }
        }
        int i7 = 0;
        while (i7 < this.m_rounds.length) {
            this.m_rounds[i7].blockSort();
            ++i7;
        }
        i7 = 0;
        while (i7 < this.m_participants.size()) {
            IndividualParticipant participant = (IndividualParticipant)this.m_participants.get(i7);
            String country = participant.getGoPlayer().getNationalityPersistentName();
            if (country != null && country.length() > 0) {
                participant.getGoPlayer().setNationality((Country)countries.get(Integer.parseInt(country) - 1));
            }
            int round = 0;
            while (round < this.getNumberOfRounds()) {
                if (participant.getPairingInRound(round + 1) == null) {
                    IndividualParticipant.TurPairing turPairing = participant.m_turPairings.get(round);
                    if ((turPairing.m_roundFlags & 0x800) == 2048) {
                        participant.setPairingInRound(Pairing.NOT_PLAYING, round + 1);
                    } else if (turPairing.m_opponent == -1) {
                        participantTwo = this.createPairingWithByeInRound(participant, round + 1, (turPairing.m_roundFlags & 0x80) == 128, null);
                    } else if (turPairing.m_opponent != -2) {
                        Participant white;
                        Participant black;
                        if ((turPairing.m_roundFlags & 0x1000) == 4096) {
                            black = participant;
                            white = this.m_participants.get(turPairing.m_opponent);
                        } else {
                            black = this.m_participants.get(turPairing.m_opponent);
                            white = participant;
                        }
                        int handicap = 0;
                        if ((turPairing.m_roundFlags & 0x100) == 256) {
                            handicap = turPairing.m_handicapStones >> 1;
                        }
                        Pairing newPairing = new Pairing(this, this.getRound(round + 1), black, white, turPairing.m_handicapStones >> 1, this.m_allowJigo, false, (turPairing.m_roundFlags & 0x80) == 128, null);
                        if (turPairing.m_board > 0) {
                            newPairing.setBoardNumberBySort(turPairing.m_board, true);
                        }
                        black.setPairingInRound(newPairing, round + 1);
                        white.setPairingInRound(newPairing, round + 1);
                        if ((turPairing.m_roundFlags & 0x42) > 0) {
                            newPairing.setResult(Pairing.BLACK_WINS);
                        } else if ((turPairing.m_roundFlags & 0x24) > 0) {
                            newPairing.setResult(Pairing.WHITE_WINS);
                        } else if ((turPairing.m_roundFlags & 8) == 8) {
                            newPairing.setResult(Pairing.JIGO);
                        } else if ((turPairing.m_roundFlags & 0x10) == 16) {
                            newPairing.setResult(Pairing.BOTH_LOSE);
                        } else if ((turPairing.m_roundFlags & 0x4000) == 16384) {
                            newPairing.setResult(Pairing.BOTH_WIN);
                        }
                        if ((turPairing.m_roundFlags & 0x4070) > 0) {
                            newPairing.setResultByReferee(true);
                        }
                        this.getRound(round + 1).addPairing(newPairing);
                    }
                }
                ++round;
            }
            ++i7;
        }
        this.buildParticipantScores();
        i7 = 0;
        while (i7 < this.m_rounds.length) {
            this.m_rounds[i7].unblockSort();
            ++i7;
        }
        this.m_walllist.unblockSort();
        this.setDescription(helper.appendMessages(this.getDescription()));
    }

    private static class ClubStatistics
    extends Statistics
    implements Comparable<ClubStatistics> {
        public Club m_club;

        public ClubStatistics(Club club) {
            this.m_club = club;
        }

        @Override
        public int compareTo(ClubStatistics o) {
            return this.m_club.compareTo(o.m_club);
        }
    }

    private static class CountryStatistics
    extends Statistics
    implements Comparable<CountryStatistics> {
        public Country m_country;

        public CountryStatistics(Country country) {
            this.m_country = country;
        }

        @Override
        public int compareTo(CountryStatistics o) {
            return this.m_country.compareTo(o.m_country);
        }
    }

    private static class GoLevelStatistics
    extends Statistics
    implements Comparable<GoLevelStatistics> {
        public GoLevel m_goLevel;

        public GoLevelStatistics(GoLevel goLevel) {
            this.m_goLevel = goLevel;
        }

        @Override
        public int compareTo(GoLevelStatistics o) {
            return this.m_goLevel.compareTo(o.m_goLevel);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (" + this.m_goLevel.toString() + ")";
        }
    }

    public static abstract class ListPrinter
    implements Printable {
        public static final int NUMBER_OF_FIXED_ROWS_PER_PAGE = 3;
    }

    public static class PairingsPrinter
    extends ListPrinter {
        private Tournament m_tournament;
        private int m_pairingsCount = -1;
        private String[][] m_pairingsData;
        private PairingsColumn[] m_columns;
        private int m_lineHeight;
        private double m_pageHeight;
        private int m_columnCount;
        private double m_offsetMeasure;
        private double m_columnOffset;

        public PairingsPrinter(Tournament tournament) {
            this.m_tournament = tournament;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int i;
            this.m_pairingsCount = this.m_tournament.getCurrentRound().getPairings().size();
            Font font = new Font(this.m_tournament.getPrintPairingsFont(), 0, this.m_tournament.getPrintPairingsFontsize());
            graphics.setFont(font);
            FontMetrics metrics = graphics.getFontMetrics(font);
            this.m_lineHeight = metrics.getHeight();
            this.m_pageHeight = pageFormat.getImageableHeight() - (double)(this.m_tournament.getPrintPairingsIndentationTop() * 2);
            int linesPerPage = (int)this.m_pageHeight / this.m_lineHeight;
            if (this.m_tournament.getCurrentRound().getPairings().size() <= (linesPerPage - 3) * pageIndex) {
                return 1;
            }
            ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            this.m_offsetMeasure = metrics.stringWidth("h");
            this.m_columnOffset = this.m_offsetMeasure * (double)this.m_tournament.getPrintPairingsColumnDistance();
            if (this.m_columns == null) {
                this.m_columnCount = 0;
                this.m_columns = new PairingsColumn[6];
                PairingsColumn column = new PairingsColumn();
                column.setName(PAIRING_COLUMNNAME_BOARD, graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                column = new PairingsColumn();
                column.setName(PAIRING_COLUMNNAME_BLACK, graphics, metrics);
                column.m_centerAlign = false;
                column.m_width = this.m_offsetMeasure * 20.0;
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                column = new PairingsColumn();
                column.setName("-", graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                column = new PairingsColumn();
                column.setName(PAIRING_COLUMNNAME_WHITE, graphics, metrics);
                column.m_centerAlign = false;
                column.m_width = this.m_offsetMeasure * 20.0;
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                column = new PairingsColumn();
                column.setName(PAIRING_COLUMNNAME_RESULT, graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                if (this.m_tournament.getPairingsShowHandicaps()) {
                    column = new PairingsColumn();
                    column.setName(PAIRING_COLUMNNAME_HANDICAP, graphics, metrics);
                    column.m_offsetToNextColumn = this.m_columnOffset;
                    this.m_columns[this.m_columnCount] = column;
                    ++this.m_columnCount;
                }
                this.m_pairingsData = new String[this.m_pairingsCount][];
                i = 0;
                while (i < this.m_pairingsCount) {
                    String whiteName;
                    String blackName;
                    Pairing pairing = this.m_tournament.getCurrentRound().getPairingAt(i);
                    String[] columns = new String[6];
                    int playerLength = this.m_tournament.getPrintPairingsAbbreviateName() ? this.m_tournament.getPrintPairingsAbbreviateNameLength() : 999;
                    int index = 0;
                    columns[index] = Integer.toString(pairing.getBoardNumber());
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    Object blackLevel = "";
                    if (this.m_tournament.getPairingsShowLevels() || this.m_tournament.getPairingsShowScores()) {
                        blackLevel = (String)blackLevel + " (";
                    }
                    if (this.m_tournament.getPairingsShowLevels()) {
                        blackLevel = (String)blackLevel + pairing.getBlack().getGoLevel().getShortDisplayString();
                    }
                    if (this.m_tournament.getPairingsShowScores()) {
                        if (this.m_tournament.getPairingsShowLevels()) {
                            blackLevel = (String)blackLevel + ", ";
                        }
                        blackLevel = (String)blackLevel + pairing.getBlack().getScoreDisplayString(pairing.getBlack().getScoreAfterRound(this.m_tournament.getCurrentRoundNumber() - 1));
                    }
                    if (this.m_tournament.getPairingsShowLevels() || this.m_tournament.getPairingsShowScores()) {
                        blackLevel = (String)blackLevel + ")";
                    }
                    if ((blackName = pairing.getBlack().getName()).length() > playerLength - ((String)blackLevel).length() && (blackName = blackName.substring(0, playerLength - ((String)blackLevel).length()).trim()).endsWith(",")) {
                        blackName = blackName.substring(0, blackName.length() - 1);
                    }
                    columns[index] = blackName + (String)blackLevel;
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    columns[++index] = "-";
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    Object whiteLevel = "";
                    if (pairing.isPairingWithBye()) {
                        whiteName = Pairing.BYE;
                    } else {
                        if (this.m_tournament.getPairingsShowLevels() || this.m_tournament.getPairingsShowScores()) {
                            whiteLevel = (String)whiteLevel + " (";
                        }
                        if (this.m_tournament.getPairingsShowLevels()) {
                            whiteLevel = (String)whiteLevel + pairing.getWhite().getGoLevel().getShortDisplayString();
                        }
                        if (this.m_tournament.getPairingsShowScores()) {
                            if (this.m_tournament.getPairingsShowLevels()) {
                                whiteLevel = (String)whiteLevel + ", ";
                            }
                            whiteLevel = (String)whiteLevel + pairing.getWhite().getScoreDisplayString(pairing.getWhite().getScoreAfterRound(this.m_tournament.getCurrentRoundNumber() - 1));
                        }
                        if (this.m_tournament.getPairingsShowLevels() || this.m_tournament.getPairingsShowScores()) {
                            whiteLevel = (String)whiteLevel + ")";
                        }
                        if ((whiteName = pairing.getWhite().getName()).length() > playerLength - ((String)whiteLevel).length() && (whiteName = whiteName.substring(0, playerLength - ((String)whiteLevel).length()).trim()).endsWith(",")) {
                            whiteName = whiteName.substring(0, whiteName.length() - 1);
                        }
                    }
                    columns[index] = whiteName + (String)whiteLevel;
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    columns[++index] = pairing.getResult() == Pairing.NO_RESULT ? "-" : pairing.getResultDisplayString();
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    if (this.m_tournament.getPairingsShowHandicaps()) {
                        columns[index] = pairing.getHandicapDisplayString();
                        this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                        ++index;
                    }
                    this.m_pairingsData[i] = columns;
                    ++i;
                }
            }
            if (this.m_columns[1].m_width > this.m_columns[3].m_width) {
                this.m_columns[3].m_width = this.m_columns[1].m_width;
            } else {
                this.m_columns[1].m_width = this.m_columns[3].m_width;
            }
            graphics.drawString(this.m_tournament.getNameRoundDisplayString() + " (" + Messages.getString("Tournament.Page") + " " + Integer.toString(pageIndex + 1) + "/" + Integer.toString(this.m_tournament.getCurrentRound().getPairings().size() / (linesPerPage - 3) + 1) + ")", this.m_tournament.getPrintPairingsIndentationLeft(), this.m_tournament.getPrintPairingsIndentationTop() + this.m_lineHeight);
            int line = 2;
            this.drawLine(graphics, metrics, null, line);
            ++line;
            i = 0;
            while (i < linesPerPage - 3 && pageIndex * (linesPerPage - 3) + i < this.m_pairingsCount) {
                this.drawLine(graphics, metrics, this.m_pairingsData[pageIndex * (linesPerPage - 3) + i], line);
                ++line;
                ++i;
            }
            if (this.m_tournament.getCurrentRound().getPairings().size() <= (linesPerPage - 3) * (pageIndex + 1)) {
                graphics.drawString("(" + DateFormat.getDateTimeInstance().format(this.m_tournament.getCurrentRound().getLastUpdated()) + ")", this.m_tournament.getPrintPairingsIndentationLeft(), this.m_tournament.getPrintPairingsIndentationTop() + line * this.m_lineHeight);
                ++line;
            }
            return 0;
        }

        private void drawLine(Graphics graphics, FontMetrics metrics, String[] columns, int line) {
            int posx = this.m_tournament.getPrintPairingsIndentationLeft();
            int i = 0;
            while (i < this.m_columnCount) {
                String value;
                String string = value = columns == null ? this.m_columns[i].m_name : columns[i];
                if (value != null) {
                    if (this.m_columns[i].m_centerAlign) {
                        Rectangle2D bounds = metrics.getStringBounds(value, graphics);
                        graphics.drawString(value, posx + (int)(this.m_columns[i].m_width / 2.0 - bounds.getWidth() / 2.0), this.m_tournament.getPrintPairingsIndentationTop() + line * this.m_lineHeight);
                    } else {
                        graphics.drawString(value, posx, this.m_tournament.getPrintPairingsIndentationTop() + line * this.m_lineHeight);
                    }
                }
                posx = (int)((double)posx + this.m_columns[i].m_width);
                posx = (int)((double)posx + this.m_columns[i].m_offsetToNextColumn);
                ++i;
            }
        }

        private static class PairingsColumn {
            public String m_name;
            public double m_width = -1.0;
            public double m_offsetToNextColumn = 0.0;
            public boolean m_centerAlign = true;

            private PairingsColumn() {
            }

            public void setName(String name, Graphics graphics, FontMetrics metrics) {
                this.m_name = name;
                this.checkWidth(this.m_name, graphics, metrics);
            }

            public void checkWidth(String value, Graphics graphics, FontMetrics metrics) {
                if (value != null) {
                    int width = metrics.stringWidth(value);
                    if (this.m_width < 0.0 || (double)width > this.m_width) {
                        this.m_width = width;
                    }
                }
            }
        }
    }

    public static class ReadTurHelper {
        private InputStream m_reader;
        private List<String> m_messages = new ArrayList<String>();

        ReadTurHelper(InputStream reader) {
            this.m_reader = reader;
        }

        public void readClassBegin() throws IOException {
            int nextByte = this.m_reader.read();
            if (nextByte != 2) {
                throw new RuntimeException("illegal byte '" + Integer.toHexString(nextByte) + "'");
            }
            nextByte = this.m_reader.read();
            if (nextByte != 91) {
                throw new RuntimeException("illegal byte '" + Integer.toHexString(nextByte) + "'");
            }
        }

        public void readClassEnd() throws IOException {
            int nextByte = this.m_reader.read();
            if (nextByte != 93) {
                throw new RuntimeException("illegal byte '" + Integer.toHexString(nextByte) + "'");
            }
        }

        public String readString() throws IOException {
            int length = this.m_reader.read();
            byte[] charbuf = new byte[length];
            this.m_reader.read(charbuf);
            return new String(charbuf, "Cp1252");
        }

        public int readInt16() throws IOException {
            int lowbyte = this.m_reader.read();
            int highbyte = this.m_reader.read();
            if ((highbyte & 0x80) == 128) {
                return Short.MIN_VALUE + (((highbyte &= 0x7F) << 8) + lowbyte);
            }
            return (highbyte << 8) + lowbyte;
        }

        public int readInt32() throws IOException {
            int byte4 = this.m_reader.read();
            int byte3 = this.m_reader.read();
            int byte2 = this.m_reader.read();
            int byte1 = this.m_reader.read();
            if ((byte1 & 0x80) == 128) {
                return Integer.MIN_VALUE + (((byte1 &= 0x7F) << 24) + (byte2 << 16) + (byte3 << 8) + byte4);
            }
            return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
        }

        public void addMessage(String message) {
            this.m_messages.add(message);
        }

        public String appendMessages(String description) {
            if (this.m_messages.size() == 0) {
                return description;
            }
            StringBuilder messages = new StringBuilder();
            if (description != null && description.length() > 0) {
                messages.append(description);
                messages.append("\n\n");
            }
            messages.append("Messages from loading TUR file into MacMahon 3:");
            Iterator<String> it = this.m_messages.iterator();
            while (it.hasNext()) {
                messages.append("\n");
                messages.append(it.next());
            }
            return messages.toString();
        }
    }

    private static class SecondCriteriaIndexOfGroup {
        long m_minIndex;
        long m_maxIndex;
        long m_middleIndex;
        int m_numberOfPlayersInThisGroup;
        ArrayList<Integer> m_placeList = new ArrayList();

        private SecondCriteriaIndexOfGroup() {
        }

        public int getSecondCriteriaIndexOfPlayer(Participant participant, Walllist.SortCriterionDescriptor sortCriterion) {
            if (this.m_middleIndex < 0L || this.m_maxIndex == this.m_minIndex) {
                return 50;
            }
            return (int)Math.round(100.0 * ((double)(this.getSecondCriteriaAbsolutOfPlayer(participant, sortCriterion) - this.m_minIndex) / (double)(this.m_maxIndex - this.m_minIndex)));
        }

        public long getSecondCriteriaAbsolutOfPlayer(Participant participant, Walllist.SortCriterionDescriptor sortCriterion) {
            if (sortCriterion == Walllist.SCD_SOS) {
                return participant.getSos();
            }
            if (sortCriterion == Walllist.SCD_SOSOS) {
                return participant.getSosos();
            }
            if (sortCriterion == Walllist.SCD_SODOS) {
                return participant.getSodos();
            }
            if (sortCriterion == Walllist.SCD_RATING) {
                return participant.getRating();
            }
            return 0L;
        }
    }

    private static abstract class Statistics {
        public int m_numberOfPlayers = 0;
        public int m_numberOfPlayersCompleteTournament = 0;
        public int m_numberOfGamesPlayed = 0;
        public int m_numberOfWins = 0;

        private Statistics() {
        }

        public void processParticipant(Participant participant) {
            ++this.m_numberOfPlayers;
            if (participant.hasPlayedCompleteTournament()) {
                ++this.m_numberOfPlayersCompleteTournament;
            }
            this.m_numberOfGamesPlayed += participant.getNumberOfRoundsPlayed();
            this.m_numberOfWins += participant.getNumberOfWinsAfterRound(participant.getNumberOfRounds());
        }
    }

    public static class WalllistPrinter
    extends ListPrinter {
        private String m_timestampDisplay = DateFormat.getDateTimeInstance().format(new Date());
        private Tournament m_tournament;
        private int m_participantCount = -1;
        private String[][] m_participantWallistData;
        private WalllistColumn[] m_columns;
        private int m_lineHeight;
        private double m_pageHeight;
        private int m_columnCount;
        private double m_offsetMeasure;
        private double m_columnOffset;

        public WalllistPrinter(Tournament tournament) {
            this.m_tournament = tournament;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            this.m_participantCount = this.m_tournament.getWalllist().getParticipantCount();
            Font font = new Font(this.m_tournament.getPrintWalllistFont(), 0, this.m_tournament.getPrintWalllistFontsize());
            graphics.setFont(font);
            FontMetrics metrics = graphics.getFontMetrics(font);
            this.m_lineHeight = metrics.getHeight();
            this.m_pageHeight = pageFormat.getImageableHeight() - (double)(this.m_tournament.getPrintWalllistIndentationTop() * 2);
            int linesPerPage = (int)this.m_pageHeight / this.m_lineHeight;
            if (this.m_participantCount <= (linesPerPage - 3) * pageIndex) {
                return 1;
            }
            ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            this.m_offsetMeasure = metrics.stringWidth("h");
            this.m_columnOffset = this.m_offsetMeasure * (double)this.m_tournament.getPrintWalllistColumnDistance();
            if (this.m_columns == null) {
                this.m_columnCount = 0;
                this.m_columns = new WalllistColumn[this.m_tournament.getCurrentRoundNumber() + 12];
                WalllistColumn column = new WalllistColumn();
                column.setName(Walllist.COLUMNNAME_PLACE, graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                column = new WalllistColumn();
                column.setName(Walllist.COLUMNNAME_NAME, graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                column.m_centerAlign = false;
                column.m_width = this.m_offsetMeasure * 10.0;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                if (this.m_tournament.getWalllist().getShowCountry() || this.m_tournament.getWalllist().getShowClub()) {
                    column = new WalllistColumn();
                    column.setName(Walllist.COLUMNNAME_CLUB, graphics, metrics);
                    column.m_offsetToNextColumn = this.m_columnOffset;
                    column.m_centerAlign = this.m_tournament.getWalllist().getClubColumnAlignmentCenter();
                    this.m_columns[this.m_columnCount] = column;
                    ++this.m_columnCount;
                }
                if (this.m_tournament.getWalllist().getShowLevels()) {
                    column = new WalllistColumn();
                    column.setName(Walllist.COLUMNNAME_LEVEL, graphics, metrics);
                    column.m_offsetToNextColumn = this.m_columnOffset;
                    this.m_columns[this.m_columnCount] = column;
                    ++this.m_columnCount;
                }
                if (this.m_tournament.getRatingAllowed() && this.m_tournament.getWalllist().getShowRatings()) {
                    column = new WalllistColumn();
                    column.setName(Walllist.COLUMNNAME_RATING, graphics, metrics);
                    column.m_offsetToNextColumn = this.m_columnOffset;
                    this.m_columns[this.m_columnCount] = column;
                    ++this.m_columnCount;
                }
                column = new WalllistColumn();
                column.setName(Walllist.SCD_SCORE.getLongName(), graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                int round = 0;
                while (round < this.m_tournament.getCurrentRoundNumber()) {
                    column = new WalllistColumn();
                    column.setName(Integer.toString(round + 1), graphics, metrics);
                    column.m_offsetToNextColumn = round + 1 < this.m_tournament.getCurrentRoundNumber() ? this.m_columnOffset / 2.0 : this.m_columnOffset;
                    column.m_roundColumn = true;
                    this.m_columns[this.m_columnCount] = column;
                    ++this.m_columnCount;
                    ++round;
                }
                column = new WalllistColumn();
                column.setName(Walllist.SCD_NUMBEROFWINS.getLongName(), graphics, metrics);
                column.m_offsetToNextColumn = this.m_columnOffset;
                this.m_columns[this.m_columnCount] = column;
                ++this.m_columnCount;
                for (Walllist.SortCriterionDescriptor sortCriterion : this.m_tournament.getWalllist().getSortCriteria()) {
                    if (sortCriterion == Walllist.SCD_SCOREX) {
                        column = new WalllistColumn();
                        column.setName(Walllist.SCD_SCOREX.getLongName(), graphics, metrics);
                        column.m_offsetToNextColumn = this.m_columnOffset;
                        this.m_columns[this.m_columnCount] = column;
                        ++this.m_columnCount;
                        continue;
                    }
                    if (sortCriterion == Walllist.SCD_SOS) {
                        column = new WalllistColumn();
                        column.setName(Walllist.SCD_SOS.getLongName(), graphics, metrics);
                        column.m_offsetToNextColumn = this.m_columnOffset;
                        this.m_columns[this.m_columnCount] = column;
                        ++this.m_columnCount;
                        continue;
                    }
                    if (sortCriterion == Walllist.SCD_SOSOS) {
                        column = new WalllistColumn();
                        column.setName(Walllist.SCD_SOSOS.getLongName(), graphics, metrics);
                        column.m_offsetToNextColumn = this.m_columnOffset;
                        this.m_columns[this.m_columnCount] = column;
                        ++this.m_columnCount;
                        continue;
                    }
                    if (sortCriterion == Walllist.SCD_SODOS) {
                        column = new WalllistColumn();
                        column.setName(Walllist.SCD_SODOS.getLongName(), graphics, metrics);
                        column.m_offsetToNextColumn = this.m_columnOffset;
                        this.m_columns[this.m_columnCount] = column;
                        ++this.m_columnCount;
                        continue;
                    }
                    if (sortCriterion != Walllist.SCD_SORP) continue;
                    column = new WalllistColumn();
                    column.setName(Walllist.SCD_SORP.getLongName(), graphics, metrics);
                    column.m_offsetToNextColumn = this.m_columnOffset;
                    this.m_columns[this.m_columnCount] = column;
                    ++this.m_columnCount;
                }
                this.m_participantWallistData = new String[this.m_participantCount][];
                int i = 0;
                while (i < this.m_participantCount) {
                    GoLevel goLevel;
                    Participant participant = this.m_tournament.getWalllist().getParticipantAt(i);
                    String[] columns = new String[this.m_tournament.getCurrentRoundNumber() + 12];
                    int index = 0;
                    columns[index] = participant.isPlaceShared() ? "(" + Integer.toString(participant.getPlace()) + ")" : Integer.toString(participant.getPlace());
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    String name = participant.getName();
                    if (this.m_tournament.getPrintWalllistAbbreviateName() && name.length() > this.m_tournament.getPrintWalllistAbbreviateNameLength() && (name = name.substring(0, this.m_tournament.getPrintWalllistAbbreviateNameLength()).trim()).endsWith(",")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    columns[index] = name;
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    if (this.m_tournament.getWalllist().getShowCountry() || this.m_tournament.getWalllist().getShowClub()) {
                        columns[index] = participant.getClubDisplayStringWalllist();
                        if (columns[index] != null) {
                            this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                        }
                        ++index;
                    }
                    if (this.m_tournament.getWalllist().getShowLevels() && (goLevel = participant.getGoLevel()) != null) {
                        columns[index] = this.m_tournament.getWalllist().getShortNotationForLevel() ? goLevel.getShortDisplayString() : goLevel.getWalllistDisplayString();
                        this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                        ++index;
                    }
                    if (this.m_tournament.getRatingAllowed() && this.m_tournament.getWalllist().getShowRatings()) {
                        columns[index] = Integer.toString(participant.getRating());
                        this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                        ++index;
                    }
                    columns[index] = participant.getScoreDisplayString();
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    int round2 = 0;
                    while (round2 < this.m_tournament.getCurrentRoundNumber()) {
                        Pairing pairing = participant.getPairingInRound(round2 + 1);
                        columns[index] = pairing == null ? "?" : pairing.getWalllistString(participant, false, 0);
                        this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                        ++index;
                        ++round2;
                    }
                    columns[index] = participant.getNumberOfWinsDisplayString();
                    this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                    ++index;
                    for (Walllist.SortCriterionDescriptor sortCriterion : this.m_tournament.getWalllist().getSortCriteria()) {
                        if (sortCriterion == Walllist.SCD_SCOREX) {
                            columns[index] = participant.getScorexDisplayString();
                            this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                            ++index;
                            continue;
                        }
                        if (sortCriterion == Walllist.SCD_SOS) {
                            columns[index] = participant.getSosDisplayString();
                            this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                            ++index;
                            continue;
                        }
                        if (sortCriterion == Walllist.SCD_SOSOS) {
                            columns[index] = participant.getSososDisplayString();
                            this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                            ++index;
                            continue;
                        }
                        if (sortCriterion == Walllist.SCD_SODOS) {
                            columns[index] = participant.getSodosDisplayString();
                            this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                            ++index;
                            continue;
                        }
                        if (sortCriterion != Walllist.SCD_SORP) continue;
                        columns[index] = participant.getSorpDisplayString();
                        this.m_columns[index].checkWidth(columns[index], graphics, metrics);
                        ++index;
                    }
                    this.m_participantWallistData[i] = columns;
                    ++i;
                }
                double width = -1.0;
                int i2 = 0;
                while (i2 < this.m_columnCount) {
                    if (this.m_columns[i2].m_roundColumn && (width < 0.0 || this.m_columns[i2].m_width > width)) {
                        width = this.m_columns[i2].m_width;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.m_columnCount) {
                    if (this.m_columns[i2].m_roundColumn) {
                        this.m_columns[i2].m_width = width;
                    }
                    ++i2;
                }
            }
            graphics.drawString(this.m_tournament.getNameRoundDisplayString() + " (" + Messages.getString("Tournament.Page") + " " + Integer.toString(pageIndex + 1) + "/" + Integer.toString(this.m_participantCount / (linesPerPage - 3) + 1) + ")", this.m_tournament.getPrintWalllistIndentationLeft(), this.m_tournament.getPrintWalllistIndentationTop() + this.m_lineHeight);
            int line = 2;
            this.drawLine(graphics, metrics, null, line);
            ++line;
            int i = 0;
            while (i < linesPerPage - 3 && pageIndex * (linesPerPage - 3) + i < this.m_participantCount) {
                this.drawLine(graphics, metrics, this.m_participantWallistData[pageIndex * (linesPerPage - 3) + i], line);
                ++line;
                ++i;
            }
            if (this.m_participantCount <= (linesPerPage - 3) * (pageIndex + 1)) {
                graphics.drawString("(" + this.m_timestampDisplay + ")", this.m_tournament.getPrintWalllistIndentationLeft(), this.m_tournament.getPrintWalllistIndentationTop() + line * this.m_lineHeight);
                ++line;
            }
            return 0;
        }

        private void drawLine(Graphics graphics, FontMetrics metrics, String[] columns, int line) {
            int posx = this.m_tournament.getPrintWalllistIndentationLeft();
            int i = 0;
            while (i < this.m_columnCount) {
                String value;
                String string = value = columns == null ? this.m_columns[i].m_name : columns[i];
                if (value != null) {
                    if (this.m_columns[i].m_centerAlign) {
                        Rectangle2D bounds = metrics.getStringBounds(value, graphics);
                        if (i == 0 && value.startsWith("(")) {
                            graphics.setColor(WalllistTable.SHARED_PLACE_COLOR);
                        }
                        graphics.drawString(value, posx + (int)(this.m_columns[i].m_width / 2.0 - bounds.getWidth() / 2.0), this.m_tournament.getPrintWalllistIndentationTop() + line * this.m_lineHeight);
                        if (i == 0 && value.startsWith("(")) {
                            graphics.setColor(Color.BLACK);
                        }
                    } else {
                        graphics.drawString(value, posx, this.m_tournament.getPrintWalllistIndentationTop() + line * this.m_lineHeight);
                    }
                }
                posx = (int)((double)posx + this.m_columns[i].m_width);
                posx = (int)((double)posx + this.m_columns[i].m_offsetToNextColumn);
                ++i;
            }
        }

        private static class WalllistColumn {
            public String m_name;
            public double m_width = -1.0;
            public double m_offsetToNextColumn = 0.0;
            public boolean m_centerAlign = true;
            public boolean m_roundColumn = false;

            private WalllistColumn() {
            }

            public void setName(String name, Graphics graphics, FontMetrics metrics) {
                this.m_name = name;
                this.checkWidth(this.m_name, graphics, metrics);
            }

            public void checkWidth(String value, Graphics graphics, FontMetrics metrics) {
                int width = metrics.stringWidth(value);
                if (this.m_width < 0.0 || (double)width > this.m_width) {
                    this.m_width = width;
                }
            }
        }
    }
}

