/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Person
extends XmlPersistentObject {
    private boolean m_asianName;
    private String m_firstName;
    private String m_name;
    private String m_surname;

    public String getFirstName() {
        return this.m_firstName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameExportForEGD() {
        String surname = this.m_surname;
        if (surname == null) {
            surname = "(undefined)";
        }
        surname = surname.replace(' ', '_');
        String firstName = this.m_firstName;
        if (firstName != null) {
            firstName = firstName.replace(' ', '_');
        }
        if (firstName == null) {
            return surname;
        }
        return surname + " " + firstName;
    }

    public String getSurname() {
        return this.m_surname;
    }

    public boolean isAsianName() {
        return this.m_asianName;
    }

    private void rebuildName() {
        this.m_name = this.m_firstName == null ? (this.m_surname == null ? "(undefined)" : this.m_surname) : (this.m_surname == null ? this.m_firstName : (this.m_asianName ? this.m_surname + " " + this.m_firstName : this.m_surname + ", " + this.m_firstName));
    }

    public void setAsianName(boolean asianName) {
        this.m_asianName = asianName;
        this.rebuildName();
    }

    public void setFirstName(String firstName) {
        if (firstName != null && (firstName = firstName.trim()).length() == 0) {
            firstName = null;
        }
        this.m_firstName = firstName;
        this.rebuildName();
    }

    public void setSurname(String surname) {
        if (surname != null && (surname = surname.trim()).length() == 0) {
            surname = null;
        }
        this.m_surname = surname;
        this.rebuildName();
    }

    @Override
    public void xmlRead(Element pe) throws MacMahonException {
        super.xmlRead(pe);
        this.m_asianName = this.xmlReadBooleanElement(pe, "AsianName");
        this.m_firstName = this.xmlReadTextElement(pe, "FirstName");
        this.m_surname = this.xmlReadTextElement(pe, "Surname");
        this.rebuildName();
    }

    @Override
    protected void xmlWrite(Element pe, Document document) {
        super.xmlWrite(pe, document);
        pe.appendChild(this.xmlCreateBooleanElement(document, "AsianName", this.m_asianName));
        if (this.m_firstName != null) {
            pe.appendChild(this.xmlCreateCDataElement(document, "FirstName", this.m_firstName));
        }
        if (this.m_surname != null) {
            pe.appendChild(this.xmlCreateCDataElement(document, "Surname", this.m_surname));
        }
    }
}

