/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParticipantCategory
extends XmlPersistentObject {
    public static final int XML_VERSION = 1;
    public static final String XML_TAGNAME = "ParticipantCategory";
    private Tournament m_tournament;
    private String m_name;
    private String m_description;
    private Set<Participant> m_members = new HashSet<Participant>();
    private List<Integer> m_memberIds;

    public ParticipantCategory() {
    }

    public ParticipantCategory(Tournament tournament) {
        this.m_tournament = tournament;
    }

    public void setTournament(Tournament tournament) {
        this.m_tournament = tournament;
        for (Integer memberId : this.m_memberIds) {
            Participant participant = this.m_tournament.getParticipantById(memberId);
            if (participant == null) {
                throw new IllegalArgumentException("Participant not known. [id=" + memberId.toString() + "]");
            }
            this.m_members.add(participant);
        }
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 1;
    }

    @Override
    public void xmlRead(Element pce) throws MacMahonException {
        super.xmlRead(pce);
        this.m_name = this.xmlReadTextElement(pce, "Name");
        this.m_description = this.xmlReadTextElement(pce, "Description");
    }

    @Override
    protected void xmlWrite(Element pce, Document document) {
        super.xmlWrite(pce, document);
        pce.appendChild(this.xmlCreateCDataElement(document, "Name", this.m_name));
        pce.appendChild(this.xmlCreateCDataElement(document, "Description", this.m_description));
    }
}

