/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.Walllist;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Participant
extends XmlPersistentObject
implements Comparable<Participant> {
    protected Tournament m_tournament;
    private int m_id = 0;
    private boolean m_joker = false;
    private boolean m_preliminaryRegistration = false;
    private int m_score = 0;
    private int m_scorex = 0;
    private boolean m_scoreAdjustment = false;
    private int m_scoreAdjustmentValue = 0;
    private boolean m_superBarMember = false;
    private int m_numberOfWins = 0;
    private int m_sos = 0;
    private int m_sosos = 0;
    private int m_sodos = 0;
    private int m_sorp = 0;
    private Pairing[] m_pairings;
    private int m_place = 0;
    private boolean m_placeShared = false;
    private String m_comment;
    List<Integer> m_notPlayingInRounds;

    public Participant() {
    }

    public Participant(Tournament tournament) {
        this.setTournament(tournament);
    }

    public abstract void buildClubDisplayStringWalllist();

    public abstract Country getCountry();

    public abstract Club getClub();

    public void buildNumberOfWins() {
        int round = this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1);
        int numberOfWins = this.getNumberOfWinsAfterRound(round);
        if (this.m_numberOfWins != numberOfWins) {
            this.m_numberOfWins = numberOfWins;
            this.m_tournament.getWalllist().doSort();
        }
    }

    public void buildScore() {
        int round;
        int score;
        if (this.m_tournament != null && this.m_score != (score = this.getScoreAfterRound(round = this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1)))) {
            this.m_tournament.getWalllist().blockSort();
            this.m_score = score;
            this.buildSos();
            int i = 0;
            while (i < round) {
                if (this.m_pairings[i] != null && !this.m_pairings[i].isPairingWithBye() && this.m_pairings[i] != Pairing.NOT_PLAYING) {
                    this.m_pairings[i].getOpponent(this).buildSos();
                    this.m_pairings[i].getOpponent(this).buildSodos();
                }
                ++i;
            }
            this.buildSosos();
            this.buildSodos();
            this.m_tournament.getWalllist().unblockSort();
        }
    }

    public void buildScorex() {
        int round;
        int scorex;
        if (this.m_tournament != null && this.m_scorex != (scorex = this.getScorexAfterRound(round = this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1)))) {
            this.m_scorex = scorex;
            this.m_tournament.getWalllist().doSort();
        }
    }

    public void buildSodos() {
        int round = this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1);
        int sodos = this.getSodosAfterRound(round);
        if (this.m_sodos != sodos) {
            this.m_sodos = sodos;
            this.m_tournament.getWalllist().doSort();
        }
    }

    public void buildSorp() {
        int round = this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1);
        int sorp = this.getSorpAfterRound(round);
        if (this.m_sorp != sorp) {
            this.m_sorp = sorp;
            this.m_tournament.getWalllist().doSort();
        }
    }

    public void buildSos() {
        int round = this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1);
        int sos = this.getSosAfterRound(round);
        if (this.m_sos != sos) {
            this.m_sos = sos;
            this.buildSosos();
            int i = 0;
            while (i < round) {
                if (this.m_pairings[i] != null && !this.m_pairings[i].isPairingWithBye() && this.m_pairings[i] != Pairing.NOT_PLAYING) {
                    this.m_pairings[i].getOpponent(this).buildSosos();
                }
                ++i;
            }
            this.m_tournament.getWalllist().doSort();
        }
    }

    public void buildSosos() {
        int sosos = this.getSososAfterRound(this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1));
        if (this.m_sosos != sosos) {
            this.m_sosos = sosos;
            this.m_tournament.getWalllist().doSort();
        }
    }

    @Override
    public int compareTo(Participant o) {
        return this.compareTo(o, false);
    }

    public int compareTo(Participant other, boolean weak) {
        for (Walllist.SortCriterionDescriptor criterion : this.m_tournament.getWalllist().getSortCriteria()) {
            if (!(weak && Walllist.SCD_SCORE.isWeak() || criterion != Walllist.SCD_SCORE)) {
                if (this.getScore() < other.getScore()) {
                    return 1;
                }
                if (this.getScore() <= other.getScore()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SCOREX.isWeak() || criterion != Walllist.SCD_SCOREX)) {
                if (this.getScorex() < other.getScorex()) {
                    return 1;
                }
                if (this.getScorex() <= other.getScorex()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_NUMBEROFWINS.isWeak() || criterion != Walllist.SCD_NUMBEROFWINS)) {
                if (this.getNumberOfWins() < other.getNumberOfWins()) {
                    return 1;
                }
                if (this.getNumberOfWins() <= other.getNumberOfWins()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SOS.isWeak() || criterion != Walllist.SCD_SOS)) {
                if (this.getSos() < other.getSos()) {
                    return 1;
                }
                if (this.getSos() <= other.getSos()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SOSOS.isWeak() || criterion != Walllist.SCD_SOSOS)) {
                if (this.getSosos() < other.getSosos()) {
                    return 1;
                }
                if (this.getSosos() <= other.getSosos()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SODOS.isWeak() || criterion != Walllist.SCD_SODOS)) {
                if (this.getSodos() < other.getSodos()) {
                    return 1;
                }
                if (this.getSodos() <= other.getSodos()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SORP.isWeak() || criterion != Walllist.SCD_SORP)) {
                if (this.getSorp() < other.getSorp()) {
                    return 1;
                }
                if (this.getSorp() <= other.getSorp()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_GO_RANK.isWeak() || criterion != Walllist.SCD_GO_RANK)) {
                int result;
                GoLevel goLevel = this.getGoLevel();
                GoLevel oGoLevel = other.getGoLevel();
                if (goLevel == null && oGoLevel != null) {
                    return 1;
                }
                if (goLevel != null && oGoLevel == null) {
                    return -1;
                }
                if (goLevel == null || oGoLevel == null || (result = goLevel.compareTo(oGoLevel)) == 0) continue;
                return result * -1;
            }
            if (!(weak && Walllist.SCD_RATING.isWeak() || criterion != Walllist.SCD_RATING)) {
                if (this.getRating() < other.getRating()) {
                    return 1;
                }
                if (this.getRating() <= other.getRating()) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_NAME.isWeak() || criterion != Walllist.SCD_NAME)) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                collator.setStrength(1);
                return collator.compare(this.getName(), other.getName());
            }
            if (weak && Walllist.SCD_ID.isWeak() || criterion != Walllist.SCD_ID) continue;
            if (this.getId() < other.getId()) {
                return -1;
            }
            if (this.getId() <= other.getId()) continue;
            return 1;
        }
        return 0;
    }

    public int compareToAfterRound(Participant other, int round) {
        boolean weak = false;
        for (Walllist.SortCriterionDescriptor criterion : this.m_tournament.getWalllist().getSortCriteria()) {
            if (!(weak && Walllist.SCD_SCORE.isWeak() || criterion != Walllist.SCD_SCORE)) {
                if (this.getScoreAfterRound(round) < other.getScoreAfterRound(round)) {
                    return 1;
                }
                if (this.getScoreAfterRound(round) <= other.getScoreAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SCOREX.isWeak() || criterion != Walllist.SCD_SCOREX)) {
                if (this.getScorexAfterRound(round) < other.getScorexAfterRound(round)) {
                    return 1;
                }
                if (this.getScorexAfterRound(round) <= other.getScorexAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_NUMBEROFWINS.isWeak() || criterion != Walllist.SCD_NUMBEROFWINS)) {
                if (this.getNumberOfWinsAfterRound(round) < other.getNumberOfWinsAfterRound(round)) {
                    return 1;
                }
                if (this.getNumberOfWinsAfterRound(round) <= other.getNumberOfWinsAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SOS.isWeak() || criterion != Walllist.SCD_SOS)) {
                if (this.getSosAfterRound(round) < other.getSosAfterRound(round)) {
                    return 1;
                }
                if (this.getSosAfterRound(round) <= other.getSosAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SOSOS.isWeak() || criterion != Walllist.SCD_SOSOS)) {
                if (this.getSososAfterRound(round) < other.getSososAfterRound(round)) {
                    return 1;
                }
                if (this.getSososAfterRound(round) <= other.getSososAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SODOS.isWeak() || criterion != Walllist.SCD_SODOS)) {
                if (this.getSodosAfterRound(round) < other.getSodosAfterRound(round)) {
                    return 1;
                }
                if (this.getSodosAfterRound(round) <= other.getSodosAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_SORP.isWeak() || criterion != Walllist.SCD_SORP)) {
                if (this.getSorpAfterRound(round) < other.getSorpAfterRound(round)) {
                    return 1;
                }
                if (this.getSorpAfterRound(round) <= other.getSorpAfterRound(round)) continue;
                return -1;
            }
            if (!(weak && Walllist.SCD_GO_RANK.isWeak() || criterion != Walllist.SCD_GO_RANK)) {
                int result;
                GoLevel goLevel = this.getGoLevel();
                GoLevel oGoLevel = other.getGoLevel();
                if (goLevel == null && oGoLevel != null) {
                    return 1;
                }
                if (goLevel != null && oGoLevel == null) {
                    return -1;
                }
                if (goLevel == null || oGoLevel == null || (result = goLevel.compareTo(oGoLevel)) == 0) continue;
                return result * -1;
            }
            if (!(weak && Walllist.SCD_RATING.isWeak() || criterion != Walllist.SCD_RATING)) {
                if (this.getRating() < other.getRating()) {
                    return 1;
                }
                if (this.getRating() <= other.getRating()) continue;
                return -1;
            }
            if (weak && Walllist.SCD_NAME.isWeak() || criterion != Walllist.SCD_NAME) continue;
            Collator collator = Collator.getInstance(Locale.getDefault());
            collator.setStrength(1);
            return collator.compare(this.getName(), other.getName());
        }
        return 0;
    }

    public int getAlreadyPlayed(Participant other) {
        int count = 0;
        int i = 0;
        while (i < this.m_pairings.length) {
            if (this.m_pairings[i] != null && !this.m_pairings[i].isPairingWithBye() && this.m_pairings[i].getOpponent(this) == other) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getAlreadyPlayedWithBye() {
        int count = 0;
        int i = 0;
        while (i < this.m_pairings.length) {
            if (this.m_pairings[i] != null && this.m_pairings[i].isPairingWithBye()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public abstract String getClubDisplayString();

    public abstract String getClubDisplayStringWalllist();

    public String getComment() {
        return this.m_comment;
    }

    public abstract GoLevel getGoLevel();

    public int getId() {
        return this.m_id;
    }

    public boolean getJoker() {
        return this.m_joker;
    }

    public abstract String getName();

    public abstract String getNameExportForEGD();

    public int getNumberOfRounds() {
        return this.m_tournament.getNumberOfRounds();
    }

    public int getNumberOfRoundsPlayed() {
        int numberOfRoundsPlayed = 0;
        int i = 0;
        while (i < this.getNumberOfRounds()) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING && this.m_pairings[i].getResult() != Pairing.NO_RESULT) {
                ++numberOfRoundsPlayed;
            }
            ++i;
        }
        return numberOfRoundsPlayed;
    }

    public int getNumberOfTimesBlack() {
        int black = 0;
        int i = 0;
        while (i < this.getNumberOfRounds()) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING && !this.m_pairings[i].isPairingWithBye() && this.m_pairings[i].getBlack() == this && this.m_pairings[i].getHandicap() == 0) {
                ++black;
            }
            ++i;
        }
        return black;
    }

    public int getNumberOfTimesWhite() {
        int white = 0;
        int i = 0;
        while (i < this.getNumberOfRounds()) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING && !this.m_pairings[i].isPairingWithBye() && this.m_pairings[i].getWhite() == this && this.m_pairings[i].getHandicap() == 0) {
                ++white;
            }
            ++i;
        }
        return white;
    }

    public int getNumberOfWins() {
        return this.m_numberOfWins;
    }

    public int getNumberOfWinsAfterRound(int round) {
        int numberOfWins = 0;
        int i = 0;
        while (i < round) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING) {
                numberOfWins = this.m_pairings[i].getBlack() == this ? (numberOfWins += this.m_pairings[i].getNumberOfWinsForBlack()) : (numberOfWins += this.m_pairings[i].getNumberOfWinsForWhite());
            }
            ++i;
        }
        return numberOfWins;
    }

    public String getNumberOfWinsDisplayString() {
        if ((this.m_numberOfWins & 1) == 1) {
            return Integer.toString(this.m_numberOfWins >> 1) + "\u00bd";
        }
        return Integer.toString(this.m_numberOfWins >> 1);
    }

    public String getFreeParticipantDisplayString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getScoreDisplayString(this.getScoreAfterRound(this.m_tournament.getCurrentRoundNumber() - 1)));
        sb.append(" - ");
        sb.append(this.getName());
        if (this.m_tournament.getPairingsShowLevels() && this.getGoLevel() != null) {
            sb.append(" (");
            if (this.m_tournament.getPairingsShortNotationForLevel()) {
                sb.append(this.getGoLevel().getShortDisplayString());
            } else {
                sb.append(this.getGoLevel().getDisplayString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getPairingDisplayString() {
        if (!(this.m_tournament.getPairingsShowScores() || this.getGoLevel() != null && this.m_tournament.getPairingsShowLevels())) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getName());
        sb.append(" (");
        if (this.m_tournament.getPairingsShowLevels()) {
            if (this.m_tournament.getPairingsShortNotationForLevel()) {
                sb.append(this.getGoLevel().getShortDisplayString());
            } else {
                sb.append(this.getGoLevel().getDisplayString());
            }
        }
        if (this.m_tournament.getPairingsShowScores()) {
            if (this.m_tournament.getPairingsShowLevels()) {
                sb.append(", ");
            }
            sb.append(this.getScoreDisplayString(this.getScoreAfterRound(this.m_tournament.getCurrentRoundNumber() - 1)));
        }
        sb.append(")");
        return sb.toString();
    }

    public Pairing getPairingInRound(int round) {
        if (this.getPreliminaryRegistration()) {
            return Pairing.NOT_PLAYING;
        }
        return this.m_pairings[round - 1];
    }

    public int getPlace() {
        return this.m_place;
    }

    public boolean getPreliminaryRegistration() {
        return this.m_preliminaryRegistration;
    }

    public boolean getPreliminaryRegistrationMayBeChanged() {
        int i = 0;
        while (i < this.m_pairings.length) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract int getRating();

    public int getScore() {
        return this.m_score;
    }

    public boolean getScoreAdjustment() {
        return this.m_scoreAdjustment;
    }

    public int getScoreAdjustmentValue() {
        return this.m_scoreAdjustmentValue;
    }

    public int getScoreAfterRound(int round) {
        int score = this.getStartScore();
        boolean halfScoreFromJigo = false;
        int i = 0;
        while (i < round) {
            if (this.m_pairings[i] == null || this.m_pairings[i] == Pairing.NOT_PLAYING) {
                score += 2;
            } else {
                if (this.m_pairings[i].getResult() == Pairing.JIGO) {
                    boolean bl = halfScoreFromJigo = !halfScoreFromJigo;
                }
                score = this.m_pairings[i].getBlack() == this ? (score += this.m_pairings[i].getScoreForBlack()) : (score += this.m_pairings[i].getScoreForWhite());
            }
            ++i;
        }
        if (!(this.m_tournament.getHalfScoreGroupsRoundDownNotJigo() && halfScoreFromJigo || !this.m_tournament.getHalfScoreGroupsRoundDown() || (score & 2) != 2)) {
            score -= 2;
        }
        return score;
    }

    public String getScoreDisplayString() {
        return this.getScoreDisplayString(this.m_score);
    }

    public String getScoreDisplayString(int score) {
        if ((score & 3) == 3) {
            return Integer.toString(score >> 2) + "\u00be";
        }
        if ((score & 3) == 2) {
            return Integer.toString(score >> 2) + "\u00bd";
        }
        if ((score & 3) == 1) {
            return Integer.toString(score >> 2) + "\u00bc";
        }
        return Integer.toString(score >> 2);
    }

    public int getScorex() {
        return this.m_scorex;
    }

    public int getScorexAfterRound(int round) {
        int scorex = this.getStartScore();
        boolean halfScoreFromJigo = false;
        int i = 0;
        while (i < round) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING) {
                if (this.m_pairings[i].getResult() == Pairing.JIGO) {
                    boolean bl = halfScoreFromJigo = !halfScoreFromJigo;
                }
                scorex = this.m_pairings[i].getBlack() == this ? (scorex += this.m_pairings[i].getScoreForBlack()) : (scorex += this.m_pairings[i].getScoreForWhite());
            }
            ++i;
        }
        if (!(this.m_tournament.getHalfScoreGroupsRoundDownNotJigo() && halfScoreFromJigo || !this.m_tournament.getHalfScoreGroupsRoundDown() || (scorex & 2) != 2)) {
            scorex -= 2;
        }
        return scorex;
    }

    public String getScorexDisplayString() {
        if ((this.m_scorex & 3) == 3) {
            return Integer.toString(this.m_scorex >> 2) + "\u00be";
        }
        if ((this.m_scorex & 3) == 2) {
            return Integer.toString(this.m_scorex >> 2) + "\u00bd";
        }
        if ((this.m_scorex & 3) == 1) {
            return Integer.toString(this.m_scorex >> 2) + "\u00bc";
        }
        return Integer.toString(this.m_scorex >> 2);
    }

    public int getSorp() {
        return this.m_sorp;
    }

    public int getSorpAfterRound(int round) {
        int sorp = 0;
        if (!this.getPreliminaryRegistration()) {
            int i = 0;
            while (i < round) {
                if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING && !this.m_pairings[i].isPairingWithBye()) {
                    sorp = this.m_pairings[i].getBlack() == this ? (this.m_pairings[i].getResult() == Pairing.BLACK_WINS ? (sorp += this.m_pairings[i].getResultPoints()) : (this.m_pairings[i].getResult() == Pairing.WHITE_WINS ? (sorp -= this.m_pairings[i].getResultPoints()) : (sorp += this.m_pairings[i].getResultPoints()))) : (this.m_pairings[i].getResult() == Pairing.BLACK_WINS ? (sorp -= this.m_pairings[i].getResultPoints()) : (this.m_pairings[i].getResult() == Pairing.WHITE_WINS ? (sorp += this.m_pairings[i].getResultPoints()) : (sorp -= this.m_pairings[i].getResultPoints())));
                }
                ++i;
            }
        }
        return sorp;
    }

    public String getSorpDisplayString() {
        return Integer.toString(this.m_sorp);
    }

    public int getSos() {
        return this.m_sos;
    }

    public int getSosAfterRound(int round) {
        int sos = 0;
        int i = 0;
        while (i < round) {
            if (this.getPreliminaryRegistration() || this.m_pairings[i] == Pairing.NOT_PLAYING) {
                sos += this.getScoreAfterRound(0);
            } else if (this.m_pairings[i] == null) {
                sos += this.getScoreAfterRound(round);
            } else if (this.m_pairings[i].isPairingWithBye()) {
                if (!this.m_tournament.getByeShouldResultInZeroSOSetc()) {
                    sos += Math.max(this.getScoreAfterRound(round) - 4, 0);
                }
            } else {
                sos += this.m_pairings[i].getOpponent(this).getScoreAfterRound(round);
                if (this.m_pairings[i].getHandicap() > 0 && this.m_tournament.getHandicapIncludeInTieBreakers()) {
                    if (this.m_pairings[i].getBlack() == this) {
                        if ((sos -= this.m_pairings[i].getHandicap() << 2) < 0) {
                            sos = 0;
                        }
                    } else {
                        sos += this.m_pairings[i].getHandicap() << 2;
                    }
                }
            }
            ++i;
        }
        return sos;
    }

    public String getSosDisplayString() {
        if ((this.m_sos & 3) == 3) {
            return (this.m_sos >> 2) + "\u00be";
        }
        if ((this.m_sos & 3) == 2) {
            return (this.m_sos >> 2) + "\u00bd";
        }
        if ((this.m_sos & 3) == 1) {
            return (this.m_sos >> 2) + "\u00bc";
        }
        return "" + (this.m_sos >> 2);
    }

    public int getSodos() {
        return this.m_sodos;
    }

    public int getSodosAfterRound(int round) {
        int sodos = 0;
        int i = 0;
        while (i < round) {
            if (!this.getPreliminaryRegistration() && this.m_pairings[i] != Pairing.NOT_PLAYING && this.m_pairings[i] != null) {
                if (this.m_pairings[i].isPairingWithBye()) {
                    if (!this.m_tournament.getByeShouldResultInZeroSOSetc()) {
                        sodos += Math.max(this.getScoreAfterRound(round) - 4, 0);
                    }
                } else if (this.m_pairings[i].getBlack() == this) {
                    if (this.m_pairings[i].getResult() == Pairing.BLACK_WINS) {
                        sodos += this.m_pairings[i].getWhite().getScoreAfterRound(round);
                        if (this.m_pairings[i].getHandicap() > 0 && this.m_tournament.getHandicapIncludeInTieBreakers() && (sodos -= this.m_pairings[i].getHandicap() << 2) < 0) {
                            sodos = 0;
                        }
                    } else if (this.m_pairings[i].getResult() == Pairing.JIGO) {
                        sodos += this.m_pairings[i].getWhite().getScoreAfterRound(round) >> 1;
                        if (this.m_pairings[i].getHandicap() > 0 && this.m_tournament.getHandicapIncludeInTieBreakers() && (sodos -= this.m_pairings[i].getHandicap() << 1) < 0) {
                            sodos = 0;
                        }
                    }
                } else if (this.m_pairings[i].getResult() == Pairing.WHITE_WINS) {
                    sodos += this.m_pairings[i].getBlack().getScoreAfterRound(round);
                    if (this.m_pairings[i].getHandicap() > 0 && this.m_tournament.getHandicapIncludeInTieBreakers()) {
                        sodos += this.m_pairings[i].getHandicap() << 2;
                    }
                } else if (this.m_pairings[i].getResult() == Pairing.JIGO) {
                    sodos += this.m_pairings[i].getBlack().getScoreAfterRound(round) >> 1;
                    if (this.m_pairings[i].getHandicap() > 0 && this.m_tournament.getHandicapIncludeInTieBreakers()) {
                        sodos += this.m_pairings[i].getHandicap() << 1;
                    }
                }
            }
            ++i;
        }
        return sodos;
    }

    public String getSodosDisplayString() {
        if ((this.m_sodos & 3) == 3) {
            return (this.m_sodos >> 2) + "\u00be";
        }
        if ((this.m_sodos & 3) == 2) {
            return (this.m_sodos >> 2) + "\u00bd";
        }
        if ((this.m_sodos & 3) == 1) {
            return (this.m_sodos >> 2) + "\u00bc";
        }
        return "" + (this.m_sodos >> 2);
    }

    public int getSosos() {
        return this.m_sosos;
    }

    public int getSososAfterRound(int round) {
        int sosos = 0;
        int i = 0;
        while (i < round) {
            if (this.getPreliminaryRegistration() || this.m_pairings[i] == Pairing.NOT_PLAYING) {
                sosos += this.getStartScore() * round;
            } else if (this.m_pairings[i] == null) {
                sosos += this.getSosAfterRound(round);
            } else if (this.m_pairings[i].isPairingWithBye()) {
                if (!this.m_tournament.getByeShouldResultInZeroSOSetc()) {
                    sosos += this.getSosAfterRound(round);
                }
            } else {
                sosos += this.m_pairings[i].getOpponent(this).getSosAfterRound(round);
            }
            ++i;
        }
        return sosos;
    }

    public String getSososDisplayString() {
        if ((this.m_sosos & 3) == 3) {
            return (this.m_sosos >> 2) + "\u00be";
        }
        if ((this.m_sosos & 3) == 2) {
            return (this.m_sosos >> 2) + "\u00bd";
        }
        if ((this.m_sosos & 3) == 1) {
            return (this.m_sosos >> 2) + "\u00bc";
        }
        return "" + (this.m_sosos >> 2);
    }

    public int getStartScore() {
        int score = 0;
        if (this.m_tournament.getRatingAllowed() && this.m_tournament.getRatingDeterminesStartScore()) {
            int rating = this.getRating() - GoLevel.getLowestRating(this.m_tournament.getRatingLowestOneDanRating());
            if (this.m_tournament.getUpperMacMahonBar()) {
                int upperMacMahonBarRating = this.m_tournament.getUpperMacMahonBarRating() - GoLevel.getLowestRating(this.m_tournament.getRatingLowestOneDanRating());
                rating = Math.min(rating, upperMacMahonBarRating);
                int groupsBelowBar = upperMacMahonBarRating / 100 + (upperMacMahonBarRating / 100 * 100 == upperMacMahonBarRating ? 0 : 1);
                if (rating >= upperMacMahonBarRating) {
                    score = groupsBelowBar << 2;
                    if (this.isSuperBarMember()) {
                        score += 4;
                    }
                } else {
                    score = groupsBelowBar - 1 - (upperMacMahonBarRating - 1 - rating) / 100 << 2;
                }
            } else {
                score = (rating + 50) / 100 << 2;
            }
        } else {
            GoLevel goLevel = this.getGoLevel();
            if (goLevel != null) {
                int upperScore;
                score = goLevel.getAbsoluteScore() << 2;
                if (this.m_scoreAdjustment) {
                    score += this.m_scoreAdjustmentValue;
                }
                if (score < 0) {
                    score = 0;
                }
                if (this.m_tournament.getUpperMacMahonBar() && score >= (upperScore = this.m_tournament.getUpperMacMahonBarLevel().getAbsoluteScore() << 2)) {
                    score = upperScore;
                }
                if (this.m_tournament.getLowerMacMahonBar() && (score -= this.m_tournament.getLowerMacMahonBarLevel().getAbsoluteScore() << 2) < 0) {
                    score = 0;
                }
                if (this.isSuperBarMember()) {
                    score += 4;
                }
            }
        }
        return score;
    }

    public boolean isDeletable() {
        int i = 0;
        while (i < this.m_pairings.length) {
            if (this.m_pairings[i] != null && this.m_pairings[i] != Pairing.NOT_PLAYING) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isFreeInCurrentRound() {
        return !this.getPreliminaryRegistration() && this.getPairingInRound(this.m_tournament.getCurrentRoundNumber()) == null;
    }

    public boolean isLowerBarMember() {
        if (!(this.isUpperBarMember() || !this.m_tournament.getLowerMacMahonBar() || this.m_tournament.getRatingAllowed() && this.m_tournament.getRatingDeterminesStartScore())) {
            return this.getStartScore() == 0;
        }
        return false;
    }

    public boolean isPlaceShared() {
        return this.m_placeShared;
    }

    public boolean isSuperBarMember() {
        return this.isUpperBarMember() && this.m_superBarMember;
    }

    public boolean isUpperBarMember() {
        if (this.m_tournament.getUpperMacMahonBar()) {
            if (this.m_tournament.getRatingAllowed() && this.m_tournament.getRatingDeterminesStartScore()) {
                return this.getRating() >= this.m_tournament.getUpperMacMahonBarRating();
            }
            if (this.m_tournament.getLowerMacMahonBar() && this.m_tournament.getUpperMacMahonBarLevel().compareTo(this.m_tournament.getLowerMacMahonBarLevel()) == 0) {
                return true;
            }
            GoLevel goLevel = this.getGoLevel();
            if (goLevel != null) {
                int upperScore;
                int score = goLevel.getAbsoluteScore() << 2;
                if (this.m_scoreAdjustment) {
                    score += this.m_scoreAdjustmentValue;
                }
                if (score < 0) {
                    score = 0;
                }
                if (score >= (upperScore = this.m_tournament.getUpperMacMahonBarLevel().getAbsoluteScore() << 2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getName() != null && !this.getName().isEmpty() && this.getGoLevel() != null;
    }

    public boolean hasPlayedCompleteTournament() {
        Pairing[] pairingArray = this.m_pairings;
        int n = this.m_pairings.length;
        int n2 = 0;
        while (n2 < n) {
            Pairing pairing = pairingArray[n2];
            if (pairing == null || pairing == Pairing.NOT_PLAYING || !pairing.isPairingWithBye() && pairing.getResult() == Pairing.NO_RESULT) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void numberOfRoundsChanged(int numberOfRounds) {
        Pairing[] newpairings = new Pairing[numberOfRounds];
        int i = 0;
        while (i < numberOfRounds) {
            newpairings[i] = this.m_pairings != null && i < this.m_pairings.length ? this.m_pairings[i] : null;
            ++i;
        }
        this.m_pairings = newpairings;
    }

    public void setComment(String comment) {
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        this.m_comment = comment;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    public void setJoker(boolean joker) {
        this.m_joker = joker;
    }

    public void setPairingInRound(Pairing pairing, int round) {
        if (this.m_pairings[round - 1] != pairing) {
            this.m_pairings[round - 1] = pairing;
            this.m_tournament.getWalllist().blockSort();
            this.buildScore();
            this.buildScorex();
            this.buildSos();
            this.buildNumberOfWins();
            this.m_tournament.getWalllist().unblockSort();
        }
    }

    public void setPlace(int place) {
        this.m_place = place;
    }

    public void setPlaceShared(boolean placeShared) {
        this.m_placeShared = placeShared;
    }

    public void setPreliminaryRegistration(boolean preliminaryRegistration) {
        if (this.m_preliminaryRegistration != preliminaryRegistration) {
            if (!this.getPreliminaryRegistrationMayBeChanged()) {
                throw new RuntimeException("preliminaryRegistration may not be changed.");
            }
            this.m_preliminaryRegistration = preliminaryRegistration;
            this.m_tournament.getWalllist().blockSort();
            int i = 1;
            while (i <= this.m_tournament.getNumberOfRounds()) {
                if (this.m_preliminaryRegistration || i <= this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1)) {
                    this.setPairingInRound(Pairing.NOT_PLAYING, i);
                } else {
                    this.setPairingInRound(null, i);
                }
                ++i;
            }
            this.m_tournament.getWalllist().unblockSort();
        }
    }

    public void setScoreAdjustment(boolean scoreAdjustment) {
        if (this.m_scoreAdjustment != scoreAdjustment) {
            this.m_scoreAdjustment = scoreAdjustment;
            this.buildScore();
            this.buildScorex();
        }
    }

    public void setScoreAdjustmentValue(int scoreAdjustmentValue) {
        if (this.m_scoreAdjustmentValue != scoreAdjustmentValue) {
            this.m_scoreAdjustmentValue = scoreAdjustmentValue;
            if (this.m_scoreAdjustmentValue == 0) {
                this.m_scoreAdjustment = false;
            }
            this.buildScore();
            this.buildScorex();
        }
    }

    public void setSuperBarMember(boolean superBarMember) {
        if (this.m_superBarMember != superBarMember) {
            this.m_superBarMember = superBarMember;
            this.buildScore();
            this.buildScorex();
        }
    }

    public void setTournament(Tournament tournament) {
        if (this.m_tournament != null) {
            throw new RuntimeException("tournament cannot be switched");
        }
        this.m_tournament = tournament;
        this.m_pairings = new Pairing[this.m_tournament.getNumberOfRounds()];
        if (this.m_notPlayingInRounds != null) {
            for (Integer round : this.m_notPlayingInRounds) {
                if (round > this.m_pairings.length) continue;
                this.m_pairings[round.intValue() - 1] = Pairing.NOT_PLAYING;
            }
        }
    }

    @Override
    public void xmlRead(Element pe) throws MacMahonException {
        super.xmlRead(pe);
        this.m_id = this.xmlReadIntegerElement(pe, "Id");
        this.m_joker = this.xmlReadBooleanElement(pe, "Joker");
        this.m_preliminaryRegistration = this.xmlReadBooleanElement(pe, "PreliminaryRegistration");
        this.m_scoreAdjustment = this.xmlReadBooleanElement(pe, "ScoreAdjustment");
        this.m_scoreAdjustmentValue = this.xmlReadIntegerElement(pe, "ScoreAdjustmentValue");
        this.m_superBarMember = this.xmlReadBooleanElement(pe, "SuperBarMember");
        this.m_comment = this.xmlReadTextElement(pe, "Comment");
        this.m_notPlayingInRounds = this.xmlReadIntegerElements(pe, "NotPlayingInRound");
    }

    @Override
    protected void xmlWrite(Element pe, Document document) {
        super.xmlWrite(pe, document);
        pe.appendChild(this.xmlCreateIntegerElement(document, "Id", this.m_id));
        pe.appendChild(this.xmlCreateBooleanElement(document, "Joker", this.m_joker));
        pe.appendChild(this.xmlCreateBooleanElement(document, "PreliminaryRegistration", this.m_preliminaryRegistration));
        pe.appendChild(this.xmlCreateBooleanElement(document, "ScoreAdjustment", this.m_scoreAdjustment));
        pe.appendChild(this.xmlCreateIntegerElement(document, "ScoreAdjustmentValue", this.m_scoreAdjustmentValue));
        pe.appendChild(this.xmlCreateBooleanElement(document, "SuperBarMember", this.m_superBarMember));
        if (this.m_comment != null) {
            pe.appendChild(this.xmlCreateCDataElement(document, "Comment", this.m_comment));
        }
        int i = 0;
        while (i < this.m_pairings.length) {
            if (this.m_pairings[i] == Pairing.NOT_PLAYING) {
                pe.appendChild(this.xmlCreateIntegerElement(document, "NotPlayingInRound", i + 1));
            }
            ++i;
        }
    }

    public String toString() {
        return this.getPairingDisplayString();
    }
}

