/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.TournamentRound;
import de.cgerlach.macmahon.model.UnwantedPairing;
import de.cgerlach.macmahon.resources.Messages;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pairing
extends XmlPersistentObject
implements Comparable<Pairing> {
    public static final int XML_VERSION = 2;
    public static final String XML_TAGNAME = "Pairing";
    public static final String BYE = Messages.getString("Pairing.Bye");
    public static final String WALLLIST_BYE = Messages.getString("Pairing.WalllistBye");
    public static final ResultDescriptor NO_RESULT = new ResultDescriptor("?-?", Messages.getString("Pairing.ResultNoResultLongName"), Messages.getString("Pairing.ResultNoResultExplanation"));
    public static final ResultDescriptor BLACK_WINS = new ResultDescriptor("1-0", Messages.getString("Pairing.ResultBlackWinsLongName"), Messages.getString("Pairing.ResultBlackWinsExplanation"));
    public static final ResultDescriptor WHITE_WINS = new ResultDescriptor("0-1", Messages.getString("Pairing.ResultWhiteWinsLongName"), Messages.getString("Pairing.ResultWhiteWinsExplanation"));
    public static final ResultDescriptor JIGO = new ResultDescriptor("\u00bd-\u00bd", Messages.getString("Pairing.ResultJigoLongName"), Messages.getString("Pairing.ResultJigoExplanation"));
    public static final ResultDescriptor BOTH_LOSE = new ResultDescriptor("0-0", Messages.getString("Pairing.ResultBothLoseLongName"), Messages.getString("Pairing.ResultBothLoseExplanation"));
    public static final ResultDescriptor BOTH_WIN = new ResultDescriptor("1-1", Messages.getString("Pairing.ResultBothWinLongName"), Messages.getString("Pairing.ResultBothWinExplanation"));
    public static final ResultDescriptor[] ALL_RESULTS = new ResultDescriptor[]{NO_RESULT, BLACK_WINS, WHITE_WINS, JIGO, BOTH_LOSE, BOTH_WIN};
    public static final Pairing NOT_PLAYING = new Pairing();
    private Tournament m_tournament;
    private TournamentRound m_round;
    private boolean m_forcedPairing;
    private boolean m_pairingWithBye;
    private Participant m_black;
    private int m_blackId;
    private Participant m_white;
    private int m_whiteId;
    private int m_handicap;
    private boolean m_allowJigo;
    private int m_boardNumber = 0;
    private boolean m_boardNumberFixed = false;
    private ResultDescriptor m_result = NO_RESULT;
    private boolean m_resultByReferee = false;
    private int m_resultPoints = 0;
    private String m_comment;
    private Date m_creationTime;

    public static ResultDescriptor getColorsSwappedResult(ResultDescriptor result) {
        if (result == BLACK_WINS) {
            return WHITE_WINS;
        }
        if (result == WHITE_WINS) {
            return BLACK_WINS;
        }
        return result;
    }

    public Pairing() {
    }

    public Pairing(Tournament tournament, TournamentRound round, Participant black, Participant white, int handicap, boolean allowJigo, boolean pairingWithBye, boolean forcedPairing, Date creationTime) {
        this.m_tournament = tournament;
        this.m_round = round;
        this.m_pairingWithBye = pairingWithBye;
        assert (black != null);
        assert (this.m_pairingWithBye && this.m_white == null || !this.m_pairingWithBye && white != null);
        this.m_black = black;
        this.m_white = white;
        if (!this.m_pairingWithBye) {
            this.m_handicap = handicap;
            this.m_allowJigo = allowJigo;
        }
        this.m_forcedPairing = forcedPairing;
        this.m_creationTime = creationTime;
    }

    public void changeResultToNext() {
        assert (!this.isPairingWithBye());
        if (!this.m_resultByReferee) {
            if (this.m_result == NO_RESULT) {
                this.setResult(BLACK_WINS);
            } else if (this.m_result == BLACK_WINS) {
                this.setResult(WHITE_WINS);
            } else if (this.m_result == WHITE_WINS) {
                if (this.m_allowJigo) {
                    this.setResult(JIGO);
                } else {
                    this.setResult(NO_RESULT);
                }
            } else if (this.m_result == JIGO) {
                this.setResult(NO_RESULT);
            }
        }
    }

    public void changeResultToPrevious() {
        assert (!this.isPairingWithBye());
        if (!this.m_resultByReferee) {
            if (this.m_result == NO_RESULT) {
                if (this.m_allowJigo) {
                    this.setResult(JIGO);
                } else {
                    this.setResult(WHITE_WINS);
                }
            } else if (this.m_result == BLACK_WINS) {
                this.setResult(NO_RESULT);
            } else if (this.m_result == WHITE_WINS) {
                this.setResult(BLACK_WINS);
            } else if (this.m_result == JIGO) {
                this.setResult(WHITE_WINS);
            }
        }
    }

    @Override
    public int compareTo(Pairing other) {
        if (!(this.m_boardNumberFixed && this.m_boardNumber != 0 || other.m_boardNumberFixed && other.m_boardNumber != 0)) {
            Participant otherBetterParticipant;
            Participant betterParticipant;
            if (this.isPairingWithBye()) {
                if (this.m_black == null) {
                    return 1;
                }
                betterParticipant = this.m_black;
            } else {
                if (this.m_black == null || this.m_white == null) {
                    return 1;
                }
                Participant participant = betterParticipant = this.m_black.compareToAfterRound(this.m_white, this.m_round.getRoundNumber() - 1) <= 0 ? this.m_black : this.m_white;
            }
            if (other.isPairingWithBye()) {
                if (other.m_black == null) {
                    return -1;
                }
                otherBetterParticipant = other.m_black;
            } else {
                if (other.m_black == null || other.m_white == null) {
                    return -1;
                }
                otherBetterParticipant = other.m_black.compareToAfterRound(other.m_white, this.m_round.getRoundNumber() - 1) <= 0 ? other.m_black : other.m_white;
            }
            return betterParticipant.compareToAfterRound(otherBetterParticipant, this.m_round.getRoundNumber() - 1);
        }
        if (!this.m_boardNumberFixed) {
            return 1;
        }
        if (!other.m_boardNumberFixed) {
            return -1;
        }
        if (this.m_boardNumber < other.m_boardNumber) {
            return -1;
        }
        return 1;
    }

    public void delete() {
        this.m_black.setPairingInRound(null, this.m_round.getRoundNumber());
        if (!this.isPairingWithBye()) {
            this.m_white.setPairingInRound(null, this.m_round.getRoundNumber());
        }
        this.m_round.removePairing(this);
    }

    public boolean getAllowJigo() {
        return this.m_allowJigo;
    }

    public Participant getBlack() {
        return this.m_black;
    }

    public int getBoardNumber() {
        return this.m_boardNumber;
    }

    public String getComment() {
        return this.m_comment;
    }

    public Date getCreationTime() {
        return this.m_creationTime;
    }

    public boolean getForcedPairing() {
        return this.m_forcedPairing;
    }

    public int getHandicap() {
        return this.m_handicap;
    }

    public String getHandicapDisplayString() {
        if (this.isPairingWithBye()) {
            return null;
        }
        if (this.m_tournament.getBoardsize() == 19) {
            if (this.m_handicap == 0) {
                return null;
            }
            if (this.m_handicap == 1) {
                if (this.m_allowJigo) {
                    return "no komi";
                }
                return "\u00bd komi";
            }
            return Integer.toString(this.m_handicap) + " stone" + (this.m_handicap > 1 ? "s" : "") + (this.m_allowJigo ? "" : ", \u00bd komi");
        }
        if (this.m_tournament.getBoardsize() == 13) {
            int stones = Math.round(this.m_handicap / 4);
            int komi = this.m_handicap - stones * 4;
            Object handicap = "";
            if (stones > 0) {
                handicap = (String)handicap + Integer.toString(stones + 1) + " stones";
            }
            if (this.m_allowJigo) {
                if (((String)handicap).length() > 0) {
                    handicap = (String)handicap + ", ";
                }
                switch (komi) {
                    case 0: {
                        handicap = (String)handicap + "8 komi";
                        break;
                    }
                    case 1: {
                        handicap = (String)handicap + "5 komi";
                        break;
                    }
                    case 2: {
                        handicap = (String)handicap + "2 komi";
                        break;
                    }
                    case 3: {
                        handicap = (String)handicap + "1 reverse komi";
                    }
                }
            } else {
                if (((String)handicap).length() > 0) {
                    handicap = (String)handicap + ", ";
                }
                switch (komi) {
                    case 0: {
                        handicap = (String)handicap + "8\u00bd komi";
                        break;
                    }
                    case 1: {
                        handicap = (String)handicap + "5\u00bd komi";
                        break;
                    }
                    case 2: {
                        handicap = (String)handicap + "2\u00bd komi";
                        break;
                    }
                    case 3: {
                        handicap = (String)handicap + "\u00bd reverse komi";
                    }
                }
            }
            return handicap;
        }
        if (this.m_tournament.getBoardsize() == 9) {
            int stones = Math.round(this.m_handicap / 7);
            int komi = this.m_handicap - stones * 7;
            Object handicap = "";
            if (stones > 0) {
                handicap = (String)handicap + Integer.toString(stones + 1) + " stones";
            }
            if (this.m_allowJigo) {
                if (((String)handicap).length() > 0) {
                    handicap = (String)handicap + ", ";
                }
                handicap = 6 - komi == 0 ? (String)handicap + "no komi" : (String)handicap + Integer.toString(6 - komi) + " komi";
            } else {
                if (((String)handicap).length() > 0) {
                    handicap = (String)handicap + ", ";
                }
                handicap = 6 - komi == 0 ? (String)handicap + "\u00bd komi" : (String)handicap + Integer.toString(6 - komi) + "\u00bd komi";
            }
            return handicap;
        }
        return this.m_handicap == 0 ? null : Integer.toString(this.m_handicap);
    }

    public int getNumberOfWinsForBlack() {
        if (this.isPairingWithBye()) {
            return 2;
        }
        if (this.m_result == BLACK_WINS) {
            return 2;
        }
        if (this.m_result == JIGO) {
            return 1;
        }
        if (this.m_result == BOTH_WIN) {
            return 2;
        }
        return 0;
    }

    public int getNumberOfWinsForWhite() {
        assert (!this.isPairingWithBye());
        if (this.m_result == WHITE_WINS) {
            return 2;
        }
        if (this.m_result == JIGO) {
            return 1;
        }
        if (this.m_result == BOTH_WIN) {
            return 2;
        }
        return 0;
    }

    public Participant getOpponent(Participant participant) {
        assert (!this.isPairingWithBye()) : "operation not supported for pairings with a bye";
        return participant == this.m_black ? this.m_white : this.m_black;
    }

    public String getPairingDisplayString() {
        if (this.isPairingWithBye()) {
            return this.m_black.getName() + " - " + BYE;
        }
        return this.m_black.getName() + " - " + this.m_white.getName();
    }

    public String getPairingPrintString() {
        String whiteName;
        Object whiteLevel;
        int playerLength = 30;
        StringBuilder sb = new StringBuilder();
        if (this.m_boardNumber < 10) {
            sb.append("   ");
        } else if (this.m_boardNumber < 100) {
            sb.append("  ");
        } else if (this.m_boardNumber < 1000) {
            sb.append(" ");
        }
        sb.append(this.m_boardNumber);
        sb.append("  ");
        Object blackLevel = this.m_tournament.getPairingsShowLevels() ? " (" + this.m_black.getGoLevel().getShortDisplayString() + ")" : "";
        String blackName = this.m_black.getName();
        if (blackName.length() > playerLength - ((String)blackLevel).length()) {
            blackName = blackName.substring(0, playerLength - ((String)blackLevel).length());
        }
        sb.append(blackName);
        sb.append((String)blackLevel);
        int i = 0;
        while (i < playerLength - (blackName.length() + ((String)blackLevel).length())) {
            sb.append(" ");
            ++i;
        }
        sb.append(" - ");
        if (this.isPairingWithBye()) {
            whiteLevel = "";
            whiteName = BYE;
        } else {
            whiteLevel = this.m_tournament.getPairingsShowLevels() ? " (" + this.m_white.getGoLevel().getShortDisplayString() + ")" : "";
            whiteName = this.m_white.getName();
            if (whiteName.length() > playerLength - ((String)whiteLevel).length()) {
                whiteName = whiteName.substring(0, playerLength - ((String)whiteLevel).length());
            }
        }
        sb.append(whiteName);
        sb.append((String)whiteLevel);
        int i2 = 0;
        while (i2 < playerLength - (whiteName.length() + ((String)whiteLevel).length())) {
            sb.append(" ");
            ++i2;
        }
        sb.append(" ");
        Object resultString = this.getResultDisplayString();
        while (((String)resultString).length() < 7) {
            if (((String)(resultString = (String)resultString + " ")).length() >= 7) continue;
            resultString = " " + (String)resultString;
        }
        sb.append((String)resultString);
        String handicapString = this.getHandicapDisplayString();
        if (handicapString != null) {
            sb.append(" ");
            int i3 = 0;
            while (i3 < 5 - handicapString.length()) {
                sb.append(" ");
                ++i3;
            }
            sb.append(handicapString);
        }
        return sb.toString();
    }

    public ResultDescriptor getResult() {
        if (this.isPairingWithBye()) {
            return BLACK_WINS;
        }
        return this.m_result;
    }

    public boolean getResultByReferee() {
        return this.m_resultByReferee;
    }

    public int getResultPoints() {
        return this.m_resultPoints;
    }

    public String getResultDisplayString() {
        if (this.isPairingWithBye()) {
            return BLACK_WINS.getShortName();
        }
        if (this.getResultByReferee()) {
            return this.m_result.getShortName() + " (!)";
        }
        return this.m_result.getShortName();
    }

    public int getScoreForBlack() {
        if (this.isPairingWithBye()) {
            return 4;
        }
        if (this.m_result == NO_RESULT) {
            return 2;
        }
        if (this.m_result == BLACK_WINS) {
            return 4;
        }
        if (this.m_result == WHITE_WINS) {
            return 0;
        }
        if (this.m_result == JIGO) {
            return 2;
        }
        if (this.m_result == BOTH_LOSE) {
            return 0;
        }
        if (this.m_result == BOTH_WIN) {
            return 4;
        }
        return 0;
    }

    public int getScoreForWhite() {
        assert (!this.isPairingWithBye());
        if (this.m_result == NO_RESULT) {
            return 2;
        }
        if (this.m_result == BLACK_WINS) {
            return 0;
        }
        if (this.m_result == WHITE_WINS) {
            return 4;
        }
        if (this.m_result == JIGO) {
            return 2;
        }
        if (this.m_result == BOTH_LOSE) {
            return 0;
        }
        if (this.m_result == BOTH_WIN) {
            return 4;
        }
        return 0;
    }

    public Tournament getTournament() {
        return this.m_tournament;
    }

    public String getWalllistString(Participant participant, boolean fixedFormat, int fixedLength) {
        if (this == NOT_PLAYING) {
            if (fixedFormat) {
                return Tournament.getCenteredString("-", fixedLength);
            }
            return "-";
        }
        if (this.isPairingWithBye()) {
            if (fixedFormat) {
                return Tournament.getCenteredString(WALLLIST_BYE, fixedLength);
            }
            return WALLLIST_BYE;
        }
        return this.getOpponent(participant).getPlace() + this.getWalllistResult(participant, fixedFormat, this.m_tournament.getWalllist().getMarkResultsByReferree(), this.m_tournament.getWalllist().getShowColors(), this.m_tournament.getWalllist().getShowHandicap());
    }

    public String getWalllistResult(Participant participant, boolean fixedFormat, boolean markResultByReferee, boolean showColors, boolean showHandicap) {
        String handicapValue;
        String colorValue;
        String colorSeparator;
        assert (!this.isPairingWithBye());
        String resultValue = this.m_result == NO_RESULT ? "?" : (this.m_result == BLACK_WINS ? (participant == this.m_black ? "+" : "-") : (this.m_result == WHITE_WINS ? (participant == this.m_black ? "-" : "+") : (this.m_result == JIGO ? "=" : (this.m_result == BOTH_LOSE ? "-" : (this.m_result == BOTH_WIN ? "+" : "(?)")))));
        String resultByRefereeValue = markResultByReferee && this.m_resultByReferee ? "!" : "";
        if (showColors || this.m_handicap > 0 && showHandicap) {
            colorSeparator = "/";
            colorValue = participant == this.m_black ? "b" : "w";
        } else {
            colorSeparator = "";
            colorValue = "";
        }
        if (this.m_handicap > 0 && showHandicap) {
            colorSeparator = "/";
            handicapValue = Integer.toString(this.m_handicap);
        } else {
            handicapValue = "";
        }
        if (fixedFormat) {
            return String.format("%s%s%s%s%-2.2s", resultValue, resultByRefereeValue, colorSeparator, colorValue, handicapValue);
        }
        return resultValue + resultByRefereeValue + colorSeparator + colorValue + handicapValue;
    }

    public Participant getWhite() {
        assert (!this.isPairingWithBye());
        return this.m_white;
    }

    public boolean isBoardNumberFixed() {
        return this.m_boardNumberFixed;
    }

    public boolean isPairingWithBye() {
        return this.m_pairingWithBye;
    }

    public boolean isUnwantedPairing() {
        if (this.isPairingWithBye()) {
            return false;
        }
        UnwantedPairing unwantedPairing = this.getTournament().getUnwantedPairing(this.m_black, this.m_white);
        return unwantedPairing != null && !unwantedPairing.getForbidden();
    }

    public boolean isForbiddenPairing() {
        if (this.isPairingWithBye()) {
            return false;
        }
        UnwantedPairing unwantedPairing = this.getTournament().getUnwantedPairing(this.m_black, this.m_white);
        return unwantedPairing != null && unwantedPairing.getForbidden();
    }

    public void setAllowJigo(boolean allowJigo) {
        this.m_allowJigo = allowJigo;
    }

    public void setBoardNumber(int boardNumber, boolean boardNumberFixed) {
        this.setBoardNumberBySort(boardNumber, boardNumberFixed);
        this.m_round.doSort();
    }

    public void setBoardNumberBySort(int boardNumber, boolean boardNumberFixed) {
        if (this.m_boardNumber != boardNumber) {
            this.m_boardNumber = boardNumber;
            this.m_round.markUpdated();
        }
        this.setBoardNumberFixed(boardNumberFixed);
    }

    public void setBoardNumberFixed(boolean boardNumberFixed) {
        if (this.m_boardNumberFixed != boardNumberFixed) {
            this.m_boardNumberFixed = boardNumberFixed;
        }
    }

    public void setComment(String comment) {
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        this.m_comment = comment;
    }

    public void setForcedPairing(boolean forcedPairing) {
        this.m_forcedPairing = forcedPairing;
    }

    public void setHandicap(int handicap) {
        assert (!this.isPairingWithBye());
        if (handicap < 0) {
            handicap = 0;
        }
        if (this.m_handicap != handicap) {
            this.m_handicap = handicap;
            this.m_black.buildSos();
            this.m_black.buildSodos();
            this.m_white.buildSos();
            this.m_white.buildSodos();
            this.m_round.markUpdated();
        }
    }

    public void setResult(ResultDescriptor result) {
        assert (!this.isPairingWithBye());
        if (this.m_result != result) {
            this.m_result = result;
            if (this.m_result == JIGO) {
                this.m_allowJigo = true;
            }
            if (this.m_result == NO_RESULT) {
                this.setResultByReferee(false);
            }
            if (this.m_result == BOTH_LOSE || this.m_result == BOTH_WIN) {
                this.setResultByReferee(true);
            }
            this.m_tournament.getWalllist().blockSort();
            this.m_black.buildScore();
            this.m_black.buildScorex();
            this.m_black.buildNumberOfWins();
            this.m_white.buildScore();
            this.m_white.buildScorex();
            this.m_white.buildNumberOfWins();
            this.m_tournament.getWalllist().unblockSort();
        }
    }

    public void setResultByReferee(boolean resultByReferee) {
        if (this.m_resultByReferee != resultByReferee) {
            this.m_resultByReferee = resultByReferee;
        }
    }

    public void setResultPoints(int resultPoints) {
        assert (!this.isPairingWithBye());
        if (this.m_resultPoints != resultPoints) {
            this.m_resultPoints = resultPoints;
            this.m_black.buildSorp();
            this.m_white.buildSorp();
        }
    }

    public void setTournament(Tournament tournament, int round) {
        this.m_tournament = tournament;
        this.m_round = this.m_tournament.getRound(round);
        this.m_black = this.m_tournament.getParticipantById(this.m_blackId);
        if (!this.isPairingWithBye()) {
            this.m_white = this.m_tournament.getParticipantById(this.m_whiteId);
        }
        this.m_black.setPairingInRound(this, round);
        if (!this.isPairingWithBye()) {
            this.m_white.setPairingInRound(this, round);
        }
    }

    public void swapColors() {
        assert (!this.isPairingWithBye());
        Participant swapper = this.m_black;
        this.m_black = this.m_white;
        this.m_white = swapper;
        this.m_round.markUpdated();
    }

    public void swapColorsIncludingResult() {
        this.swapColors();
        this.setResult(Pairing.getColorsSwappedResult(this.getResult()));
    }

    @Override
    public void xmlRead(Element pe) throws MacMahonException {
        super.xmlRead(pe);
        this.m_forcedPairing = this.xmlReadBooleanElement(pe, "ForcedPairing");
        this.m_pairingWithBye = this.xmlReadBooleanElement(pe, "PairingWithBye");
        this.m_blackId = this.xmlReadIntegerElement(pe, "Black");
        if (!this.m_pairingWithBye) {
            this.m_whiteId = this.xmlReadIntegerElement(pe, "White");
            this.m_handicap = this.xmlReadIntegerElement(pe, "Handicap");
            this.m_allowJigo = this.xmlReadBooleanElement(pe, "AllowJigo");
            String result = this.xmlReadTextElement(pe, "Result");
            if (result.equals(NO_RESULT.getShortName())) {
                this.m_result = NO_RESULT;
            } else if (result.equals(BLACK_WINS.getShortName())) {
                this.m_result = BLACK_WINS;
            } else if (result.equals(WHITE_WINS.getShortName())) {
                this.m_result = WHITE_WINS;
            } else if (result.equals(JIGO.getShortName())) {
                this.m_result = JIGO;
            } else if (result.equals(BOTH_LOSE.getShortName())) {
                this.m_result = BOTH_LOSE;
            } else if (result.equals(BOTH_WIN.getShortName())) {
                this.m_result = BOTH_WIN;
            }
            this.m_resultByReferee = this.xmlReadBooleanElement(pe, "ResultByReferee");
            this.m_resultPoints = this.xmlReadIntegerElement(pe, "ResultPoints");
        }
        this.m_boardNumber = this.xmlReadIntegerElement(pe, "BoardNumber");
        this.m_boardNumberFixed = this.xmlReadBooleanElement(pe, "BoardNumberFixed");
        this.m_comment = this.xmlReadTextElement(pe, "Comment");
        if (this.xmlVersion() >= 2) {
            this.m_creationTime = this.xmlReadDateElement(pe, "CreationTime");
        }
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 2;
    }

    @Override
    protected void xmlWrite(Element pe, Document document) {
        super.xmlWrite(pe, document);
        pe.appendChild(this.xmlCreateBooleanElement(document, "ForcedPairing", this.m_forcedPairing));
        pe.appendChild(this.xmlCreateBooleanElement(document, "PairingWithBye", this.m_pairingWithBye));
        pe.appendChild(this.xmlCreateIntegerElement(document, "Black", this.m_black.getId()));
        if (!this.m_pairingWithBye) {
            pe.appendChild(this.xmlCreateIntegerElement(document, "White", this.m_white.getId()));
            pe.appendChild(this.xmlCreateIntegerElement(document, "Handicap", this.m_handicap));
            pe.appendChild(this.xmlCreateBooleanElement(document, "AllowJigo", this.m_allowJigo));
            pe.appendChild(this.xmlCreateTextElement(document, "Result", this.m_result.getShortName()));
            pe.appendChild(this.xmlCreateBooleanElement(document, "ResultByReferee", this.m_resultByReferee));
            pe.appendChild(this.xmlCreateIntegerElement(document, "ResultPoints", this.m_resultPoints));
        }
        pe.appendChild(this.xmlCreateIntegerElement(document, "BoardNumber", this.m_boardNumber));
        pe.appendChild(this.xmlCreateBooleanElement(document, "BoardNumberFixed", this.m_boardNumberFixed));
        if (this.m_comment != null) {
            pe.appendChild(this.xmlCreateCDataElement(document, "Comment", this.m_comment));
        }
        if (this.m_creationTime != null) {
            pe.appendChild(this.xmlCreateDateElement(document, "CreationTime", this.m_creationTime));
        }
    }

    public static class ResultDescriptor {
        private String m_shortName;
        private String m_longName;
        private String m_explanation;

        public ResultDescriptor(String shortName, String longName, String explanation) {
            this.m_shortName = shortName;
            this.m_longName = longName;
            this.m_explanation = explanation;
        }

        public String getShortName() {
            return this.m_shortName;
        }

        public String getLongName() {
            return this.m_longName;
        }

        public String getExplanation() {
            return this.m_explanation;
        }

        public String toString() {
            return this.getShortName();
        }
    }
}

