/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.GoPlayer;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IndividualParticipant
extends Participant {
    public static final int XML_VERSION = 1;
    public static final String XML_TAGNAME = "IndividualParticipant";
    private GoPlayer m_goPlayer;
    public List<TurPairing> m_turPairings;

    public IndividualParticipant() {
    }

    public IndividualParticipant(Tournament tournament, GoPlayer goPlayer) {
        super(tournament);
        this.m_goPlayer = goPlayer;
    }

    @Override
    public void buildClubDisplayStringWalllist() {
        this.m_goPlayer.buildClubDisplayStringWalllist();
    }

    @Override
    public String getClubDisplayString() {
        return this.m_goPlayer.getClubDisplayString();
    }

    @Override
    public String getClubDisplayStringWalllist() {
        return this.m_goPlayer.getClubDisplayStringWalllist();
    }

    @Override
    public Country getCountry() {
        return this.m_goPlayer.getCountry();
    }

    @Override
    public Club getClub() {
        return this.m_goPlayer.getClub();
    }

    @Override
    public GoLevel getGoLevel() {
        return this.m_goPlayer == null ? null : this.m_goPlayer.getGoLevel();
    }

    public GoPlayer getGoPlayer() {
        return this.m_goPlayer;
    }

    @Override
    public String getName() {
        return this.m_goPlayer.getName();
    }

    @Override
    public String getNameExportForEGD() {
        return this.m_goPlayer.getNameExportForEGD();
    }

    @Override
    public int getRating() {
        return this.m_goPlayer.getRating();
    }

    public void setGoLevel(GoLevel goLevel) {
        this.m_goPlayer.setGoLevel(goLevel);
        this.buildScore();
        this.buildScorex();
        this.m_tournament.getWalllist().doSort();
    }

    @Override
    public void setTournament(Tournament tournament) {
        super.setTournament(tournament);
        if (this.m_goPlayer != null) {
            this.m_goPlayer.setTournament(this.m_tournament);
        }
    }

    public void turRead(Tournament.ReadTurHelper helper) throws IOException, MacMahonException {
        this.m_goPlayer = new GoPlayer();
        helper.readClassBegin();
        if (!helper.readString().equals("TPlayer")) {
            throw new RuntimeException("illegal classname");
        }
        this.getGoPlayer().setSurname(helper.readString());
        this.getGoPlayer().setFirstName(helper.readString());
        this.getGoPlayer().setNationalityPersistentName(Integer.toString(helper.readInt16()));
        int clubID = helper.readInt16();
        int opponent = 0;
        boolean ignore = false;
        this.m_turPairings = new ArrayList<TurPairing>();
        int j = 0;
        while (j < 18) {
            if (!ignore && (opponent = helper.readInt16()) == -3) {
                ignore = true;
            }
            if (!ignore) {
                TurPairing turPairing = new TurPairing();
                turPairing.m_opponent = opponent;
                turPairing.m_roundFlags = helper.readInt16();
                turPairing.m_handicapStones = helper.readInt16();
                turPairing.m_board = helper.readInt16();
                this.m_turPairings.add(turPairing);
            }
            ++j;
        }
        while (opponent != -3) {
            opponent = helper.readInt16();
            if (opponent == -3) break;
            helper.readInt16();
            helper.readInt16();
            helper.readInt16();
        }
        int flags = helper.readInt16();
        this.setSuperBarMember((flags & 8) == 8);
        this.setPreliminaryRegistration((flags & 0x20) == 32);
        this.setJoker((flags & 0x80) == 128);
        this.getGoPlayer().setAsianName((flags & 0x100) == 256);
        int level = helper.readInt16();
        if (level > 0) {
            this.getGoPlayer().setGoLevel(new GoLevel(level, false, false));
        } else {
            this.getGoPlayer().setGoLevel(new GoLevel(1 + level * -1, true, false));
        }
        int startMacMahonScore = helper.readInt16();
        helper.readClassEnd();
    }

    @Override
    public void xmlRead(Element pe) throws MacMahonException {
        super.xmlRead(pe);
        this.m_goPlayer = (GoPlayer)this.xmlReadSinglePersistentObject(pe, "GoPlayer", GoPlayer.class);
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 1;
    }

    @Override
    protected void xmlWrite(Element ipe, Document document) {
        super.xmlWrite(ipe, document);
        ipe.appendChild(this.m_goPlayer.xmlWrite(document));
    }

    public static class TurPairing {
        public int m_opponent;
        public int m_roundFlags;
        public int m_handicapStones;
        public int m_board;
    }
}

