/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.Person;
import de.cgerlach.macmahon.model.Tournament;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GoPlayer
extends Person {
    public static final int XML_VERSION = 1;
    public static final String XML_TAGNAME = "GoPlayer";
    private Tournament m_tournament;
    private GoLevel m_goLevel;
    private int m_rating = 0;
    private int m_egdPin = 0;
    private Country m_country;
    private String m_countryPersistentName;
    private Club m_club;
    private String m_clubPersistentName;
    private Country m_nationality;
    private String m_nationalityPersistentName;
    private String m_clubDisplayStringWalllist;

    public GoPlayer() {
    }

    public GoPlayer(Tournament tournament) {
        this.m_tournament = tournament;
    }

    public void buildClubDisplayStringWalllist() {
        if (this.m_country == null) {
            this.m_clubDisplayStringWalllist = null;
        } else if (!this.m_tournament.getWalllist().getShowClub() || this.m_club == null) {
            this.m_clubDisplayStringWalllist = this.m_tournament.getWalllist().getShowCountry() ? this.m_country.getInternetCode() : null;
        } else {
            this.m_clubDisplayStringWalllist = this.m_tournament.getWalllist().getShowCountry() ? this.m_country.getInternetCode() : null;
            String club = this.m_tournament.getWalllist().getShowClubEgdName() ? this.m_club.getEgdName() : this.m_club.getName();
            if (this.m_tournament.getWalllist().getShowClubAbbreviateName() && club != null && club.length() > 4) {
                club = club.substring(0, 4);
            }
            if (club != null) {
                this.m_clubDisplayStringWalllist = this.m_clubDisplayStringWalllist == null ? club : String.valueOf(this.m_clubDisplayStringWalllist) + "-" + club;
            }
        }
    }

    public Club getClub() {
        return this.m_club;
    }

    public String getClubDisplayString() {
        if (this.m_country == null) {
            return "";
        }
        StringBuilder clubDisplayBuilder = new StringBuilder(32);
        clubDisplayBuilder.append(this.m_country.getInternetCode());
        if (this.m_club != null) {
            clubDisplayBuilder.append(" - ");
            clubDisplayBuilder.append(this.m_club.getName());
            clubDisplayBuilder.append(" (");
            clubDisplayBuilder.append(this.m_club.getEgdName());
            clubDisplayBuilder.append(")");
        }
        return clubDisplayBuilder.toString();
    }

    public String getClubDisplayStringWalllist() {
        return this.m_clubDisplayStringWalllist;
    }

    public Country getCountry() {
        return this.m_country;
    }

    public int getEgdPin() {
        return this.m_egdPin;
    }

    public String getEgdPinDisplayString() {
        if (this.m_egdPin == 0) {
            return null;
        }
        return Integer.toString(this.m_egdPin);
    }

    public GoLevel getGoLevel() {
        return this.m_goLevel;
    }

    public Country getNationality() {
        return this.m_nationality;
    }

    public String getNationalityPersistentName() {
        return this.m_nationalityPersistentName;
    }

    public int getRating() {
        return this.m_rating;
    }

    public void setClub(Club club) {
        this.m_club = club;
        this.buildClubDisplayStringWalllist();
    }

    public void setClubPersistentName(String clubPersistentName) {
        this.m_clubPersistentName = clubPersistentName;
    }

    public void setCountry(Country country) {
        this.m_country = country;
        this.buildClubDisplayStringWalllist();
    }

    public void setCountryPersistentName(String countryPersistentName) {
        this.m_countryPersistentName = countryPersistentName;
    }

    public void setEgdPin(int egdPin) {
        this.m_egdPin = egdPin;
    }

    public void setGoLevel(GoLevel goLevel) {
        this.m_goLevel = goLevel;
    }

    public void setNationality(Country nationality) {
        this.m_nationality = nationality;
    }

    public void setNationalityPersistentName(String nationalityPersistentName) {
        this.m_nationalityPersistentName = nationalityPersistentName;
    }

    public void setRating(int rating) {
        this.m_rating = rating;
    }

    public void setTournament(Tournament tournament) {
        this.m_tournament = tournament;
        if (this.m_countryPersistentName != null) {
            this.m_country = this.m_tournament.findCountry(this.m_countryPersistentName);
            if (this.m_country != null && this.m_clubPersistentName != null) {
                this.m_club = this.m_country.findClub(this.m_clubPersistentName);
            }
        }
        this.buildClubDisplayStringWalllist();
        if (this.m_nationalityPersistentName != null) {
            this.m_nationality = this.m_tournament.findCountry(this.m_nationalityPersistentName);
        }
    }

    @Override
    public void xmlRead(Element gpe) throws MacMahonException {
        super.xmlRead(gpe);
        this.m_goLevel = new GoLevel(this.xmlReadTextElement(gpe, "GoLevel"));
        this.m_rating = this.xmlReadIntegerElement(gpe, "Rating");
        this.m_egdPin = this.xmlReadIntegerElement(gpe, "EgdPin");
        this.m_countryPersistentName = this.xmlReadTextElement(gpe, "Country");
        if (this.m_countryPersistentName != null) {
            this.m_clubPersistentName = this.xmlReadTextElement(gpe, "Club");
        }
        this.m_nationalityPersistentName = this.xmlReadTextElement(gpe, "Nationality");
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 1;
    }

    @Override
    protected void xmlWrite(Element gpe, Document document) {
        super.xmlWrite(gpe, document);
        gpe.appendChild(this.xmlCreateTextElement(document, "GoLevel", this.m_goLevel.getShortDisplayString()));
        gpe.appendChild(this.xmlCreateIntegerElement(document, "Rating", this.m_rating));
        gpe.appendChild(this.xmlCreateIntegerElement(document, "EgdPin", this.m_egdPin));
        if (this.getCountry() != null) {
            gpe.appendChild(this.xmlCreateTextElement(document, "Country", this.getCountry().getInternetCode()));
            if (this.getClub() != null) {
                gpe.appendChild(this.xmlCreateTextElement(document, "Club", this.getClub().getName()));
            }
        }
        if (this.getNationality() != null) {
            gpe.appendChild(this.xmlCreateTextElement(document, "Nationality", this.getNationality().getInternetCode()));
        }
    }
}

