/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.resources.Messages;

public class GoLevel
implements Comparable<GoLevel> {
    public static final int WEAKEST_KYU = 35;
    public static final int STRONGEST_KYU = 1;
    public static final int WEAKEST_DAN = 1;
    public static final int STRONGEST_DAN = 9;
    public static final int WEAKEST_PRO = 1;
    public static final int STRONGEST_PRO = 10;
    public static final int WEAKEST_ONE_DAN_RATING = 2050;
    public static final String DAN = Messages.getString("GoLevel.Dan");
    public static final String KYU = Messages.getString("GoLevel.Kyu");
    public static final String PRO = Messages.getString("GoLevel.Pro");
    private static final String ALLOWED_RANGE_MESSAGE = Messages.getString("GoLevel.MessageAllowedLevels", Integer.toString(1), Integer.toString(10), Integer.toString(1), Integer.toString(9), Integer.toString(1), Integer.toString(35));
    private int m_rank;
    private boolean m_dan;
    private boolean m_professional;

    public static GoLevel getRandomGoLevel(boolean includeProfessional) {
        int rank;
        int scale = 43 + (includeProfessional ? 10 : 0);
        int level = (int)Math.round(Math.random() * (double)scale) + 1;
        boolean dan = false;
        boolean pro = false;
        if (level <= 35) {
            rank = level;
        } else if ((level -= 35) <= 9) {
            dan = true;
            rank = level;
        } else {
            dan = true;
            pro = true;
            rank = level -= 9;
        }
        GoLevel newGoLevel = null;
        try {
            newGoLevel = new GoLevel(rank, dan, pro);
        }
        catch (MacMahonException exception) {
            System.out.println(">> illegal GoLevel\n" + exception.getClientDisplayMessage());
        }
        return newGoLevel;
    }

    public static int getLowestRating(int weakestOneDanRating) {
        return weakestOneDanRating - 3500;
    }

    public GoLevel(String rankAsString) throws MacMahonException {
        boolean ende = false;
        int i = 0;
        int rank = 0;
        boolean dan = false;
        boolean professional = false;
        boolean number = false;
        boolean numberFinished = false;
        while (!ende && i != rankAsString.length()) {
            if (!Character.isWhitespace(rankAsString.charAt(i))) {
                if (!number && rankAsString.charAt(i) == '-') {
                    dan = true;
                } else if (!numberFinished && Character.isDigit(rankAsString.charAt(i))) {
                    rank = rank * 10 + rankAsString.charAt(i) - 48;
                    number = true;
                } else {
                    if (Character.toUpperCase(rankAsString.charAt(i)) == 'D' || Character.toUpperCase(rankAsString.charAt(i)) == Messages.getString("GoLevel.ParseLevelDan").charAt(0)) {
                        dan = true;
                    } else if (Character.toUpperCase(rankAsString.charAt(i)) == 'P' || Character.toUpperCase(rankAsString.charAt(i)) == Messages.getString("GoLevel.ParseLevelPro").charAt(0)) {
                        professional = true;
                        dan = true;
                        ende = true;
                    }
                    numberFinished = true;
                }
            }
            ++i;
        }
        this.initialize(rank, dan, professional);
    }

    public GoLevel(int rating, int weakestOneDanRating) {
        if (rating >= weakestOneDanRating) {
            this.m_rank = (rating -= weakestOneDanRating) / 100 + 1;
            if (this.m_rank > 9) {
                this.m_rank = 9;
            }
            this.m_dan = true;
            this.m_professional = false;
        } else {
            rating = weakestOneDanRating - 1 - rating;
            this.m_rank = rating / 100 + 1;
            if (this.m_rank > 35) {
                this.m_rank = 35;
            }
            this.m_dan = false;
            this.m_professional = false;
        }
    }

    public GoLevel(int rank, boolean dan, boolean professional) throws MacMahonException {
        this.initialize(rank, dan, professional);
    }

    public int getAbsoluteScore() {
        if (this.m_professional) {
            return 43 + this.m_rank;
        }
        if (this.m_dan) {
            return 34 + this.m_rank;
        }
        return 35 - this.m_rank;
    }

    public String getDisplayString() {
        return this.m_rank + " " + (this.m_dan ? DAN : KYU) + (String)(this.m_professional ? " (" + PRO + ")" : "");
    }

    public int getRank() {
        return this.m_rank;
    }

    public String getShortDisplayString() {
        return this.m_rank + (this.m_professional ? "p" : (this.m_dan ? "d" : "k"));
    }

    public String getWalllistDisplayString() {
        return this.m_rank + (this.m_professional ? " " + PRO : " " + (this.m_dan ? DAN : KYU));
    }

    public boolean equals(Object other) {
        if (other instanceof GoLevel) {
            return this.compareTo((GoLevel)other) == 0;
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getShortDisplayString().hashCode();
    }

    @Override
    public int compareTo(GoLevel other) {
        if (!this.isProfessional() && other.isProfessional()) {
            return -1;
        }
        if (this.isProfessional() && !other.isProfessional()) {
            return 1;
        }
        if (!this.isDan() && other.isDan()) {
            return -1;
        }
        if (this.isDan() && !other.isDan()) {
            return 1;
        }
        if (this.isDan()) {
            if (this.getRank() < other.getRank()) {
                return -1;
            }
            if (this.getRank() > other.getRank()) {
                return 1;
            }
        } else {
            if (this.getRank() > other.getRank()) {
                return -1;
            }
            if (this.getRank() < other.getRank()) {
                return 1;
            }
        }
        return 0;
    }

    public int getScoreDifferenceTo(GoLevel other) {
        int result = this.compareTo(other);
        if (result == 0) {
            return 0;
        }
        if (result > 0) {
            return other.getScoreDifferenceTo(this);
        }
        if (this.isProfessional()) {
            return other.getRank() - this.getRank();
        }
        if (this.isDan()) {
            if (other.isProfessional()) {
                return 9 - this.getRank() + other.getRank();
            }
            return other.getRank() - this.getRank();
        }
        if (other.isProfessional()) {
            return this.getRank() - 1 + 8 + 1 + other.getRank();
        }
        if (other.isDan()) {
            return this.getRank() - 1 + other.getRank();
        }
        return this.getRank() - other.getRank();
    }

    public GoLevel decreaseOneLevel() {
        int rank = this.m_rank;
        boolean dan = this.m_dan;
        boolean professional = this.m_professional;
        if (professional && rank == 1) {
            professional = false;
            dan = true;
            rank = 9;
        } else if (professional) {
            --rank;
        } else if (dan && rank == 1) {
            dan = false;
            rank = 1;
        } else if (dan) {
            --rank;
        } else {
            if (rank == 35) {
                return this;
            }
            ++rank;
        }
        try {
            return new GoLevel(rank, dan, professional);
        }
        catch (MacMahonException e) {
            return null;
        }
    }

    public GoLevel increaseOneLevel() {
        int rank = this.m_rank;
        boolean dan = this.m_dan;
        boolean professional = this.m_professional;
        if (professional && rank == 10) {
            return this;
        }
        if (professional) {
            ++rank;
        } else if (dan && rank == 9) {
            professional = true;
            rank = 1;
        } else if (dan) {
            ++rank;
        } else if (rank == 1) {
            dan = true;
            rank = 1;
        } else {
            --rank;
        }
        try {
            return new GoLevel(rank, dan, professional);
        }
        catch (MacMahonException e) {
            return null;
        }
    }

    private void initialize(int rank, boolean dan, boolean professional) throws MacMahonException {
        if (dan && professional && (rank < 1 || rank > 10)) {
            throw new MacMahonException(Messages.getString("GoLevel.MessageIllegalProfessionalLevel", Integer.toString(rank), ALLOWED_RANGE_MESSAGE));
        }
        if (!dan && professional) {
            throw new MacMahonException(Messages.getString("GoLevel.MessageNoProfessionalKyuLevels", ALLOWED_RANGE_MESSAGE));
        }
        if (dan && !professional && (rank < 1 || rank > 9)) {
            throw new MacMahonException(Messages.getString("GoLevel.MessageIllegalDanLevel", Integer.toString(rank), ALLOWED_RANGE_MESSAGE));
        }
        if (!(dan || professional || rank >= 1 && rank <= 35)) {
            throw new MacMahonException(Messages.getString("GoLevel.MessageIllegalKyuLevel", Integer.toString(rank), ALLOWED_RANGE_MESSAGE));
        }
        this.m_rank = rank;
        this.m_dan = dan;
        this.m_professional = professional;
    }

    public boolean isDan() {
        return this.m_dan;
    }

    public boolean isProfessional() {
        return this.m_professional;
    }

    public String toString() {
        return this.getDisplayString();
    }
}

