/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.resources.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EgdService {
    private static final String EGD_LOOKUP_BY_PIN_URL = "https://www.europeangodatabase.eu/EGD/GetPlayerDataByPIN.php";
    private static final String EGD_LOOKUP_BY_DATA_URL = "https://www.europeangodatabase.eu/EGD/GetPlayerDataByData.php";
    private static EgdService s_instance = new EgdService();

    public static EgdService instance() {
        return s_instance;
    }

    private EgdService() {
    }

    public EgdPlayerRecord getPlayerByPin(int pin) throws MacMahonException {
        String charset = "UTF-8";
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        try {
            String line;
            URI uri = new URI("https://www.europeangodatabase.eu/EGD/GetPlayerDataByPIN.php?pin=" + Integer.toString(pin));
            URL url = uri.toURL();
            URLConnection uc = url.openConnection();
            connection = (HttpURLConnection)uc;
            connection.setReadTimeout(15000);
            connection.setRequestProperty("Accept-Charset", charset);
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.connect();
            try {
                inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                inputStream = connection.getErrorStream();
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder egdReturn = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                egdReturn.append(line);
            }
            JSONObject jsonEGDReturn = new JSONObject(egdReturn.toString());
            if (jsonEGDReturn.getString("retcode").equals("Ok")) {
                EgdPlayerRecord player;
                EgdPlayerRecord egdPlayerRecord = player = new EgdPlayerRecord(jsonEGDReturn);
                return egdPlayerRecord;
            }
        }
        catch (URISyntaxException e) {
            throw new MacMahonException(Messages.getString("EgdService.MessageURISyntaxExceptionPin"), e);
        }
        catch (IOException e) {
            throw new MacMahonException(Messages.getString("EgdService.MessageIOExceptionPin"), e);
        }
        catch (JSONException e) {
            throw new MacMahonException(Messages.getString("EgdService.MessageJSONExceptionPin"), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public List<EgdPlayerRecord> getPlayerByData(String lastName, String name, String country, String club) throws MacMahonException {
        String charset = "UTF-8";
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        try {
            String line;
            Object urlString = "https://www.europeangodatabase.eu/EGD/GetPlayerDataByData.php?";
            urlString = (String)urlString + "lastname=" + URLEncoder.encode(lastName, charset);
            if (name != null && name.length() > 0) {
                urlString = (String)urlString + "&name=" + URLEncoder.encode(name, charset);
            }
            if (country != null && country.length() > 0) {
                urlString = (String)urlString + "&country=" + URLEncoder.encode(country, charset);
            }
            if (club != null && club.length() > 0) {
                urlString = (String)urlString + "&club=" + URLEncoder.encode(club, charset);
            }
            URI uri = new URI((String)urlString);
            URL url = uri.toURL();
            URLConnection uc = url.openConnection();
            connection = (HttpURLConnection)uc;
            connection.setReadTimeout(15000);
            connection.setRequestProperty("Accept-Charset", charset);
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.connect();
            try {
                inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                inputStream = connection.getErrorStream();
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder egdReturn = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                egdReturn.append(line);
            }
            JSONObject jsonEGDReturn = new JSONObject(egdReturn.toString());
            ArrayList<EgdPlayerRecord> players = new ArrayList<EgdPlayerRecord>();
            if (jsonEGDReturn.getString("retcode").equals("Ok")) {
                JSONArray jsonPlayers = jsonEGDReturn.getJSONArray("players");
                int i = 0;
                while (i < jsonPlayers.length()) {
                    EgdPlayerRecord player = new EgdPlayerRecord(jsonPlayers.getJSONObject(i));
                    players.add(player);
                    ++i;
                }
            }
            ArrayList<EgdPlayerRecord> arrayList = players;
            return arrayList;
        }
        catch (IOException e) {
            throw new MacMahonException(Messages.getString("EgdService.MessageIOExceptionData"), e);
        }
        catch (JSONException e) {
            throw new MacMahonException(Messages.getString("EgdService.MessageJSONExceptionData"), e);
        }
        catch (URISyntaxException e) {
            throw new MacMahonException(Messages.getString("EgdService.MessageURISyntaxExceptionData"), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class EgdPlayerRecord {
        public String m_pinPlayer;
        public String m_lastName;
        public String m_name;
        public String m_countryCode;
        public String m_club;
        public String m_grade;
        public String m_gor;
        public String m_totalTournaments;
        public String m_lastAppearence;

        public EgdPlayerRecord(JSONObject jsonPlayer) throws JSONException {
            this.m_pinPlayer = jsonPlayer.getString("Pin_Player");
            this.m_lastName = jsonPlayer.getString("Last_Name");
            this.m_name = jsonPlayer.getString("Name");
            this.m_countryCode = jsonPlayer.getString("Country_Code");
            this.m_club = jsonPlayer.getString("Club");
            this.m_grade = jsonPlayer.getString("Grade");
            this.m_gor = jsonPlayer.getString("Gor");
            this.m_totalTournaments = jsonPlayer.getString("Tot_Tournaments");
            this.m_lastAppearence = jsonPlayer.getString("Last_Appearance");
        }

        public String toString() {
            return "Pin=" + this.m_pinPlayer + ", LastName=" + this.m_lastName + ", Name=" + this.m_name + ", Country=" + this.m_countryCode + ", Club=" + this.m_club + ", Grade=" + this.m_grade + ", Gor=" + this.m_gor + ", Tournaments=" + this.m_totalTournaments + ", LastAppearance=" + this.m_lastAppearence;
        }
    }
}

