/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.model;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.framework.XmlPersistentObject;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.resources.Messages;
import java.text.Collator;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Club
extends XmlPersistentObject
implements Comparable<Club> {
    public static final String[][] DEFAULT_CLUB_DATA = new String[][]{{"de", "Augsburg", "A"}, {"de", "Aschaffenburg", "AB"}, {"de", "Aachen", "AC"}, {"de", "Altenkirchen (Westerwald)", "AK"}, {"de", "Berlin", "B"}, {"de", "B\u00f6blingen", "BB"}, {"de", "Bielefeld", "BI"}, {"de", "Bergheim/Rhein-Erft-Kreis", "BM"}, {"de", "Bonn", "BN"}, {"de", "Bochum", "BO"}, {"de", "Borken", "BOR"}, {"de", "Bottrop", "Bot"}, {"de", "Braunschweig", "BS"}, {"de", "Bayreuth", "BT"}, {"de", "Bautzen", "BZ"}, {"de", "Chemnitz", "C"}, {"de", "Castrop-Rauxel", "CAS"}, {"de", "Cottbus", "CB"}, {"de", "Clausthal-Zellerfeld", "CLZ"}, {"de", "Coburg", "CO"}, {"de", "D\u00fcsseldorf", "D"}, {"de", "Darmstadt", "DA"}, {"de", "Bad Doberan", "DBR"}, {"de", "Dresden", "DD"}, {"de", "Dingolfing-Landau", "DGF"}, {"de", "Diepholz", "DH"}, {"de", "Dinslaken", "DIN"}, {"de", "D\u00f6beln (Landkreis)", "DL"}, {"de", "D\u00fcren", "DN"}, {"de", "Dortmund", "DO"}, {"de", "Donau-Ries", "DON"}, {"de", "Detmold", "DT"}, {"de", "Duisburg", "DU"}, {"de", "Dippoldiswalde/Wei\u00dferitzkreis", "DW"}, {"de", "Essen", "E"}, {"de", "Eisenach", "EA"}, {"de", "Ebersberg", "EBE"}, {"de", "Erding", "ED"}, {"de", "Eisenh\u00fcttenstadt", "EH"}, {"de", "Emden", "EMD"}, {"de", "Erlangen", "ER"}, {"de", "Euskirchen", "EU"}, {"de", "Frankfurt", "F"}, {"de", "Friedberg/Wetteraukreis", "FB"}, {"de", "Fulda", "FD"}, {"de", "Freudenstadt", "FDS"}, {"de", "Frankfurt (Oder)", "FF"}, {"de", "F\u00fcrstenfeldbruck", "FFB"}, {"de", "Flensburg", "FL"}, {"de", "Friedrichshafen/Bodenseekreis", "FN"}, {"de", "Forchheim", "FO"}, {"de", "Freiburg/Breisgau-Hochschwarzwald", "FR"}, {"de", "Schw\u00e4bisch Gm\u00fcnd", "GD"}, {"de", "Gelsenkirchen", "GE"}, {"de", "Gifhorn", "GF"}, {"de", "Gie\u00dfen", "GI"}, {"de", "Bergisch Gladbach/Rheinisch-Bergischer Kreis", "GL"}, {"de", "Gummersbach/Oberbergischer Kreis", "GM"}, {"de", "G\u00f6ttingen", "GOE"}, {"de", "G\u00f6ppingen", "GP"}, {"de", "Greiz", "GRZ"}, {"de", "G\u00fctersloh", "GT"}, {"de", "Hannover", "H"}, {"de", "Hagen (Westfalen)", "HA"}, {"de", "Bremen/Bremerhaven", "HB"}, {"de", "Heidelberg/Rhein-Neckar-Kreis", "HD"}, {"de", "Helmstedt", "HE"}, {"de", "Herford", "HF"}, {"de", "Greifswald", "HGW"}, {"de", "Hamburg", "HH"}, {"de", "Hildesheim", "HI"}, {"de", "L\u00fcbeck", "HL"}, {"de", "Hameln-Pyrmont", "HM"}, {"de", "Heilbronn (Neckar)", "HN"}, {"de", "Heppenheim (Bergstra\u00dfe)", "HP"}, {"de", "Rostock", "HRO"}, {"de", "Meschede/Hochsauerlandkreis", "HSK"}, {"de", "Stralsund", "HST"}, {"de", "Hanau", "HU"}, {"de", "Rathenow/Havelland", "HVL"}, {"de", "H\u00f6xter", "HX"}, {"de", "Ilmenau", "IL"}, {"de", "Itzehoe", "IZ"}, {"de", "Jena", "J"}, {"de", "K\u00f6ln", "K"}, {"de", "Karlsruhe", "KA"}, {"de", "Korbach/Waldeck-Frankenberg", "KB"}, {"de", "Kaufbeuren", "KF"}, {"de", "Bad Kreuznach", "KH"}, {"de", "Kiel", "KI"}, {"de", "Kaiserslautern", "KL"}, {"de", "Kamenz", "KM"}, {"de", "Konstanz", "KN"}, {"de", "Koblenz", "KO"}, {"de", "Krefeld", "KR"}, {"de", "Kassel", "KS"}, {"de", "Leipzig", "L"}, {"de", "Landshut", "LA"}, {"de", "Ludwigsburg", "LB"}, {"de", "Landau", "LD"}, {"de", "Landkreis Dahme-Spreewald", "LDS"}, {"de", "Leer", "LER"}, {"de", "Lemgo", "LE"}, {"de", "Leverkusen", "LEV"}, {"de", "Lippstadt", "LP"}, {"de", "L\u00fcneburg", "LG"}, {"de", "Langerwehe", "LGW"}, {"de", "L\u00f6bau", "LOEB"}, {"de", "Landkreis Oder-Spree", "LOS"}, {"de", "Ludwigshafen (Rhein)", "LU"}, {"de", "M\u00fcnchen", "M"}, {"de", "Mannheim", "MA"}, {"de", "Magdeburg", "MD"}, {"de", "Mettmann", "ME"}, {"de", "Meerbusch", "MEE"}, {"de", "M\u00f6nchengladbach", "MG"}, {"de", "Marburg (Lahn)", "MR"}, {"de", "M\u00fcnster", "MS"}, {"de", "Landkreis Mansfeld-S\u00fcdharz", "MSH"}, {"de", "Mittweida", "MW"}, {"de", "Mainz", "MZ"}, {"de", "N\u00fcrnberg", "N"}, {"de", "Neubrandenburg", "NB"}, {"de", "Nienburg", "NI"}, {"de", "Neunkirchen (Saarland)", "NK"}, {"de", "Nordhausen", "NDH"}, {"de", "N\u00fcrtingen", "NT"}, {"de", "Oberhausen", "OB"}, {"de", "Olpe", "OE"}, {"de", "Offenbach", "OF"}, {"de", "Oldenburg", "OL"}, {"de", "Osnabr\u00fcck", "OS"}, {"de", "Potsdam", "P"}, {"de", "Passau", "PA"}, {"de", "Paderborn", "PB"}, {"de", "Peine", "PE"}, {"de", "Pforzheim", "PF"}, {"de", "Pinneberg", "PI"}, {"de", "Ratingen", "RAT"}, {"de", "Rendsburg-Eckernf\u00f6rde", "RD"}, {"de", "Recklinghausen", "RE"}, {"de", "Roth (Rednitz)", "RH"}, {"de", "Rosenheim", "RO"}, {"de", "Reutlingen", "RT"}, {"de", "Stuttgart", "S"}, {"de", "Saarbr\u00fccken", "SB"}, {"de", "Schleiz", "SCZ"}, {"de", "Schwedt (Oder)", "SDT"}, {"de", "Bad Segeberg", "SE"}, {"de", "Soltau-Fallingbostel", "SFA"}, {"de", "Solingen", "SG"}, {"de", "Schaumburg/Stadthagen", "SHG"}, {"de", "Siegen", "SI"}, {"de", "Schleswig", "SL"}, {"de", "Saalfeld", "SLF"}, {"de", "Saarlouis", "SLS"}, {"de", "Schwerin", "SN"}, {"de", "Spree-Nei\u00dfe", "SPN"}, {"de", "Steinfurt", "ST"}, {"de", "Stade", "STD"}, {"de", "Siegburg", "SU"}, {"de", "Schweinfurt", "SW"}, {"de", "Syke", "SY"}, {"de", "Salzgitter", "SZ"}, {"de", "Teltow-Fl\u00e4ming", "TF"}, {"de", "Torgau", "TG"}, {"de", "Trier", "TR"}, {"de", "Uelzen", "UE"}, {"de", "Ulm", "UL"}, {"de", "Unna", "UN"}, {"de", "Wuppertal", "W"}, {"de", "Wanne-Eickel", "WAN"}, {"de", "Weimar", "WE"}, {"de", "Wolfenb\u00fcttel", "WF"}, {"de", "Wilhelmshaven", "WHV"}, {"de", "Wiesbaden", "WI"}, {"de", "Witten (Ruhr)", "WIT"}, {"de", "Winsen (Luhe)", "WL"}, {"de", "Worms", "WO"}, {"de", "Wolfsburg", "WOB"}, {"de", "Zittau", "ZI"}, {"es", "Agoca", "Agoc"}, {"es", "Alicante", "Ala"}, {"es", "Alicante", "Ali"}, {"es", "AmaGo", "AMaG"}, {"es", "Barcelona", "Bar"}, {"es", "Barcelona", "Barc"}, {"es", "Bilbao", "Bil"}, {"es", "Bilbao", "Bilb"}, {"es", "Cadiz", "Cad"}, {"es", "Cadiz", "Cadi"}, {"es", "Canarias", "CAN"}, {"es", "Cordoba", "Cor"}, {"es", "Cordoba", "Cord"}, {"es", "Granada", "Gra"}, {"es", "Granada", "Gran"}, {"es", "Huelva", "Hue"}, {"es", "Huelva", "Huel"}, {"es", "Madrid", "Mad"}, {"es", "Madrid", "Madr"}, {"es", "Malaga", "Mal"}, {"es", "Malaga", "Mala"}, {"es", "Murcia", "Mur"}, {"es", "NamBan", "Nam"}, {"es", "NamBan", "NamB"}, {"es", "Pedra", "Pedr"}, {"es", "Sevilla", "Sev"}, {"es", "Sevilla", "Sevi"}, {"es", "Tengen", "Ten"}, {"es", "Tengen", "Teng"}, {"es", "UbicuoKiin", "Ubic"}, {"es", "Zaragoza", "Zar"}, {"it", "Alghero", "Algh"}, {"it", "Bari", "Bari"}, {"it", "Belluno", "Bell"}, {"it", "Biella", "Biel"}, {"it", "Bologna", "Bolo"}, {"it", "Brescia", "Bres"}, {"it", "Caserta", "Case"}, {"it", "Como", "Como"}, {"it", "Faenza", "Faen"}, {"it", "Ferrara", "Ferr"}, {"it", "Firenze", "Fire"}, {"it", "Forl\u00ec", "Forl"}, {"it", "Frascati", "Fras"}, {"it", "Gaeta", "Gaet"}, {"it", "Genova", "Geno"}, {"it", "Gorizia", "Gori"}, {"it", "Grosseto", "Gros"}, {"it", "Imola", "Imol"}, {"it", "Imperia", "Impe"}, {"it", "La Spezia", "LaSp"}, {"it", "Livorno", "Livo"}, {"it", "Lodi", "Lodi"}, {"it", "Lucca", "Lucc"}, {"it", "Milano", "Mila"}, {"it", "Modena", "Mode"}, {"it", "Napoli", "Napo"}, {"it", "Novara", "Nova"}, {"it", "Padova", "Pado"}, {"it", "Palermo", "Pale"}, {"it", "Parma", "Parm"}, {"it", "Perugia", "Peru"}, {"it", "Pescara", "Pesc"}, {"it", "Piacenza", "Piac"}, {"it", "Pisa", "Pisa"}, {"it", "Pordenone", "Pord"}, {"it", "Prato", "Prat"}, {"it", "Ravenna", "Rave"}, {"it", "Reggio Emilia", "RegE"}, {"it", "Rimini", "Rimi"}, {"it", "Roma", "Roma"}, {"it", "San Marino", "S.Mi"}, {"it", "Sassari", "Sass"}, {"it", "Savona", "Savo"}, {"it", "Siena", "Sien"}, {"it", "Teramo", "Tera"}, {"it", "Thiene", "Thie"}, {"it", "Torino", "Tori"}, {"it", "Tradate", "Trad"}, {"it", "Trento", "Tren"}, {"it", "Treviso", "Trev"}, {"it", "Trieste", "Trie"}, {"it", "Tuenno", "Tuen"}, {"it", "Udine", "Udin"}, {"it", "Urbino", "Urbi"}, {"it", "Varese", "Vare"}, {"it", "Venezia", "Vene"}, {"it", "Verona", "vero"}, {"it", "Vicenza", "Vice"}, {"it", "Viterbo", "Vite"}};
    public static final int XML_VERSION = 1;
    public static final String XML_TAGNAME = "Club";
    private String m_name;
    private String m_egdName;
    private Country m_country;

    public Club() {
    }

    public Club(Country country, String name, String egdName) {
        assert (country != null);
        this.m_country = country;
        this.m_name = name;
        this.m_egdName = egdName;
    }

    @Override
    public int compareTo(Club o) {
        int result = this.m_country.compareTo(o.m_country);
        if (result != 0) {
            return result;
        }
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(1);
        return collator.compare(this.toString(), o.toString());
    }

    public Country getCountry() {
        return this.m_country;
    }

    public String getEgdName() {
        return this.m_egdName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setCountry(Country country) {
        this.m_country = country;
    }

    public void setEgdName(String egdName) throws MacMahonException {
        if (egdName != null) {
            if ((egdName = egdName.trim()).length() > 4) {
                throw new MacMahonException(Messages.getString("Club.MessageEgdNameMaximumLength", egdName));
            }
            if (egdName.length() == 0) {
                egdName = null;
            }
        }
        this.m_egdName = egdName;
    }

    public void setName(String name) throws MacMahonException {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            throw new MacMahonException(Messages.getString("Club.MessageNoEmptyClubNames"));
        }
        this.m_name = name;
    }

    public String toString() {
        if (this.m_egdName == null) {
            return this.m_name;
        }
        return this.m_name + " (" + this.m_egdName + ")";
    }

    @Override
    public void xmlRead(Element gpe) throws MacMahonException {
        super.xmlRead(gpe);
        this.m_name = this.xmlReadTextElement(gpe, "Name");
        this.m_egdName = this.xmlReadTextElement(gpe, "EGDName");
    }

    @Override
    public String xmlTagName() {
        return XML_TAGNAME;
    }

    @Override
    protected int xmlTypeVersion() {
        return 1;
    }

    @Override
    protected void xmlWrite(Element gpe, Document document) {
        super.xmlWrite(gpe, document);
        gpe.appendChild(this.xmlCreateTextElement(document, "Name", this.m_name));
        if (this.m_egdName != null) {
            gpe.appendChild(this.xmlCreateTextElement(document, "EGDName", this.m_egdName));
        }
    }
}

