/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui.external;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class FontChooserComboBoxItem
extends JPanel {
    private static final long serialVersionUID = 1L;
    public final Font font;
    public final boolean isSeparator;

    public FontChooserComboBoxItem(String fontName, int previewFontSize, String previewString) {
        if (fontName != null) {
            this.font = new Font(fontName, 0, previewFontSize);
            this.isSeparator = false;
        } else {
            this.font = null;
            this.isSeparator = true;
        }
        this.setOpaque(true);
        if (!this.isSeparator) {
            this.setLayout(new FlowLayout(0));
            JLabel labelHelp = new JLabel(this.font.getName());
            this.add(labelHelp);
            if (previewString != null) {
                StringBuilder thisPreview = new StringBuilder();
                int i = 0;
                while (i < previewString.length()) {
                    char c = previewString.charAt(i);
                    if (this.font.canDisplay(c)) {
                        thisPreview.append(c);
                    }
                    ++i;
                }
                JLabel labelFont = new JLabel(thisPreview.toString());
                labelFont.setFont(this.font);
                this.add(labelFont);
            }
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)new JSeparator(0), "Center");
        }
    }

    @Override
    public String toString() {
        if (this.font != null) {
            return this.font.getFamily();
        }
        return "";
    }
}

