/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui.external;

import de.cgerlach.macmahon.gui.external.FontChooserComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FontChooserComboBox
extends JComboBox<FontChooserComboBoxItem>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private int previewFontSize;
    private String previewString = null;
    private int recentFontsCount = 5;
    private List<String> fontNames;
    private HashMap<String, FontChooserComboBoxItem> itemsCache = new HashMap();
    private LinkedList<String> recentFontNames;
    private HashMap<String, FontChooserComboBoxItem> recentItemsCache = new HashMap();

    public FontChooserComboBox() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] fontNames = ge.getAvailableFontFamilyNames();
        Arrays.sort(fontNames);
        this.fontNames = Arrays.asList(fontNames);
        this.recentFontNames = new LinkedList();
        JLabel label = new JLabel();
        this.previewFontSize = label.getFont().getSize();
        this.updateList("Monospaced");
        this.setEditable(true);
        this.setEditor(new FontChooserComboBoxEditor());
        this.setRenderer(new FontChooserComboBoxRenderer());
        this.addItemListener(this);
    }

    public int getPreviewFontSize() {
        return this.previewFontSize;
    }

    public void setPreviewFontSize(int previewFontSize) {
        this.previewFontSize = previewFontSize;
        this.updateList(this.getSelectedFontName());
    }

    public String getPreviewString() {
        return this.previewString;
    }

    public void setPreviewString(String previewString) {
        this.previewString = previewString != null && previewString.length() > 0 ? previewString : null;
        this.updateList(this.getSelectedFontName());
    }

    public int getRecentFontsCount() {
        return this.recentFontsCount;
    }

    public void setRecentFontsCount(int recentFontsCount) {
        this.recentFontsCount = recentFontsCount;
        boolean listChanged = false;
        while (this.recentFontNames.size() > recentFontsCount) {
            this.recentFontNames.removeLast();
            listChanged = true;
        }
        if (listChanged) {
            this.updateList(this.getSelectedFontName());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String fontName = this.getSelectedFontName();
        if (!(fontName == null || this.recentFontsCount <= 0 || this.recentFontNames.size() > 0 && this.recentFontNames.getFirst().equals(fontName))) {
            this.recentFontNames.remove(fontName);
            this.recentFontNames.addFirst(fontName);
            if (this.recentFontNames.size() > this.recentFontsCount) {
                this.recentFontNames.removeLast();
            }
            this.updateList(fontName);
        }
    }

    private void updateList(String selectedFontName) {
        FontChooserComboBoxItem item;
        this.removeAllItems();
        this.itemsCache.clear();
        this.recentItemsCache.clear();
        if (this.recentFontNames.size() > 0) {
            for (String recentFontName : this.recentFontNames) {
                item = new FontChooserComboBoxItem(recentFontName, this.previewFontSize, this.previewString);
                this.addItem(item);
                this.recentItemsCache.put(recentFontName, item);
            }
            this.addItem(new FontChooserComboBoxItem(null, this.previewFontSize, this.previewString));
        }
        for (String fontName : this.fontNames) {
            item = new FontChooserComboBoxItem(fontName, this.previewFontSize, this.previewString);
            this.addItem(item);
            this.itemsCache.put(fontName, item);
        }
        if (selectedFontName != null) {
            this.setSelectedItem(selectedFontName);
        }
    }

    public String getSelectedFontName() {
        if (this.getSelectedItem() != null) {
            return ((FontChooserComboBoxItem)this.getSelectedItem()).font.getFontName();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, new JComboBox<E>().getPreferredSize().height);
    }

    public void setSelectedItem(String fontName) {
        FontChooserComboBoxItem item = this.recentItemsCache.get(fontName);
        if (item == null) {
            item = this.itemsCache.get(fontName);
        }
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    private class FontChooserComboBoxEditor
    extends BasicComboBoxEditor {
        private FontChooserComboBoxEditor() {
            this.editor.setDocument(new AutoCompletionDocument());
            if (FontChooserComboBox.this.fontNames.size() > 0) {
                this.editor.setText(FontChooserComboBox.this.fontNames.get(0).toString());
            }
        }

        private String getMatch(String input) {
            for (String fontName : FontChooserComboBox.this.fontNames) {
                if (!fontName.toLowerCase().startsWith(input.toLowerCase())) continue;
                return fontName;
            }
            return null;
        }

        private class AutoCompletionDocument
        extends PlainDocument {
            private static final long serialVersionUID = 1L;
            private JTextField textField;

            private AutoCompletionDocument() {
                this.textField = FontChooserComboBoxEditor.this.editor;
            }

            @Override
            public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
                super.remove(i, j);
                this.insertString(i, s, attributeset);
            }

            @Override
            public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
                if (s != null && !"".equals(s)) {
                    String s1 = this.getText(0, i);
                    String s2 = FontChooserComboBoxEditor.this.getMatch(s1 + s);
                    int j = i + s.length() - 1;
                    if (s2 == null) {
                        s2 = FontChooserComboBoxEditor.this.getMatch(s1);
                        --j;
                    }
                    if (s2 != null) {
                        FontChooserComboBox.this.setSelectedItem(s2);
                    }
                    super.remove(0, this.getLength());
                    super.insertString(0, s2, attributeset);
                    this.textField.setSelectionStart(j + 1);
                    this.textField.setSelectionEnd(this.getLength());
                }
            }

            @Override
            public void remove(int i, int j) throws BadLocationException {
                int k = this.textField.getSelectionStart();
                if (k > 0) {
                    --k;
                }
                String s = FontChooserComboBoxEditor.this.getMatch(this.getText(0, k));
                super.remove(0, this.getLength());
                super.insertString(0, s, null);
                if (s != null) {
                    FontChooserComboBox.this.setSelectedItem(s);
                }
                try {
                    this.textField.setSelectionStart(k);
                    this.textField.setSelectionEnd(this.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class FontChooserComboBoxRenderer
    implements ListCellRenderer<FontChooserComboBoxItem> {
        private FontChooserComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends FontChooserComboBoxItem> list, FontChooserComboBoxItem item, int index, boolean isSelected, boolean cellHasFocus) {
            boolean s = isSelected && !item.isSeparator;
            item.setBackground(s ? list.getSelectionBackground() : list.getBackground());
            item.setForeground(s ? list.getSelectionForeground() : list.getForeground());
            return item;
        }
    }
}

