/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WalllistTableParticipantPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private MacMahonApplication m_application;
    private Participant m_participant;
    private JCheckBoxMenuItem m_menuItemPreliminaryRegistration;
    private JCheckBoxMenuItem m_menuItemSuperBarMember;

    public WalllistTableParticipantPopupMenu(MacMahonApplication application, Participant participant) {
        this.m_application = application;
        this.m_participant = participant;
        this.add(new JLabel(this.m_participant.getName()));
        this.add(new JPopupMenu.Separator());
        JMenuItem menuItemEditParticipant = new JMenuItem();
        menuItemEditParticipant.setText(Messages.getString("ParticipantPopupMenu.EditParticipant"));
        menuItemEditParticipant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WalllistTableParticipantPopupMenu.this.m_application.editParticipant(WalllistTableParticipantPopupMenu.this.m_participant);
            }
        });
        this.add(menuItemEditParticipant);
        if (this.m_participant.isDeletable()) {
            JMenuItem menuItemDeleteParticipant = new JMenuItem();
            menuItemDeleteParticipant.setText(Messages.getString("ParticipantPopupMenu.DeleteParticipant"));
            menuItemDeleteParticipant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WalllistTableParticipantPopupMenu.this.m_application.participantDelete(WalllistTableParticipantPopupMenu.this.m_participant);
                }
            });
            this.add(menuItemDeleteParticipant);
        }
        if (this.m_participant.getPreliminaryRegistrationMayBeChanged()) {
            this.m_menuItemPreliminaryRegistration = new JCheckBoxMenuItem();
            this.m_menuItemPreliminaryRegistration.setText(Messages.getString("ParticipantPopupMenu.PreliminaryRegistered"));
            this.m_menuItemPreliminaryRegistration.setSelected(this.m_participant.getPreliminaryRegistration());
            this.m_menuItemPreliminaryRegistration.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    WalllistTableParticipantPopupMenu.this.m_participant.setPreliminaryRegistration(WalllistTableParticipantPopupMenu.this.m_menuItemPreliminaryRegistration.isSelected());
                    WalllistTableParticipantPopupMenu.this.m_application.fireWalllistTableDataChanged();
                }
            });
            this.add(this.m_menuItemPreliminaryRegistration);
        }
        if (this.m_participant.isSuperBarMember() || this.m_participant.isUpperBarMember()) {
            this.m_menuItemSuperBarMember = new JCheckBoxMenuItem();
            this.m_menuItemSuperBarMember.setText(Messages.getString("ParticipantPopupMenu.SuperBarMembership"));
            this.m_menuItemSuperBarMember.setSelected(this.m_participant.isSuperBarMember());
            this.m_menuItemSuperBarMember.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    WalllistTableParticipantPopupMenu.this.m_participant.setSuperBarMember(WalllistTableParticipantPopupMenu.this.m_menuItemSuperBarMember.isSelected());
                    WalllistTableParticipantPopupMenu.this.m_application.fireWalllistTableDataChanged();
                }
            });
            this.add(this.m_menuItemSuperBarMember);
        }
    }

    public Participant getParticipant() {
        return this.m_participant;
    }
}

