/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.Walllist;
import javax.swing.table.AbstractTableModel;

public class WalllistTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Tournament m_tournament;
    private Walllist m_walllist;
    private int m_columnCount = -1;
    protected Walllist.SortCriterionDescriptor[] m_sortCriteriaMapping = new Walllist.SortCriterionDescriptor[5];
    private int m_clubColumnIndex = -2;
    private int m_levelColumnIndex = -2;
    private int m_ratingColumnIndex = -2;
    private int m_barMembershipColumnIndex = -2;
    private int m_scoreColumnIndex = -1;
    private int m_firstRoundColumnIndex = -1;
    private int m_lastRoundColumnIndex = -1;
    private int m_numberOfWinsColumnIndex = -1;
    private int m_firstSortCriteriaColumnIndex = -2;
    private int m_lastSortCriteriaColumnIndex = -2;

    public WalllistTableModel(Tournament tournament) {
        this.m_tournament = tournament;
        this.m_walllist = this.m_tournament.getWalllist();
    }

    public int getPlaceColumnIndex() {
        return 0;
    }

    public int getNameColumnIndex() {
        return 1;
    }

    public int getClubColumnIndex() {
        if (this.m_clubColumnIndex == -2) {
            this.m_clubColumnIndex = this.m_tournament.getWalllist().getShowCountry() || this.m_tournament.getWalllist().getShowClub() ? this.getNameColumnIndex() + 1 : -1;
        }
        return this.m_clubColumnIndex;
    }

    public int getLevelColumnIndex() {
        if (this.m_levelColumnIndex == -2) {
            this.m_levelColumnIndex = this.m_tournament.getWalllist().getShowLevels() ? (this.getClubColumnIndex() == -1 ? this.getNameColumnIndex() : this.getClubColumnIndex()) + 1 : -1;
        }
        return this.m_levelColumnIndex;
    }

    public int getRatingColumnIndex() {
        if (this.m_ratingColumnIndex == -2) {
            this.m_ratingColumnIndex = this.m_tournament.getRatingAllowed() && this.m_walllist.getShowRatings() ? (this.getLevelColumnIndex() == -1 ? (this.getClubColumnIndex() == -1 ? this.getNameColumnIndex() + 1 : this.getClubColumnIndex() + 1) : this.getLevelColumnIndex() + 1) : -1;
        }
        return this.m_ratingColumnIndex;
    }

    public int getBarMembershipColumnIndex() {
        if (this.m_barMembershipColumnIndex == -2) {
            this.m_barMembershipColumnIndex = this.m_walllist.getShowBarMembershipVisible() ? (this.getRatingColumnIndex() == -1 ? (this.getLevelColumnIndex() == -1 ? (this.getClubColumnIndex() == -1 ? this.getNameColumnIndex() + 1 : this.getClubColumnIndex() + 1) : this.getLevelColumnIndex() + 1) : this.getRatingColumnIndex() + 1) : -1;
        }
        return this.m_barMembershipColumnIndex;
    }

    public int getScoreColumnIndex() {
        if (this.m_scoreColumnIndex == -1) {
            this.m_scoreColumnIndex = this.getBarMembershipColumnIndex() == -1 ? (this.getRatingColumnIndex() == -1 ? (this.getLevelColumnIndex() == -1 ? (this.getClubColumnIndex() == -1 ? this.getNameColumnIndex() + 1 : this.getClubColumnIndex() + 1) : this.getLevelColumnIndex() + 1) : this.getRatingColumnIndex() + 1) : this.getBarMembershipColumnIndex() + 1;
        }
        return this.m_scoreColumnIndex;
    }

    public int getFirstRoundColumnIndex() {
        if (this.m_firstRoundColumnIndex == -1) {
            this.m_firstRoundColumnIndex = this.getScoreColumnIndex() + 1;
        }
        return this.m_firstRoundColumnIndex;
    }

    public int getLastRoundColumnIndex() {
        if (this.m_lastRoundColumnIndex == -1) {
            this.m_lastRoundColumnIndex = this.getFirstRoundColumnIndex() + (this.m_tournament.getCurrentRoundNumber() - 1);
        }
        return this.m_lastRoundColumnIndex;
    }

    public int getNumberOfWinsColumnIndex() {
        if (this.m_numberOfWinsColumnIndex == -1) {
            this.m_numberOfWinsColumnIndex = this.getLastRoundColumnIndex() + 1;
        }
        return this.m_numberOfWinsColumnIndex;
    }

    public int getFirstSortCriteriaColumnIndex() {
        if (this.m_firstSortCriteriaColumnIndex == -2) {
            int columnCount = 0;
            for (Walllist.SortCriterionDescriptor sortCriterion : this.m_tournament.getWalllist().getSortCriteria()) {
                if (sortCriterion == Walllist.SCD_SCORE || sortCriterion == Walllist.SCD_NUMBEROFWINS || sortCriterion == Walllist.SCD_GO_RANK || sortCriterion == Walllist.SCD_RATING || sortCriterion == Walllist.SCD_NAME || sortCriterion == Walllist.SCD_ID) continue;
                this.m_sortCriteriaMapping[columnCount] = sortCriterion;
                ++columnCount;
            }
            if (columnCount == 0) {
                this.m_firstSortCriteriaColumnIndex = -1;
                this.m_lastSortCriteriaColumnIndex = -1;
            } else {
                this.m_firstSortCriteriaColumnIndex = this.getNumberOfWinsColumnIndex() + 1;
                this.m_lastSortCriteriaColumnIndex = this.m_firstSortCriteriaColumnIndex + (columnCount - 1);
            }
        }
        return this.m_firstSortCriteriaColumnIndex;
    }

    public int getLastSortCriteriaColumnIndex() {
        if (this.m_lastSortCriteriaColumnIndex == -2) {
            this.getFirstSortCriteriaColumnIndex();
        }
        return this.m_lastSortCriteriaColumnIndex;
    }

    @Override
    public void fireTableStructureChanged() {
        this.m_columnCount = -1;
        this.m_clubColumnIndex = -2;
        this.m_levelColumnIndex = -2;
        this.m_ratingColumnIndex = -2;
        this.m_barMembershipColumnIndex = -2;
        this.m_scoreColumnIndex = -1;
        this.m_firstRoundColumnIndex = -1;
        this.m_lastRoundColumnIndex = -1;
        this.m_numberOfWinsColumnIndex = -1;
        this.m_firstSortCriteriaColumnIndex = -2;
        this.m_lastSortCriteriaColumnIndex = -2;
        super.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.m_walllist.getParticipantCount();
    }

    @Override
    public int getColumnCount() {
        if (this.m_columnCount == -1) {
            this.m_columnCount = Math.max(this.getNumberOfWinsColumnIndex() + 1, this.getLastSortCriteriaColumnIndex() + 1);
        }
        return this.m_columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == this.getPlaceColumnIndex()) {
            return Walllist.COLUMNNAME_PLACE;
        }
        if (columnIndex == this.getNameColumnIndex()) {
            return Walllist.COLUMNNAME_NAME;
        }
        if (columnIndex == this.getClubColumnIndex()) {
            return Walllist.COLUMNNAME_CLUB;
        }
        if (columnIndex == this.getLevelColumnIndex()) {
            return Walllist.COLUMNNAME_LEVEL;
        }
        if (columnIndex == this.getRatingColumnIndex()) {
            return Walllist.COLUMNNAME_RATING;
        }
        if (columnIndex == this.getBarMembershipColumnIndex()) {
            return " ";
        }
        if (columnIndex == this.getScoreColumnIndex()) {
            return Walllist.SCD_SCORE.getLongName();
        }
        if (columnIndex >= this.getFirstRoundColumnIndex() && columnIndex <= this.getLastRoundColumnIndex()) {
            return Integer.toString(columnIndex - this.getFirstRoundColumnIndex() + 1);
        }
        if (columnIndex == this.getNumberOfWinsColumnIndex()) {
            return Walllist.SCD_NUMBEROFWINS.getLongName();
        }
        if (columnIndex >= this.getFirstSortCriteriaColumnIndex() && columnIndex <= this.getLastSortCriteriaColumnIndex()) {
            return this.m_sortCriteriaMapping[columnIndex - this.getFirstSortCriteriaColumnIndex()].getLongName();
        }
        return null;
    }

    public Tournament getTournament() {
        return this.m_tournament;
    }

    public Participant getParticipantAtRow(int rowIndex) {
        return this.m_walllist.getParticipantAt(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Participant participant = this.m_walllist.getParticipantAt(rowIndex);
        if (columnIndex == this.getPlaceColumnIndex()) {
            if (participant.isPlaceShared()) {
                return "(" + participant.getPlace() + ")";
            }
            return participant.getPlace();
        }
        if (columnIndex == this.getNameColumnIndex()) {
            return participant.getName();
        }
        if (columnIndex == this.getClubColumnIndex()) {
            return participant.getClubDisplayStringWalllist();
        }
        if (columnIndex == this.getLevelColumnIndex()) {
            GoLevel goLevel = participant.getGoLevel();
            if (goLevel != null) {
                if (this.m_walllist.getShortNotationForLevel()) {
                    return goLevel.getShortDisplayString();
                }
                return goLevel.getWalllistDisplayString();
            }
            return null;
        }
        if (columnIndex == this.getRatingColumnIndex()) {
            return Integer.toString(participant.getRating());
        }
        if (columnIndex == this.getBarMembershipColumnIndex()) {
            return " ";
        }
        if (columnIndex == this.getScoreColumnIndex()) {
            return participant.getScoreDisplayString();
        }
        if (columnIndex >= this.getFirstRoundColumnIndex() && columnIndex <= this.getLastRoundColumnIndex()) {
            Pairing pairing = participant.getPairingInRound(columnIndex - this.getFirstRoundColumnIndex() + 1);
            if (pairing == null) {
                return "?";
            }
            return pairing.getWalllistString(participant, false, 0);
        }
        if (columnIndex == this.getNumberOfWinsColumnIndex()) {
            return participant.getNumberOfWinsDisplayString();
        }
        if (columnIndex >= this.getFirstSortCriteriaColumnIndex() && columnIndex <= this.getLastSortCriteriaColumnIndex()) {
            int sortCriteriaIndex = columnIndex - this.getFirstSortCriteriaColumnIndex();
            if (this.m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SCOREX) {
                return participant.getScorexDisplayString();
            }
            if (this.m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SOS) {
                return participant.getSosDisplayString();
            }
            if (this.m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SOSOS) {
                return participant.getSososDisplayString();
            }
            if (this.m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SODOS) {
                return participant.getSodosDisplayString();
            }
            if (this.m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SORP) {
                return participant.getSorpDisplayString();
            }
            if (this.m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_ID) {
                return Integer.toString(participant.getId());
            }
        }
        return null;
    }
}

