/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.gui.WalllistTableModel;
import de.cgerlach.macmahon.gui.WalllistTablePairingPopupMenu;
import de.cgerlach.macmahon.gui.WalllistTableParticipantPopupMenu;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Walllist;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WalllistTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Color SUPER_BAR_MEMBER_BACKGROUNDCOLOR = Color.RED;
    private static final Color UPPER_BAR_MEMBER_BACKGROUNDCOLOR = Color.ORANGE;
    private static final Color LOWER_BAR_MEMBER_BACKGROUNDCOLOR = Color.BLUE;
    private static final Color PRELIMINARY_PARTICIPANT_BACKGROUNDCOLOR = new Color(210, 210, 210);
    private static final Color PARTICIPANT_NOT_VALID_BACKGROUNDCOLOR = Color.RED;
    public static final Color SHARED_PLACE_COLOR = new Color(128, 128, 128);
    private static final TableCellRenderer WALLLIST_COLUMN_HEADER_RENDERER = new WalllistColumnHeaderRenderer();
    private static final TableCellRenderer WALLLIST_CELL_RENDERER = new WalllistCellRenderer();
    private MacMahonApplication m_application;
    private Participant m_participantSelectedForcedPairing;
    private Font m_font;
    private boolean m_fontsizeChanged = false;
    private double m_widthPerCharacter;

    public WalllistTable(MacMahonApplication application, int fontsize) {
        this.m_application = application;
        this.setFontsize(fontsize);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    WalllistTable.this.doPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    WalllistTable.this.doPopup(evt);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = WalllistTable.this.rowAtPoint(e.getPoint());
                    int column = WalllistTable.this.columnAtPoint(e.getPoint());
                    if (row >= 0 && column >= 0) {
                        Participant participant;
                        Pairing pairing;
                        if (column == ((WalllistTableModel)WalllistTable.this.getModel()).getPlaceColumnIndex() || column == ((WalllistTableModel)WalllistTable.this.getModel()).getNameColumnIndex() || column == ((WalllistTableModel)WalllistTable.this.getModel()).getLevelColumnIndex()) {
                            WalllistTable.this.m_application.editParticipant(WalllistTable.this.m_application.getTournament().getWalllist().getParticipantAt(row));
                        }
                        if (column >= ((WalllistTableModel)WalllistTable.this.getModel()).getFirstRoundColumnIndex() && column <= ((WalllistTableModel)WalllistTable.this.getModel()).getLastRoundColumnIndex() && (pairing = (participant = WalllistTable.this.m_application.getTournament().getWalllist().getParticipantAt(row)).getPairingInRound(column - ((WalllistTableModel)WalllistTable.this.getModel()).getFirstRoundColumnIndex() + 1)) != null && pairing != Pairing.NOT_PLAYING) {
                            WalllistTable.this.m_application.pairingEdit(pairing);
                        }
                    }
                }
            }
        });
    }

    public void cancelForcedPairing() {
        this.m_participantSelectedForcedPairing = null;
    }

    @Override
    public void createDefaultColumnsFromModel() {
        this.cancelForcedPairing();
        if (this.getModel() instanceof WalllistTableModel) {
            WalllistTableModel m = (WalllistTableModel)this.getModel();
            if (m != null) {
                TableColumnModel cm = this.getColumnModel();
                while (cm.getColumnCount() > 0) {
                    cm.removeColumn(cm.getColumn(0));
                }
                int i = 0;
                while (i < m.getColumnCount()) {
                    TableColumn newColumn = this.createTableColumn(i);
                    this.addColumn(newColumn);
                    ++i;
                }
            }
        } else {
            super.createDefaultColumnModel();
        }
    }

    public TableColumn createTableColumn(int columnIndex) {
        TableColumn column = new TableColumn(columnIndex);
        int chars = 0;
        if (columnIndex == ((WalllistTableModel)this.getModel()).getPlaceColumnIndex()) {
            chars = 5;
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getNameColumnIndex()) {
            if (this.m_application.getTournament().getWalllist().getNameColumnWidth() == 0) {
                this.m_application.getTournament().getWalllist().setNameColumnWidth((int)Math.round(25.0 * this.m_widthPerCharacter + 2.0));
            }
            column.setPreferredWidth(this.m_application.getTournament().getWalllist().getNameColumnWidth());
            column.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("width")) {
                        WalllistTable.this.m_application.getTournament().getWalllist().setNameColumnWidth((Integer)evt.getNewValue());
                    }
                }
            });
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getClubColumnIndex()) {
            chars = 0;
            if (this.m_application.getTournament().getWalllist().getShowCountry()) {
                chars += 3;
            }
            if (this.m_application.getTournament().getWalllist().getShowClub()) {
                if (this.m_application.getTournament().getWalllist().getShowClubEgdName() || this.m_application.getTournament().getWalllist().getShowClubAbbreviateName()) {
                    chars += 4;
                } else {
                    if (this.m_application.getTournament().getWalllist().getClubColumnWidth() == 0) {
                        this.m_application.getTournament().getWalllist().setClubColumnWidth((int)Math.round(15.0 * this.m_widthPerCharacter + 2.0));
                    }
                    chars = 0;
                    column.setPreferredWidth(this.m_application.getTournament().getWalllist().getClubColumnWidth());
                    column.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName().equals("width")) {
                                WalllistTable.this.m_application.getTournament().getWalllist().setClubColumnWidth((Integer)evt.getNewValue());
                            }
                        }
                    });
                }
            }
            if (chars > 0 && chars < 4) {
                chars = 4;
            }
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getLevelColumnIndex()) {
            chars = 5;
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getRatingColumnIndex()) {
            chars = 6;
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getBarMembershipColumnIndex()) {
            column.setMinWidth(7);
            column.setMaxWidth(7);
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getScoreColumnIndex()) {
            chars = Locale.getDefault().getLanguage() == "ko" ? 8 : 5;
        }
        if (columnIndex >= ((WalllistTableModel)this.getModel()).getFirstRoundColumnIndex() && columnIndex <= ((WalllistTableModel)this.getModel()).getLastRoundColumnIndex()) {
            chars = 5;
            if (((WalllistTableModel)this.getModel()).getTournament().getWalllist().getShowColors() || ((WalllistTableModel)this.getModel()).getTournament().getWalllist().getShowHandicap()) {
                chars += 2;
                if (((WalllistTableModel)this.getModel()).getTournament().getWalllist().getShowHandicap()) {
                    ++chars;
                }
            }
        }
        if (columnIndex == ((WalllistTableModel)this.getModel()).getNumberOfWinsColumnIndex()) {
            chars = 6;
        }
        if (columnIndex >= ((WalllistTableModel)this.getModel()).getFirstSortCriteriaColumnIndex() && columnIndex <= ((WalllistTableModel)this.getModel()).getLastSortCriteriaColumnIndex()) {
            int sortCriteriaIndex = columnIndex - ((WalllistTableModel)this.getModel()).getFirstSortCriteriaColumnIndex();
            if (((WalllistTableModel)this.getModel()).m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SCOREX) {
                chars = Locale.getDefault().getLanguage() == "ko" ? 8 : 6;
            } else if (((WalllistTableModel)this.getModel()).m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SOS) {
                chars = 6;
            } else if (((WalllistTableModel)this.getModel()).m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SOSOS) {
                chars = 7;
            } else if (((WalllistTableModel)this.getModel()).m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SODOS) {
                chars = 6;
            } else if (((WalllistTableModel)this.getModel()).m_sortCriteriaMapping[sortCriteriaIndex] == Walllist.SCD_SORP) {
                chars = 5;
            }
        }
        if (chars > 0) {
            column.setMinWidth((int)Math.round((double)chars * this.m_widthPerCharacter + 6.0));
            column.setMaxWidth((int)Math.round((double)chars * this.m_widthPerCharacter + 6.0));
        }
        column.setHeaderRenderer(WALLLIST_COLUMN_HEADER_RENDERER);
        return column;
    }

    public void doPopup(MouseEvent evt) {
        int rowIndex = this.rowAtPoint(evt.getPoint());
        int columnIndex = this.columnAtPoint(evt.getPoint());
        if (rowIndex >= 0 && columnIndex >= 0) {
            if (columnIndex == ((WalllistTableModel)this.getModel()).getPlaceColumnIndex() || columnIndex == ((WalllistTableModel)this.getModel()).getPlaceColumnIndex() || columnIndex == ((WalllistTableModel)this.getModel()).getNameColumnIndex() || columnIndex == ((WalllistTableModel)this.getModel()).getClubColumnIndex() || columnIndex == ((WalllistTableModel)this.getModel()).getLevelColumnIndex() || columnIndex == ((WalllistTableModel)this.getModel()).getBarMembershipColumnIndex()) {
                final Participant participant = ((WalllistTableModel)this.getModel()).getParticipantAtRow(rowIndex);
                final WalllistTableParticipantPopupMenu popupMenu = new WalllistTableParticipantPopupMenu(this.m_application, participant);
                if (!participant.getPreliminaryRegistration() && participant.getPairingInRound(this.m_application.getTournament().getCurrentRoundNumber()) == null) {
                    JMenuItem menuItemSelectForcedPairing = new JMenuItem();
                    menuItemSelectForcedPairing.setText(Messages.getString("WalllistTable.PopupMenuSelectForForcedPairing"));
                    menuItemSelectForcedPairing.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WalllistTable.this.m_participantSelectedForcedPairing = popupMenu.getParticipant();
                        }
                    });
                    popupMenu.add(menuItemSelectForcedPairing);
                    JMenuItem menuItemForcedPairingWithBye = new JMenuItem();
                    menuItemForcedPairingWithBye.setText(Messages.getString("WalllistTable.PopupMenuCreateForcedPairingWithBye"));
                    menuItemForcedPairingWithBye.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WalllistTable.this.m_application.createForcedPairingWithBye(participant);
                            WalllistTable.this.m_participantSelectedForcedPairing = null;
                        }
                    });
                    popupMenu.add(menuItemForcedPairingWithBye);
                }
                if (this.m_participantSelectedForcedPairing != null && this.m_participantSelectedForcedPairing != participant && !participant.getPreliminaryRegistration() && participant.getPairingInRound(this.m_application.getTournament().getCurrentRoundNumber()) == null) {
                    JMenuItem menuItemCompleteForcedPairing = new JMenuItem();
                    menuItemCompleteForcedPairing.setText(Messages.getString("WalllistTable.PopupMenuCreateForcedPairingWithPlayer", this.m_participantSelectedForcedPairing.getName()));
                    menuItemCompleteForcedPairing.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WalllistTable.this.m_application.createForcedPairing(WalllistTable.this.m_participantSelectedForcedPairing, participant);
                            WalllistTable.this.m_participantSelectedForcedPairing = null;
                        }
                    });
                    popupMenu.add(menuItemCompleteForcedPairing);
                    JMenuItem menuItemCancelForcedPairing = new JMenuItem();
                    menuItemCancelForcedPairing.setText(Messages.getString("WalllistTable.PopupMenuCancelForcedPairing"));
                    menuItemCancelForcedPairing.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WalllistTable.this.cancelForcedPairing();
                        }
                    });
                    popupMenu.add(menuItemCancelForcedPairing);
                }
                popupMenu.show((Component)evt.getSource(), evt.getPoint().x, evt.getPoint().y);
            } else if (columnIndex >= ((WalllistTableModel)this.getModel()).getFirstRoundColumnIndex() && columnIndex <= ((WalllistTableModel)this.getModel()).getLastRoundColumnIndex()) {
                int round;
                Participant participant = ((WalllistTableModel)this.getModel()).getParticipantAtRow(rowIndex);
                Pairing pairing = participant.getPairingInRound(round = columnIndex - ((WalllistTableModel)this.getModel()).getFirstRoundColumnIndex() + 1);
                if (pairing == null || pairing == Pairing.NOT_PLAYING) {
                    JPopupMenu playingInRoundPopupMenu = new JPopupMenu(participant, pairing, round){
                        private static final long serialVersionUID = 1L;
                        {
                            this.add(new JLabel(participant.getName()));
                            this.add(new JPopupMenu.Separator());
                            final JCheckBoxMenuItem menuItemPlayingInRound = new JCheckBoxMenuItem();
                            menuItemPlayingInRound.setText(Messages.getString("WalllistTable.PlayingInRoundMenuItemLabel"));
                            menuItemPlayingInRound.setSelected(pairing == null);
                            if (participant.getPreliminaryRegistration()) {
                                menuItemPlayingInRound.setEnabled(false);
                            } else {
                                menuItemPlayingInRound.addChangeListener(new ChangeListener(){

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        participant.setPairingInRound(menuItemPlayingInRound.isSelected() ? null : Pairing.NOT_PLAYING, n);
                                        (this).WalllistTable.this.m_application.fireWalllistTableDataChanged();
                                    }
                                });
                            }
                            this.add(menuItemPlayingInRound);
                        }
                    };
                    playingInRoundPopupMenu.show((Component)evt.getSource(), evt.getPoint().x, evt.getPoint().y);
                } else {
                    WalllistTablePairingPopupMenu popupMenu = new WalllistTablePairingPopupMenu(this.m_application, pairing);
                    popupMenu.show((Component)evt.getSource(), evt.getPoint().x, evt.getPoint().y);
                }
            }
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return WALLLIST_CELL_RENDERER;
    }

    public void setFontsize(int fontsize) {
        this.m_font = new Font("Dialog", 0, fontsize);
        this.m_fontsizeChanged = true;
        JLabel label = new JLabel("SOSOS");
        label.setFont(this.m_font);
        this.m_widthPerCharacter = (double)label.getPreferredSize().width / 4.8;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
    }

    private static class WalllistCellRenderer
    implements TableCellRenderer {
        private WalllistCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Participant participant = ((WalllistTableModel)table.getModel()).getParticipantAtRow(rowIndex);
            JLabel label = new JLabel(value == null ? "" : value.toString());
            if (columnIndex != ((WalllistTableModel)table.getModel()).getNameColumnIndex() && (columnIndex != ((WalllistTableModel)table.getModel()).getClubColumnIndex() || ((WalllistTableModel)table.getModel()).getTournament().getWalllist().getClubColumnAlignmentCenter())) {
                label.setHorizontalAlignment(0);
            }
            label.setFont(((WalllistTable)table).m_font);
            if (((WalllistTableModel)table.getModel()).getTournament().getWalllist().getMarkPreliminaryRegisteredParticipants() && participant.getPreliminaryRegistration()) {
                label.setBackground(PRELIMINARY_PARTICIPANT_BACKGROUNDCOLOR);
                label.setOpaque(true);
            }
            if (((WalllistTableModel)table.getModel()).getTournament().getWalllist().getShowBarMembershipVisible() && columnIndex == ((WalllistTableModel)table.getModel()).getBarMembershipColumnIndex()) {
                if (participant.isSuperBarMember()) {
                    label.setBackground(SUPER_BAR_MEMBER_BACKGROUNDCOLOR);
                    label.setOpaque(true);
                } else if (participant.isUpperBarMember()) {
                    label.setBackground(UPPER_BAR_MEMBER_BACKGROUNDCOLOR);
                    label.setOpaque(true);
                } else if (participant.isLowerBarMember()) {
                    label.setBackground(LOWER_BAR_MEMBER_BACKGROUNDCOLOR);
                    label.setOpaque(true);
                }
            }
            if (columnIndex >= ((WalllistTableModel)table.getModel()).getFirstRoundColumnIndex() && columnIndex <= ((WalllistTableModel)table.getModel()).getLastRoundColumnIndex()) {
                Pairing pairing;
                int round;
                if (((WalllistTableModel)table.getModel()).getTournament().getWalllist().getShowWarningMissingPairing() && (round = columnIndex - ((WalllistTableModel)table.getModel()).getFirstRoundColumnIndex() + 1) < ((WalllistTableModel)table.getModel()).getTournament().getCurrentRoundNumber() + (((WalllistTableModel)table.getModel()).getTournament().takeCurrentRoundInAccount() ? 1 : 0) && ((pairing = participant.getPairingInRound(columnIndex - ((WalllistTableModel)table.getModel()).getFirstRoundColumnIndex() + 1)) == null || pairing != Pairing.NOT_PLAYING && pairing.getResult() == Pairing.NO_RESULT)) {
                    label.setBackground(Color.RED);
                    label.setOpaque(true);
                }
                if (participant.getPairingInRound(columnIndex - ((WalllistTableModel)table.getModel()).getFirstRoundColumnIndex() + 1) == Pairing.NOT_PLAYING) {
                    label.setBackground(PRELIMINARY_PARTICIPANT_BACKGROUNDCOLOR);
                    label.setOpaque(true);
                }
            }
            if (columnIndex == 0 && participant.isPlaceShared()) {
                label.setForeground(SHARED_PLACE_COLOR);
            }
            if (((WalllistTable)table).m_fontsizeChanged) {
                table.setRowHeight(label.getMinimumSize().height);
                ((WalllistTable)table).m_fontsizeChanged = false;
            }
            if (!participant.isValid()) {
                label.setBackground(PARTICIPANT_NOT_VALID_BACKGROUNDCOLOR);
                label.setOpaque(true);
            }
            return label;
        }
    }

    private static class WalllistColumnHeaderRenderer
    implements TableCellRenderer {
        private WalllistColumnHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value == null ? "" : value.toString());
            label.setHorizontalAlignment(0);
            label.setFont(((WalllistTable)table).m_font);
            label.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return label;
        }
    }
}

