/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.Walllist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class SearchParticipantResultTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Tournament m_tournament;
    private List<ParticipantResultTableColumn> m_columns = new ArrayList<ParticipantResultTableColumn>();
    private List<Participant> m_participants = new ArrayList<Participant>();

    public SearchParticipantResultTableModel(Tournament tournament) {
        this.m_tournament = tournament;
        this.m_columns.add(new ParticipantResultTableColumn(){

            @Override
            public String getColumnName() {
                return Walllist.COLUMNNAME_NAME;
            }

            @Override
            public Object getValue(Participant participant) {
                return participant.getName();
            }
        });
        this.m_columns.add(new ParticipantResultTableColumn(){

            @Override
            public String getColumnName() {
                return Walllist.COLUMNNAME_CLUB;
            }

            @Override
            public Object getValue(Participant participant) {
                return participant.getClubDisplayStringWalllist();
            }
        });
        this.m_columns.add(new ParticipantResultTableColumn(){

            @Override
            public String getColumnName() {
                return Walllist.COLUMNNAME_LEVEL;
            }

            @Override
            public Object getValue(Participant participant) {
                if (participant.getGoLevel() == null) {
                    return "";
                }
                return participant.getGoLevel().getWalllistDisplayString();
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.m_participants.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.m_columns.get(columnIndex).getColumnName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.m_columns.get(columnIndex).getValue(this.m_participants.get(rowIndex));
    }

    public Participant getParticipantAtRow(int row) {
        return this.m_participants.get(row);
    }

    public void doQuery(String query) {
        this.m_participants.clear();
        if (query != null && (query = query.trim()).length() >= 2) {
            String[] queryTermsRaw = query.split(" ");
            ArrayList<String> queryTerms = new ArrayList<String>(queryTermsRaw.length);
            String[] stringArray = queryTermsRaw;
            int n = queryTermsRaw.length;
            int n2 = 0;
            while (n2 < n) {
                String queryTerm = stringArray[n2];
                if (!(queryTerm = queryTerm.trim()).isEmpty()) {
                    queryTerms.add(queryTerm);
                }
                ++n2;
            }
            for (Participant participant : this.m_tournament.getParticipants()) {
                boolean matched = true;
                for (String queryTerm : queryTerms) {
                    if (Pattern.compile(Pattern.quote(queryTerm), 2).matcher(participant.getName()).find()) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                this.m_participants.add(participant);
            }
            Collections.sort(this.m_participants, new Comparator<Participant>(){

                @Override
                public int compare(Participant o1, Participant o2) {
                    int nameCompare = o1.getName().compareTo(o2.getName());
                    return nameCompare == 0 ? (o1.getId() <= o2.getId() ? -1 : 1) : nameCompare;
                }
            });
        }
        this.fireTableDataChanged();
    }

    private static abstract class ParticipantResultTableColumn {
        private ParticipantResultTableColumn() {
        }

        public abstract String getColumnName();

        public abstract Object getValue(Participant var1);
    }
}

