/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.gui.SearchParticipantResultTableModel;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SearchParticipantDialog {
    private MacMahonApplication m_application;
    private JTextField queryEntryField;
    private JTable queryResultsTable;

    public static void addChangeListener(final JTextComponent text, final ChangeListener changeListener) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(changeListener);
        DocumentListener dl = new DocumentListener(){
            private int lastChange = 0;
            private int lastNotifiedChange = 0;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ++this.lastChange;
                SwingUtilities.invokeLater(() -> {
                    if (this.lastNotifiedChange != this.lastChange) {
                        this.lastNotifiedChange = this.lastChange;
                        changeListener.stateChanged(new ChangeEvent(text));
                    }
                });
            }
        };
        text.addPropertyChangeListener("document", e -> {
            Document d1 = (Document)e.getOldValue();
            Document d2 = (Document)e.getNewValue();
            if (d1 != null) {
                d1.removeDocumentListener(dl);
            }
            if (d2 != null) {
                d2.addDocumentListener(dl);
            }
            dl.changedUpdate(null);
        });
        Document d = text.getDocument();
        if (d != null) {
            d.addDocumentListener(dl);
        }
    }

    public SearchParticipantDialog(MacMahonApplication application) {
        this.m_application = application;
    }

    public void show(Component parent) {
        final JDialog jDialog = new JDialog();
        jDialog.setTitle(Messages.getString("SearchParticipantDialog.FindParticipantsTitle"));
        jDialog.setSize(new Dimension(560, 361));
        jDialog.setDefaultCloseOperation(2);
        jDialog.setModal(true);
        JPanel panel = new JPanel();
        jDialog.setContentPane(panel);
        jDialog.setBounds(100, 100, 831, 547);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[3];
        gridBagLayout.rowHeights = new int[5];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        jDialog.getContentPane().setLayout(gridBagLayout);
        JLabel lblQueryTerms = new JLabel(Messages.getString("SearchParticipantDialog.QueryTermsLabel"));
        GridBagConstraints gbc_lblQueryTerms = new GridBagConstraints();
        gbc_lblQueryTerms.insets = new Insets(5, 5, 5, 5);
        gbc_lblQueryTerms.anchor = 17;
        gbc_lblQueryTerms.gridx = 0;
        gbc_lblQueryTerms.gridy = 0;
        jDialog.getContentPane().add((Component)lblQueryTerms, gbc_lblQueryTerms);
        this.queryEntryField = new JTextField();
        SearchParticipantDialog.addChangeListener(this.queryEntryField, e -> ((SearchParticipantResultTableModel)this.queryResultsTable.getModel()).doQuery(this.queryEntryField.getText()));
        GridBagConstraints gbc_queryEntryField = new GridBagConstraints();
        gbc_queryEntryField.insets = new Insets(5, 10, 5, 0);
        gbc_queryEntryField.fill = 2;
        gbc_queryEntryField.anchor = 11;
        gbc_queryEntryField.gridx = 1;
        gbc_queryEntryField.gridy = 0;
        jDialog.getContentPane().add((Component)this.queryEntryField, gbc_queryEntryField);
        this.queryEntryField.setColumns(10);
        JLabel lblHint = new JLabel(Messages.getString("SearchParticipantDialog.QueryHint"));
        lblHint.setFont(new Font("Dialog", 0, 9));
        GridBagConstraints gbc_lblHint = new GridBagConstraints();
        gbc_lblHint.anchor = 17;
        gbc_lblHint.gridwidth = 2;
        gbc_lblHint.insets = new Insets(0, 5, 5, 5);
        gbc_lblHint.gridx = 0;
        gbc_lblHint.gridy = 1;
        panel.add((Component)lblHint, gbc_lblHint);
        JScrollPane scrollPaneResultsTable = new JScrollPane();
        GridBagConstraints gbc_scrollPaneResultsTable = new GridBagConstraints();
        gbc_scrollPaneResultsTable.gridwidth = 2;
        gbc_scrollPaneResultsTable.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPaneResultsTable.fill = 1;
        gbc_scrollPaneResultsTable.gridx = 0;
        gbc_scrollPaneResultsTable.gridy = 2;
        panel.add((Component)scrollPaneResultsTable, gbc_scrollPaneResultsTable);
        this.queryResultsTable = new JTable();
        this.queryResultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = SearchParticipantDialog.this.queryResultsTable.rowAtPoint(e.getPoint());
                    int column = SearchParticipantDialog.this.queryResultsTable.columnAtPoint(e.getPoint());
                    if (row >= 0 && column >= 0) {
                        SearchParticipantDialog.this.editParticipantAtRow(row);
                    }
                }
            }
        });
        this.queryResultsTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.queryResultsTable.getActionMap().put("Enter", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedRow = SearchParticipantDialog.this.queryResultsTable.getSelectedRow();
                if (selectedRow >= 0) {
                    SearchParticipantDialog.this.editParticipantAtRow(selectedRow);
                }
            }
        });
        scrollPaneResultsTable.setViewportView(this.queryResultsTable);
        this.queryResultsTable.setModel(new SearchParticipantResultTableModel(this.m_application.getTournament()));
        this.queryResultsTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.queryResultsTable.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.queryResultsTable.getColumnModel().getColumn(2).setPreferredWidth(20);
        JButton closeButton = new JButton(Messages.getString("SearchParticipantDialog.CloseButtonLabel"));
        GridBagConstraints gbc_closeButton = new GridBagConstraints();
        gbc_closeButton.fill = 1;
        gbc_closeButton.gridwidth = 2;
        gbc_closeButton.gridx = 0;
        gbc_closeButton.gridy = 3;
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add((Component)closeButton, gbc_closeButton);
        ActionListener escapeListener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                jDialog.dispose();
            }
        };
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        jDialog.getRootPane().registerKeyboardAction(escapeListener, escapeKeyStroke, 1);
        jDialog.setLocationRelativeTo(parent);
        jDialog.setVisible(true);
    }

    private void editParticipantAtRow(int row) {
        this.m_application.editParticipant(((SearchParticipantResultTableModel)this.queryResultsTable.getModel()).getParticipantAtRow(row));
        ((SearchParticipantResultTableModel)this.queryResultsTable.getModel()).fireTableRowsUpdated(row, row);
    }
}

