/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PairingsTablePairingPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private MacMahonApplication m_application;
    private Pairing m_pairing;
    private Participant m_participant;

    public PairingsTablePairingPopupMenu(MacMahonApplication application, Pairing pairing, Participant participant) {
        this.m_application = application;
        this.m_pairing = pairing;
        this.m_participant = participant;
        this.add(new JLabel(this.m_pairing.getPairingDisplayString()));
        this.add(new JPopupMenu.Separator());
        JMenuItem menuItemEditPairing = new JMenuItem();
        menuItemEditPairing.setText(Messages.getString("PairingPopupMenu.EditPairing"));
        menuItemEditPairing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairingsTablePairingPopupMenu.this.m_application.pairingEdit(PairingsTablePairingPopupMenu.this.m_pairing);
            }
        });
        this.add(menuItemEditPairing);
        if (!this.m_pairing.isPairingWithBye()) {
            JMenuItem menuItemSwapColors = new JMenuItem();
            menuItemSwapColors.setText(Messages.getString("EditPairingDialog.SwapColorsButton"));
            menuItemSwapColors.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PairingsTablePairingPopupMenu.this.m_application.pairingSwapColorsIncludingResult(PairingsTablePairingPopupMenu.this.m_pairing);
                }
            });
            this.add(menuItemSwapColors);
        }
        JMenuItem menuItemDeletePairing = new JMenuItem();
        menuItemDeletePairing.setText(Messages.getString("PairingPopupMenu.DeletePairing"));
        menuItemDeletePairing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairingsTablePairingPopupMenu.this.m_application.pairingDelete(PairingsTablePairingPopupMenu.this.m_pairing);
            }
        });
        this.add(menuItemDeletePairing);
        if (this.m_participant != null) {
            this.add(new JPopupMenu.Separator());
            this.add(new JLabel(this.m_participant.getName()));
            this.add(new JPopupMenu.Separator());
            JMenuItem menuItemEditParticipant = new JMenuItem();
            menuItemEditParticipant.setText(Messages.getString("ParticipantPopupMenu.EditParticipant"));
            menuItemEditParticipant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PairingsTablePairingPopupMenu.this.m_application.editParticipant(PairingsTablePairingPopupMenu.this.m_participant);
                }
            });
            this.add(menuItemEditParticipant);
        }
    }
}

