/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Tournament;
import javax.swing.table.AbstractTableModel;

public class PairingsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Tournament m_tournament;

    public PairingsTableModel(Tournament tournament) {
        this.m_tournament = tournament;
    }

    @Override
    public int getRowCount() {
        return this.m_tournament.getCurrentRound().getPairings().size();
    }

    @Override
    public int getColumnCount() {
        return this.m_tournament.getPairingsShowHandicaps() ? 5 : 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Tournament.PAIRING_COLUMNNAME_BOARD;
            }
            case 1: {
                return Tournament.PAIRING_COLUMNNAME_BLACK;
            }
            case 2: {
                return Tournament.PAIRING_COLUMNNAME_WHITE;
            }
            case 3: {
                return Tournament.PAIRING_COLUMNNAME_RESULT;
            }
            case 4: {
                return Tournament.PAIRING_COLUMNNAME_HANDICAP;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pairing pairing = this.m_tournament.getCurrentRound().getPairings().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return pairing.getBoardNumber();
            }
            case 1: {
                return pairing.getBlack().getPairingDisplayString();
            }
            case 2: {
                return pairing.isPairingWithBye() ? Pairing.BYE : pairing.getWhite().getPairingDisplayString();
            }
            case 3: {
                return pairing.getResultDisplayString();
            }
            case 4: {
                return pairing.getHandicapDisplayString();
            }
        }
        return null;
    }

    public Pairing getPairingAtRow(int rowIndex) {
        return this.m_tournament.getCurrentRound().getPairings().get(rowIndex);
    }
}

