/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.gui.PairingsTableModel;
import de.cgerlach.macmahon.gui.PairingsTablePairingPopupMenu;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PairingsTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Color NO_RESULT_BACKGROUNDCOLOR = new Color(254, 249, 226);
    private static final Color UNWANTED_PAIRING_BACKGROUNDCOLOR = new Color(255, 218, 0);
    private static final Color FORBIDDEN_PAIRING_BACKGROUNDCOLOR = new Color(209, 0, 0);
    private static final TableCellRenderer PAIRINGS_COLUMN_HEADER_RENDERER = new PairingsColumnHeaderRenderer();
    private static final TableCellRenderer PAIRINGS_CELL_RENDERER = new PairingsCellRenderer();
    private MacMahonApplication m_application;
    private Font m_font;
    private Font m_fontBold;
    private boolean m_fontsizeChanged = false;
    private double m_widthPerCharacter;

    public PairingsTable(MacMahonApplication application, int fontsize) {
        this.m_application = application;
        this.setFontsize(fontsize);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    PairingsTable.this.doPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    PairingsTable.this.doPopup(evt);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int column;
                int row;
                if (e.getClickCount() == 2) {
                    Pairing pairing;
                    row = PairingsTable.this.rowAtPoint(e.getPoint());
                    column = PairingsTable.this.columnAtPoint(e.getPoint());
                    if (row >= 0 && (column == 0 || column == 4)) {
                        PairingsTable.this.m_application.pairingEdit(PairingsTable.this.m_application.getTournament().getCurrentRound().getPairingAt(row));
                    }
                    if (row >= 0 && column == 1) {
                        PairingsTable.this.m_application.editParticipant(PairingsTable.this.m_application.getTournament().getCurrentRound().getPairingAt(row).getBlack());
                    }
                    if (row >= 0 && column == 2 && !(pairing = PairingsTable.this.m_application.getTournament().getCurrentRound().getPairingAt(row)).isPairingWithBye()) {
                        PairingsTable.this.m_application.editParticipant(pairing.getWhite());
                    }
                }
                if (e.getButton() == 1 || e.getButton() == 3) {
                    row = PairingsTable.this.rowAtPoint(e.getPoint());
                    column = PairingsTable.this.columnAtPoint(e.getPoint());
                    if (row >= 0 && column == 3) {
                        if (e.getButton() == 1) {
                            PairingsTable.this.m_application.pairingChangeResultToNext(PairingsTable.this.m_application.getTournament().getCurrentRound().getPairingAt(row));
                        } else if (e.getButton() == 3) {
                            PairingsTable.this.m_application.pairingChangeResultToPrevious(PairingsTable.this.m_application.getTournament().getCurrentRound().getPairingAt(row));
                        }
                    }
                }
            }
        });
    }

    @Override
    public void createDefaultColumnsFromModel() {
        if (this.getModel() instanceof PairingsTableModel) {
            PairingsTableModel m = (PairingsTableModel)this.getModel();
            if (m != null) {
                TableColumnModel cm = this.getColumnModel();
                while (cm.getColumnCount() > 0) {
                    cm.removeColumn(cm.getColumn(0));
                }
                int i = 0;
                while (i < m.getColumnCount()) {
                    TableColumn newColumn = this.createTableColumn(i);
                    this.addColumn(newColumn);
                    ++i;
                }
            }
        } else {
            super.createDefaultColumnModel();
        }
    }

    public TableColumn createTableColumn(int columnIndex) {
        TableColumn column = new TableColumn(columnIndex);
        int chars = 0;
        switch (columnIndex) {
            case 0: {
                if (Locale.getDefault().getLanguage() == "ko") {
                    chars = 7;
                    break;
                }
                chars = 5;
                break;
            }
            case 1: {
                if (this.m_application.getTournament().getPairingsBlackColumnWidth() == 0) {
                    this.m_application.getTournament().setPairingsBlackColumnWidth((int)Math.round(25.0 * this.m_widthPerCharacter + 2.0));
                }
                column.setPreferredWidth(this.m_application.getTournament().getPairingsBlackColumnWidth());
                column.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("width")) {
                            PairingsTable.this.m_application.getTournament().setPairingsBlackColumnWidth((Integer)evt.getNewValue());
                        }
                    }
                });
                break;
            }
            case 2: {
                if (this.m_application.getTournament().getPairingsWhiteColumnWidth() == 0) {
                    this.m_application.getTournament().setPairingsWhiteColumnWidth((int)Math.round(25.0 * this.m_widthPerCharacter + 2.0));
                }
                column.setPreferredWidth(this.m_application.getTournament().getPairingsWhiteColumnWidth());
                column.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("width")) {
                            PairingsTable.this.m_application.getTournament().setPairingsWhiteColumnWidth((Integer)evt.getNewValue());
                        }
                    }
                });
                break;
            }
            case 3: {
                chars = 5;
                break;
            }
            case 4: {
                chars = 13;
            }
        }
        if (chars > 0) {
            column.setMinWidth((int)Math.round((double)chars * this.m_widthPerCharacter + 2.0));
            column.setMaxWidth((int)Math.round((double)chars * this.m_widthPerCharacter + 2.0));
        }
        column.setHeaderRenderer(PAIRINGS_COLUMN_HEADER_RENDERER);
        return column;
    }

    public void doPopup(MouseEvent evt) {
        int rowIndex = this.rowAtPoint(evt.getPoint());
        int columnIndex = this.columnAtPoint(evt.getPoint());
        if (rowIndex >= 0 && columnIndex >= 0 && columnIndex != 3) {
            Pairing pairing = ((PairingsTableModel)this.getModel()).getPairingAtRow(rowIndex);
            Participant participant = columnIndex == 1 ? pairing.getBlack() : (columnIndex == 2 && !pairing.isPairingWithBye() ? pairing.getWhite() : null);
            PairingsTablePairingPopupMenu popupMenu = new PairingsTablePairingPopupMenu(this.m_application, pairing, participant);
            popupMenu.show((Component)evt.getSource(), evt.getPoint().x, evt.getPoint().y);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return PAIRINGS_CELL_RENDERER;
    }

    public void setFontsize(int fontsize) {
        this.m_font = new Font("Dailog", 0, fontsize);
        this.m_fontBold = new Font("Dialog", 1, fontsize);
        this.m_fontsizeChanged = true;
        JLabel label = new JLabel("SOSOS");
        label.setFont(this.m_font);
        this.m_widthPerCharacter = (double)label.getPreferredSize().width / 4.8;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
    }

    private static class PairingsCellRenderer
    implements TableCellRenderer {
        private PairingsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Pairing pairing = ((PairingsTableModel)table.getModel()).getPairingAtRow(rowIndex);
            JLabel label = new JLabel(value == null ? "" : value.toString());
            if (columnIndex != 1 && columnIndex != 2) {
                label.setHorizontalAlignment(0);
            }
            if (pairing.getTournament().getPairingsMarkWinner() && (columnIndex == 1 && pairing.getNumberOfWinsForBlack() == 2 || columnIndex == 2 && !pairing.isPairingWithBye() && pairing.getNumberOfWinsForWhite() == 2)) {
                label.setFont(((PairingsTable)table).m_fontBold);
            } else if (columnIndex == 0 && pairing.getTournament().getPairingsMarkFixedBoardnumbers() && pairing.isBoardNumberFixed()) {
                label.setFont(((PairingsTable)table).m_fontBold);
            } else {
                label.setFont(((PairingsTable)table).m_font);
            }
            if (((PairingsTable)table).m_fontsizeChanged) {
                table.setRowHeight(label.getMinimumSize().height);
                ((PairingsTable)table).m_fontsizeChanged = false;
            }
            if (pairing.getTournament().getPairingsMarkMissingResults() && pairing.getResult() == Pairing.NO_RESULT) {
                label.setBackground(NO_RESULT_BACKGROUNDCOLOR);
                label.setOpaque(true);
            }
            if (columnIndex == 0 && pairing.getTournament().getPairingsMarkUnwantedPairings() && pairing.isUnwantedPairing()) {
                label.setBackground(UNWANTED_PAIRING_BACKGROUNDCOLOR);
                label.setOpaque(true);
            }
            if (columnIndex == 0 && pairing.getTournament().getPairingsMarkUnwantedPairings() && pairing.isForbiddenPairing()) {
                label.setBackground(FORBIDDEN_PAIRING_BACKGROUNDCOLOR);
                label.setOpaque(true);
            }
            return label;
        }
    }

    private static class PairingsColumnHeaderRenderer
    implements TableCellRenderer {
        private PairingsColumnHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            JLabel label = new JLabel(value == null ? "" : value.toString());
            label.setHorizontalAlignment(0);
            label.setFont(((PairingsTable)table).m_font);
            label.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return label;
        }
    }
}

