/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.Walllist;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class PairingsFreeParticipantsListModel
extends AbstractListModel<Participant>
implements Walllist.WalllistChangeListener {
    private static final long serialVersionUID = 1L;
    private Tournament m_tournament;
    private List<Participant> m_freeParticipants = new ArrayList<Participant>();

    public void setTournament(Tournament tournament) {
        if (this.m_tournament != null) {
            this.m_tournament.getWalllist().removeChangeListener(this);
            this.walllistChanged();
        }
        this.m_tournament = tournament;
        if (this.m_tournament != null) {
            this.m_tournament.getWalllist().addChangeListener(this);
            this.walllistChanged();
        }
    }

    @Override
    public int getSize() {
        return this.m_freeParticipants.size();
    }

    @Override
    public Participant getElementAt(int index) {
        return this.m_freeParticipants.get(index);
    }

    public Participant getParticipantAt(int index) {
        return this.m_freeParticipants.get(index);
    }

    @Override
    public void walllistParticipantAdded(Participant participant) {
    }

    @Override
    public void walllistParticipantRemoved(Participant participant) {
    }

    @Override
    public void walllistChanged() {
        this.m_freeParticipants.clear();
        if (this.m_tournament != null) {
            for (Participant participant : this.m_tournament.getWalllist().getWalllist()) {
                if (!participant.isFreeInCurrentRound()) continue;
                this.m_freeParticipants.add(participant);
            }
        }
        this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
    }
}

