/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.TransferableParticipantList;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

public class MakePairingDialog {
    private Tournament m_tournament;
    private boolean m_makePairing = false;
    private int m_topGroupScore = -1;
    private int m_numberOfFreeParticipants = -1;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JButton jButtonOk = null;
    private JLabel jLabelTopGroup = null;
    private JTextField jTextFieldTopGroup = null;
    private JCheckBox jCheckBoxOddNumberOfParticipants = null;
    private JLabel jLabelOdd = null;
    private JPanel jPanelOdd = null;
    private JPanel jPanelJoker = null;
    private JPanel jPanelJokerPlaying = null;
    private JPanel jPanelJokerNotPlaying = null;
    private JLabel jLabelJokerPlaying = null;
    private JLabel jLabelJokerNotPlaying = null;
    private JScrollPane jScrollPaneJokerPlaying = null;
    private JScrollPane jScrollPaneJokerNotPlaying = null;
    private JList<Participant> jListJokerPlaying = null;
    private JList<Participant> jListJokerNotPlaying = null;
    private JLabel jLabelNumberOfFreeParticipants = null;
    private JTextField jTextFieldNumberOfFreeParticipants = null;
    private JLabel jLabelHintJokers = null;

    public MakePairingDialog(Tournament tournament) {
        this.m_tournament = tournament;
    }

    public boolean getMakePairing() {
        return this.m_makePairing;
    }

    public void show(Component parent) {
        this.getJDialog();
        this.buildTopGroupEtc();
        DefaultListModel<Participant> jokerPlayingListModel = new DefaultListModel<Participant>();
        Iterator<Participant> itParticipant = this.m_tournament.getJokerParticipantsFreeInRound(this.m_tournament.getCurrentRoundNumber()).iterator();
        while (itParticipant.hasNext()) {
            jokerPlayingListModel.addElement(itParticipant.next());
        }
        this.getJListJokerPlaying().setModel(jokerPlayingListModel);
        this.getJListJokerPlaying().setDragEnabled(true);
        this.getJListJokerPlaying().setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                JList list = (JList)c;
                ArrayList<Participant> selectedParticipants = new ArrayList<Participant>();
                selectedParticipants.addAll(list.getSelectedValuesList());
                return new TransferableParticipantList(selectedParticipants);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if (action == 2) {
                    JList list = (JList)source;
                    try {
                        List removeParticipants = (List)data.getTransferData(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR);
                        for (Participant participant : removeParticipants) {
                            ((DefaultListModel)list.getModel()).removeElement(participant);
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (!support.isDataFlavorSupported(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR)) {
                    return false;
                }
                try {
                    Participant participant;
                    List importedParticipants = (List)support.getTransferable().getTransferData(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR);
                    Iterator iterator = importedParticipants.iterator();
                    do {
                        if (!iterator.hasNext()) {
                            return true;
                        }
                        participant = (Participant)iterator.next();
                    } while (!((DefaultListModel)MakePairingDialog.this.getJListJokerPlaying().getModel()).contains(participant));
                    return false;
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                try {
                    int index = ((JList.DropLocation)support.getDropLocation()).getIndex();
                    List importedParticipants = (List)support.getTransferable().getTransferData(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR);
                    for (Participant participant : importedParticipants) {
                        ((DefaultListModel)((JList)support.getComponent()).getModel()).insertElementAt(participant, index++);
                        participant.setPairingInRound(null, MakePairingDialog.this.m_tournament.getCurrentRoundNumber());
                    }
                    MakePairingDialog.this.buildTopGroupEtc();
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        });
        this.getJListJokerPlaying().setDropMode(DropMode.INSERT);
        DefaultListModel<Participant> jokerNotPlayingListModel = new DefaultListModel<Participant>();
        itParticipant = this.m_tournament.getJokerParticipantsNotPlayingInRound(this.m_tournament.getCurrentRoundNumber()).iterator();
        while (itParticipant.hasNext()) {
            jokerNotPlayingListModel.addElement(itParticipant.next());
        }
        this.getJListJokerNotPlaying().setModel(jokerNotPlayingListModel);
        this.getJListJokerNotPlaying().setDragEnabled(true);
        this.getJListJokerNotPlaying().setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                JList list = (JList)c;
                ArrayList<Participant> selectedParticipants = new ArrayList<Participant>();
                selectedParticipants.addAll(list.getSelectedValuesList());
                return new TransferableParticipantList(selectedParticipants);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if (action == 2) {
                    JList list = (JList)source;
                    try {
                        List removeParticipants = (List)data.getTransferData(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR);
                        for (Participant participant : removeParticipants) {
                            ((DefaultListModel)list.getModel()).removeElement(participant);
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (!support.isDataFlavorSupported(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR)) {
                    return false;
                }
                try {
                    Participant participant;
                    List importedParticipants = (List)support.getTransferable().getTransferData(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR);
                    Iterator iterator = importedParticipants.iterator();
                    do {
                        if (!iterator.hasNext()) {
                            return true;
                        }
                        participant = (Participant)iterator.next();
                    } while (!((DefaultListModel)MakePairingDialog.this.getJListJokerNotPlaying().getModel()).contains(participant));
                    return false;
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                try {
                    int index = ((JList.DropLocation)support.getDropLocation()).getIndex();
                    List importedParticipants = (List)support.getTransferable().getTransferData(TransferableParticipantList.PARTICIPANT_LIST_DATA_FLAVOR);
                    for (Participant participant : importedParticipants) {
                        ((DefaultListModel)((JList)support.getComponent()).getModel()).insertElementAt(participant, index++);
                        participant.setPairingInRound(Pairing.NOT_PLAYING, MakePairingDialog.this.m_tournament.getCurrentRoundNumber());
                    }
                    MakePairingDialog.this.buildTopGroupEtc();
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        });
        this.getJListJokerNotPlaying().setDropMode(DropMode.INSERT);
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                MakePairingDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    private void buildTopGroupEtc() {
        this.m_topGroupScore = this.m_tournament.getTopGroupScoreForRound(this.m_tournament.getCurrentRoundNumber());
        Object topGroupScore = this.m_topGroupScore < 0 ? Messages.getString("MakePairingDialog.NoTopGroup") : ((this.m_topGroupScore & 3) == 3 ? (this.m_topGroupScore >> 2) + "\u00be" : ((this.m_topGroupScore & 3) == 2 ? (this.m_topGroupScore >> 2) + "\u00bd" : ((this.m_topGroupScore & 3) == 1 ? (this.m_topGroupScore >> 2) + "\u00bc" : "" + (this.m_topGroupScore >> 2))));
        this.getJTextFieldTopGroup().setText((String)topGroupScore);
        this.m_numberOfFreeParticipants = this.m_tournament.getNumberOfFreeParticipantsInRound(this.m_tournament.getCurrentRoundNumber());
        this.getJTextFieldNumberOfFreeParticipants().setText(Integer.toString(this.m_numberOfFreeParticipants));
        this.getJCheckBoxOddNumberOfParticipants().setSelected((this.m_numberOfFreeParticipants & 1) == 1);
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setSize(new Dimension(679, 340));
            this.jDialog.setTitle(Messages.getString("MakePairingDialog.Title"));
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setModal(true);
            this.jDialog.setContentPane(this.getJContentPane());
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 4;
            this.jLabelHintJokers = new JLabel();
            this.jLabelHintJokers.setText(Messages.getString("MakePairingDialog.JokerHint"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.insets = new Insets(10, 0, 5, 0);
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 2;
            this.jLabelOdd = new JLabel();
            this.jLabelOdd.setText(Messages.getString("MakePairingDialog.NumberOfParticipantsOddCheckbox"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.gridy = 5;
            this.jContentPane = new JPanel();
            GridBagLayout gbl_jContentPane = new GridBagLayout();
            gbl_jContentPane.columnWeights = new double[]{0.0, 0.0};
            this.jContentPane.setLayout(gbl_jContentPane);
            this.jLabelTopGroup = new JLabel();
            GridBagConstraints gbc_jLabelTopGroup = new GridBagConstraints();
            gbc_jLabelTopGroup.anchor = 17;
            gbc_jLabelTopGroup.insets = new Insets(0, 0, 5, 5);
            gbc_jLabelTopGroup.gridx = 0;
            gbc_jLabelTopGroup.gridy = 0;
            this.jContentPane.add((Component)this.jLabelTopGroup, gbc_jLabelTopGroup);
            this.jLabelTopGroup.setText(Messages.getString("MakePairingDialog.TopGroupScoreLabel"));
            GridBagConstraints gbc_jTextFieldTopGroup = new GridBagConstraints();
            gbc_jTextFieldTopGroup.anchor = 17;
            gbc_jTextFieldTopGroup.insets = new Insets(0, 0, 5, 0);
            gbc_jTextFieldTopGroup.gridx = 1;
            gbc_jTextFieldTopGroup.gridy = 0;
            this.jContentPane.add((Component)this.getJTextFieldTopGroup(), gbc_jTextFieldTopGroup);
            this.jLabelNumberOfFreeParticipants = new JLabel();
            GridBagConstraints gbc_jLabelNumberOfFreeParticipants = new GridBagConstraints();
            gbc_jLabelNumberOfFreeParticipants.anchor = 17;
            gbc_jLabelNumberOfFreeParticipants.insets = new Insets(0, 0, 5, 5);
            gbc_jLabelNumberOfFreeParticipants.gridx = 0;
            gbc_jLabelNumberOfFreeParticipants.gridy = 1;
            this.jContentPane.add((Component)this.jLabelNumberOfFreeParticipants, gbc_jLabelNumberOfFreeParticipants);
            this.jLabelNumberOfFreeParticipants.setText(Messages.getString("MakePairingDialog.NumberOfParticipantsLabel"));
            GridBagConstraints gbc_jTextFieldNumberOfFreeParticipants = new GridBagConstraints();
            gbc_jTextFieldNumberOfFreeParticipants.anchor = 17;
            gbc_jTextFieldNumberOfFreeParticipants.insets = new Insets(0, 0, 5, 0);
            gbc_jTextFieldNumberOfFreeParticipants.gridx = 1;
            gbc_jTextFieldNumberOfFreeParticipants.gridy = 1;
            this.jContentPane.add((Component)this.getJTextFieldNumberOfFreeParticipants(), gbc_jTextFieldNumberOfFreeParticipants);
            this.jContentPane.add((Component)this.getJButtonOk(), gridBagConstraints);
            this.jContentPane.add((Component)this.getJPanelOdd(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getJPanelJoker(), gridBagConstraints8);
            this.jContentPane.add((Component)this.jLabelHintJokers, gridBagConstraints17);
        }
        return this.jContentPane;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("MakePairingDialog.MakePairing"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MakePairingDialog.this.m_makePairing = true;
                    MakePairingDialog.this.getJDialog().dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JTextField getJTextFieldTopGroup() {
        if (this.jTextFieldTopGroup == null) {
            this.jTextFieldTopGroup = new JTextField();
            this.jTextFieldTopGroup.setMinimumSize(new Dimension(110, 20));
            this.jTextFieldTopGroup.setPreferredSize(new Dimension(110, 20));
            this.jTextFieldTopGroup.setEditable(false);
        }
        return this.jTextFieldTopGroup;
    }

    private JCheckBox getJCheckBoxOddNumberOfParticipants() {
        if (this.jCheckBoxOddNumberOfParticipants == null) {
            this.jCheckBoxOddNumberOfParticipants = new JCheckBox();
            this.jCheckBoxOddNumberOfParticipants.setText("");
            this.jCheckBoxOddNumberOfParticipants.setEnabled(false);
        }
        return this.jCheckBoxOddNumberOfParticipants;
    }

    private JPanel getJPanelOdd() {
        if (this.jPanelOdd == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridwidth = 1;
            this.jPanelOdd = new JPanel();
            this.jPanelOdd.setLayout(new GridBagLayout());
            this.jPanelOdd.add((Component)this.getJCheckBoxOddNumberOfParticipants(), gridBagConstraints3);
            this.jPanelOdd.add((Component)this.jLabelOdd, gridBagConstraints4);
        }
        return this.jPanelOdd;
    }

    private JPanel getJPanelJoker() {
        if (this.jPanelJoker == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 0;
            this.jPanelJoker = new JPanel();
            this.jPanelJoker.setLayout(new GridBagLayout());
            this.jPanelJoker.add((Component)this.getJPanelJokerPlaying(), gridBagConstraints7);
            this.jPanelJoker.add((Component)this.getJPanelJokerNotPlaying(), gridBagConstraints9);
        }
        return this.jPanelJoker;
    }

    private JPanel getJPanelJokerPlaying() {
        if (this.jPanelJokerPlaying == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridx = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 0;
            this.jLabelJokerPlaying = new JLabel();
            this.jLabelJokerPlaying.setText(Messages.getString("MakePairingDialog.JokersToBePairedLabel"));
            this.jPanelJokerPlaying = new JPanel();
            this.jPanelJokerPlaying.setLayout(new GridBagLayout());
            this.jPanelJokerPlaying.add((Component)this.jLabelJokerPlaying, gridBagConstraints10);
            this.jPanelJokerPlaying.add((Component)this.getJScrollPaneJokerPlaying(), gridBagConstraints12);
        }
        return this.jPanelJokerPlaying;
    }

    private JPanel getJPanelJokerNotPlaying() {
        if (this.jPanelJokerNotPlaying == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridx = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 0;
            this.jLabelJokerNotPlaying = new JLabel();
            this.jLabelJokerNotPlaying.setText(Messages.getString("MakePairingDialog.JokersNotToBePairedLabel"));
            this.jPanelJokerNotPlaying = new JPanel();
            this.jPanelJokerNotPlaying.setLayout(new GridBagLayout());
            this.jPanelJokerNotPlaying.add((Component)this.jLabelJokerNotPlaying, gridBagConstraints11);
            this.jPanelJokerNotPlaying.add((Component)this.getJScrollPaneJokerNotPlaying(), gridBagConstraints13);
        }
        return this.jPanelJokerNotPlaying;
    }

    private JScrollPane getJScrollPaneJokerPlaying() {
        if (this.jScrollPaneJokerPlaying == null) {
            this.jScrollPaneJokerPlaying = new JScrollPane();
            this.jScrollPaneJokerPlaying.setViewportView(this.getJListJokerPlaying());
        }
        return this.jScrollPaneJokerPlaying;
    }

    private JScrollPane getJScrollPaneJokerNotPlaying() {
        if (this.jScrollPaneJokerNotPlaying == null) {
            this.jScrollPaneJokerNotPlaying = new JScrollPane();
            this.jScrollPaneJokerNotPlaying.setViewportView(this.getJListJokerNotPlaying());
        }
        return this.jScrollPaneJokerNotPlaying;
    }

    private JList<Participant> getJListJokerPlaying() {
        if (this.jListJokerPlaying == null) {
            this.jListJokerPlaying = new JList();
        }
        return this.jListJokerPlaying;
    }

    private JList<Participant> getJListJokerNotPlaying() {
        if (this.jListJokerNotPlaying == null) {
            this.jListJokerNotPlaying = new JList();
        }
        return this.jListJokerNotPlaying;
    }

    private JTextField getJTextFieldNumberOfFreeParticipants() {
        if (this.jTextFieldNumberOfFreeParticipants == null) {
            this.jTextFieldNumberOfFreeParticipants = new JTextField();
            this.jTextFieldNumberOfFreeParticipants.setMinimumSize(new Dimension(110, 20));
            this.jTextFieldNumberOfFreeParticipants.setPreferredSize(new Dimension(110, 20));
            this.jTextFieldNumberOfFreeParticipants.setEditable(false);
        }
        return this.jTextFieldNumberOfFreeParticipants;
    }
}

