/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.gui.PairingsFreeParticipantsListModel;
import de.cgerlach.macmahon.gui.PairingsTable;
import de.cgerlach.macmahon.gui.WalllistTable;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.IndividualParticipant;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Walllist;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MacMahonMainWindow {
    private MacMahonApplication m_application;
    private JFrame jFrame = null;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenuTournament = null;
    private JMenuItem jMenuItemTournamentNew = null;
    private JMenuItem jMenuItemTournamentClose = null;
    private JMenu jMenuParticipants = null;
    private JMenuItem jMenuItemNewIndividualParticipant = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelWallList = null;
    private JScrollPane jScrollPaneWalllist = null;
    private JTable jTableWalllist = null;
    private JMenu jMenuPairing = null;
    private JMenuItem jMenuItemMakePairing = null;
    private JPanel jPanelPairings = null;
    private JScrollPane jScrollPanePairings = null;
    private JTable jTablePairings = null;
    private JMenuItem jMenuItemDropPairing = null;
    private JMenu jMenuRound = null;
    private JCheckBoxMenuItem jCheckBoxMenuItemTakeCurrentRoundInAccount = null;
    private JMenuItem jMenuItemTournamentEdit = null;
    private JMenuItem jMenuItemNextRound = null;
    private JMenuItem jMenuItemPreviousRound = null;
    private JMenu jMenuGotoRound = null;
    private JMenuItem jMenuItemPairingFixBoardNumbers = null;
    private JMenuItem jMenuItemPairingUnfixBoardNumbers = null;
    private JMenu jMenuTest = null;
    private JMenuItem jMenuItemGenerateParticipants = null;
    private JMenu jMenuHelp = null;
    private JMenuItem jMenuItemHelpAboutMacMahon = null;
    private JMenuItem jMenuItemQuit = null;
    private JMenuItem jMenuItemTournamentOpen = null;
    private JMenuItem jMenuItemTournamentSave = null;
    private JMenuItem jMenuItemTournamentSaveAs = null;
    private JMenuItem jMenuItemEditMakePairingSettings = null;
    private JMenuItem jMenuItemEditClubs = null;
    private JMenuItem jMenuItemParticipantsDeletePreliminaryRegisteredParticipants = null;
    private JMenuItem jMenuItemTestRandomResults = null;
    private JMenuItem jMenuItemTournamentExportForEGD = null;
    private JMenuItem jMenuItemTournamentImportParticipantsTxt = null;
    private JMenuItem jMenuItemTournamentExportCurrentPairing = null;
    private JMenuItem jMenuItemTournamentExportWalllist = null;
    private JMenu jMenuPrint = null;
    private JMenuItem jMenuItemPrintPairings = null;
    private JMenuItem jMenuItemPrintWalllist = null;
    private JMenuItem jMenuItemTournamentImportSettings = null;
    private JLabel jLabelGlobalMessageLabel = null;
    private JLabel jLabelGlobalMessage = null;
    private JMenuItem jMenuItemPrintEditSettings = null;
    private JMenuItem jMenuItemSearchParticipant = null;
    private JMenuItem menuItemHelpForcedPairings;
    private JSplitPane splitPanePairings;
    private JPanel panelPairingsFreeParticipants;
    private JLabel lblFreeParticipants;
    private JScrollPane scrollPaneFreeParticipants;
    private JList<Participant> listFreeParticipants;
    private JButton btnMakePairing;
    private JMenuItem mntmDefineUnwantedPairings;
    private JMenuItem mntmExportStatistics;
    private JMenuItem mntmLastUpdated;

    public MacMahonMainWindow(MacMahonApplication application) {
        this.m_application = application;
    }

    public void setupWindow() {
        this.getJFrame();
        try {
            BufferedImage image = ImageIO.read(MacMahonMainWindow.class.getResource("/de/cgerlach/macmahon/resources/macmahon-logo.png"));
            this.getJFrame().setIconImage(image);
        }
        catch (IOException image) {
            // empty catch block
        }
        this.getJMenuParticipants().setVisible(false);
        this.getJMenuRound().setVisible(false);
        this.getJMenuPairing().setVisible(false);
        this.getJMenuPrint().setVisible(false);
        this.getJMenuTest().setEnabled(false);
        this.getJTabbedPane().setVisible(false);
        int i = 1;
        while (i <= 9) {
            GotoRoundActionListener gotoRoundAction = new GotoRoundActionListener(this.m_application, i);
            this.getJFrame().getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(48 + i, 512, false), "gotoRound" + i);
            this.getJFrame().getRootPane().getActionMap().put("gotoRound" + i, gotoRoundAction);
            ++i;
        }
        this.getJFrame().getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(521, 512, false), "gotoNextRound");
        this.getJFrame().getRootPane().getActionMap().put("gotoNextRound", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacMahonMainWindow.this.m_application.gotoRound(MacMahonMainWindow.this.m_application.getTournament().getCurrentRoundNumber() + 1);
            }
        });
        this.getJFrame().getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(45, 512, false), "gotoPreviousRound");
        this.getJFrame().getRootPane().getActionMap().put("gotoPreviousRound", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacMahonMainWindow.this.m_application.gotoRound(MacMahonMainWindow.this.m_application.getTournament().getCurrentRoundNumber() - 1);
            }
        });
        this.getJFrame().getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(116, 0, false), "showWalllist");
        this.getJFrame().getRootPane().getActionMap().put("showWalllist", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacMahonMainWindow.this.getJTabbedPane().setSelectedComponent(MacMahonMainWindow.this.getJPanelWallList());
            }
        });
        this.getJFrame().getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(117, 0, false), "showPairings");
        this.getJFrame().getRootPane().getActionMap().put("showPairings", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacMahonMainWindow.this.getJTabbedPane().setSelectedComponent(MacMahonMainWindow.this.getJPanelPairings());
            }
        });
        this.getJFrame().setLocationRelativeTo(null);
        this.getJFrame().setVisible(true);
    }

    public JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            Dimension screensize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
            Dimension mysize = new Dimension(Math.min(screensize.width, 1024), Math.min(screensize.height, 700));
            this.jFrame.setSize(mysize);
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MacMahonMainWindow.this.m_application.quit();
                }
            });
            this.jFrame.setDefaultCloseOperation(0);
            this.jFrame.setJMenuBar(this.getJJMenuBar());
        }
        return this.jFrame;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints11.gridy = 1;
            this.jLabelGlobalMessage = new JLabel();
            this.jLabelGlobalMessage.setText("");
            this.jLabelGlobalMessage.setFont(new Font("Dialog", 0, 10));
            this.jLabelGlobalMessage.setVisible(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 0;
            this.jLabelGlobalMessageLabel = new JLabel();
            this.jLabelGlobalMessageLabel.setText(Messages.getString("MacMahonMainWindow.MessageLabel"));
            this.jLabelGlobalMessageLabel.setFont(new Font("Dialog", 0, 10));
            this.jLabelGlobalMessageLabel.setVisible(false);
            this.jContentPane.add((Component)this.getJTabbedPane(), gridBagConstraints);
            this.jContentPane.add((Component)this.jLabelGlobalMessageLabel, gridBagConstraints1);
            this.jContentPane.add((Component)this.jLabelGlobalMessage, gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getJMenuTournament());
            this.jJMenuBar.add(this.getJMenuParticipants());
            this.jJMenuBar.add(this.getJMenuRound());
            this.jJMenuBar.add(this.getJMenuPairing());
            this.jJMenuBar.add(this.getJMenuPrint());
            this.jJMenuBar.add(this.getJMenuHelp());
        }
        return this.jJMenuBar;
    }

    private JMenu getJMenuTournament() {
        if (this.jMenuTournament == null) {
            this.jMenuTournament = new JMenu();
            this.jMenuTournament.setText(Messages.getString("MacMahonMainWindow.TournamentMenu"));
            this.jMenuTournament.add(this.getJMenuItemTournamentNew());
            this.jMenuTournament.add(this.getJMenuItemTournamentOpen());
            this.jMenuTournament.add(this.getJMenuItemTournamentSave());
            this.jMenuTournament.add(this.getJMenuItemTournamentSaveAs());
            this.jMenuTournament.add(this.getJMenuItemTournamentClose());
            this.jMenuTournament.addSeparator();
            this.jMenuTournament.add(this.getJMenuItemTournamentEdit());
            this.jMenuTournament.addSeparator();
            this.jMenuTournament.add(this.getJMenuItemTournamentImportSettings());
            this.jMenuTournament.add(this.getJMenuItemTournamentImportParticipantsTxt());
            this.jMenuTournament.addSeparator();
            this.jMenuTournament.add(this.getJMenuItemTournamentExportCurrentPairing());
            this.jMenuTournament.add(this.getJMenuItemTournamentExportWalllist());
            this.jMenuTournament.add(this.getJMenuItemTournamentExportForEGD());
            this.jMenuTournament.add(this.getMntmExportStatistics());
            this.jMenuTournament.addSeparator();
            this.jMenuTournament.add(this.getJMenuItemQuit());
        }
        return this.jMenuTournament;
    }

    public JMenuItem getJMenuItemTournamentNew() {
        if (this.jMenuItemTournamentNew == null) {
            this.jMenuItemTournamentNew = new JMenuItem();
            this.jMenuItemTournamentNew.setText(Messages.getString("MacMahonMainWindow.TournamentNewMenuItem"));
            this.jMenuItemTournamentNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentNew();
                }
            });
        }
        return this.jMenuItemTournamentNew;
    }

    public JMenuItem getJMenuItemTournamentClose() {
        if (this.jMenuItemTournamentClose == null) {
            this.jMenuItemTournamentClose = new JMenuItem();
            this.jMenuItemTournamentClose.setText(Messages.getString("MacMahonMainWindow.TournamentCloseMenuItem"));
            this.jMenuItemTournamentClose.setEnabled(false);
            this.jMenuItemTournamentClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentClose();
                }
            });
        }
        return this.jMenuItemTournamentClose;
    }

    public JMenu getJMenuParticipants() {
        if (this.jMenuParticipants == null) {
            this.jMenuParticipants = new JMenu();
            this.jMenuParticipants.setText(Messages.getString("MacMahonMainWindow.ParticipantsMenu"));
            this.jMenuParticipants.add(this.getJMenuItemNewIndividualParticipant());
            this.jMenuParticipants.add(this.getJMenuItemParticipantsDeletePreliminaryRegisteredParticipants());
            this.jMenuParticipants.add(this.getJMenuItemSearchParticipant());
            this.jMenuParticipants.addSeparator();
            this.jMenuParticipants.add(this.getJMenuItemEditClubs());
        }
        return this.jMenuParticipants;
    }

    private JMenuItem getJMenuItemNewIndividualParticipant() {
        if (this.jMenuItemNewIndividualParticipant == null) {
            this.jMenuItemNewIndividualParticipant = new JMenuItem();
            this.jMenuItemNewIndividualParticipant.setAccelerator(KeyStroke.getKeyStroke(78, 128));
            this.jMenuItemNewIndividualParticipant.setText(Messages.getString("MacMahonMainWindow.ParticipantNewIndividualMenuItem"));
            this.jMenuItemNewIndividualParticipant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.newIndividualParticipant();
                }
            });
        }
        return this.jMenuItemNewIndividualParticipant;
    }

    public JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setVisible(true);
            this.jTabbedPane.addTab(Messages.getString("MacMahonMainWindow.TabWalllistTitle"), null, this.getJPanelWallList(), null);
            this.jTabbedPane.addTab(Messages.getString("MacMahonMainWindow.TabPairingsTitle"), null, this.getJPanelPairings(), null);
        }
        return this.jTabbedPane;
    }

    public JPanel getJPanelWallList() {
        if (this.jPanelWallList == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            this.jPanelWallList = new JPanel();
            this.jPanelWallList.setLayout(new GridBagLayout());
            this.jPanelWallList.add((Component)this.getJScrollPaneWalllist(), gridBagConstraints1);
        }
        return this.jPanelWallList;
    }

    private JScrollPane getJScrollPaneWalllist() {
        if (this.jScrollPaneWalllist == null) {
            this.jScrollPaneWalllist = new JScrollPane();
            this.jScrollPaneWalllist.setViewportView(this.getJTableWalllist());
        }
        return this.jScrollPaneWalllist;
    }

    public JTable getJTableWalllist() {
        if (this.jTableWalllist == null) {
            this.jTableWalllist = new WalllistTable(this.m_application, 12);
            this.jTableWalllist.setRowSelectionAllowed(false);
            this.jTableWalllist.setAutoResizeMode(0);
            this.jTableWalllist.getTableHeader().setReorderingAllowed(false);
            this.jTableWalllist.getTableHeader().setResizingAllowed(true);
        }
        return this.jTableWalllist;
    }

    public JMenu getJMenuPairing() {
        if (this.jMenuPairing == null) {
            this.jMenuPairing = new JMenu();
            this.jMenuPairing.setText(Messages.getString("MacMahonMainWindow.PairingMenu"));
            this.jMenuPairing.add(this.getJMenuItemMakePairing());
            this.jMenuPairing.add(this.getJMenuItemDropPairing());
            this.jMenuPairing.addSeparator();
            this.jMenuPairing.add(this.getMntmDefineUnwantedPairings());
            this.jMenuPairing.add(this.getJMenuItemEditMakePairingSettings());
            this.jMenuPairing.addSeparator();
            this.jMenuPairing.add(this.getJMenuItemPairingFixBoardNumbers());
            this.jMenuPairing.add(this.getJMenuItemPairingUnfixBoardNumbers());
        }
        return this.jMenuPairing;
    }

    private JMenuItem getJMenuItemMakePairing() {
        if (this.jMenuItemMakePairing == null) {
            this.jMenuItemMakePairing = new JMenuItem();
            this.jMenuItemMakePairing.setText(Messages.getString("MacMahonMainWindow.PairingMakePairingMenuItem"));
            this.jMenuItemMakePairing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.makePairing();
                }
            });
        }
        return this.jMenuItemMakePairing;
    }

    private JPanel getJPanelPairings() {
        if (this.jPanelPairings == null) {
            this.jPanelPairings = new JPanel();
            GridBagLayout gbl_jPanelPairings = new GridBagLayout();
            gbl_jPanelPairings.rowWeights = new double[]{1.0};
            gbl_jPanelPairings.columnWeights = new double[]{1.0};
            this.jPanelPairings.setLayout(gbl_jPanelPairings);
            GridBagConstraints gbc_splitPanePairings = new GridBagConstraints();
            gbc_splitPanePairings.insets = new Insets(0, 0, 5, 0);
            gbc_splitPanePairings.fill = 1;
            gbc_splitPanePairings.gridx = 0;
            gbc_splitPanePairings.gridy = 0;
            this.jPanelPairings.add((Component)this.getSplitPanePairings(), gbc_splitPanePairings);
        }
        return this.jPanelPairings;
    }

    private JScrollPane getJScrollPanePairings() {
        if (this.jScrollPanePairings == null) {
            this.jScrollPanePairings = new JScrollPane();
            this.jScrollPanePairings.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int pairingsWidth = MacMahonMainWindow.this.getJScrollPanePairings().getWidth();
                    int freeParticipantsWidth = MacMahonMainWindow.this.getPanelPairingsFreeParticipants().getWidth();
                    double resizeWeight = (double)pairingsWidth * (1.0 / (double)(pairingsWidth + freeParticipantsWidth));
                    MacMahonMainWindow.this.getSplitPanePairings().setResizeWeight(resizeWeight);
                }
            });
            this.jScrollPanePairings.setViewportView(this.getJTablePairings());
        }
        return this.jScrollPanePairings;
    }

    public JTable getJTablePairings() {
        if (this.jTablePairings == null) {
            this.jTablePairings = new PairingsTable(this.m_application, 12);
            this.jTablePairings.setRowSelectionAllowed(false);
            this.jTablePairings.setAutoResizeMode(0);
            this.jTablePairings.getTableHeader().setReorderingAllowed(false);
            this.jTablePairings.getTableHeader().setResizingAllowed(true);
        }
        return this.jTablePairings;
    }

    private JMenuItem getJMenuItemDropPairing() {
        if (this.jMenuItemDropPairing == null) {
            this.jMenuItemDropPairing = new JMenuItem();
            this.jMenuItemDropPairing.setText(Messages.getString("MacMahonMainWindow.PairingDropPairingMenuItem"));
            this.jMenuItemDropPairing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.dropPairing();
                }
            });
        }
        return this.jMenuItemDropPairing;
    }

    public JMenu getJMenuRound() {
        if (this.jMenuRound == null) {
            this.jMenuRound = new JMenu();
            this.jMenuRound.setText(Messages.getString("MacMahonMainWindow.RoundMenu"));
            this.jMenuRound.add(this.getJMenuItemNextRound());
            this.jMenuRound.add(this.getJMenuItemPreviousRound());
            this.jMenuRound.add(this.getJMenuGotoRound());
            this.jMenuRound.add(this.getMntmLastUpdated());
            this.jMenuRound.add(this.getJCheckBoxMenuItemTakeCurrentRoundInAccount());
        }
        return this.jMenuRound;
    }

    public JCheckBoxMenuItem getJCheckBoxMenuItemTakeCurrentRoundInAccount() {
        if (this.jCheckBoxMenuItemTakeCurrentRoundInAccount == null) {
            this.jCheckBoxMenuItemTakeCurrentRoundInAccount = new JCheckBoxMenuItem();
            this.jCheckBoxMenuItemTakeCurrentRoundInAccount.setText(Messages.getString("MacMahonMainWindow.RoundTakeCurrentRoundInAccountMenuItem"));
            this.jCheckBoxMenuItemTakeCurrentRoundInAccount.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MacMahonMainWindow.this.m_application.setTakeCurrentRoundInAccout(MacMahonMainWindow.this.jCheckBoxMenuItemTakeCurrentRoundInAccount.isSelected());
                }
            });
        }
        return this.jCheckBoxMenuItemTakeCurrentRoundInAccount;
    }

    public JMenuItem getJMenuItemTournamentEdit() {
        if (this.jMenuItemTournamentEdit == null) {
            this.jMenuItemTournamentEdit = new JMenuItem();
            this.jMenuItemTournamentEdit.setAccelerator(KeyStroke.getKeyStroke(69, 128));
            this.jMenuItemTournamentEdit.setEnabled(false);
            this.jMenuItemTournamentEdit.setText(Messages.getString("MacMahonMainWindow.TournamentEditSettingsMenuItem"));
            this.jMenuItemTournamentEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentEditSettings();
                }
            });
        }
        return this.jMenuItemTournamentEdit;
    }

    public JMenuItem getJMenuItemNextRound() {
        if (this.jMenuItemNextRound == null) {
            this.jMenuItemNextRound = new JMenuItem();
            this.jMenuItemNextRound.setAccelerator(KeyStroke.getKeyStroke(521, 128));
            this.jMenuItemNextRound.setText(Messages.getString("MacMahonMainWindow.RoundGotoNextMenuItem"));
            this.jMenuItemNextRound.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.gotoRound(MacMahonMainWindow.this.m_application.getTournament().getCurrentRoundNumber() + 1);
                }
            });
        }
        return this.jMenuItemNextRound;
    }

    public JMenuItem getJMenuItemPreviousRound() {
        if (this.jMenuItemPreviousRound == null) {
            this.jMenuItemPreviousRound = new JMenuItem();
            this.jMenuItemPreviousRound.setAccelerator(KeyStroke.getKeyStroke(45, 128));
            this.jMenuItemPreviousRound.setEnabled(false);
            this.jMenuItemPreviousRound.setText(Messages.getString("MacMahonMainWindow.RoundGotoPreviousMenuItem"));
            this.jMenuItemPreviousRound.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.gotoRound(MacMahonMainWindow.this.m_application.getTournament().getCurrentRoundNumber() - 1);
                }
            });
        }
        return this.jMenuItemPreviousRound;
    }

    public JMenu getJMenuGotoRound() {
        if (this.jMenuGotoRound == null) {
            this.jMenuGotoRound = new JMenu();
            this.jMenuGotoRound.setText(Messages.getString("MacMahonMainWindow.RoundGotoRoundMenu"));
        }
        return this.jMenuGotoRound;
    }

    private JMenuItem getJMenuItemPairingFixBoardNumbers() {
        if (this.jMenuItemPairingFixBoardNumbers == null) {
            this.jMenuItemPairingFixBoardNumbers = new JMenuItem();
            this.jMenuItemPairingFixBoardNumbers.setText(Messages.getString("MacMahonMainWindow.PairingFixBoardNumbersMenuItem"));
            this.jMenuItemPairingFixBoardNumbers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.pairingFixBoardNumbers();
                }
            });
        }
        return this.jMenuItemPairingFixBoardNumbers;
    }

    private JMenuItem getJMenuItemPairingUnfixBoardNumbers() {
        if (this.jMenuItemPairingUnfixBoardNumbers == null) {
            this.jMenuItemPairingUnfixBoardNumbers = new JMenuItem();
            this.jMenuItemPairingUnfixBoardNumbers.setText(Messages.getString("MacMahonMainWindow.PairingUnfixBoardNumbers"));
            this.jMenuItemPairingUnfixBoardNumbers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.pairingUnfixBoardNumbers();
                }
            });
        }
        return this.jMenuItemPairingUnfixBoardNumbers;
    }

    public JMenu getJMenuTest() {
        if (this.jMenuTest == null) {
            this.jMenuTest = new JMenu();
            this.jMenuTest.setText(Messages.getString("MacMahonMainWindow.TestMenu"));
            this.jMenuTest.add(this.getJMenuItemGenerateParticipants());
            this.jMenuTest.add(this.getJMenuItemTestRandomResults());
        }
        return this.jMenuTest;
    }

    private JMenuItem getJMenuItemGenerateParticipants() {
        if (this.jMenuItemGenerateParticipants == null) {
            this.jMenuItemGenerateParticipants = new JMenuItem();
            this.jMenuItemGenerateParticipants.setText(Messages.getString("MacMahonMainWindow.TestGenerateParticipantsMenuItem"));
            this.jMenuItemGenerateParticipants.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.testGenerateParticipants();
                }
            });
        }
        return this.jMenuItemGenerateParticipants;
    }

    private JMenu getJMenuHelp() {
        if (this.jMenuHelp == null) {
            this.jMenuHelp = new JMenu();
            this.jMenuHelp.setText(Messages.getString("MacMahonMainWindow.HelpMenu"));
            this.jMenuHelp.add(this.getJMenuItemHelpAboutMacMahon());
            this.jMenuHelp.addSeparator();
            this.jMenuHelp.add(this.getMenuItemHelpForcedPairings());
            this.jMenuHelp.addSeparator();
            this.jMenuHelp.add(this.getJMenuTest());
        }
        return this.jMenuHelp;
    }

    private JMenuItem getJMenuItemHelpAboutMacMahon() {
        if (this.jMenuItemHelpAboutMacMahon == null) {
            this.jMenuItemHelpAboutMacMahon = new JMenuItem();
            this.jMenuItemHelpAboutMacMahon.setText(Messages.getString("MacMahonMainWindow.HelpAboutMacMahonMenuItem"));
            this.jMenuItemHelpAboutMacMahon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.helpAboutMacMahon();
                }
            });
        }
        return this.jMenuItemHelpAboutMacMahon;
    }

    private JMenuItem getJMenuItemQuit() {
        if (this.jMenuItemQuit == null) {
            this.jMenuItemQuit = new JMenuItem();
            this.jMenuItemQuit.setText(Messages.getString("MacMahonMainWindow.TournamentQuitMenuItem"));
            this.jMenuItemQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.quit();
                }
            });
        }
        return this.jMenuItemQuit;
    }

    public JMenuItem getJMenuItemTournamentOpen() {
        if (this.jMenuItemTournamentOpen == null) {
            this.jMenuItemTournamentOpen = new JMenuItem();
            this.jMenuItemTournamentOpen.setText(Messages.getString("MacMahonMainWindow.TournamentOpenMenuItem"));
            this.jMenuItemTournamentOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentOpen();
                }
            });
        }
        return this.jMenuItemTournamentOpen;
    }

    public JMenuItem getJMenuItemTournamentSave() {
        if (this.jMenuItemTournamentSave == null) {
            this.jMenuItemTournamentSave = new JMenuItem();
            this.jMenuItemTournamentSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
            this.jMenuItemTournamentSave.setText(Messages.getString("MacMahonMainWindow.TournamentSaveMenuItem"));
            this.jMenuItemTournamentSave.setEnabled(false);
            this.jMenuItemTournamentSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentSave();
                }
            });
        }
        return this.jMenuItemTournamentSave;
    }

    public JMenuItem getJMenuItemTournamentSaveAs() {
        if (this.jMenuItemTournamentSaveAs == null) {
            this.jMenuItemTournamentSaveAs = new JMenuItem();
            this.jMenuItemTournamentSaveAs.setText(Messages.getString("MacMahonMainWindow.TournamentSaveAsMenuItem"));
            this.jMenuItemTournamentSaveAs.setEnabled(false);
            this.jMenuItemTournamentSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentSaveAs();
                }
            });
        }
        return this.jMenuItemTournamentSaveAs;
    }

    private JMenuItem getJMenuItemEditMakePairingSettings() {
        if (this.jMenuItemEditMakePairingSettings == null) {
            this.jMenuItemEditMakePairingSettings = new JMenuItem();
            this.jMenuItemEditMakePairingSettings.setText(Messages.getString("MacMahonMainWindow.PairingMakePairingSettingsMenuItem"));
            this.jMenuItemEditMakePairingSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.makePairingEditSettings();
                }
            });
        }
        return this.jMenuItemEditMakePairingSettings;
    }

    private JMenuItem getJMenuItemEditClubs() {
        if (this.jMenuItemEditClubs == null) {
            this.jMenuItemEditClubs = new JMenuItem();
            this.jMenuItemEditClubs.setText(Messages.getString("MacMahonMainWindow.ParticipantsEditClubsMenuItem"));
            this.jMenuItemEditClubs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.participantsEditClubs();
                }
            });
        }
        return this.jMenuItemEditClubs;
    }

    private JMenuItem getJMenuItemParticipantsDeletePreliminaryRegisteredParticipants() {
        if (this.jMenuItemParticipantsDeletePreliminaryRegisteredParticipants == null) {
            this.jMenuItemParticipantsDeletePreliminaryRegisteredParticipants = new JMenuItem();
            this.jMenuItemParticipantsDeletePreliminaryRegisteredParticipants.setText(Messages.getString("MacMahonMainWindow.ParticipantsDeletePreliminaryMenuItem"));
            this.jMenuItemParticipantsDeletePreliminaryRegisteredParticipants.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.participantsDeletePreliminaryRegisteredParticipants();
                }
            });
        }
        return this.jMenuItemParticipantsDeletePreliminaryRegisteredParticipants;
    }

    private JMenuItem getJMenuItemTestRandomResults() {
        if (this.jMenuItemTestRandomResults == null) {
            this.jMenuItemTestRandomResults = new JMenuItem();
            this.jMenuItemTestRandomResults.setText(Messages.getString("MacMahonMainWindow.TestRandomResultsMenuItem"));
            this.jMenuItemTestRandomResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.testRandomResults();
                }
            });
        }
        return this.jMenuItemTestRandomResults;
    }

    public JMenuItem getJMenuItemTournamentExportForEGD() {
        if (this.jMenuItemTournamentExportForEGD == null) {
            this.jMenuItemTournamentExportForEGD = new JMenuItem();
            this.jMenuItemTournamentExportForEGD.setText(Messages.getString("MacMahonMainWindow.TournamentExportForEGDMenuItem"));
            this.jMenuItemTournamentExportForEGD.setEnabled(false);
            this.jMenuItemTournamentExportForEGD.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentExportForEGD();
                }
            });
        }
        return this.jMenuItemTournamentExportForEGD;
    }

    public JMenuItem getJMenuItemTournamentImportParticipantsTxt() {
        if (this.jMenuItemTournamentImportParticipantsTxt == null) {
            this.jMenuItemTournamentImportParticipantsTxt = new JMenuItem();
            this.jMenuItemTournamentImportParticipantsTxt.setText(Messages.getString("MacMahonMainWindow.TournamentImportParticipantsTxtMenuItem"));
            this.jMenuItemTournamentImportParticipantsTxt.setEnabled(false);
            this.jMenuItemTournamentImportParticipantsTxt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentImportParticipantsTxt();
                }
            });
        }
        return this.jMenuItemTournamentImportParticipantsTxt;
    }

    public JMenuItem getJMenuItemTournamentExportCurrentPairing() {
        if (this.jMenuItemTournamentExportCurrentPairing == null) {
            this.jMenuItemTournamentExportCurrentPairing = new JMenuItem();
            this.jMenuItemTournamentExportCurrentPairing.setText(Messages.getString("MacMahonMainWindow.TournamentExportPairingMenuItem"));
            this.jMenuItemTournamentExportCurrentPairing.setEnabled(false);
            this.jMenuItemTournamentExportCurrentPairing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentExportCurrentPairing();
                }
            });
        }
        return this.jMenuItemTournamentExportCurrentPairing;
    }

    public JMenuItem getJMenuItemTournamentExportWalllist() {
        if (this.jMenuItemTournamentExportWalllist == null) {
            this.jMenuItemTournamentExportWalllist = new JMenuItem();
            this.jMenuItemTournamentExportWalllist.setText(Messages.getString("MacMahonMainWindow.TournamentExportWalllistMenuItem"));
            this.jMenuItemTournamentExportWalllist.setEnabled(false);
            this.jMenuItemTournamentExportWalllist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentExportWalllist();
                }
            });
        }
        return this.jMenuItemTournamentExportWalllist;
    }

    public JMenu getJMenuPrint() {
        if (this.jMenuPrint == null) {
            this.jMenuPrint = new JMenu();
            this.jMenuPrint.setText(Messages.getString("MacMahonMainWindow.PrintMenu"));
            this.jMenuPrint.add(this.getJMenuItemPrintPairings());
            this.jMenuPrint.add(this.getJMenuItemPrintWalllist());
            this.jMenuPrint.addSeparator();
            this.jMenuPrint.add(this.getJMenuItemPrintEditSettings());
        }
        return this.jMenuPrint;
    }

    private JMenuItem getJMenuItemPrintPairings() {
        if (this.jMenuItemPrintPairings == null) {
            this.jMenuItemPrintPairings = new JMenuItem();
            this.jMenuItemPrintPairings.setText(Messages.getString("MacMahonMainWindow.PrintPairingsMenuItem"));
            this.jMenuItemPrintPairings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.printPairings();
                }
            });
        }
        return this.jMenuItemPrintPairings;
    }

    private JMenuItem getJMenuItemPrintWalllist() {
        if (this.jMenuItemPrintWalllist == null) {
            this.jMenuItemPrintWalllist = new JMenuItem();
            this.jMenuItemPrintWalllist.setText(Messages.getString("MacMahonMainWindow.PrintWalllistMenuItem"));
            this.jMenuItemPrintWalllist.setVisible(true);
            this.jMenuItemPrintWalllist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.printWalllist();
                }
            });
        }
        return this.jMenuItemPrintWalllist;
    }

    public JMenuItem getJMenuItemTournamentImportSettings() {
        if (this.jMenuItemTournamentImportSettings == null) {
            this.jMenuItemTournamentImportSettings = new JMenuItem();
            this.jMenuItemTournamentImportSettings.setText(Messages.getString("MacMahonMainWindow.TournamentImportSettings"));
            this.jMenuItemTournamentImportSettings.setEnabled(false);
            this.jMenuItemTournamentImportSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentImportSettings();
                }
            });
        }
        return this.jMenuItemTournamentImportSettings;
    }

    public JLabel getJLabelGlobalMessageLabel() {
        return this.jLabelGlobalMessageLabel;
    }

    public JLabel getJLabelGlobalMessage() {
        return this.jLabelGlobalMessage;
    }

    private JMenuItem getJMenuItemPrintEditSettings() {
        if (this.jMenuItemPrintEditSettings == null) {
            this.jMenuItemPrintEditSettings = new JMenuItem();
            this.jMenuItemPrintEditSettings.setText(Messages.getString("MacMahonMainWindow.PrintEditSettings"));
            this.jMenuItemPrintEditSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.printEditSettings();
                }
            });
        }
        return this.jMenuItemPrintEditSettings;
    }

    private JMenuItem getJMenuItemSearchParticipant() {
        if (this.jMenuItemSearchParticipant == null) {
            this.jMenuItemSearchParticipant = new JMenuItem();
            this.jMenuItemSearchParticipant.setAccelerator(KeyStroke.getKeyStroke(70, 128));
            this.jMenuItemSearchParticipant.setText(Messages.getString("MacMahonMainWindow.ParticipantsFindParticipantsMenuItem"));
            this.jMenuItemSearchParticipant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.searchParticipant();
                }
            });
        }
        return this.jMenuItemSearchParticipant;
    }

    private JMenuItem getMenuItemHelpForcedPairings() {
        if (this.menuItemHelpForcedPairings == null) {
            this.menuItemHelpForcedPairings = new JMenuItem(Messages.getString("MacMahonMainWindow.HelpOnForcedPairings"));
            this.menuItemHelpForcedPairings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.helpForcedPairings();
                }
            });
        }
        return this.menuItemHelpForcedPairings;
    }

    public JSplitPane getSplitPanePairings() {
        if (this.splitPanePairings == null) {
            this.splitPanePairings = new JSplitPane();
            this.splitPanePairings.setOneTouchExpandable(true);
            this.splitPanePairings.setLeftComponent(this.getJScrollPanePairings());
            this.splitPanePairings.setRightComponent(this.getPanelPairingsFreeParticipants());
            this.splitPanePairings.setDividerLocation(710);
        }
        return this.splitPanePairings;
    }

    private JPanel getPanelPairingsFreeParticipants() {
        if (this.panelPairingsFreeParticipants == null) {
            this.panelPairingsFreeParticipants = new JPanel();
            GridBagLayout gbl_panelPairingsFreeParticipants = new GridBagLayout();
            gbl_panelPairingsFreeParticipants.columnWidths = new int[2];
            gbl_panelPairingsFreeParticipants.rowHeights = new int[4];
            gbl_panelPairingsFreeParticipants.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_panelPairingsFreeParticipants.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
            this.panelPairingsFreeParticipants.setLayout(gbl_panelPairingsFreeParticipants);
            GridBagConstraints gbc_lblFreeParticipants = new GridBagConstraints();
            gbc_lblFreeParticipants.anchor = 17;
            gbc_lblFreeParticipants.insets = new Insets(0, 0, 5, 0);
            gbc_lblFreeParticipants.gridx = 0;
            gbc_lblFreeParticipants.gridy = 0;
            this.panelPairingsFreeParticipants.add((Component)this.getLblFreeParticipants(), gbc_lblFreeParticipants);
            GridBagConstraints gbc_scrollPaneFreeParticipants = new GridBagConstraints();
            gbc_scrollPaneFreeParticipants.insets = new Insets(0, 0, 5, 0);
            gbc_scrollPaneFreeParticipants.fill = 1;
            gbc_scrollPaneFreeParticipants.gridx = 0;
            gbc_scrollPaneFreeParticipants.gridy = 1;
            this.panelPairingsFreeParticipants.add((Component)this.getScrollPaneFreeParticipants(), gbc_scrollPaneFreeParticipants);
            GridBagConstraints gbc_btnMakePairing = new GridBagConstraints();
            gbc_btnMakePairing.fill = 2;
            gbc_btnMakePairing.gridx = 0;
            gbc_btnMakePairing.gridy = 2;
            this.panelPairingsFreeParticipants.add((Component)this.getBtnMakePairing(), gbc_btnMakePairing);
        }
        return this.panelPairingsFreeParticipants;
    }

    private JLabel getLblFreeParticipants() {
        if (this.lblFreeParticipants == null) {
            this.lblFreeParticipants = new JLabel(Messages.getString("MacMahonMainWindow.FreeParticipantsLabel"));
        }
        return this.lblFreeParticipants;
    }

    private JScrollPane getScrollPaneFreeParticipants() {
        if (this.scrollPaneFreeParticipants == null) {
            this.scrollPaneFreeParticipants = new JScrollPane();
            this.scrollPaneFreeParticipants.setViewportView(this.getListFreeParticipants());
        }
        return this.scrollPaneFreeParticipants;
    }

    public JList<Participant> getListFreeParticipants() {
        if (this.listFreeParticipants == null) {
            this.listFreeParticipants = new JList();
            this.listFreeParticipants.setDragEnabled(true);
            PairingsFreeParticipantsListModel listFreeParticipantsModel = new PairingsFreeParticipantsListModel();
            listFreeParticipantsModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    MacMahonMainWindow.this.listFreeParticipants.clearSelection();
                }
            });
            this.listFreeParticipants.setModel(listFreeParticipantsModel);
            this.listFreeParticipants.setCellRenderer(new ListCellRenderer<Participant>(){
                protected DefaultListCellRenderer m_defaultRenderer = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends Participant> list, Participant value, int index, boolean isSelected, boolean cellHasFocus) {
                    Country nationality;
                    JLabel renderer = (JLabel)this.m_defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    renderer.setText(value.getFreeParticipantDisplayString());
                    StringBuilder sb = new StringBuilder(160);
                    sb.append("<html><strong>");
                    sb.append(value.getPairingDisplayString());
                    sb.append("</strong>");
                    String clubDisplay = value.getClubDisplayString();
                    if (clubDisplay != null) {
                        sb.append("<br/>");
                        sb.append(Messages.getString("EditIndividualParticipantDialog.ClubLabel"));
                        sb.append(" ");
                        sb.append(clubDisplay);
                    }
                    if (value instanceof IndividualParticipant && (nationality = ((IndividualParticipant)value).getGoPlayer().getNationality()) != null) {
                        sb.append("<br/>");
                        sb.append(Messages.getString("EditIndividualParticipantDialog.NationalityLabel"));
                        sb.append(" ");
                        sb.append(nationality.getName());
                    }
                    sb.append("<br/>");
                    sb.append(Walllist.SCD_SOS.getLongName());
                    sb.append(": ");
                    sb.append(value.getSosDisplayString());
                    sb.append("</html>");
                    renderer.setToolTipText(sb.toString());
                    return renderer;
                }
            });
        }
        return this.listFreeParticipants;
    }

    private JButton getBtnMakePairing() {
        if (this.btnMakePairing == null) {
            this.btnMakePairing = new JButton(Messages.getString("MacMahonMainWindow.MakePairingButtonLabel"));
            this.btnMakePairing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedParticipantIndices = MacMahonMainWindow.this.getListFreeParticipants().getSelectedIndices();
                    if (selectedParticipantIndices.length > 0) {
                        ArrayList<Participant> participants = new ArrayList<Participant>();
                        int[] nArray = selectedParticipantIndices;
                        int n = selectedParticipantIndices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int index = nArray[n2];
                            participants.add(((PairingsFreeParticipantsListModel)MacMahonMainWindow.this.getListFreeParticipants().getModel()).getParticipantAt(index));
                            ++n2;
                        }
                        MacMahonMainWindow.this.m_application.makePairing(participants);
                    }
                }
            });
        }
        return this.btnMakePairing;
    }

    private JMenuItem getMntmDefineUnwantedPairings() {
        if (this.mntmDefineUnwantedPairings == null) {
            this.mntmDefineUnwantedPairings = new JMenuItem(Messages.getString("MacMahonMainWindow.mntmDefineUnwantedPairings.text", "Edit unwanted pairings ..."));
            this.mntmDefineUnwantedPairings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.editUnwantedPairings();
                }
            });
        }
        return this.mntmDefineUnwantedPairings;
    }

    public JMenuItem getMntmExportStatistics() {
        if (this.mntmExportStatistics == null) {
            this.mntmExportStatistics = new JMenuItem(Messages.getString("MacMahonMainWindow.mntmExportStatistics.text", "Export statistics ..."));
            this.mntmExportStatistics.setEnabled(false);
            this.mntmExportStatistics.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonMainWindow.this.m_application.tournamentExportStatistics();
                }
            });
        }
        return this.mntmExportStatistics;
    }

    public JMenuItem getMntmLastUpdated() {
        if (this.mntmLastUpdated == null) {
            this.mntmLastUpdated = new JMenuItem(Messages.getString("MacMahonMainWindow.mntmLastUpdated.text", "Last updated:"));
            this.mntmLastUpdated.setEnabled(false);
        }
        return this.mntmLastUpdated;
    }

    private static class GotoRoundActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private MacMahonApplication m_application;
        private int m_gotoRound;

        public GotoRoundActionListener(MacMahonApplication application, int gotoRound) {
            this.m_application = application;
            this.m_gotoRound = gotoRound;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.m_application.gotoRound(this.m_gotoRound);
        }
    }
}

