/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.gui.DisplayMacMahonExceptionDialog;
import de.cgerlach.macmahon.gui.EditClubsDialog;
import de.cgerlach.macmahon.gui.EditIndividualParticipantDialog;
import de.cgerlach.macmahon.gui.EditMakePairingSettingsDialog;
import de.cgerlach.macmahon.gui.EditPairingDialog;
import de.cgerlach.macmahon.gui.EditPrintSettingsDialog;
import de.cgerlach.macmahon.gui.EditTournamentSettingsDialog;
import de.cgerlach.macmahon.gui.EditUnwantedPairingsDialog;
import de.cgerlach.macmahon.gui.MacMahonMainWindow;
import de.cgerlach.macmahon.gui.MakePairingDialog;
import de.cgerlach.macmahon.gui.PairingsFreeParticipantsListModel;
import de.cgerlach.macmahon.gui.PairingsTable;
import de.cgerlach.macmahon.gui.PairingsTableModel;
import de.cgerlach.macmahon.gui.SearchParticipantDialog;
import de.cgerlach.macmahon.gui.WalllistTable;
import de.cgerlach.macmahon.gui.WalllistTableModel;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.GoPlayer;
import de.cgerlach.macmahon.model.IndividualParticipant;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.TournamentRound;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DateFormatter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MacMahonApplication
implements TournamentRound.LastUpdatedListener {
    public static final String APPLICATION_NAME = "MacMahon";
    public static final String APPLICATION_VERSION = "3.10";
    public static final String NEWLINE = "\r\n";
    public static final String TAB = "\t";
    private MacMahonMainWindow m_mainWindow;
    private Tournament m_tournament;
    private String m_defaultFilePath;

    public static void main(String[] args) {
        Tournament tournament;
        File file;
        MacMahonApplication application = new MacMahonApplication();
        application.run();
        boolean tournamentOpened = false;
        if (args.length > 0 && (file = new File(args[0])).exists() && file.isFile() && (tournament = application.tournamentOpenInternal(file)) != null) {
            application.m_tournament = tournament;
            application.tournamentOpened();
            tournamentOpened = true;
        }
        if (!tournamentOpened) {
            try {
                File startDirectory = new File(application.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
                application.m_defaultFilePath = startDirectory.getAbsolutePath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private MacMahonApplication() {
        ToolTipManager.sharedInstance().setInitialDelay(2000);
        ToolTipManager.sharedInstance().setDismissDelay(6000);
    }

    public void buildRoundMenuItems() {
        this.m_mainWindow.getJMenuItemPreviousRound().setEnabled(this.m_tournament.getCurrentRoundNumber() != 1);
        this.m_mainWindow.getJMenuItemNextRound().setEnabled(this.m_tournament.getCurrentRoundNumber() != this.m_tournament.getNumberOfRounds());
        this.m_mainWindow.getJMenuGotoRound().removeAll();
        int i = 0;
        while (i < this.m_tournament.getNumberOfRounds()) {
            JMenuItem gotoRoundMenuItem = new JMenuItem();
            gotoRoundMenuItem.setText(Integer.toString(i + 1));
            gotoRoundMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacMahonApplication.this.gotoRound(Integer.parseInt(((JMenuItem)e.getSource()).getText()));
                }
            });
            this.m_mainWindow.getJMenuGotoRound().add(gotoRoundMenuItem);
            ++i;
        }
    }

    public void buildMainWindowTitle() {
        Object title = "MacMahon 3.10";
        if (this.m_tournament != null) {
            title = (String)title + " - ";
            title = (String)title + this.m_tournament.getNameRoundDisplayString();
        }
        this.m_mainWindow.getJFrame().setTitle((String)title);
    }

    public Pairing createForcedPairing(Participant p1, Participant p2) {
        try {
            if (!p1.isValid()) {
                throw new MacMahonException(Messages.getString("MacMahonApplication.ParticipantNotValidExceptionMessage", p1.getName()));
            }
            if (!p2.isValid()) {
                throw new MacMahonException(Messages.getString("MacMahonApplication.ParticipantNotValidExceptionMessage", p2.getName()));
            }
            int count = p1.getAlreadyPlayed(p2);
            if (count == 0 || JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmForcedPairingAlreadyExists", p1.getPairingDisplayString(), p2.getPairingDisplayString(), Integer.toString(count)), Messages.getString("MacMahonApplication.ConfirmForcedPairingAlreadyExistsTitle"), 0) == 0) {
                Pairing newPairing = this.m_tournament.createForcedPairing(p1, p2);
                this.fireWalllistTableDataChanged();
                this.firePairingsTableDataChanged();
                this.setGlobalMessage(Messages.getString("MacMahonApplication.ForcedPairingCreatedPairingMessage"));
                return newPairing;
            }
        }
        catch (MacMahonException exception) {
            new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
        }
        return null;
    }

    public Pairing createForcedPairingWithBye(Participant participant) {
        try {
            if (!participant.isValid()) {
                throw new MacMahonException(Messages.getString("MacMahonApplication.ParticipantNotValidExceptionMessage", participant.getName()));
            }
            int count = participant.getAlreadyPlayedWithBye();
            if (count == 0 || JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmForcedPairingWithByeAlreadyExists", participant.getPairingDisplayString(), Integer.toString(count)), Messages.getString("MacMahonApplication.ConfirmForcedPairingAlreadyExistsTitle"), 0) == 0) {
                Pairing newPairing = this.m_tournament.createForcedPairingWithBye(participant);
                this.fireWalllistTableDataChanged();
                this.firePairingsTableDataChanged();
                this.setGlobalMessage(Messages.getString("MacMahonApplication.ForcedPairingCreatedPairingWithByeMessage"));
                return newPairing;
            }
        }
        catch (MacMahonException exception) {
            new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
        }
        return null;
    }

    public void editUnwantedPairings() {
        EditUnwantedPairingsDialog dialog = new EditUnwantedPairingsDialog((Component)this.m_mainWindow.getJFrame(), this.m_tournament);
        dialog.setVisible(true);
        this.firePairingsTableDataChanged();
    }

    public void dropPairing() {
        int result = JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmDropPairings"), Messages.getString("MacMahonApplication.Pairings"), 0);
        if (result == 0) {
            this.m_tournament.dropPairing();
            ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
            ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableStructureChanged();
        }
    }

    public void editParticipant(Participant participant) {
        if (participant instanceof IndividualParticipant) {
            EditIndividualParticipantDialog dialog = new EditIndividualParticipantDialog(this, this.m_tournament, (IndividualParticipant)participant, false);
            dialog.show(this.m_mainWindow.getJFrame());
            ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
            ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableStructureChanged();
        }
    }

    public void fireWalllistTableDataChanged() {
        ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
    }

    public void firePairingsTableDataChanged() {
        ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableDataChanged();
    }

    public Tournament getTournament() {
        return this.m_tournament;
    }

    public void gotoRound(int gotoRound) {
        if (this.m_tournament != null && gotoRound > 0 && gotoRound <= this.m_tournament.getNumberOfRounds() && this.m_tournament.getCurrentRoundNumber() != gotoRound) {
            this.m_tournament.getCurrentRound().unregisterLastUpdatedListener(this);
            this.m_tournament.setCurrentRoundNumber(gotoRound);
            this.m_tournament.getCurrentRound().registerLastUpdatedListener(this);
            this.tournamentRoundLastUpdatedChanged(this.m_tournament.getCurrentRound());
            this.buildMainWindowTitle();
            this.buildRoundMenuItems();
            ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableStructureChanged();
            ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableDataChanged();
        }
    }

    public void helpAboutMacMahon() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        style.append("background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");");
        String aboutMessage = "<html><body style=\"" + style.toString() + "\">MacMahon 3.10<br/><br/>The implemented algorithm guarantees the global optimum for all players.<br/>Optimisation is done by Edmonds' maximum weight perfect matching algorithm.<br/><br/>Licence:<br/><blockquote>This software is provided as is with no warranty. Licence is granted to use<br/>MacMahon at tournaments of all kinds without charge. Anyway, if I attend your<br/>tournament you have to let me participate without charging me an entry fee<br/>for the tournament itself (not including costs for food, accomodation, ...).</blockquote><br/>Contributors:<br/><blockquote>Andrea Partiti (translation to Italian/it)<br/>Volodymyr Kachanovskyi (translation to Ukrainian/uk)<br/>Alexander Eckert (basic Java code to import old tur-files)<br/></blockquote><br/>Author/Contact:<br/><blockquote>Christoph Gerlach, In der Steinriede 3, 30161 Hannover, Germany<br/>e-mail: christoph@cgerlach.de<br/><a href=\"http://www.cgerlach.de/go/macmahon.html\">http://www.cgerlach.de/go/macmahon.html</a><br/></blockquote><br/>\u00a91994-2020 by Christoph Gerlach</body></html>";
        JEditorPane ep = new JEditorPane("text/html", aboutMessage);
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Desktop desktop;
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(e.getURL().toURI());
                    }
                    catch (IOException e2) {
                        new DisplayMacMahonExceptionDialog(new MacMahonException("IOException while opening hyperlink.", e2)).show(MacMahonApplication.this.m_mainWindow.getJFrame());
                    }
                    catch (URISyntaxException e3) {
                        new DisplayMacMahonExceptionDialog(new MacMahonException("URISyntaxException while opening hyperlink.", e3)).show(MacMahonApplication.this.m_mainWindow.getJFrame());
                    }
                }
            }
        });
        ep.setEditable(false);
        ep.setBackground(label.getBackground());
        JOptionPane.showMessageDialog(this.m_mainWindow.getJFrame(), ep, Messages.getString("MacMahonApplication.AboutTitle"), -1);
    }

    public void helpForcedPairings() {
        String message = "'Forced Pairing' is the manual pairing of players by the tournament director.\n\nThere are two ways to create forced pairings, one is working in the walllist view and the other in the pairings view.\n\nOn the walllist tab:\n  1. Be sure to be in the round in which you want to create a forced pairing.\n  2. Right click on the first player's name you want to be part of a forced pairing to open the popup menu.\n  3. Select this player for a forced pairing or create a forced pairing with a bye.\n  4. Right click on the player's name you want to be paired to the previously selected player to open the popup menu.\n  5. Create the forced pairing with the previously selected player.\n  6. To edit colors or handicap manually or to delete the pairing, double click on the pairing.\n\nOn the pairings tab:\n  1. Be sure to be in the round in which you want to create a forced pairing.\n  2. Select the players in question from the sidebar in the \"free participants\" list (shift + ctrl keys supported).\n  3. Press the \"Make Pairing\" button.";
        JOptionPane.showMessageDialog(this.m_mainWindow.getJFrame(), message, "Help on Forced Pairings", -1);
    }

    public void makePairing() {
        block6: {
            MakePairingDialog dialog = new MakePairingDialog(this.m_tournament);
            dialog.show(this.m_mainWindow.getJFrame());
            if (dialog.getMakePairing()) {
                try {
                    try {
                        this.m_mainWindow.getJFrame().setCursor(Cursor.getPredefinedCursor(3));
                        this.setGlobalMessage(this.m_tournament.makePairing());
                    }
                    catch (MacMahonException exception) {
                        this.m_mainWindow.getJFrame().setCursor(null);
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        this.m_mainWindow.getJFrame().setCursor(null);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.m_mainWindow.getJFrame().setCursor(null);
                    throw throwable;
                }
                this.m_mainWindow.getJFrame().setCursor(null);
            }
        }
        ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
        ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableStructureChanged();
    }

    public void setGlobalMessage(String message) {
        this.m_mainWindow.getJLabelGlobalMessage().setText(message);
    }

    public void makePairing(List<Participant> participants) {
        if (participants.size() == 1) {
            this.createForcedPairingWithBye(participants.get(0));
        } else if (participants.size() == 2) {
            this.createForcedPairing(participants.get(0), participants.get(1));
        } else {
            block9: {
                try {
                    try {
                        this.m_mainWindow.getJFrame().setCursor(Cursor.getPredefinedCursor(3));
                        this.setGlobalMessage(this.m_tournament.makePairing(participants, true));
                    }
                    catch (MacMahonException exception) {
                        this.m_mainWindow.getJFrame().setCursor(null);
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        this.m_mainWindow.getJFrame().setCursor(null);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.m_mainWindow.getJFrame().setCursor(null);
                    throw throwable;
                }
                this.m_mainWindow.getJFrame().setCursor(null);
            }
            ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
            ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableStructureChanged();
        }
    }

    public void makePairingEditSettings() {
        new EditMakePairingSettingsDialog(this.m_tournament).show(this.m_mainWindow.getJFrame());
    }

    public void newIndividualParticipant() {
        GoPlayer goPlayer = new GoPlayer(this.m_tournament);
        goPlayer.setAsianName(this.m_tournament.getDefaultAsianName());
        goPlayer.setCountry(this.m_tournament.getDefaultCountry());
        goPlayer.setNationality(this.m_tournament.getDefaultNationality());
        IndividualParticipant individualParticipant = new IndividualParticipant(this.m_tournament, goPlayer);
        individualParticipant.setPreliminaryRegistration(this.m_tournament.getDefaultPreliminaryRegistration());
        if (!individualParticipant.getPreliminaryRegistration()) {
            int i = 1;
            while (i <= this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1)) {
                individualParticipant.setPairingInRound(Pairing.NOT_PLAYING, i);
                ++i;
            }
        }
        EditIndividualParticipantDialog dialog = new EditIndividualParticipantDialog(this, this.m_tournament, individualParticipant, true);
        dialog.show(this.m_mainWindow.getJFrame());
        if (dialog.isOk()) {
            this.m_tournament.addParticipant(individualParticipant);
            this.fireWalllistTableDataChanged();
            if (dialog.getOpenNewDialogOnOk()) {
                this.newIndividualParticipant();
            }
        }
    }

    public void pairingChangeResultToNext(Pairing pairing) {
        if (!pairing.isPairingWithBye()) {
            pairing.changeResultToNext();
            this.fireWalllistTableDataChanged();
            this.firePairingsTableDataChanged();
        }
    }

    public void pairingChangeResultToPrevious(Pairing pairing) {
        if (!pairing.isPairingWithBye()) {
            pairing.changeResultToPrevious();
            this.fireWalllistTableDataChanged();
            this.firePairingsTableDataChanged();
        }
    }

    public boolean pairingDelete(Pairing pairing) {
        int result = JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmDeletePairing"), "Pairing", 0);
        if (result == 0) {
            this.pairingDeleteInternal(pairing);
            return true;
        }
        return false;
    }

    public void pairingDeleteInternal(Pairing pairing) {
        this.m_tournament.getWalllist().blockSort();
        pairing.delete();
        this.m_tournament.getWalllist().unblockSort();
        this.fireWalllistTableDataChanged();
        this.firePairingsTableDataChanged();
    }

    public void pairingEdit(Pairing pairing) {
        EditPairingDialog dialog = new EditPairingDialog(this, pairing);
        dialog.show(this.m_mainWindow.getJFrame());
        this.fireWalllistTableDataChanged();
        this.firePairingsTableDataChanged();
    }

    public void pairingFixBoardNumbers() {
        int affectedCount = this.m_tournament.getCurrentRound().fixBoardNumbers();
        this.setGlobalMessage(Messages.getString("MacMahonApplication.BoardNumbersFixedMessage", Integer.toString(affectedCount)));
        this.firePairingsTableDataChanged();
    }

    public void pairingSwapColorsIncludingResult(Pairing pairing) {
        pairing.swapColorsIncludingResult();
        this.fireWalllistTableDataChanged();
        this.firePairingsTableDataChanged();
    }

    public void pairingUnfixBoardNumbers() {
        int affectedCount = this.m_tournament.getCurrentRound().unfixBoardNumbers();
        this.firePairingsTableDataChanged();
        this.setGlobalMessage(Messages.getString("MacMahonApplication.BoardNumbersUnfixedMessage", Integer.toString(affectedCount)));
    }

    public boolean participantDelete(Participant participant) {
        return this.participantDelete(participant, this.m_mainWindow.getJFrame());
    }

    public boolean participantDelete(Participant participant, Component parentComponent) {
        int result = JOptionPane.showConfirmDialog(parentComponent, Messages.getString("MacMahonApplication.ConfirmDeleteParticipant"), Messages.getString("MacMahonApplication.Participant"), 0);
        if (result == 0) {
            this.m_tournament.deleteParticipant(participant);
            this.fireWalllistTableDataChanged();
            ((WalllistTable)this.m_mainWindow.getJTableWalllist()).cancelForcedPairing();
            return true;
        }
        return false;
    }

    public void participantsDeletePreliminaryRegisteredParticipants() {
        int result = JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmDeletePreliminaryParticipants"), Messages.getString("MacMahonApplication.Registration"), 0);
        if (result == 0) {
            this.m_tournament.deletePreliminaryRegisteredParticipants();
            this.fireWalllistTableDataChanged();
            ((WalllistTable)this.m_mainWindow.getJTableWalllist()).cancelForcedPairing();
        }
    }

    public void participantsEditClubs() {
        EditClubsDialog dialog = new EditClubsDialog(this.m_tournament);
        dialog.show(this.m_mainWindow.getJFrame());
        this.fireWalllistTableDataChanged();
    }

    public void printEditSettings() {
        EditPrintSettingsDialog dialog = new EditPrintSettingsDialog(this.m_tournament);
        dialog.show(this.m_mainWindow.getJFrame());
    }

    public void printPairings() {
        block6: {
            if (this.m_tournament.getCurrentRound().getPairings().size() == 0) {
                JOptionPane.showMessageDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.MessageNoPairingsToPrint"));
            } else {
                try {
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    pj.setPrintable(new Tournament.PairingsPrinter(this.m_tournament));
                    if (!pj.printDialog()) break block6;
                    try {
                        pj.print();
                        this.m_tournament.getCurrentRound().fixBoardNumbers();
                        this.firePairingsTableDataChanged();
                    }
                    catch (PrinterException exc) {
                        throw new MacMahonException(Messages.getString("MacMahonApplication.PrinterExceptionOnPrintPairings"), exc);
                    }
                }
                catch (MacMahonException exception) {
                    new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                }
            }
        }
    }

    public void printWalllist() {
        block6: {
            if (this.m_tournament.getWalllist().getParticipantCount() == 0) {
                JOptionPane.showMessageDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.MessageNoWalllistToPrint"));
            } else {
                try {
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    pj.setPrintable(new Tournament.WalllistPrinter(this.m_tournament));
                    if (!pj.printDialog()) break block6;
                    try {
                        pj.print();
                    }
                    catch (PrinterException exc) {
                        throw new MacMahonException(Messages.getString("MacMahonApplication.PrinterExceptionOnPrintWalllist"), exc);
                    }
                }
                catch (MacMahonException exception) {
                    new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                }
            }
        }
    }

    public void quit() {
        if (this.m_tournament != null) {
            int result = JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmCloseApplication"), APPLICATION_NAME, 1);
            if (result == 0 ? (result = this.tournamentSave()) == 2 : result == 2) {
                return;
            }
            this.tournamentCloseInternal();
        }
        System.exit(0);
    }

    private void run() {
        this.m_mainWindow = new MacMahonMainWindow(this);
        this.m_mainWindow.setupWindow();
        this.buildMainWindowTitle();
    }

    public void searchParticipant() {
        SearchParticipantDialog dialog = new SearchParticipantDialog(this);
        dialog.show(this.m_mainWindow.getJFrame());
    }

    public void setTakeCurrentRoundInAccout(boolean takeCurrentRoundInAccount) {
        this.m_tournament.setTakeCurrentRoundInAccount(takeCurrentRoundInAccount);
        if (this.m_mainWindow.getJTableWalllist().getModel() instanceof WalllistTableModel) {
            ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
        }
        this.buildMainWindowTitle();
    }

    public void testGenerateParticipants() {
        this.m_tournament.getWalllist().blockSort();
        this.m_tournament.getCurrentRound().blockSort();
        int i = 0;
        while (i < 100) {
            GoPlayer newGoPlayer = new GoPlayer(this.m_tournament);
            newGoPlayer.setSurname("Player_" + (i + 1));
            IndividualParticipant newParticipant = new IndividualParticipant(this.m_tournament, newGoPlayer);
            newParticipant.setGoLevel(GoLevel.getRandomGoLevel(false));
            newParticipant.getGoPlayer().setCountry(this.m_tournament.getDefaultCountry());
            newParticipant.getGoPlayer().setNationality(this.m_tournament.getDefaultNationality());
            newParticipant.setPreliminaryRegistration(this.m_tournament.getDefaultPreliminaryRegistration());
            if (!newParticipant.getPreliminaryRegistration()) {
                int round = 1;
                while (round <= this.m_tournament.getCurrentRoundNumber() - (this.m_tournament.takeCurrentRoundInAccount() ? 0 : 1)) {
                    newParticipant.setPairingInRound(Pairing.NOT_PLAYING, round);
                    ++round;
                }
            }
            this.m_tournament.addParticipant(newParticipant);
            ++i;
        }
        this.m_tournament.getCurrentRound().unblockSort();
        this.m_tournament.getWalllist().unblockSort();
        ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
    }

    public void testRandomResults() {
        this.m_tournament.getWalllist().blockSort();
        this.m_tournament.getCurrentRound().blockSort();
        List<Pairing> pairings = this.m_tournament.getCurrentRound().getPairings();
        int i = 0;
        while (i < pairings.size()) {
            Pairing pairing = pairings.get(i);
            if (pairing.getResult() == Pairing.NO_RESULT) {
                double random = Math.random();
                if (this.m_tournament.getAllowJigo()) {
                    if (random < 0.47) {
                        pairing.setResult(Pairing.BLACK_WINS);
                    } else if (random > 0.53) {
                        pairing.setResult(Pairing.WHITE_WINS);
                    } else {
                        pairing.setResult(Pairing.JIGO);
                    }
                } else if (random < 0.5) {
                    pairing.setResult(Pairing.BLACK_WINS);
                } else {
                    pairing.setResult(Pairing.WHITE_WINS);
                }
            }
            ++i;
        }
        this.m_tournament.getCurrentRound().unblockSort();
        this.m_tournament.getWalllist().unblockSort();
        ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
        ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableDataChanged();
    }

    public void tournamentClose() {
        assert (this.m_tournament != null);
        int result = JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmCloseTournament"), APPLICATION_NAME, 1);
        if (result == 0) {
            result = this.tournamentSave();
            if (result != 2) {
                this.tournamentCloseInternal();
            }
        } else if (result == 1) {
            this.tournamentCloseInternal();
        }
    }

    protected void tournamentCloseInternal() {
        this.m_tournament.getCurrentRound().unregisterLastUpdatedListener(this);
        this.m_tournament = null;
        this.m_mainWindow.getJTabbedPane().setVisible(false);
        this.m_mainWindow.getJLabelGlobalMessageLabel().setVisible(false);
        this.m_mainWindow.getJLabelGlobalMessage().setVisible(false);
        this.m_mainWindow.getJLabelGlobalMessage().setText(null);
        this.m_mainWindow.getJMenuItemTournamentSave().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentSaveAs().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentClose().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentEdit().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentImportSettings().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentImportParticipantsTxt().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentExportCurrentPairing().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentExportWalllist().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentExportForEGD().setEnabled(false);
        this.m_mainWindow.getMntmExportStatistics().setEnabled(false);
        this.m_mainWindow.getJMenuParticipants().setVisible(false);
        this.m_mainWindow.getJMenuRound().setVisible(false);
        this.m_mainWindow.getJMenuPairing().setVisible(false);
        this.m_mainWindow.getJMenuPrint().setVisible(false);
        this.m_mainWindow.getJMenuTest().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentNew().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentOpen().setEnabled(true);
        ((PairingsFreeParticipantsListModel)this.m_mainWindow.getListFreeParticipants().getModel()).setTournament(null);
        this.buildMainWindowTitle();
    }

    public void tournamentEditSettings() {
        EditTournamentSettingsDialog dialog = new EditTournamentSettingsDialog(this.m_tournament);
        dialog.show(this.m_mainWindow.getJFrame());
        this.buildMainWindowTitle();
        this.buildRoundMenuItems();
        ((WalllistTable)this.m_mainWindow.getJTableWalllist()).setFontsize(this.m_tournament.getWalllist().getFontsize());
        ((PairingsTable)this.m_mainWindow.getJTablePairings()).setFontsize(this.m_tournament.getPairingsFontsize());
        ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableStructureChanged();
        ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableStructureChanged();
    }

    public void tournamentExportCurrentPairing() {
        block18: {
            int returnVal;
            JFileChooser fc = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    Object filePath = file.getPath();
                    if (!((String)filePath).toLowerCase().endsWith(".txt")) {
                        filePath = (String)filePath + ".txt";
                        file = new File((String)filePath);
                        this.setSelectedFile(file);
                    }
                    if (file.exists()) {
                        if (JOptionPane.showConfirmDialog(this, Messages.getString("MacMahonApplication.ConfirmOverwriteFile", file.getName()), Messages.getString("MacMahonApplication.ConfirmOverwriteFileTitle"), 0, 2) == 0) {
                            super.approveSelection();
                        }
                    } else {
                        super.approveSelection();
                    }
                }
            };
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
            fc.setFileFilter(filter);
            if (this.m_defaultFilePath != null) {
                File defaultFilePath = new File(this.m_defaultFilePath);
                fc.setCurrentDirectory(defaultFilePath);
            }
            if ((returnVal = fc.showSaveDialog(this.m_mainWindow.getJFrame())) == 0) {
                this.m_defaultFilePath = fc.getCurrentDirectory().getPath();
                BufferedWriter out = null;
                try {
                    try {
                        File file = fc.getSelectedFile();
                        try {
                            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.m_tournament.getExportEncoding()));
                            this.m_tournament.exportCurrentPairing(out);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageUnsupportedEncodingException"), e);
                        }
                        catch (FileNotFoundException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageFileNotFoundException"), e);
                        }
                        catch (IOException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                        }
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        if (out == null) break block18;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public void tournamentExportForEGD() {
        block18: {
            int returnVal;
            JFileChooser fc = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    Object filePath = file.getPath();
                    if (!((String)filePath).toLowerCase().endsWith(".txt")) {
                        filePath = (String)filePath + ".txt";
                        file = new File((String)filePath);
                        this.setSelectedFile(file);
                    }
                    if (file.exists()) {
                        if (JOptionPane.showConfirmDialog(this, Messages.getString("MacMahonApplication.ConfirmOverwriteFile", file.getName()), Messages.getString("MacMahonApplication.ConfirmOverwriteFileTitle"), 0, 2) == 0) {
                            super.approveSelection();
                        }
                    } else {
                        super.approveSelection();
                    }
                }
            };
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
            fc.setFileFilter(filter);
            if (this.m_defaultFilePath != null) {
                File defaultFilePath = new File(this.m_defaultFilePath);
                fc.setCurrentDirectory(defaultFilePath);
            }
            if ((returnVal = fc.showSaveDialog(this.m_mainWindow.getJFrame())) == 0) {
                this.m_defaultFilePath = fc.getCurrentDirectory().getPath();
                BufferedWriter out = null;
                try {
                    try {
                        File file = fc.getSelectedFile();
                        try {
                            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
                            this.m_tournament.exportForEGD(out);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageUnsupportedEncodingException"), e);
                        }
                        catch (FileNotFoundException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageFileNotFoundException"), e);
                        }
                        catch (IOException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                        }
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        if (out == null) break block18;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public void tournamentExportStatistics() {
        block18: {
            int returnVal;
            JFileChooser fc = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    Object filePath = file.getPath();
                    if (!((String)filePath).toLowerCase().endsWith(".txt")) {
                        filePath = (String)filePath + ".txt";
                        file = new File((String)filePath);
                        this.setSelectedFile(file);
                    }
                    if (file.exists()) {
                        if (JOptionPane.showConfirmDialog(this, Messages.getString("MacMahonApplication.ConfirmOverwriteFile", file.getName()), Messages.getString("MacMahonApplication.ConfirmOverwriteFileTitle"), 0, 2) == 0) {
                            super.approveSelection();
                        }
                    } else {
                        super.approveSelection();
                    }
                }
            };
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
            fc.setFileFilter(filter);
            if (this.m_defaultFilePath != null) {
                File defaultFilePath = new File(this.m_defaultFilePath);
                fc.setCurrentDirectory(defaultFilePath);
            }
            if ((returnVal = fc.showSaveDialog(this.m_mainWindow.getJFrame())) == 0) {
                this.m_defaultFilePath = fc.getCurrentDirectory().getPath();
                BufferedWriter out = null;
                try {
                    try {
                        File file = fc.getSelectedFile();
                        try {
                            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
                            this.m_tournament.exportStatistics(out);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageUnsupportedEncodingException"), e);
                        }
                        catch (FileNotFoundException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageFileNotFoundException"), e);
                        }
                        catch (IOException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                        }
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        if (out == null) break block18;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public void tournamentExportWalllist() {
        block18: {
            int returnVal;
            JFileChooser fc = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    Object filePath = file.getPath();
                    if (!((String)filePath).toLowerCase().endsWith(".txt")) {
                        filePath = (String)filePath + ".txt";
                        file = new File((String)filePath);
                        this.setSelectedFile(file);
                    }
                    if (file.exists()) {
                        if (JOptionPane.showConfirmDialog(this, Messages.getString("MacMahonApplication.ConfirmOverwriteFile", file.getName()), Messages.getString("MacMahonApplication.ConfirmOverwriteFileTitle"), 0, 2) == 0) {
                            super.approveSelection();
                        }
                    } else {
                        super.approveSelection();
                    }
                }
            };
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
            fc.setFileFilter(filter);
            if (this.m_defaultFilePath != null) {
                File defaultFilePath = new File(this.m_defaultFilePath);
                fc.setCurrentDirectory(defaultFilePath);
            }
            if ((returnVal = fc.showSaveDialog(this.m_mainWindow.getJFrame())) == 0) {
                this.m_defaultFilePath = fc.getCurrentDirectory().getPath();
                BufferedWriter out = null;
                try {
                    try {
                        File file = fc.getSelectedFile();
                        try {
                            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.m_tournament.getExportEncoding()));
                            this.m_tournament.exportWalllist(out);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageUnsupportedEncodingException"), e);
                        }
                        catch (FileNotFoundException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageFileNotFoundException"), e);
                        }
                        catch (IOException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                        }
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        if (out == null) break block18;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public void tournamentImportParticipantsTxt() {
        block72: {
            FileInputStream fis;
            block71: {
                fis = null;
                try {
                    try {
                        int returnVal;
                        JFileChooser fc = new JFileChooser();
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
                        fc.setFileFilter(filter);
                        if (this.m_defaultFilePath != null) {
                            File defaultFilePath = new File(this.m_defaultFilePath);
                            fc.setCurrentDirectory(defaultFilePath);
                        }
                        if ((returnVal = fc.showOpenDialog(this.m_mainWindow.getJFrame())) != 0) break block71;
                        this.m_defaultFilePath = fc.getCurrentDirectory().getPath();
                        File file = fc.getSelectedFile();
                        try {
                            fis = new FileInputStream(file);
                        }
                        catch (FileNotFoundException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageCouldNotOpenFile"), e);
                        }
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader((InputStream)fis, this.m_tournament.getImportEncoding()));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new MacMahonException(Messages.getString("MacMahonApplication.MessageUnsupportedEncodingException"), e);
                        }
                        try {
                            try {
                                String row;
                                ArrayList<Object> warningMessages = new ArrayList<Object>();
                                if (this.m_tournament.getRatingAllowed()) {
                                    if (this.m_tournament.getRatingDeterminesRank()) {
                                        warningMessages.add(Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningRatingsDetermineRanks"));
                                    }
                                } else {
                                    warningMessages.add(Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningRatingsDisabled"));
                                }
                                warningMessages.add(Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningRegistrationDefault") + (this.m_tournament.getDefaultPreliminaryRegistration() ? Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningParticipationPreliminaryValue") : Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningParticipationFinalValue")) + ".");
                                int rowNumber = 0;
                                while ((row = reader.readLine()) != null) {
                                    Country country;
                                    String surname;
                                    ++rowNumber;
                                    if ((row = row.trim()).length() > 0 && row.charAt(0) == '\ufeff') {
                                        row = row.substring(1);
                                    }
                                    String[] columns = row.split("\\|", 0);
                                    String firstname = null;
                                    String level = null;
                                    String countrycode = null;
                                    String clubname = null;
                                    String rating = null;
                                    String registration = null;
                                    String playingInRounds = null;
                                    if (columns.length <= 0 || (surname = columns[0].trim()).isEmpty() || surname.charAt(0) == ';') continue;
                                    if (columns.length > 1) {
                                        firstname = columns[1].trim();
                                        if (firstname.isEmpty()) {
                                            firstname = null;
                                        }
                                        if (columns.length > 2) {
                                            level = columns[2].trim();
                                            if (level.isEmpty()) {
                                                level = null;
                                            }
                                            if (columns.length > 3) {
                                                countrycode = columns[3].trim();
                                                if (countrycode.isEmpty()) {
                                                    countrycode = null;
                                                }
                                                if (columns.length > 4) {
                                                    clubname = columns[4].trim();
                                                    if (clubname.isEmpty()) {
                                                        clubname = null;
                                                    }
                                                    if (columns.length > 5) {
                                                        rating = columns[5].trim();
                                                        if (rating.isEmpty()) {
                                                            rating = null;
                                                        }
                                                        if (columns.length > 6) {
                                                            registration = columns[6].trim();
                                                            if (registration.isEmpty()) {
                                                                registration = null;
                                                            }
                                                            if (columns.length > 7 && (playingInRounds = columns[7].trim()).isEmpty()) {
                                                                playingInRounds = null;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    GoPlayer goPlayer = new GoPlayer(this.m_tournament);
                                    goPlayer.setAsianName(this.m_tournament.getDefaultAsianName());
                                    goPlayer.setSurname(surname);
                                    if (firstname != null) {
                                        goPlayer.setFirstName(firstname);
                                    }
                                    if (level != null) {
                                        try {
                                            GoLevel goLevel = new GoLevel(level);
                                            goPlayer.setGoLevel(goLevel);
                                        }
                                        catch (MacMahonException exception) {
                                            warningMessages.add(Integer.toString(rowNumber) + ": " + Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningIllegalRank") + " '" + goPlayer.getName() + "' [" + level + "]");
                                        }
                                    }
                                    if (countrycode != null && (country = this.m_tournament.findCountry(countrycode)) != null) {
                                        goPlayer.setCountry(country);
                                        if (clubname != null && clubname.length() > 0) {
                                            Club club = country.findClub(clubname);
                                            if (club == null && (club = country.findClubByEgdName(clubname)) == null) {
                                                club = new Club(country, clubname, clubname.length() > 4 ? clubname.substring(0, 4) : clubname);
                                                country.addClub(club);
                                                warningMessages.add(Integer.toString(rowNumber) + ": " + Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningAddClub", club.getName(), club.getEgdName(), country.getName()));
                                            }
                                            goPlayer.setClub(club);
                                        }
                                    }
                                    if (this.m_tournament.getRatingAllowed()) {
                                        int ratingValue = 0;
                                        if (rating != null) {
                                            try {
                                                ratingValue = Integer.parseInt(rating);
                                            }
                                            catch (NumberFormatException e) {
                                                warningMessages.add(Integer.toString(rowNumber) + ": " + Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningIllegalRating") + " '" + goPlayer.getName() + "' [" + rating + "]");
                                            }
                                        }
                                        goPlayer.setRating(ratingValue);
                                        if (this.m_tournament.getRatingDeterminesRank()) {
                                            GoLevel goLevel = new GoLevel(goPlayer.getRating(), this.m_tournament.getRatingLowestOneDanRating());
                                            goPlayer.setGoLevel(goLevel);
                                            if (goPlayer.getRating() < GoLevel.getLowestRating(this.m_tournament.getRatingLowestOneDanRating())) {
                                                goPlayer.setRating(GoLevel.getLowestRating(this.m_tournament.getRatingLowestOneDanRating()));
                                            }
                                        }
                                    }
                                    IndividualParticipant individualParticipant = new IndividualParticipant(this.m_tournament, goPlayer);
                                    Boolean preliminaryRegistration = null;
                                    if (registration != null) {
                                        if (registration.equals("p") || registration.equals("P")) {
                                            preliminaryRegistration = Boolean.TRUE;
                                        } else if (registration.equals("f") || registration.equals("F")) {
                                            preliminaryRegistration = Boolean.FALSE;
                                        } else {
                                            warningMessages.add(Integer.toString(rowNumber) + ": " + Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningUnrecognizedRegistration") + " '" + goPlayer.getName() + "' [" + registration + "]");
                                        }
                                    }
                                    if (preliminaryRegistration == null) {
                                        preliminaryRegistration = this.m_tournament.getDefaultPreliminaryRegistration();
                                    }
                                    individualParticipant.setPreliminaryRegistration(preliminaryRegistration);
                                    if (!individualParticipant.getPreliminaryRegistration() && playingInRounds != null) {
                                        if (playingInRounds.length() > this.m_tournament.getNumberOfRounds()) {
                                            warningMessages.add(Integer.toString(rowNumber) + ": " + Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningNumberOfRounds", goPlayer.getName()) + " [numberOfRoundsTournament=" + this.m_tournament.getNumberOfRounds() + "; numberOfRoundsImport=" + playingInRounds.length() + "; importString='" + playingInRounds + "']");
                                        }
                                        int i = 1;
                                        while (i <= this.m_tournament.getNumberOfRounds() && i <= playingInRounds.length()) {
                                            if (playingInRounds.charAt(i - 1) == '0') {
                                                individualParticipant.setPairingInRound(Pairing.NOT_PLAYING, i);
                                            } else if (playingInRounds.charAt(i - 1) == '1') {
                                                individualParticipant.setPairingInRound(null, i);
                                            } else {
                                                warningMessages.add(Integer.toString(rowNumber) + ": " + Messages.getString("MacMahonApplication.TournamentImportParticipantsTxt.WarningUnrecognizedPlayingInRound") + " '" + goPlayer.getName() + "' [round=" + i + "; importString='" + playingInRounds + "']");
                                            }
                                            ++i;
                                        }
                                    }
                                    this.m_tournament.addParticipant(individualParticipant);
                                }
                            }
                            catch (IOException e) {
                                throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                            }
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block72;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.m_tournament.buildParticipantScores();
        ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableDataChanged();
    }

    public void tournamentImportSettings() {
        Tournament tournament;
        if (JOptionPane.showConfirmDialog(this.m_mainWindow.getJFrame(), Messages.getString("MacMahonApplication.ConfirmImportSettings"), Messages.getString("MacMahonApplication.ConfirmImportSettingsTitle"), 0, 2) == 0 && (tournament = this.tournamentOpenWithFilechooser()) != null) {
            try {
                this.m_tournament.importSettings(tournament);
            }
            catch (MacMahonException exception) {
                new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
            }
            this.buildMainWindowTitle();
            this.buildRoundMenuItems();
            ((WalllistTable)this.m_mainWindow.getJTableWalllist()).setFontsize(this.m_tournament.getWalllist().getFontsize());
            ((PairingsTable)this.m_mainWindow.getJTablePairings()).setFontsize(this.m_tournament.getPairingsFontsize());
            ((WalllistTableModel)this.m_mainWindow.getJTableWalllist().getModel()).fireTableStructureChanged();
            ((PairingsTableModel)this.m_mainWindow.getJTablePairings().getModel()).fireTableStructureChanged();
        }
    }

    public void tournamentNew() {
        assert (this.m_tournament == null);
        this.m_tournament = new Tournament();
        this.m_tournament.importDefaultCountriesAndClubs();
        this.m_tournament.setVersionCreated("MacMahon 3.10");
        this.tournamentOpened();
    }

    public void tournamentOpen() {
        this.m_tournament = this.tournamentOpenWithFilechooser();
        if (this.m_tournament != null) {
            this.tournamentOpened();
        }
    }

    private Tournament tournamentOpenWithFilechooser() {
        int returnVal;
        Tournament tournament = null;
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("XML files", "xml");
        fc.setFileFilter(xmlFilter);
        FileNameExtensionFilter turFilter = new FileNameExtensionFilter("MacMahon 2.xx TUR files", "tur");
        fc.addChoosableFileFilter(turFilter);
        fc.setFileFilter(xmlFilter);
        if (this.m_defaultFilePath != null) {
            File defaultFilePath = new File(this.m_defaultFilePath);
            fc.setCurrentDirectory(defaultFilePath);
        }
        if ((returnVal = fc.showOpenDialog(this.m_mainWindow.getJFrame())) == 0) {
            File file = fc.getSelectedFile();
            tournament = this.tournamentOpenInternal(file);
        }
        return tournament;
    }

    private Tournament tournamentOpenInternal(File file) {
        FileInputStream fis = null;
        Tournament tournament = null;
        try {
            boolean xml = !file.getName().substring(file.getName().lastIndexOf(46) + 1).toLowerCase().equals("tur");
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new MacMahonException(Messages.getString("MacMahonApplication.MessageFileNotFoundException"), e);
            }
            if (xml) {
                Document document;
                this.m_mainWindow.getJFrame().setCursor(Cursor.getPredefinedCursor(3));
                DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
                dBF.setIgnoringComments(true);
                DocumentBuilder builder = null;
                try {
                    builder = dBF.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.MessageParserConfigurationException"), e);
                }
                InputSource input = new InputSource(fis);
                try {
                    document = builder.parse(input);
                }
                catch (SAXException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.MessageSAXException"), e);
                }
                catch (IOException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                }
                tournament = new Tournament();
                tournament.setFilePath(file.getPath());
                tournament.xmlRead(document.getDocumentElement());
            } else {
                this.m_mainWindow.getJFrame().setCursor(Cursor.getPredefinedCursor(3));
                tournament = new Tournament();
                try {
                    tournament.turRead(fis);
                }
                catch (IOException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                }
                catch (RuntimeException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.RuntimeExceptionOccured"), e);
                }
            }
            this.setGlobalMessage(Messages.getString("MacMahonApplication.StateMessageTournamentOpened", file.getPath().replaceAll("\\\\", "/")));
            this.m_defaultFilePath = file.getParentFile().getAbsolutePath();
            Tournament tournament2 = tournament;
            return tournament2;
        }
        catch (MacMahonException exception) {
            this.m_mainWindow.getJFrame().setCursor(null);
            new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
        }
        finally {
            this.m_mainWindow.getJFrame().setCursor(null);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void tournamentOpened() {
        this.m_mainWindow.getJMenuItemTournamentNew().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentOpen().setEnabled(false);
        this.m_mainWindow.getJMenuItemTournamentSave().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentSaveAs().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentClose().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentEdit().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentImportSettings().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentImportParticipantsTxt().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentExportCurrentPairing().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentExportWalllist().setEnabled(true);
        this.m_mainWindow.getJMenuItemTournamentExportForEGD().setEnabled(true);
        this.m_mainWindow.getMntmExportStatistics().setEnabled(true);
        this.m_mainWindow.getJMenuParticipants().setVisible(true);
        this.m_mainWindow.getJCheckBoxMenuItemTakeCurrentRoundInAccount().setSelected(this.m_tournament.takeCurrentRoundInAccount());
        this.buildRoundMenuItems();
        this.m_mainWindow.getJMenuRound().setVisible(true);
        this.m_tournament.getCurrentRound().registerLastUpdatedListener(this);
        this.tournamentRoundLastUpdatedChanged(this.m_tournament.getCurrentRound());
        this.m_mainWindow.getJMenuPairing().setVisible(true);
        this.m_mainWindow.getJMenuPrint().setVisible(true);
        ((WalllistTable)this.m_mainWindow.getJTableWalllist()).setFontsize(this.m_tournament.getWalllist().getFontsize());
        ((PairingsTable)this.m_mainWindow.getJTablePairings()).setFontsize(this.m_tournament.getPairingsFontsize());
        this.m_mainWindow.getJTableWalllist().setModel(new WalllistTableModel(this.m_tournament));
        this.m_mainWindow.getJTablePairings().setModel(new PairingsTableModel(this.m_tournament));
        this.buildMainWindowTitle();
        this.m_mainWindow.getJMenuTest().setEnabled(true);
        this.m_mainWindow.getJTabbedPane().setSelectedComponent(this.m_mainWindow.getJPanelWallList());
        this.m_mainWindow.getJTabbedPane().setVisible(true);
        this.m_mainWindow.getJLabelGlobalMessageLabel().setVisible(true);
        this.m_mainWindow.getJLabelGlobalMessage().setVisible(true);
        ((PairingsFreeParticipantsListModel)this.m_mainWindow.getListFreeParticipants().getModel()).setTournament(this.m_tournament);
        this.m_mainWindow.getSplitPanePairings().setDividerLocation(710);
    }

    public int tournamentSave() {
        if (this.m_tournament.getFilepath() == null) {
            return this.tournamentSaveAs();
        }
        File file = new File(this.m_tournament.getFilepath());
        this.tournamentSave(file);
        return 0;
    }

    private void tournamentSave(File file) {
        try {
            DocumentBuilder builder;
            DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
            try {
                builder = dBF.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new MacMahonException("ParserConfigurationException occured", e);
            }
            Document document = builder.newDocument();
            this.m_tournament.setVersionSaved("MacMahon 3.10");
            Element eTournament = this.m_tournament.xmlWrite(document);
            document.appendChild(eTournament);
            FileOutputStream outputStream = null;
            try {
                try {
                    outputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.MessageFileNotFoundException"), e);
                }
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(outputStream);
                    transformer.transform(source, result);
                    try {
                        this.setGlobalMessage(Messages.getString("MacMahonApplication.StateMessageTournamentSaved", file.getPath().replaceAll("\\\\", "/"), new DateFormatter(DateFormat.getDateTimeInstance()).valueToString(new Date())));
                    }
                    catch (ParseException e) {
                        throw new MacMahonException("ParseException", e);
                    }
                }
                catch (TransformerException e) {
                    throw new MacMahonException(Messages.getString("MacMahonApplication.MessageIOException"), e);
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (MacMahonException exception) {
            new DisplayMacMahonExceptionDialog(exception).show(this.m_mainWindow.getJFrame());
        }
    }

    public int tournamentSaveAs() {
        int returnVal;
        JFileChooser fc = new JFileChooser(){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                Object filePath = file.getPath();
                if (!((String)filePath).toLowerCase().endsWith(".xml")) {
                    filePath = (String)filePath + ".xml";
                    file = new File((String)filePath);
                    this.setSelectedFile(file);
                }
                if (file.exists()) {
                    if (JOptionPane.showConfirmDialog(this, Messages.getString("MacMahonApplication.ConfirmOverwriteFile", file.getName()), Messages.getString("MacMahonApplication.ConfirmOverwriteFileTitle"), 0, 2) == 0) {
                        super.approveSelection();
                    }
                } else {
                    super.approveSelection();
                }
            }
        };
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files", "xml");
        fc.setFileFilter(filter);
        if (this.m_defaultFilePath != null) {
            File defaultFilePath = new File(this.m_defaultFilePath);
            fc.setCurrentDirectory(defaultFilePath);
        }
        if ((returnVal = fc.showSaveDialog(this.m_mainWindow.getJFrame())) == 0) {
            this.m_defaultFilePath = fc.getCurrentDirectory().getPath();
            File file = fc.getSelectedFile();
            this.m_tournament.setFilePath(file.getPath());
            this.tournamentSave(file);
            return 0;
        }
        return 2;
    }

    @Override
    public void tournamentRoundLastUpdatedChanged(TournamentRound round) {
        this.m_mainWindow.getMntmLastUpdated().setText(Messages.getString("MacMahonMainWindow.mntmLastUpdated.text") + " " + DateFormat.getDateTimeInstance().format(round.getLastUpdated()));
    }
}

