/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.model.Participant;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.UnwantedPairing;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditUnwantedPairingsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Tournament m_tournament;

    public EditUnwantedPairingsDialog(Component parent, Tournament tournament) {
        this.m_tournament = tournament;
        this.setSize(new Dimension(682, 575));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(Messages.getString("EditUnwantedPairingsDialog.Title"));
        this.setDefaultCloseOperation(2);
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditUnwantedPairingsDialog.this.dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        this.setLocationRelativeTo(parent);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[9];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JTextPane txtpnExplanationunwantedPairings = new JTextPane();
        txtpnExplanationunwantedPairings.setEditable(false);
        txtpnExplanationunwantedPairings.setOpaque(false);
        txtpnExplanationunwantedPairings.setText(Messages.getString("EditUnwantedPairingsDialog.Explanation"));
        GridBagConstraints gbc_txtpnExplanationunwantedPairings = new GridBagConstraints();
        gbc_txtpnExplanationunwantedPairings.insets = new Insets(0, 0, 5, 0);
        gbc_txtpnExplanationunwantedPairings.fill = 1;
        gbc_txtpnExplanationunwantedPairings.gridx = 0;
        gbc_txtpnExplanationunwantedPairings.gridy = 0;
        this.getContentPane().add((Component)txtpnExplanationunwantedPairings, gbc_txtpnExplanationunwantedPairings);
        JLabel lblParticipants = new JLabel(Messages.getString("EditUnwantedPairingsDialog.ParticipantsLabel"));
        GridBagConstraints gbc_lblParticipants = new GridBagConstraints();
        gbc_lblParticipants.anchor = 17;
        gbc_lblParticipants.insets = new Insets(0, 0, 5, 0);
        gbc_lblParticipants.gridx = 0;
        gbc_lblParticipants.gridy = 1;
        this.getContentPane().add((Component)lblParticipants, gbc_lblParticipants);
        JScrollPane scrollPaneListParticipants = new JScrollPane();
        GridBagConstraints gbc_scrollPaneListParticipants = new GridBagConstraints();
        gbc_scrollPaneListParticipants.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPaneListParticipants.fill = 1;
        gbc_scrollPaneListParticipants.gridx = 0;
        gbc_scrollPaneListParticipants.gridy = 2;
        this.getContentPane().add((Component)scrollPaneListParticipants, gbc_scrollPaneListParticipants);
        final JList<Participant> listParticipants = new JList<Participant>();
        scrollPaneListParticipants.setViewportView(listParticipants);
        listParticipants.setModel(new ParticipantsListModel(this.m_tournament.getWalllist().getWalllist()));
        JPanel panelAddButtons = new JPanel();
        GridBagConstraints gbc_panelAddButtons = new GridBagConstraints();
        gbc_panelAddButtons.insets = new Insets(0, 0, 5, 0);
        gbc_panelAddButtons.fill = 1;
        gbc_panelAddButtons.gridx = 0;
        gbc_panelAddButtons.gridy = 3;
        this.getContentPane().add((Component)panelAddButtons, gbc_panelAddButtons);
        GridBagLayout gbl_panelAddButtons = new GridBagLayout();
        gbl_panelAddButtons.columnWidths = new int[3];
        gbl_panelAddButtons.rowHeights = new int[2];
        gbl_panelAddButtons.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_panelAddButtons.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelAddButtons.setLayout(gbl_panelAddButtons);
        final JButton btnAddUnwantedPairings = new JButton(Messages.getString("EditUnwantedPairingsDialog.AddAsUnwantedPairingsButtonLabel"));
        GridBagConstraints gbc_btnAddUnwantedPairings = new GridBagConstraints();
        gbc_btnAddUnwantedPairings.gridx = 0;
        gbc_btnAddUnwantedPairings.gridy = 0;
        panelAddButtons.add((Component)btnAddUnwantedPairings, gbc_btnAddUnwantedPairings);
        btnAddUnwantedPairings.setEnabled(false);
        final JButton btnAddForbiddenPairings = new JButton(Messages.getString("EditUnwantedPairingsDialog.AddAsForbiddenPairingsButtonLabel"));
        btnAddForbiddenPairings.setEnabled(false);
        GridBagConstraints gbc_btnAddForbiddenPairings = new GridBagConstraints();
        gbc_btnAddForbiddenPairings.gridx = 1;
        gbc_btnAddForbiddenPairings.gridy = 0;
        panelAddButtons.add((Component)btnAddForbiddenPairings, gbc_btnAddForbiddenPairings);
        ListSelectionListener listParticipantsSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean enabled = listParticipants.getSelectedIndices().length >= 2;
                btnAddUnwantedPairings.setEnabled(enabled);
                btnAddForbiddenPairings.setEnabled(enabled);
            }
        };
        listParticipants.addListSelectionListener(listParticipantsSelectionListener);
        JLabel lblUnwantedPairings = new JLabel(Messages.getString("EditUnwantedPairingsDialog.UnwantedPairingsLabel"));
        GridBagConstraints gbc_lblUnwantedPairings = new GridBagConstraints();
        gbc_lblUnwantedPairings.anchor = 17;
        gbc_lblUnwantedPairings.insets = new Insets(0, 0, 5, 0);
        gbc_lblUnwantedPairings.gridx = 0;
        gbc_lblUnwantedPairings.gridy = 4;
        this.getContentPane().add((Component)lblUnwantedPairings, gbc_lblUnwantedPairings);
        JScrollPane scrollPaneListUnwantedPairings = new JScrollPane();
        GridBagConstraints gbc_scrollPaneListUnwantedPairings = new GridBagConstraints();
        gbc_scrollPaneListUnwantedPairings.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPaneListUnwantedPairings.fill = 1;
        gbc_scrollPaneListUnwantedPairings.gridx = 0;
        gbc_scrollPaneListUnwantedPairings.gridy = 5;
        this.getContentPane().add((Component)scrollPaneListUnwantedPairings, gbc_scrollPaneListUnwantedPairings);
        final JList<UnwantedPairing> listUnwantedPairings = new JList<UnwantedPairing>();
        scrollPaneListUnwantedPairings.setViewportView(listUnwantedPairings);
        listUnwantedPairings.setModel(new UnwantedPairingsListModel(this.m_tournament.getUnwantedPairings()));
        btnAddUnwantedPairings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditUnwantedPairingsDialog.this.m_tournament.createUnwantedPairings(listParticipants.getSelectedValuesList(), false);
                ((UnwantedPairingsListModel)listUnwantedPairings.getModel()).replaceAll(EditUnwantedPairingsDialog.this.m_tournament.getUnwantedPairings());
                listParticipants.clearSelection();
            }
        });
        btnAddForbiddenPairings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditUnwantedPairingsDialog.this.m_tournament.createUnwantedPairings(listParticipants.getSelectedValuesList(), true);
                ((UnwantedPairingsListModel)listUnwantedPairings.getModel()).replaceAll(EditUnwantedPairingsDialog.this.m_tournament.getUnwantedPairings());
                listParticipants.clearSelection();
            }
        });
        final JButton btnDeleteSelectedUnwanted = new JButton(Messages.getString("EditUnwantedPairingsDialog.DeleteUnwantedPairingsButtonLabel"));
        btnDeleteSelectedUnwanted.setEnabled(false);
        GridBagConstraints gbc_btnDeleteSelectedUnwanted = new GridBagConstraints();
        gbc_btnDeleteSelectedUnwanted.insets = new Insets(0, 0, 5, 0);
        gbc_btnDeleteSelectedUnwanted.gridx = 0;
        gbc_btnDeleteSelectedUnwanted.gridy = 6;
        this.getContentPane().add((Component)btnDeleteSelectedUnwanted, gbc_btnDeleteSelectedUnwanted);
        btnDeleteSelectedUnwanted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<UnwantedPairing> unwantedPairings = listUnwantedPairings.getSelectedValuesList();
                EditUnwantedPairingsDialog.this.m_tournament.deleteUnwantedPairings(unwantedPairings);
                ((UnwantedPairingsListModel)listUnwantedPairings.getModel()).removeAll(unwantedPairings);
                listUnwantedPairings.clearSelection();
            }
        });
        ListSelectionListener listUnwantedPairingsSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                btnDeleteSelectedUnwanted.setEnabled(listUnwantedPairings.getSelectedIndices().length > 0);
            }
        };
        listUnwantedPairings.addListSelectionListener(listUnwantedPairingsSelectionListener);
        JButton btnClose = new JButton(Messages.getString("EditUnwantedPairingsDialog.CloseButtonLabel"));
        GridBagConstraints gbc_btnClose = new GridBagConstraints();
        gbc_btnClose.fill = 2;
        gbc_btnClose.gridx = 0;
        gbc_btnClose.gridy = 7;
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditUnwantedPairingsDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)btnClose, gbc_btnClose);
    }

    private static class ParticipantsListModel
    extends AbstractListModel<Participant> {
        private static final long serialVersionUID = 1L;
        private List<Participant> m_participants;

        public ParticipantsListModel(List<Participant> participants) {
            this.m_participants = participants;
        }

        @Override
        public int getSize() {
            return this.m_participants.size();
        }

        @Override
        public Participant getElementAt(int index) {
            return this.m_participants.get(index);
        }
    }

    private static class UnwantedPairingsListModel
    extends AbstractListModel<UnwantedPairing> {
        private static final long serialVersionUID = 1L;
        private List<UnwantedPairing> m_unwantedPairings;

        public UnwantedPairingsListModel(List<UnwantedPairing> unwantedPairings) {
            this.m_unwantedPairings = new ArrayList<UnwantedPairing>(unwantedPairings);
            Collections.sort(this.m_unwantedPairings);
        }

        @Override
        public int getSize() {
            return this.m_unwantedPairings.size();
        }

        @Override
        public UnwantedPairing getElementAt(int index) {
            return this.m_unwantedPairings.get(index);
        }

        public void replaceAll(List<UnwantedPairing> unwantedPairings) {
            this.m_unwantedPairings.clear();
            this.m_unwantedPairings.addAll(unwantedPairings);
            Collections.sort(this.m_unwantedPairings);
            this.fireContentsChanged(this, 0, this.m_unwantedPairings.size() - 1);
        }

        public void removeAll(List<UnwantedPairing> unwantedPairings) {
            this.m_unwantedPairings.removeAll(unwantedPairings);
            this.fireContentsChanged(this, 0, this.m_unwantedPairings.size() - 1);
        }
    }
}

