/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.gui.DisplayMacMahonExceptionDialog;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.Walllist;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditTournamentSettingsDialog {
    private static final DataFlavor s_sortCriterionDataFlavor = new DataFlavor(Walllist.SortCriterionDescriptor.class, "Wallist.SortCriterionDescriptor");
    private Tournament m_tournament;
    private int m_surpressCheckRatingAllowRatings = 0;
    private boolean m_ratingAllowRatings = false;
    private boolean m_ratingDeterminesRank = false;
    private boolean m_ratingDeterminesStartScore = false;
    private String m_ratingUpperMacMahonBarRating;
    private String m_upperMacMahonBarLevel;
    private boolean m_lowerMacMahonBar = false;
    private String m_lowerMacMahonBarLevel;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JLabel jLabelName = null;
    private JTextField jTextFieldName = null;
    private JButton jButtonOk = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelMainSettings = null;
    private JLabel jLabelDescription = null;
    private JTextArea jTextAreaDescription = null;
    private JScrollPane jScrollPaneDescription = null;
    private JLabel jLabelNumberOfRounds = null;
    private JPanel jPanelNumberOfRounds = null;
    private JTextField jTextFieldNumberOfRounds = null;
    private JPanel jPanelHandicap = null;
    private JRadioButton jRadioButtonHandicapOnlyEvenGames = null;
    private JRadioButton jRadioButtonHandicapUseHandicap = null;
    private JTextField jTextFieldHandicapUseHandicapBelow = null;
    private JRadioButton jRadioButtonHandicapRelativeToLevel = null;
    private JRadioButton jRadioButtonHandicapRelativeToScore = null;
    private JTextField jTextFieldHandicapAdjustmentValue = null;
    private JLabel jLabelBoardsize = null;
    private JPanel jPanelBoardsize = null;
    private JRadioButton jRadioButtonBoardsize19x19 = null;
    private JRadioButton jRadioButtonBoardsize13x13 = null;
    private JRadioButton jRadioButtonBoardsize9x9 = null;
    private JRadioButton jRadioButtonBoardsizeOther = null;
    private JCheckBox jCheckBoxAllowJigo = null;
    private JCheckBox jCheckBoxHandicapLimit = null;
    private JTextField jTextFieldHandicapLimit = null;
    private JLabel jLabelHandicapLimit = null;
    private JCheckBox jCheckBoxHandicapBelow = null;
    private JCheckBox jCheckBoxHandicapAdjustment = null;
    private JLabel jLabelHandicapAdjustBy = null;
    private JLabel jLabelMacMahonBars = null;
    private JPanel jPanelMacMahonBars = null;
    private JCheckBox jCheckBoxUpperMacMahonBar = null;
    private JTextField jTextFieldUpperMacMahonBar = null;
    private JCheckBox jCheckBoxLowerMacMahonBar = null;
    private JTextField jTextFieldLowerMacMahonBar = null;
    private JPanel jPanelWalllist = null;
    private JPanel jPanelWalllistDummy = null;
    private JPanel jPanelRegistration = null;
    private JPanel jPanelRegistrationDummy = null;
    private JLabel jLabelRegistrationDefaultRegistration = null;
    private JPanel jPanelRegistrationDefaultRegistration = null;
    private JRadioButton jRadioButtonRegistrationDefaultRegistrationPreliminary = null;
    private JRadioButton jRadioButtonRegistrationDefaultRegistrationFinal = null;
    private JCheckBox jCheckBoxHandicapIncludeHandicapInTieBreakers = null;
    private JLabel jLabelSortCriteria = null;
    private JPanel jPanelSortCriteriaSortCriteria = null;
    private JScrollPane jScrollPaneWalllistSortCriteriaActive = null;
    private JList<Walllist.SortCriterionDescriptor> jListSortCriteriaActive = null;
    private JScrollPane jScrollPaneWalllistSortCriteriaAvailable = null;
    private JList<Walllist.SortCriterionDescriptor> jListSortCriteriaAvailable = null;
    private JLabel jLabelSortCriteriaActive = null;
    private JLabel jLabelSortCriteriaAvailable = null;
    private JLabel jLabelSortKriteriaHint = null;
    private JLabel jLabelWalllistDisplayGameData = null;
    private JCheckBox jCheckBoxWalllistShowColors = null;
    private JCheckBox jCheckBoxWalllistShowHandicap = null;
    private JCheckBox jCheckBoxWalllistMarkResultsByReferee = null;
    private JLabel jLabelRegistrationDefaultCountry = null;
    private JComboBox<Country> jComboBoxRegistrationDefaultCountry = null;
    private JLabel jLabelWallistFontsize = null;
    private JPanel jPanelWalllistFontsize = null;
    private JTextField jTextFieldWalllistFontsize = null;
    private JLabel jLabelWalllistFontsizePoints = null;
    private JPanel jPanelPairings = null;
    private JLabel jLabelPairingsFontsize = null;
    private JPanel jPanelPairingsFontsize = null;
    private JTextField jTextFieldPairingsFontsize = null;
    private JLabel jLabelPairingsFontsizePoints = null;
    private JPanel jPanelPairingsDummy = null;
    private JLabel jLabelRegistrationDefaultAsianName = null;
    private JCheckBox jCheckBoxRegistrationDefaultAsianName = null;
    private JPanel jPanelSortCriteria = null;
    private JPanel jPanelSortCriteriaDummy = null;
    private JLabel jLabelWalllistPlayerData = null;
    private JCheckBox jCheckBoxWalllistShortLevel = null;
    private JCheckBox jCheckBoxWalllistShowBarMembership = null;
    private JCheckBox jCheckBoxWalllistShowWarningMissingPairing = null;
    private JLabel jLabelRating = null;
    private JCheckBox jCheckBoxRatingAllowRatings = null;
    private JCheckBox jCheckBoxRatingDeterminesRank = null;
    private JPanel jPanelRatingSettings = null;
    private JTextField jTextFieldRatingLowestOneDanRating = null;
    private JCheckBox jCheckBoxRatingDeterminesStartScore = null;
    private JCheckBox jCheckBoxWalllistShowRating = null;
    private JLabel jLabelPairingsPlayerData = null;
    private JCheckBox jCheckBoxPairingsShortLevel = null;
    private JCheckBox jCheckBoxWalllistShowCountry = null;
    private JCheckBox jCheckBoxWalllistShowClubEgdName = null;
    private JCheckBox jCheckBoxWalllistShowClubAbbreviateName = null;
    private JCheckBox jCheckBoxWalllistShowClub = null;
    private JCheckBox jCheckBoxWalllistClubColumnAlignment = null;
    private JLabel jLabelRegistrationEGDSupport = null;
    private JCheckBox jCheckBoxRegistrationEGDSupport = null;
    private JCheckBox jCheckBoxRegistrationSearchEGDByPin = null;
    private JPanel jPanelExport = null;
    private JLabel jLabelExportColumnDelimiter = null;
    private JPanel jPanelExportColumnDelimiter = null;
    private JPanel jPanelExportDummy = null;
    private JRadioButton jRadioButtonExportColumnDelimiterTab = null;
    private JRadioButton jRadioButtonExportColumnDelimiterSemikolon = null;
    private JRadioButton jRadioButtonExportColumnDelimiterPipe = null;
    private JCheckBox jCheckBoxWalllistShowLevels = null;
    private JCheckBox jCheckBoxPairingsShowLevels = null;
    private JCheckBox jCheckBoxWalllistMarkPreliminaryRegisteredParticipants = null;
    private JLabel jLabelPlacementCriteriaSharedPlaces = null;
    private JRadioButton jRadioButtonPlacementCriteriaWeakRankNameId = null;
    private JRadioButton jRadioButtonPlacementCriteriaWeakNameId = null;
    private JRadioButton jRadioButtonPlacementCriteriaWeakId = null;
    private JLabel jLabelBye = null;
    private JCheckBox jCheckBoxByeSos = null;
    private JLabel jLabelHalfScoreGroups = null;
    private JCheckBox jCheckBoxHalfScoreGroupsRoundDown = null;
    private JCheckBox jCheckBoxHalfScoreGroupsRoundDownNotJigo = null;
    private JCheckBox jCheckBoxPairingsShowScores = null;
    private JLabel jLabelRegistrationDefaultNationality = null;
    private JComboBox<Country> jComboBoxRegistrationDefaultNationality = null;
    private JCheckBox jCheckBoxExportWalllistShowTournamentTitle = null;
    private JLabel jLabelVersionCreated = null;
    private JTextField jTextFieldVersionCreated = null;
    private JLabel jLabelVersionSaved = null;
    private JTextField jTextFieldVersionSaved = null;
    private JLabel jLabelExportEncoding = null;
    private JComboBox<String> jComboBoxExportEncoding = null;
    private JCheckBox jCheckBoxPairingsShowHandicaps = null;
    private JCheckBox jCheckBoxPairingsMarkWinner = null;
    private JCheckBox jCheckBoxPairingsMarkMissingResults = null;
    private JPanel jPanelHandicapDummy;
    private JRadioButton rdbtnUseFixedFormat;
    private JCheckBox chckbxMarkFixedBoardnumbers;
    private JCheckBox chckbxMarkUnwantedPairings;
    private JPanel panel;
    private JPanel panelUnwantedExample;
    private JLabel lblUnwanted;
    private JPanel panelForbiddenExample;
    private JLabel lblForbidden;
    private JPanel panelImport;
    private JLabel lblImportEncoding;
    private JComboBox<String> comboBoxImportEncoding;

    public EditTournamentSettingsDialog(Tournament tournament) {
        this.m_tournament = tournament;
    }

    public void show(Component parent) {
        this.getJDialog();
        if (this.m_tournament.getName() != null) {
            this.getJTextFieldName().setText(this.m_tournament.getName());
        }
        if (this.m_tournament.getDescription() != null) {
            this.getJTextAreaDescription().setText(this.m_tournament.getDescription());
        }
        this.getJTextFieldNumberOfRounds().setText(Integer.toString(this.m_tournament.getNumberOfRounds()));
        this.getJTextFieldVersionCreated().setText(this.m_tournament.getVersionCreated());
        this.getJTextFieldVersionSaved().setText(this.m_tournament.getVersionSaved());
        ButtonGroup bgBoardsize = new ButtonGroup();
        bgBoardsize.add(this.getJRadioButtonBoardsize19x19());
        bgBoardsize.add(this.getJRadioButtonBoardsize13x13());
        bgBoardsize.add(this.getJRadioButtonBoardsize9x9());
        bgBoardsize.add(this.getJRadioButtonBoardsizeOther());
        if (this.m_tournament.getBoardsize() == 19) {
            this.getJRadioButtonBoardsize19x19().setSelected(true);
        } else if (this.m_tournament.getBoardsize() == 13) {
            this.getJRadioButtonBoardsize13x13().setSelected(true);
        } else if (this.m_tournament.getBoardsize() == 9) {
            this.getJRadioButtonBoardsize9x9().setSelected(true);
        } else {
            this.getJRadioButtonBoardsizeOther().setSelected(true);
        }
        this.getJCheckBoxAllowJigo().setSelected(this.m_tournament.getAllowJigo());
        ++this.m_surpressCheckRatingAllowRatings;
        this.m_ratingDeterminesRank = this.m_tournament.getRatingDeterminesRank();
        this.m_ratingDeterminesStartScore = this.m_tournament.getRatingDeterminesStartScore();
        this.m_ratingUpperMacMahonBarRating = Integer.toString(this.m_tournament.getUpperMacMahonBarRating());
        this.m_upperMacMahonBarLevel = this.m_tournament.getUpperMacMahonBarLevel().getDisplayString();
        this.getJTextFieldUpperMacMahonBar().setText(this.m_upperMacMahonBarLevel);
        this.m_lowerMacMahonBar = this.m_tournament.getLowerMacMahonBar();
        this.getJCheckBoxLowerMacMahonBar().setSelected(this.m_lowerMacMahonBar);
        this.m_lowerMacMahonBarLevel = this.m_tournament.getLowerMacMahonBarLevel().getDisplayString();
        this.getJTextFieldLowerMacMahonBar().setText(this.m_lowerMacMahonBarLevel);
        this.getJCheckBoxRatingAllowRatings().setSelected(this.m_tournament.getRatingAllowed());
        this.getJTextFieldRatingLowestOneDanRating().setText(Integer.toString(this.m_tournament.getRatingLowestOneDanRating()));
        this.getJTextFieldRatingLowestOneDanRating().setEditable(false);
        this.getJCheckBoxUpperMacMahonBar().setSelected(this.m_tournament.getUpperMacMahonBar());
        this.getJTextFieldUpperMacMahonBar().setEnabled(this.getJCheckBoxUpperMacMahonBar().isSelected());
        this.checkRatingAllowRatings(true);
        --this.m_surpressCheckRatingAllowRatings;
        this.getJCheckBoxByeSos().setSelected(this.m_tournament.getByeShouldResultInZeroSOSetc());
        this.getJCheckBoxHalfScoreGroupsRoundDown().setSelected(this.m_tournament.getHalfScoreGroupsRoundDown());
        this.getJCheckBoxHalfScoreGroupsRoundDownNotJigo().setSelected(this.m_tournament.getHalfScoreGroupsRoundDownNotJigo());
        DefaultListModel<Walllist.SortCriterionDescriptor> sortCriteriaListModel = new DefaultListModel<Walllist.SortCriterionDescriptor>();
        for (Walllist.SortCriterionDescriptor sortCriterionDescriptor : this.m_tournament.getWalllist().getSortCriteria()) {
            if (sortCriterionDescriptor.isWeak()) continue;
            sortCriteriaListModel.addElement(sortCriterionDescriptor);
        }
        this.getJListSortCriteriaActive().setModel(sortCriteriaListModel);
        this.getJListSortCriteriaActive().setDragEnabled(true);
        this.getJListSortCriteriaActive().setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                JList list = (JList)c;
                return new SortCriterionTransferable((Walllist.SortCriterionDescriptor)list.getSelectedValue());
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if (action == 2) {
                    JList list = (JList)source;
                    try {
                        ((DefaultListModel)list.getModel()).removeElement(data.getTransferData(s_sortCriterionDataFlavor));
                    }
                    catch (UnsupportedFlavorException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(s_sortCriterionDataFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                Walllist.SortCriterionDescriptor data;
                Transferable t = support.getTransferable();
                try {
                    data = (Walllist.SortCriterionDescriptor)t.getTransferData(s_sortCriterionDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                TransferHandler.DropLocation loc = support.getDropLocation();
                DefaultListModel listModel = (DefaultListModel)((JList)support.getComponent()).getModel();
                int index = ((JList.DropLocation)loc).getIndex();
                boolean result = true;
                if (listModel.contains(data) && listModel.indexOf(data) > index) {
                    listModel.removeElement(data);
                    result = false;
                }
                listModel.insertElementAt(data, ((JList.DropLocation)loc).getIndex());
                return result;
            }
        });
        this.getJListSortCriteriaActive().setDropMode(DropMode.INSERT);
        DefaultListModel<Walllist.SortCriterionDescriptor> sortCriteriaAvailableListModel = new DefaultListModel<Walllist.SortCriterionDescriptor>();
        for (Walllist.SortCriterionDescriptor sortCriterionDescriptor : this.m_tournament.getWalllist().getSortCriteriaAvailable()) {
            sortCriteriaAvailableListModel.addElement(sortCriterionDescriptor);
        }
        this.getJListSortCriteriaAvailable().setModel(sortCriteriaAvailableListModel);
        this.getJListSortCriteriaAvailable().setDragEnabled(true);
        this.getJListSortCriteriaAvailable().setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                JList list = (JList)c;
                return new SortCriterionTransferable((Walllist.SortCriterionDescriptor)list.getSelectedValue());
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if (action == 2) {
                    JList list = (JList)source;
                    try {
                        ((DefaultListModel)list.getModel()).removeElement(data.getTransferData(s_sortCriterionDataFlavor));
                    }
                    catch (UnsupportedFlavorException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(s_sortCriterionDataFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                Walllist.SortCriterionDescriptor data;
                Transferable t = support.getTransferable();
                try {
                    data = (Walllist.SortCriterionDescriptor)t.getTransferData(s_sortCriterionDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                TransferHandler.DropLocation loc = support.getDropLocation();
                ((DefaultListModel)((JList)support.getComponent()).getModel()).insertElementAt(data, ((JList.DropLocation)loc).getIndex());
                return true;
            }
        });
        this.getJListSortCriteriaAvailable().setDropMode(DropMode.INSERT);
        ButtonGroup bgSharedPlacesOrder = new ButtonGroup();
        bgSharedPlacesOrder.add(this.getJRadioButtonPlacementCriteriaWeakRankNameId());
        bgSharedPlacesOrder.add(this.getJRadioButtonPlacementCriteriaWeakNameId());
        bgSharedPlacesOrder.add(this.getJRadioButtonPlacementCriteriaWeakId());
        if (this.m_tournament.getWalllist().getWeakSortCriteria() == 1) {
            this.getJRadioButtonPlacementCriteriaWeakRankNameId().setSelected(true);
        } else if (this.m_tournament.getWalllist().getWeakSortCriteria() == 2) {
            this.getJRadioButtonPlacementCriteriaWeakNameId().setSelected(true);
        } else {
            this.getJRadioButtonPlacementCriteriaWeakId().setSelected(true);
        }
        this.getJCheckBoxRegistrationEGDSupport().setSelected(this.m_tournament.getOnlineEgdSupport());
        this.getJCheckBoxRegistrationSearchEGDByPin().setSelected(this.m_tournament.getOnlineEgdSupportByPin());
        ButtonGroup bgRegistration = new ButtonGroup();
        bgRegistration.add(this.getJRadioButtonRegistrationDefaultRegistrationPreliminary());
        bgRegistration.add(this.getJRadioButtonRegistrationDefaultRegistrationFinal());
        if (this.m_tournament.getDefaultPreliminaryRegistration()) {
            this.getJRadioButtonRegistrationDefaultRegistrationPreliminary().setSelected(true);
        } else {
            this.getJRadioButtonRegistrationDefaultRegistrationFinal().setSelected(true);
        }
        DefaultComboBoxModel<Country> countriesModel = new DefaultComboBoxModel<Country>(this.m_tournament.getCountries().toArray(new Country[0]));
        countriesModel.insertElementAt(null, 0);
        this.getJComboBoxRegistrationDefaultCountry().setModel(countriesModel);
        this.getJComboBoxRegistrationDefaultCountry().setSelectedItem(this.m_tournament.getDefaultCountry());
        DefaultComboBoxModel<Country> nationalitiesModel = new DefaultComboBoxModel<Country>(this.m_tournament.getCountries().toArray(new Country[0]));
        nationalitiesModel.insertElementAt(null, 0);
        this.getJComboBoxRegistrationDefaultNationality().setModel(nationalitiesModel);
        this.getJComboBoxRegistrationDefaultNationality().setSelectedItem(this.m_tournament.getDefaultNationality());
        this.getJCheckBoxRegistrationDefaultAsianName().setSelected(this.m_tournament.getDefaultAsianName());
        this.getJCheckBoxWalllistShowLevels().setSelected(this.m_tournament.getWalllist().getShowLevels());
        this.getJCheckBoxWalllistShortLevel().setSelected(this.m_tournament.getWalllist().getShortNotationForLevel());
        this.getJCheckBoxWalllistShowBarMembership().setSelected(this.m_tournament.getWalllist().getShowBarMembership());
        this.getJCheckBoxWalllistShowRating().setSelected(this.m_tournament.getWalllist().getShowRatings());
        this.getJCheckBoxWalllistShowCountry().setSelected(this.m_tournament.getWalllist().getShowCountry());
        this.getJCheckBoxWalllistShowClub().setSelected(this.m_tournament.getWalllist().getShowClub());
        this.getJCheckBoxWalllistShowClubEgdName().setSelected(this.m_tournament.getWalllist().getShowClubEgdName());
        this.getJCheckBoxWalllistShowClubAbbreviateName().setSelected(this.m_tournament.getWalllist().getShowClubAbbreviateName());
        this.getJCheckBoxWalllistClubColumnAlignment().setSelected(this.m_tournament.getWalllist().getClubColumnAlignmentCenter());
        this.getJCheckBoxWalllistMarkPreliminaryRegisteredParticipants().setSelected(this.m_tournament.getWalllist().getMarkPreliminaryRegisteredParticipants());
        this.getJCheckBoxWalllistMarkResultsByReferee().setSelected(this.m_tournament.getWalllist().getMarkResultsByReferree());
        this.getJCheckBoxWalllistShowColors().setSelected(this.m_tournament.getWalllist().getShowColors());
        this.getJCheckBoxWalllistShowHandicap().setSelected(this.m_tournament.getWalllist().getShowHandicap());
        this.getJCheckBoxWalllistShowWarningMissingPairing().setSelected(this.m_tournament.getWalllist().getShowWarningMissingPairing());
        this.getJTextFieldWalllistFontsize().setText(Integer.toString(this.m_tournament.getWalllist().getFontsize()));
        this.getChckbxMarkFixedBoardnumbers().setSelected(this.m_tournament.getPairingsMarkFixedBoardnumbers());
        this.getJCheckBoxPairingsMarkMissingResults().setSelected(this.m_tournament.getPairingsMarkMissingResults());
        this.getJCheckBoxPairingsMarkWinner().setSelected(this.m_tournament.getPairingsMarkWinner());
        this.getChckbxMarkUnwantedPairings().setSelected(this.m_tournament.getPairingsMarkUnwantedPairings());
        this.getJCheckBoxPairingsShowLevels().setSelected(this.m_tournament.getPairingsShowLevels());
        this.getJCheckBoxPairingsShortLevel().setSelected(this.m_tournament.getPairingsShortNotationForLevel());
        this.getJCheckBoxPairingsShowScores().setSelected(this.m_tournament.getPairingsShowScores());
        this.getJCheckBoxPairingsShowHandicaps().setSelected(this.m_tournament.getPairingsShowHandicaps());
        this.getJTextFieldPairingsFontsize().setText(Integer.toString(this.m_tournament.getPairingsFontsize()));
        ButtonGroup bgHandicap = new ButtonGroup();
        bgHandicap.add(this.getJRadioButtonHandicapOnlyEvenGames());
        bgHandicap.add(this.getJRadioButtonHandicapUseHandicap());
        if (this.m_tournament.getHandicapUsed()) {
            this.getJRadioButtonHandicapUseHandicap().setSelected(true);
        } else {
            this.getJRadioButtonHandicapOnlyEvenGames().setSelected(true);
        }
        ButtonGroup bgHandicapRelative = new ButtonGroup();
        bgHandicapRelative.add(this.getJRadioButtonHandicapRelativeToScore());
        bgHandicapRelative.add(this.getJRadioButtonHandicapRelativeToLevel());
        if (this.m_tournament.getHandicapByLevel()) {
            this.getJRadioButtonHandicapRelativeToLevel().setSelected(true);
        } else {
            this.getJRadioButtonHandicapRelativeToScore().setSelected(true);
        }
        this.getJCheckBoxHandicapBelow().setSelected(this.m_tournament.getHandicapBelow());
        this.getJTextFieldHandicapUseHandicapBelow().setText(this.m_tournament.getHandicapBelowLevel().getDisplayString());
        this.getJCheckBoxHandicapAdjustment().setSelected(this.m_tournament.getHandicapAdjustment());
        this.getJTextFieldHandicapAdjustmentValue().setText(Integer.toString(this.m_tournament.getHandicapAdjustmentValue()));
        this.getJCheckBoxHandicapLimit().setSelected(this.m_tournament.getHandicapLimit());
        this.getJTextFieldHandicapLimit().setText(Integer.toString(this.m_tournament.getHandicapLimitValue()));
        this.getJCheckBoxHandicapIncludeHandicapInTieBreakers().setSelected(this.m_tournament.getHandicapIncludeInTieBreakers());
        this.setHandicapEnabled(this.m_tournament.getHandicapUsed());
        DefaultComboBoxModel<String> importEncodingsModel = new DefaultComboBoxModel<String>(Tournament.IMPORT_EXPORT_ENCODINGS);
        this.getComboBoxImportEncoding().setModel(importEncodingsModel);
        this.getComboBoxImportEncoding().setSelectedItem(this.m_tournament.getImportEncoding());
        ButtonGroup bgExportColumnDelimiter = new ButtonGroup();
        bgExportColumnDelimiter.add(this.getJRadioButtonExportColumnDelimiterTab());
        bgExportColumnDelimiter.add(this.getJRadioButtonExportColumnDelimiterSemikolon());
        bgExportColumnDelimiter.add(this.getJRadioButtonExportColumnDelimiterPipe());
        bgExportColumnDelimiter.add(this.getRdbtnUseFixedFormat());
        if (this.m_tournament.getExportColumnDelimiter().equals(";")) {
            this.getJRadioButtonExportColumnDelimiterSemikolon().setSelected(true);
        } else if (this.m_tournament.getExportColumnDelimiter().equals("|")) {
            this.getJRadioButtonExportColumnDelimiterPipe().setSelected(true);
        } else if (this.m_tournament.getExportColumnDelimiter().equals("f")) {
            this.getRdbtnUseFixedFormat().setSelected(true);
        } else {
            this.getJRadioButtonExportColumnDelimiterTab().setSelected(true);
        }
        this.getJCheckBoxExportWalllistShowTournamentTitle().setSelected(this.m_tournament.getExportWalllistShowTournamentTitle());
        DefaultComboBoxModel<String> exportEncodingsModel = new DefaultComboBoxModel<String>(Tournament.IMPORT_EXPORT_ENCODINGS);
        this.getJComboBoxExportEncoding().setModel(exportEncodingsModel);
        this.getJComboBoxExportEncoding().setSelectedItem(this.m_tournament.getExportEncoding());
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditTournamentSettingsDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditTournamentSettingsDialog.this.getJScrollPaneDescription().getVerticalScrollBar().setValue(0);
            }
        });
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    private void setHandicapEnabled(boolean enabled) {
        this.getJRadioButtonHandicapRelativeToScore().setEnabled(enabled);
        this.getJRadioButtonHandicapRelativeToLevel().setEnabled(enabled);
        this.getJCheckBoxHandicapBelow().setEnabled(enabled);
        this.getJCheckBoxHandicapAdjustment().setEnabled(enabled);
        this.getJCheckBoxHandicapLimit().setEnabled(enabled);
        this.setHandicapBelowEnabled(enabled && this.getJCheckBoxHandicapBelow().isSelected());
        this.setHandicapAdjustmentEnabled(enabled && this.getJCheckBoxHandicapAdjustment().isSelected());
        this.setHandicapLimitEnabled(enabled && this.getJCheckBoxHandicapLimit().isSelected());
    }

    private void setHandicapBelowEnabled(boolean enabled) {
        this.getJTextFieldHandicapUseHandicapBelow().setEnabled(enabled);
    }

    private void setHandicapAdjustmentEnabled(boolean enabled) {
        this.getJTextFieldHandicapAdjustmentValue().setEnabled(enabled);
    }

    private void setHandicapLimitEnabled(boolean enabled) {
        this.getJTextFieldHandicapLimit().setEnabled(enabled);
    }

    private void setUpperMacMahonBarEnabled(boolean enabled) {
        this.getJTextFieldUpperMacMahonBar().setEnabled(enabled);
    }

    private void setLowerMacMahonBarEnabled(boolean enabled) {
        this.getJTextFieldLowerMacMahonBar().setEnabled(enabled);
    }

    private void checkRatingAllowRatings(boolean initialCall) {
        if (initialCall || this.m_ratingAllowRatings != this.getJCheckBoxRatingAllowRatings().isSelected()) {
            this.m_ratingAllowRatings = this.getJCheckBoxRatingAllowRatings().isSelected();
            if (this.getJCheckBoxRatingAllowRatings().isSelected()) {
                ++this.m_surpressCheckRatingAllowRatings;
                if (!initialCall) {
                    this.m_upperMacMahonBarLevel = this.getJTextFieldUpperMacMahonBar().getText();
                }
                this.getJCheckBoxRatingDeterminesRank().setSelected(this.m_ratingDeterminesRank);
                this.getJCheckBoxRatingDeterminesRank().setEnabled(true);
                this.getJCheckBoxRatingDeterminesStartScore().setSelected(this.m_ratingDeterminesStartScore);
                this.getJCheckBoxRatingDeterminesStartScore().setEnabled(true);
                this.checkRatingDeterminesScore(true);
                --this.m_surpressCheckRatingAllowRatings;
            } else {
                ++this.m_surpressCheckRatingAllowRatings;
                if (!initialCall) {
                    this.m_ratingDeterminesRank = this.getJCheckBoxRatingDeterminesRank().isSelected();
                    this.m_ratingDeterminesStartScore = this.getJCheckBoxRatingDeterminesStartScore().isSelected();
                }
                this.getJCheckBoxRatingDeterminesRank().setSelected(false);
                this.getJCheckBoxRatingDeterminesRank().setEnabled(false);
                this.getJCheckBoxRatingDeterminesStartScore().setEnabled(false);
                if (initialCall || this.m_ratingDeterminesStartScore) {
                    this.getJCheckBoxRatingDeterminesStartScore().setSelected(false);
                    this.checkRatingDeterminesScore(true);
                }
                --this.m_surpressCheckRatingAllowRatings;
            }
        }
    }

    private void checkRatingDeterminesScore(boolean initialCall) {
        if (initialCall || (this.m_ratingDeterminesStartScore && this.m_ratingAllowRatings) != this.getJCheckBoxRatingDeterminesStartScore().isSelected()) {
            if (this.m_ratingAllowRatings) {
                if (!this.m_ratingDeterminesStartScore && !this.getJCheckBoxRatingDeterminesStartScore().isSelected()) {
                    this.m_upperMacMahonBarLevel = this.getJTextFieldUpperMacMahonBar().getText();
                    this.m_lowerMacMahonBar = this.getJCheckBoxLowerMacMahonBar().isSelected();
                    this.m_lowerMacMahonBarLevel = this.getJTextFieldLowerMacMahonBar().getText();
                }
                if (this.m_ratingDeterminesStartScore && this.getJCheckBoxRatingDeterminesStartScore().isSelected()) {
                    this.m_lowerMacMahonBar = this.getJCheckBoxLowerMacMahonBar().isSelected();
                    this.m_lowerMacMahonBarLevel = this.getJTextFieldLowerMacMahonBar().getText();
                }
                this.m_ratingDeterminesStartScore = this.getJCheckBoxRatingDeterminesStartScore().isSelected();
            }
            if (this.getJCheckBoxRatingDeterminesStartScore().isSelected()) {
                if (!initialCall) {
                    this.m_upperMacMahonBarLevel = this.getJTextFieldUpperMacMahonBar().getText();
                    this.m_lowerMacMahonBar = this.getJCheckBoxLowerMacMahonBar().isSelected();
                    this.m_lowerMacMahonBarLevel = this.getJTextFieldLowerMacMahonBar().getText();
                }
                this.getJTextFieldUpperMacMahonBar().setText(this.m_ratingUpperMacMahonBarRating);
                this.getJCheckBoxLowerMacMahonBar().setSelected(false);
                this.getJCheckBoxLowerMacMahonBar().setEnabled(false);
                this.getJTextFieldLowerMacMahonBar().setText(null);
                this.getJTextFieldLowerMacMahonBar().setEnabled(false);
            } else {
                if (!initialCall) {
                    this.m_ratingUpperMacMahonBarRating = this.getJTextFieldUpperMacMahonBar().getText();
                }
                this.getJTextFieldUpperMacMahonBar().setText(this.m_upperMacMahonBarLevel);
                this.getJCheckBoxLowerMacMahonBar().setSelected(this.m_lowerMacMahonBar);
                this.getJCheckBoxLowerMacMahonBar().setEnabled(true);
                this.getJTextFieldLowerMacMahonBar().setText(this.m_lowerMacMahonBarLevel);
                this.getJTextFieldLowerMacMahonBar().setEnabled(this.getJCheckBoxLowerMacMahonBar().isSelected());
            }
        }
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setSize(new Dimension(740, 492));
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setModal(true);
            this.jDialog.setTitle(Messages.getString("EditTournamentSettingsDialog.Title"));
            this.jDialog.setContentPane(this.getJContentPane());
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints2.gridy = 1;
            this.jLabelName = new JLabel();
            this.jLabelName.setText(Messages.getString("EditTournamentSettingsDialog.MainNameLabel"));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJButtonOk(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJTabbedPane(), gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private JTextField getJTextFieldName() {
        if (this.jTextFieldName == null) {
            this.jTextFieldName = new JTextField();
        }
        return this.jTextFieldName;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("EditTournamentSettingsDialog.OK"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().blockSort();
                    boolean ok = true;
                    String name = EditTournamentSettingsDialog.this.getJTextFieldName().getText().trim();
                    EditTournamentSettingsDialog.this.m_tournament.setName(name.length() == 0 ? null : name);
                    String description = EditTournamentSettingsDialog.this.getJTextAreaDescription().getText().trim();
                    EditTournamentSettingsDialog.this.m_tournament.setDescription(description.length() == 0 ? null : description);
                    int numberOfRounds = 0;
                    try {
                        numberOfRounds = Integer.parseInt(EditTournamentSettingsDialog.this.getJTextFieldNumberOfRounds().getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        EditTournamentSettingsDialog.this.m_tournament.setNumberOfRounds(numberOfRounds);
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(EditTournamentSettingsDialog.this.getJDialog());
                        ok = false;
                    }
                    if (EditTournamentSettingsDialog.this.getJRadioButtonBoardsize19x19().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setBoardsize(19);
                    } else if (EditTournamentSettingsDialog.this.getJRadioButtonBoardsize13x13().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setBoardsize(13);
                    } else if (EditTournamentSettingsDialog.this.getJRadioButtonBoardsize9x9().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setBoardsize(9);
                    } else {
                        EditTournamentSettingsDialog.this.m_tournament.setBoardsize(0);
                    }
                    EditTournamentSettingsDialog.this.m_tournament.setAllowJigo(EditTournamentSettingsDialog.this.getJCheckBoxAllowJigo().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setRatingAllowed(EditTournamentSettingsDialog.this.getJCheckBoxRatingAllowRatings().isSelected());
                    if (EditTournamentSettingsDialog.this.getJCheckBoxRatingAllowRatings().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setRatingDeterminesRank(EditTournamentSettingsDialog.this.getJCheckBoxRatingDeterminesRank().isSelected());
                        EditTournamentSettingsDialog.this.m_tournament.setRatingDeterminesStartScore(EditTournamentSettingsDialog.this.getJCheckBoxRatingDeterminesStartScore().isSelected());
                    }
                    if (EditTournamentSettingsDialog.this.getJCheckBoxRatingDeterminesStartScore().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setUpperMacMahonBar(EditTournamentSettingsDialog.this.getJCheckBoxUpperMacMahonBar().isSelected());
                        if (EditTournamentSettingsDialog.this.getJCheckBoxUpperMacMahonBar().isSelected()) {
                            int upperMacMahonBarRating = 0;
                            try {
                                upperMacMahonBarRating = Integer.parseInt(EditTournamentSettingsDialog.this.getJTextFieldUpperMacMahonBar().getText());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            EditTournamentSettingsDialog.this.m_tournament.setUpperMacMahonBarRating(upperMacMahonBarRating);
                        }
                    } else {
                        GoLevel upperMacMahonBar = null;
                        if (EditTournamentSettingsDialog.this.getJCheckBoxUpperMacMahonBar().isSelected()) {
                            try {
                                upperMacMahonBar = new GoLevel(EditTournamentSettingsDialog.this.getJTextFieldUpperMacMahonBar().getText());
                            }
                            catch (MacMahonException exception) {
                                new DisplayMacMahonExceptionDialog(exception).show(EditTournamentSettingsDialog.this.getJDialog());
                                ok = false;
                            }
                        }
                        GoLevel lowerMacMahonBar = null;
                        if (EditTournamentSettingsDialog.this.getJCheckBoxLowerMacMahonBar().isSelected()) {
                            try {
                                lowerMacMahonBar = new GoLevel(EditTournamentSettingsDialog.this.getJTextFieldLowerMacMahonBar().getText());
                            }
                            catch (MacMahonException exception) {
                                new DisplayMacMahonExceptionDialog(exception).show(EditTournamentSettingsDialog.this.getJDialog());
                                ok = false;
                            }
                        }
                        if (ok) {
                            if (upperMacMahonBar != null && lowerMacMahonBar != null && upperMacMahonBar.compareTo(lowerMacMahonBar) < 0) {
                                new DisplayMacMahonExceptionDialog(new MacMahonException(Messages.getString("EditTournamentSettingsDialog.MessageMacMahonBarsInvalid"))).show(EditTournamentSettingsDialog.this.getJDialog());
                                ok = false;
                            } else {
                                EditTournamentSettingsDialog.this.m_tournament.setUpperMacMahonBar(EditTournamentSettingsDialog.this.getJCheckBoxUpperMacMahonBar().isSelected());
                                if (EditTournamentSettingsDialog.this.getJCheckBoxUpperMacMahonBar().isSelected()) {
                                    EditTournamentSettingsDialog.this.m_tournament.setUpperMacMahonBarLevel(upperMacMahonBar);
                                }
                                EditTournamentSettingsDialog.this.m_tournament.setLowerMacMahonBar(EditTournamentSettingsDialog.this.getJCheckBoxLowerMacMahonBar().isSelected());
                                if (EditTournamentSettingsDialog.this.getJCheckBoxLowerMacMahonBar().isSelected()) {
                                    EditTournamentSettingsDialog.this.m_tournament.setLowerMacMahonBarLevel(lowerMacMahonBar);
                                }
                            }
                        }
                    }
                    EditTournamentSettingsDialog.this.m_tournament.setByeShouldResultInZeroSOSetc(EditTournamentSettingsDialog.this.getJCheckBoxByeSos().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setHalfScoreGroupsRoundDown(EditTournamentSettingsDialog.this.getJCheckBoxHalfScoreGroupsRoundDown().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setHalfScoreGroupsRoundDownNotJigo(EditTournamentSettingsDialog.this.getJCheckBoxHalfScoreGroupsRoundDownNotJigo().isSelected());
                    if (EditTournamentSettingsDialog.this.getJRadioButtonPlacementCriteriaWeakRankNameId().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.getWalllist().setWeakSortCriteria(1);
                    } else if (EditTournamentSettingsDialog.this.getJRadioButtonPlacementCriteriaWeakNameId().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.getWalllist().setWeakSortCriteria(2);
                    } else {
                        EditTournamentSettingsDialog.this.m_tournament.getWalllist().setWeakSortCriteria(3);
                    }
                    ArrayList<Walllist.SortCriterionDescriptor> sortCriteria = new ArrayList<Walllist.SortCriterionDescriptor>();
                    DefaultListModel sortCriteriaListModel = (DefaultListModel)EditTournamentSettingsDialog.this.getJListSortCriteriaActive().getModel();
                    int i = 0;
                    while (i < sortCriteriaListModel.getSize()) {
                        sortCriteria.add((Walllist.SortCriterionDescriptor)sortCriteriaListModel.get(i));
                        ++i;
                    }
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setSortCriteria(sortCriteria);
                    EditTournamentSettingsDialog.this.m_tournament.setOnlineEgdSupport(EditTournamentSettingsDialog.this.getJCheckBoxRegistrationEGDSupport().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setOnlineEgdSupportByPin(EditTournamentSettingsDialog.this.getJCheckBoxRegistrationSearchEGDByPin().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPreliminaryDefaultRegistration(EditTournamentSettingsDialog.this.getJRadioButtonRegistrationDefaultRegistrationPreliminary().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setDefaultCountry((Country)EditTournamentSettingsDialog.this.getJComboBoxRegistrationDefaultCountry().getSelectedItem());
                    EditTournamentSettingsDialog.this.m_tournament.setDefaultNationality((Country)EditTournamentSettingsDialog.this.getJComboBoxRegistrationDefaultNationality().getSelectedItem());
                    EditTournamentSettingsDialog.this.m_tournament.setDefaultAsianName(EditTournamentSettingsDialog.this.getJCheckBoxRegistrationDefaultAsianName().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowLevels(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowLevels().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShortNotationForLevel(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShortLevel().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowBarMembership(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowBarMembership().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowRatings(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowRating().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowCountry(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowCountry().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowClub(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowClub().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowClubEgdName(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowClubEgdName().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowClubAbbreviateName(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowClubAbbreviateName().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setClubColumnAlignmentCenter(EditTournamentSettingsDialog.this.getJCheckBoxWalllistClubColumnAlignment().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setMarkPreliminaryRegisteredParticipants(EditTournamentSettingsDialog.this.getJCheckBoxWalllistMarkPreliminaryRegisteredParticipants().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setMarkResultsByReferree(EditTournamentSettingsDialog.this.getJCheckBoxWalllistMarkResultsByReferee().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowColors(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowColors().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowHandicap(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowHandicap().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setShowWarningMissingPairing(EditTournamentSettingsDialog.this.getJCheckBoxWalllistShowWarningMissingPairing().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().setFontsize(Integer.parseInt(EditTournamentSettingsDialog.this.getJTextFieldWalllistFontsize().getText()));
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsMarkFixedBoardnumbers(EditTournamentSettingsDialog.this.getChckbxMarkFixedBoardnumbers().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsMarkMissingResults(EditTournamentSettingsDialog.this.getJCheckBoxPairingsMarkMissingResults().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsMarkWinner(EditTournamentSettingsDialog.this.getJCheckBoxPairingsMarkWinner().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsMarkUnwantedPairings(EditTournamentSettingsDialog.this.getChckbxMarkUnwantedPairings().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsShowLevels(EditTournamentSettingsDialog.this.getJCheckBoxPairingsShowLevels().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsShortNotationForLevel(EditTournamentSettingsDialog.this.getJCheckBoxPairingsShortLevel().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsShowScores(EditTournamentSettingsDialog.this.getJCheckBoxPairingsShowScores().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsShowHandicaps(EditTournamentSettingsDialog.this.getJCheckBoxPairingsShowHandicaps().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setPairingsFontsize(Integer.parseInt(EditTournamentSettingsDialog.this.getJTextFieldPairingsFontsize().getText()));
                    EditTournamentSettingsDialog.this.m_tournament.setHandicapUsed(EditTournamentSettingsDialog.this.getJRadioButtonHandicapUseHandicap().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setHandicapByLevel(EditTournamentSettingsDialog.this.getJRadioButtonHandicapRelativeToLevel().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setHandicapBelow(EditTournamentSettingsDialog.this.getJCheckBoxHandicapBelow().isSelected());
                    if (EditTournamentSettingsDialog.this.getJCheckBoxHandicapBelow().isSelected()) {
                        try {
                            EditTournamentSettingsDialog.this.m_tournament.setHandicapBelowLevel(new GoLevel(EditTournamentSettingsDialog.this.getJTextFieldHandicapUseHandicapBelow().getText()));
                        }
                        catch (MacMahonException exception) {
                            new DisplayMacMahonExceptionDialog(exception).show(EditTournamentSettingsDialog.this.getJDialog());
                            ok = false;
                        }
                    }
                    EditTournamentSettingsDialog.this.m_tournament.setHandicapAdjustment(EditTournamentSettingsDialog.this.getJCheckBoxHandicapAdjustment().isSelected());
                    if (EditTournamentSettingsDialog.this.getJCheckBoxHandicapAdjustment().isSelected()) {
                        int handicapAdjustmentValue = 0;
                        try {
                            handicapAdjustmentValue = Integer.parseInt(EditTournamentSettingsDialog.this.getJTextFieldHandicapAdjustmentValue().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        EditTournamentSettingsDialog.this.m_tournament.setHandicapAdjustmentValue(handicapAdjustmentValue);
                    }
                    EditTournamentSettingsDialog.this.m_tournament.setHandicapLimit(EditTournamentSettingsDialog.this.getJCheckBoxHandicapLimit().isSelected());
                    if (EditTournamentSettingsDialog.this.getJCheckBoxHandicapLimit().isSelected()) {
                        int handicapLimit = 0;
                        try {
                            handicapLimit = Integer.parseInt(EditTournamentSettingsDialog.this.getJTextFieldHandicapLimit().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            EditTournamentSettingsDialog.this.m_tournament.setHandicapLimitValue(handicapLimit);
                        }
                        catch (MacMahonException exception) {
                            new DisplayMacMahonExceptionDialog(exception).show(EditTournamentSettingsDialog.this.getJDialog());
                            ok = false;
                        }
                    }
                    EditTournamentSettingsDialog.this.m_tournament.setHandicapIncludeInTieBreakers(EditTournamentSettingsDialog.this.getJCheckBoxHandicapIncludeHandicapInTieBreakers().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setImportEncoding((String)EditTournamentSettingsDialog.this.getComboBoxImportEncoding().getSelectedItem());
                    if (EditTournamentSettingsDialog.this.getJRadioButtonExportColumnDelimiterSemikolon().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setExportColumnDelimiter(";");
                    } else if (EditTournamentSettingsDialog.this.getJRadioButtonExportColumnDelimiterPipe().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setExportColumnDelimiter("|");
                    } else if (EditTournamentSettingsDialog.this.getRdbtnUseFixedFormat().isSelected()) {
                        EditTournamentSettingsDialog.this.m_tournament.setExportColumnDelimiter("f");
                    } else {
                        EditTournamentSettingsDialog.this.m_tournament.setExportColumnDelimiter("\t");
                    }
                    EditTournamentSettingsDialog.this.m_tournament.setExportWalllistShowTournamentTitle(EditTournamentSettingsDialog.this.getJCheckBoxExportWalllistShowTournamentTitle().isSelected());
                    EditTournamentSettingsDialog.this.m_tournament.setExportEncoding((String)EditTournamentSettingsDialog.this.getJComboBoxExportEncoding().getSelectedItem());
                    EditTournamentSettingsDialog.this.m_tournament.getWalllist().unblockSort();
                    if (ok) {
                        EditTournamentSettingsDialog.this.getJDialog().dispose();
                    }
                }
            });
        }
        return this.jButtonOk;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabMainTitle"), null, this.getJPanelMainSettings(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabPlacementCriteriaTitle"), null, this.getJPanelSortCriteria(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabRegistrationTitle"), null, this.getJPanelRegistration(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabWalllistTitle"), null, this.getJPanelWalllist(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabPairingsTitle"), null, this.getJPanelPairings(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabHandicapTitle"), null, this.getJPanelHandicap(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.panelImport.title", "Import"), null, this.getPanelImport(), null);
            this.jTabbedPane.addTab(Messages.getString("EditTournamentSettingsDialog.TabExportTitle"), null, this.getJPanelExport(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelMainSettings() {
        if (this.jPanelMainSettings == null) {
            GridBagConstraints gridBagConstraints91 = new GridBagConstraints();
            gridBagConstraints91.fill = 1;
            gridBagConstraints91.gridy = -1;
            gridBagConstraints91.weightx = 1.0;
            gridBagConstraints91.weighty = 1.0;
            gridBagConstraints91.gridx = -1;
            GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
            gridBagConstraints66.gridx = 1;
            gridBagConstraints66.anchor = 17;
            gridBagConstraints66.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints66.gridy = 5;
            GridBagConstraints gridBagConstraints310 = new GridBagConstraints();
            gridBagConstraints310.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints310.gridx = 0;
            gridBagConstraints310.anchor = 13;
            gridBagConstraints310.gridy = 5;
            this.jLabelRating = new JLabel();
            this.jLabelRating.setText(Messages.getString("EditTournamentSettingsDialog.MainRatingLabel"));
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.anchor = 17;
            gridBagConstraints110.gridx = 1;
            gridBagConstraints110.gridy = 4;
            gridBagConstraints110.insets = new Insets(0, 10, 0, 0);
            GridBagConstraints gridBagConstraints81 = new GridBagConstraints();
            gridBagConstraints81.gridx = 1;
            gridBagConstraints81.anchor = 17;
            gridBagConstraints81.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints81.gridy = 3;
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            gridBagConstraints71.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints71.gridx = 0;
            gridBagConstraints71.anchor = 13;
            gridBagConstraints71.gridy = 3;
            this.jLabelBoardsize = new JLabel();
            this.jLabelBoardsize.setText(Messages.getString("EditTournamentSettingsDialog.MainBoardsizeLabel"));
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints5.gridy = 2;
            this.jLabelNumberOfRounds = new JLabel();
            this.jLabelNumberOfRounds.setText(Messages.getString("EditTournamentSettingsDialog.MainNumberOfRoundsLabel"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.anchor = 12;
            gridBagConstraints21.gridy = 1;
            this.jLabelDescription = new JLabel();
            this.jLabelDescription.setText(Messages.getString("EditTournamentSettingsDialog.MainDescriptionLabel"));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.insets = new Insets(0, 10, 5, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            this.jPanelMainSettings = new JPanel();
            GridBagLayout gbl_jPanelMainSettings = new GridBagLayout();
            gbl_jPanelMainSettings.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            gbl_jPanelMainSettings.columnWeights = new double[]{0.0, 0.0};
            this.jPanelMainSettings.setLayout(gbl_jPanelMainSettings);
            this.jPanelMainSettings.add((Component)this.jLabelName, gridBagConstraints);
            this.jPanelMainSettings.add((Component)this.getJTextFieldName(), gridBagConstraints1);
            this.jPanelMainSettings.add((Component)this.jLabelDescription, gridBagConstraints21);
            this.jPanelMainSettings.add((Component)this.getJScrollPaneDescription(), gridBagConstraints4);
            this.jPanelMainSettings.add((Component)this.jLabelNumberOfRounds, gridBagConstraints5);
            this.jPanelMainSettings.add((Component)this.getJPanelNumberOfRounds(), gridBagConstraints6);
            this.jPanelMainSettings.add((Component)this.jLabelBoardsize, gridBagConstraints71);
            this.jPanelMainSettings.add((Component)this.getJPanelBoardsize(), gridBagConstraints81);
            this.jPanelMainSettings.add((Component)this.getJCheckBoxAllowJigo(), gridBagConstraints110);
            GridBagConstraints gridBagConstraints82 = new GridBagConstraints();
            gridBagConstraints82.gridx = 1;
            gridBagConstraints82.fill = 0;
            gridBagConstraints82.weightx = 0.0;
            gridBagConstraints82.weighty = 0.0;
            gridBagConstraints82.anchor = 18;
            gridBagConstraints82.insets = new Insets(0, 30, 0, 0);
            gridBagConstraints82.gridy = 6;
            this.jPanelMainSettings.add((Component)this.getJPanelRatingSettings(), gridBagConstraints82);
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.anchor = 12;
            gridBagConstraints15.insets = new Insets(4, 0, 0, 5);
            gridBagConstraints15.gridy = 7;
            this.jLabelMacMahonBars = new JLabel();
            this.jLabelMacMahonBars.setText(Messages.getString("EditTournamentSettingsDialog.MainMacMahonBarsLabel"));
            this.jPanelMainSettings.add((Component)this.jLabelMacMahonBars, gridBagConstraints15);
            this.jPanelMainSettings.add((Component)this.jLabelRating, gridBagConstraints310);
            this.jPanelMainSettings.add((Component)this.getJCheckBoxRatingAllowRatings(), gridBagConstraints66);
            GridBagConstraints gridBagConstraints210 = new GridBagConstraints();
            gridBagConstraints210.gridx = 1;
            gridBagConstraints210.fill = 1;
            gridBagConstraints210.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints210.gridy = 7;
            this.jPanelMainSettings.add((Component)this.getJPanelMacMahonBars(), gridBagConstraints210);
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints111.gridx = 0;
            gridBagConstraints111.anchor = 13;
            gridBagConstraints111.gridy = 8;
            this.jLabelBye = new JLabel();
            this.jLabelBye.setText(Messages.getString("EditTournamentSettingsDialog.MainByeLabel"));
            this.jPanelMainSettings.add((Component)this.jLabelBye, gridBagConstraints111);
            GridBagConstraints gridBagConstraints211 = new GridBagConstraints();
            gridBagConstraints211.gridx = 1;
            gridBagConstraints211.anchor = 17;
            gridBagConstraints211.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints211.gridy = 8;
            this.jPanelMainSettings.add((Component)this.getJCheckBoxByeSos(), gridBagConstraints211);
            GridBagConstraints gridBagConstraints311 = new GridBagConstraints();
            gridBagConstraints311.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints311.gridx = 0;
            gridBagConstraints311.anchor = 13;
            gridBagConstraints311.gridy = 9;
            this.jLabelHalfScoreGroups = new JLabel();
            this.jLabelHalfScoreGroups.setText(Messages.getString("EditTournamentSettingsDialog.MainHalfScoreGroupsLabel"));
            this.jPanelMainSettings.add((Component)this.jLabelHalfScoreGroups, gridBagConstraints311);
            GridBagConstraints gridBagConstraints410 = new GridBagConstraints();
            gridBagConstraints410.gridx = 1;
            gridBagConstraints410.anchor = 17;
            gridBagConstraints410.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints410.gridy = 9;
            this.jPanelMainSettings.add((Component)this.getJCheckBoxHalfScoreGroupsRoundDown(), gridBagConstraints410);
            GridBagConstraints gridBagConstraints112 = new GridBagConstraints();
            gridBagConstraints112.gridx = 1;
            gridBagConstraints112.anchor = 17;
            gridBagConstraints112.insets = new Insets(0, 30, 0, 0);
            gridBagConstraints112.gridy = 10;
            this.jPanelMainSettings.add((Component)this.getJCheckBoxHalfScoreGroupsRoundDownNotJigo(), gridBagConstraints112);
        }
        return this.jPanelMainSettings;
    }

    private JTextArea getJTextAreaDescription() {
        if (this.jTextAreaDescription == null) {
            this.jTextAreaDescription = new JTextArea();
            this.jTextAreaDescription.setWrapStyleWord(true);
            this.jTextAreaDescription.setLineWrap(true);
        }
        return this.jTextAreaDescription;
    }

    private JScrollPane getJScrollPaneDescription() {
        if (this.jScrollPaneDescription == null) {
            this.jScrollPaneDescription = new JScrollPane();
            this.jScrollPaneDescription.setVerticalScrollBarPolicy(20);
            this.jScrollPaneDescription.setViewportView(this.getJTextAreaDescription());
        }
        return this.jScrollPaneDescription;
    }

    private JPanel getJPanelNumberOfRounds() {
        if (this.jPanelNumberOfRounds == null) {
            this.jPanelNumberOfRounds = new JPanel();
            this.jPanelNumberOfRounds.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 0.0;
            this.jPanelNumberOfRounds.add((Component)this.getJTextFieldNumberOfRounds(), gridBagConstraints3);
            GridBagConstraints gridBagConstraints102 = new GridBagConstraints();
            gridBagConstraints102.gridx = 1;
            gridBagConstraints102.insets = new Insets(0, 80, 0, 5);
            gridBagConstraints102.gridy = 0;
            this.jLabelVersionCreated = new JLabel();
            this.jLabelVersionCreated.setText(Messages.getString("EditTournamentSettingsDialog.CreatedWithLabel"));
            this.jPanelNumberOfRounds.add((Component)this.jLabelVersionCreated, gridBagConstraints102);
            GridBagConstraints gridBagConstraints103 = new GridBagConstraints();
            gridBagConstraints103.fill = 3;
            gridBagConstraints103.gridy = 0;
            gridBagConstraints103.weightx = 0.0;
            gridBagConstraints103.insets = new Insets(0, 10, 0, 5);
            gridBagConstraints103.gridx = 2;
            this.jPanelNumberOfRounds.add((Component)this.getJTextFieldVersionCreated(), gridBagConstraints103);
            GridBagConstraints gridBagConstraints104 = new GridBagConstraints();
            gridBagConstraints104.gridx = 3;
            gridBagConstraints104.insets = new Insets(0, 10, 0, 5);
            gridBagConstraints104.gridy = 0;
            this.jLabelVersionSaved = new JLabel();
            this.jLabelVersionSaved.setText(Messages.getString("EditTournamentSettingsDialog.SavedWithLabel"));
            this.jPanelNumberOfRounds.add((Component)this.jLabelVersionSaved, gridBagConstraints104);
            GridBagConstraints gridBagConstraints105 = new GridBagConstraints();
            gridBagConstraints105.fill = 3;
            gridBagConstraints105.gridy = 0;
            gridBagConstraints105.weightx = 0.0;
            gridBagConstraints105.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints105.gridx = 4;
            this.jPanelNumberOfRounds.add((Component)this.getJTextFieldVersionSaved(), gridBagConstraints105);
        }
        return this.jPanelNumberOfRounds;
    }

    private JTextField getJTextFieldNumberOfRounds() {
        if (this.jTextFieldNumberOfRounds == null) {
            this.jTextFieldNumberOfRounds = new JTextField();
            this.jTextFieldNumberOfRounds.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldNumberOfRounds.setMinimumSize(this.jTextFieldNumberOfRounds.getPreferredSize());
        }
        return this.jTextFieldNumberOfRounds;
    }

    private JPanel getJPanelHandicap() {
        if (this.jPanelHandicap == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.anchor = 18;
            gridBagConstraints13.gridwidth = 3;
            gridBagConstraints13.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints13.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 18;
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 1;
            this.jPanelHandicap = new JPanel();
            GridBagLayout gbl_jPanelHandicap = new GridBagLayout();
            gbl_jPanelHandicap.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            gbl_jPanelHandicap.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0};
            this.jPanelHandicap.setLayout(gbl_jPanelHandicap);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.gridy = 0;
            this.jPanelHandicap.add((Component)this.getJRadioButtonHandicapOnlyEvenGames(), gridBagConstraints7);
            this.jPanelHandicap.add((Component)this.getJRadioButtonHandicapUseHandicap(), gridBagConstraints8);
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.anchor = 18;
            gridBagConstraints12.gridwidth = 3;
            gridBagConstraints12.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints12.gridy = 2;
            this.jPanelHandicap.add((Component)this.getJRadioButtonHandicapRelativeToLevel(), gridBagConstraints12);
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 1;
            gridBagConstraints25.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.gridy = 3;
            this.jPanelHandicap.add((Component)this.getJCheckBoxHandicapBelow(), gridBagConstraints25);
            this.jPanelHandicap.add((Component)this.getJRadioButtonHandicapRelativeToScore(), gridBagConstraints13);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 3;
            gridBagConstraints9.anchor = 10;
            gridBagConstraints9.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.ipadx = 0;
            gridBagConstraints9.gridx = 2;
            this.jPanelHandicap.add((Component)this.getJTextFieldHandicapUseHandicapBelow(), gridBagConstraints9);
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 1;
            gridBagConstraints20.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.gridy = 4;
            this.jPanelHandicap.add((Component)this.getJCheckBoxHandicapAdjustment(), gridBagConstraints20);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridx = 2;
            gridBagConstraints16.gridy = 4;
            gridBagConstraints16.weightx = 0.0;
            gridBagConstraints16.ipadx = 0;
            gridBagConstraints16.insets = new Insets(0, 10, 5, 5);
            this.jPanelHandicap.add((Component)this.getJTextFieldHandicapAdjustmentValue(), gridBagConstraints16);
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 3;
            gridBagConstraints14.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.gridy = 4;
            this.jLabelHandicapAdjustBy = new JLabel();
            this.jLabelHandicapAdjustBy.setText(Messages.getString("EditTournamentSettingsDialog.HandicalAdjustByStonesLabel"));
            this.jPanelHandicap.add((Component)this.jLabelHandicapAdjustBy, gridBagConstraints14);
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.gridwidth = 1;
            gridBagConstraints26.anchor = 17;
            gridBagConstraints26.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints26.gridy = 5;
            this.jPanelHandicap.add((Component)this.getJCheckBoxHandicapLimit(), gridBagConstraints26);
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 2;
            gridBagConstraints27.gridy = 5;
            gridBagConstraints27.weightx = 0.0;
            gridBagConstraints27.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints27.ipadx = 0;
            gridBagConstraints27.gridx = 2;
            this.jPanelHandicap.add((Component)this.getJTextFieldHandicapLimit(), gridBagConstraints27);
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 3;
            gridBagConstraints28.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints28.anchor = 17;
            gridBagConstraints28.gridy = 5;
            this.jLabelHandicapLimit = new JLabel();
            this.jLabelHandicapLimit.setText(Messages.getString("EditTournamentSettingsDialog.HandicalLimitStonesLabel"));
            this.jPanelHandicap.add((Component)this.jLabelHandicapLimit, gridBagConstraints28);
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints37.gridx = 0;
            gridBagConstraints37.gridwidth = 4;
            gridBagConstraints37.anchor = 17;
            gridBagConstraints37.gridy = 6;
            this.jPanelHandicap.add((Component)this.getJCheckBoxHandicapIncludeHandicapInTieBreakers(), gridBagConstraints37);
            GridBagConstraints gbc_jPanelHandicapDummy = new GridBagConstraints();
            gbc_jPanelHandicapDummy.fill = 1;
            gbc_jPanelHandicapDummy.gridx = 3;
            gbc_jPanelHandicapDummy.gridy = 7;
            this.jPanelHandicap.add((Component)this.getJPanelHandicapDummy(), gbc_jPanelHandicapDummy);
        }
        return this.jPanelHandicap;
    }

    private JRadioButton getJRadioButtonHandicapOnlyEvenGames() {
        if (this.jRadioButtonHandicapOnlyEvenGames == null) {
            this.jRadioButtonHandicapOnlyEvenGames = new JRadioButton();
            this.jRadioButtonHandicapOnlyEvenGames.setText(Messages.getString("EditTournamentSettingsDialog.HandycapOnlyEvenGamesRadioButton"));
        }
        return this.jRadioButtonHandicapOnlyEvenGames;
    }

    private JRadioButton getJRadioButtonHandicapUseHandicap() {
        if (this.jRadioButtonHandicapUseHandicap == null) {
            this.jRadioButtonHandicapUseHandicap = new JRadioButton();
            this.jRadioButtonHandicapUseHandicap.setText(Messages.getString("EditTournamentSettingsDialog.HandicapUseHandicapRadioButton"));
            this.jRadioButtonHandicapUseHandicap.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditTournamentSettingsDialog.this.setHandicapEnabled(EditTournamentSettingsDialog.this.jRadioButtonHandicapUseHandicap.isSelected());
                }
            });
        }
        return this.jRadioButtonHandicapUseHandicap;
    }

    private JTextField getJTextFieldHandicapUseHandicapBelow() {
        if (this.jTextFieldHandicapUseHandicapBelow == null) {
            this.jTextFieldHandicapUseHandicapBelow = new JTextField();
            this.jTextFieldHandicapUseHandicapBelow.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldHandicapUseHandicapBelow.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldHandicapUseHandicapBelow;
    }

    private JRadioButton getJRadioButtonHandicapRelativeToLevel() {
        if (this.jRadioButtonHandicapRelativeToLevel == null) {
            this.jRadioButtonHandicapRelativeToLevel = new JRadioButton();
            this.jRadioButtonHandicapRelativeToLevel.setText(Messages.getString("EditTournamentSettingsDialog.HandicapBasedOnStrengthRadioButton"));
        }
        return this.jRadioButtonHandicapRelativeToLevel;
    }

    private JRadioButton getJRadioButtonHandicapRelativeToScore() {
        if (this.jRadioButtonHandicapRelativeToScore == null) {
            this.jRadioButtonHandicapRelativeToScore = new JRadioButton();
            this.jRadioButtonHandicapRelativeToScore.setText(Messages.getString("EditTournamentSettingsDialog.HandicapBasedOnScoreRadioButton"));
        }
        return this.jRadioButtonHandicapRelativeToScore;
    }

    private JTextField getJTextFieldHandicapAdjustmentValue() {
        if (this.jTextFieldHandicapAdjustmentValue == null) {
            this.jTextFieldHandicapAdjustmentValue = new JTextField();
            this.jTextFieldHandicapAdjustmentValue.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldHandicapAdjustmentValue.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldHandicapAdjustmentValue;
    }

    private JPanel getJPanelBoardsize() {
        if (this.jPanelBoardsize == null) {
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 3;
            gridBagConstraints24.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints24.gridy = 0;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 2;
            gridBagConstraints23.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints23.gridy = 0;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints22.gridy = 0;
            this.jPanelBoardsize = new JPanel();
            this.jPanelBoardsize.setLayout(new GridBagLayout());
            this.jPanelBoardsize.add((Component)this.getJRadioButtonBoardsize19x19(), new GridBagConstraints());
            this.jPanelBoardsize.add((Component)this.getJRadioButtonBoardsize13x13(), gridBagConstraints22);
            this.jPanelBoardsize.add((Component)this.getJRadioButtonBoardsize9x9(), gridBagConstraints23);
            this.jPanelBoardsize.add((Component)this.getJRadioButtonBoardsizeOther(), gridBagConstraints24);
        }
        return this.jPanelBoardsize;
    }

    private JRadioButton getJRadioButtonBoardsize19x19() {
        if (this.jRadioButtonBoardsize19x19 == null) {
            this.jRadioButtonBoardsize19x19 = new JRadioButton();
            this.jRadioButtonBoardsize19x19.setText(Messages.getString("EditTournamentSettingsDialog.Main19x19RadioButton"));
        }
        return this.jRadioButtonBoardsize19x19;
    }

    private JRadioButton getJRadioButtonBoardsize13x13() {
        if (this.jRadioButtonBoardsize13x13 == null) {
            this.jRadioButtonBoardsize13x13 = new JRadioButton();
            this.jRadioButtonBoardsize13x13.setText(Messages.getString("EditTournamentSettingsDialog.Main13x13RadioButton"));
        }
        return this.jRadioButtonBoardsize13x13;
    }

    private JRadioButton getJRadioButtonBoardsize9x9() {
        if (this.jRadioButtonBoardsize9x9 == null) {
            this.jRadioButtonBoardsize9x9 = new JRadioButton();
            this.jRadioButtonBoardsize9x9.setText(Messages.getString("EditTournamentSettingsDialog.Main9x9RadioButton"));
        }
        return this.jRadioButtonBoardsize9x9;
    }

    private JRadioButton getJRadioButtonBoardsizeOther() {
        if (this.jRadioButtonBoardsizeOther == null) {
            this.jRadioButtonBoardsizeOther = new JRadioButton();
            this.jRadioButtonBoardsizeOther.setText(Messages.getString("EditTournamentSettingsDialog.MainOtherBoardsizeRadioButton"));
        }
        return this.jRadioButtonBoardsizeOther;
    }

    private JCheckBox getJCheckBoxAllowJigo() {
        if (this.jCheckBoxAllowJigo == null) {
            this.jCheckBoxAllowJigo = new JCheckBox();
            this.jCheckBoxAllowJigo.setText(Messages.getString("EditTournamentSettingsDialog.MainAllowJigoCheckBox"));
        }
        return this.jCheckBoxAllowJigo;
    }

    private JCheckBox getJCheckBoxHandicapLimit() {
        if (this.jCheckBoxHandicapLimit == null) {
            this.jCheckBoxHandicapLimit = new JCheckBox();
            this.jCheckBoxHandicapLimit.setText(Messages.getString("EditTournamentSettingsDialog.HanidicapLimitHandicapCheckBox"));
            this.jCheckBoxHandicapLimit.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditTournamentSettingsDialog.this.setHandicapLimitEnabled(EditTournamentSettingsDialog.this.jCheckBoxHandicapLimit.isSelected());
                }
            });
        }
        return this.jCheckBoxHandicapLimit;
    }

    private JTextField getJTextFieldHandicapLimit() {
        if (this.jTextFieldHandicapLimit == null) {
            this.jTextFieldHandicapLimit = new JTextField();
            this.jTextFieldHandicapLimit.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldHandicapLimit.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldHandicapLimit;
    }

    private JCheckBox getJCheckBoxHandicapBelow() {
        if (this.jCheckBoxHandicapBelow == null) {
            this.jCheckBoxHandicapBelow = new JCheckBox();
            this.jCheckBoxHandicapBelow.setText(Messages.getString("EditTournamentSettingsDialog.HandicapBelowLevelCheckBox"));
            this.jCheckBoxHandicapBelow.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditTournamentSettingsDialog.this.setHandicapBelowEnabled(EditTournamentSettingsDialog.this.jCheckBoxHandicapBelow.isSelected());
                }
            });
        }
        return this.jCheckBoxHandicapBelow;
    }

    private JCheckBox getJCheckBoxHandicapAdjustment() {
        if (this.jCheckBoxHandicapAdjustment == null) {
            this.jCheckBoxHandicapAdjustment = new JCheckBox();
            this.jCheckBoxHandicapAdjustment.setText(Messages.getString("EditTournamentSettingsDialog.HandicapAdjustByCheckBox"));
            this.jCheckBoxHandicapAdjustment.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditTournamentSettingsDialog.this.setHandicapAdjustmentEnabled(EditTournamentSettingsDialog.this.jCheckBoxHandicapAdjustment.isSelected());
                }
            });
        }
        return this.jCheckBoxHandicapAdjustment;
    }

    private JPanel getJPanelMacMahonBars() {
        if (this.jPanelMacMahonBars == null) {
            this.jPanelMacMahonBars = new JPanel();
            this.jPanelMacMahonBars.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 0;
            this.jPanelMacMahonBars.add((Component)this.getJCheckBoxUpperMacMahonBar(), gridBagConstraints17);
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 0;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints18.ipadx = 0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridx = 1;
            this.jPanelMacMahonBars.add((Component)this.getJTextFieldUpperMacMahonBar(), gridBagConstraints18);
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.gridy = 1;
            this.jPanelMacMahonBars.add((Component)this.getJCheckBoxLowerMacMahonBar(), gridBagConstraints19);
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.fill = 0;
            gridBagConstraints30.gridy = 1;
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.ipadx = 0;
            gridBagConstraints30.anchor = 17;
            gridBagConstraints30.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints30.gridx = 1;
            this.jPanelMacMahonBars.add((Component)this.getJTextFieldLowerMacMahonBar(), gridBagConstraints30);
        }
        return this.jPanelMacMahonBars;
    }

    private JCheckBox getJCheckBoxUpperMacMahonBar() {
        if (this.jCheckBoxUpperMacMahonBar == null) {
            this.jCheckBoxUpperMacMahonBar = new JCheckBox();
            this.jCheckBoxUpperMacMahonBar.setText(Messages.getString("EditTournamentSettingsDialog.MainUpperMacMahonBarCheckBox"));
            this.jCheckBoxUpperMacMahonBar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditTournamentSettingsDialog.this.setUpperMacMahonBarEnabled(EditTournamentSettingsDialog.this.jCheckBoxUpperMacMahonBar.isSelected());
                }
            });
        }
        return this.jCheckBoxUpperMacMahonBar;
    }

    private JTextField getJTextFieldUpperMacMahonBar() {
        if (this.jTextFieldUpperMacMahonBar == null) {
            this.jTextFieldUpperMacMahonBar = new JTextField();
            this.jTextFieldUpperMacMahonBar.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldUpperMacMahonBar.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldUpperMacMahonBar;
    }

    private JCheckBox getJCheckBoxLowerMacMahonBar() {
        if (this.jCheckBoxLowerMacMahonBar == null) {
            this.jCheckBoxLowerMacMahonBar = new JCheckBox();
            this.jCheckBoxLowerMacMahonBar.setText(Messages.getString("EditTournamentSettingsDialog.MainLowerMacMahonBarCheckBox"));
            this.jCheckBoxLowerMacMahonBar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditTournamentSettingsDialog.this.setLowerMacMahonBarEnabled(EditTournamentSettingsDialog.this.jCheckBoxLowerMacMahonBar.isSelected());
                }
            });
        }
        return this.jCheckBoxLowerMacMahonBar;
    }

    private JTextField getJTextFieldLowerMacMahonBar() {
        if (this.jTextFieldLowerMacMahonBar == null) {
            this.jTextFieldLowerMacMahonBar = new JTextField();
            this.jTextFieldLowerMacMahonBar.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldLowerMacMahonBar.setEnabled(false);
            this.jTextFieldLowerMacMahonBar.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldLowerMacMahonBar;
    }

    private JPanel getJPanelWalllist() {
        if (this.jPanelWalllist == null) {
            GridBagConstraints gridBagConstraints93 = new GridBagConstraints();
            gridBagConstraints93.gridx = 1;
            gridBagConstraints93.anchor = 17;
            gridBagConstraints93.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints93.gridy = 9;
            GridBagConstraints gridBagConstraints90 = new GridBagConstraints();
            gridBagConstraints90.gridx = 1;
            gridBagConstraints90.anchor = 17;
            gridBagConstraints90.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints90.gridy = 0;
            GridBagConstraints gridBagConstraints78 = new GridBagConstraints();
            gridBagConstraints78.gridx = 1;
            gridBagConstraints78.anchor = 17;
            gridBagConstraints78.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints78.gridy = 8;
            GridBagConstraints gridBagConstraints77 = new GridBagConstraints();
            gridBagConstraints77.gridx = 1;
            gridBagConstraints77.anchor = 17;
            gridBagConstraints77.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints77.gridy = 5;
            GridBagConstraints gridBagConstraints76 = new GridBagConstraints();
            gridBagConstraints76.gridx = 1;
            gridBagConstraints76.anchor = 17;
            gridBagConstraints76.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints76.gridy = 7;
            GridBagConstraints gridBagConstraints75 = new GridBagConstraints();
            gridBagConstraints75.gridx = 1;
            gridBagConstraints75.anchor = 17;
            gridBagConstraints75.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints75.gridy = 6;
            GridBagConstraints gridBagConstraints74 = new GridBagConstraints();
            gridBagConstraints74.gridx = 1;
            gridBagConstraints74.anchor = 17;
            gridBagConstraints74.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints74.gridy = 4;
            GridBagConstraints gridBagConstraints70 = new GridBagConstraints();
            gridBagConstraints70.gridx = 1;
            gridBagConstraints70.anchor = 17;
            gridBagConstraints70.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints70.gridy = 3;
            GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
            gridBagConstraints65.gridx = 1;
            gridBagConstraints65.anchor = 17;
            gridBagConstraints65.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints65.gridy = 13;
            GridBagConstraints gridBagConstraints64 = new GridBagConstraints();
            gridBagConstraints64.gridx = 1;
            gridBagConstraints64.anchor = 17;
            gridBagConstraints64.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints64.gridy = 2;
            GridBagConstraints gridBagConstraints63 = new GridBagConstraints();
            gridBagConstraints63.gridx = 1;
            gridBagConstraints63.anchor = 17;
            gridBagConstraints63.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints63.gridy = 1;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.anchor = 13;
            gridBagConstraints29.gridy = 0;
            this.jLabelWalllistPlayerData = new JLabel();
            this.jLabelWalllistPlayerData.setText(Messages.getString("EditTournamentSettingsDialog.WalllistPlayerDataLabel"));
            GridBagConstraints gridBagConstraints52 = new GridBagConstraints();
            gridBagConstraints52.gridx = 1;
            gridBagConstraints52.fill = 1;
            gridBagConstraints52.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints52.anchor = 17;
            gridBagConstraints52.gridy = 14;
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.gridx = 0;
            gridBagConstraints51.anchor = 13;
            gridBagConstraints51.gridy = 14;
            this.jLabelWallistFontsize = new JLabel();
            this.jLabelWallistFontsize.setText(Messages.getString("EditTournamentSettingsDialog.WalllistFontsizeLabel"));
            GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
            gridBagConstraints48.gridx = 1;
            gridBagConstraints48.anchor = 17;
            gridBagConstraints48.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints48.gridy = 10;
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.gridx = 1;
            gridBagConstraints47.anchor = 17;
            gridBagConstraints47.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints47.gridy = 12;
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.gridx = 1;
            gridBagConstraints46.anchor = 17;
            gridBagConstraints46.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints46.gridy = 11;
            GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
            gridBagConstraints45.gridx = 0;
            gridBagConstraints45.anchor = 13;
            gridBagConstraints45.gridy = 10;
            this.jLabelWalllistDisplayGameData = new JLabel();
            this.jLabelWalllistDisplayGameData.setText(Messages.getString("EditTournamentSettingsDialog.WalllistGameDataLabel"));
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weighty = 1.0;
            gridBagConstraints31.fill = 1;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.gridy = 15;
            this.jPanelWalllist = new JPanel();
            this.jPanelWalllist.setLayout(new GridBagLayout());
            this.jPanelWalllist.add((Component)this.getJPanelWalllistDummy(), gridBagConstraints31);
            this.jPanelWalllist.add((Component)this.jLabelWalllistDisplayGameData, gridBagConstraints45);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowColors(), gridBagConstraints46);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowHandicap(), gridBagConstraints47);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistMarkResultsByReferee(), gridBagConstraints48);
            this.jPanelWalllist.add((Component)this.jLabelWallistFontsize, gridBagConstraints51);
            this.jPanelWalllist.add((Component)this.getJPanelWalllistFontsize(), gridBagConstraints52);
            this.jPanelWalllist.add((Component)this.jLabelWalllistPlayerData, gridBagConstraints29);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShortLevel(), gridBagConstraints63);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowBarMembership(), gridBagConstraints64);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowWarningMissingPairing(), gridBagConstraints65);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowRating(), gridBagConstraints70);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowCountry(), gridBagConstraints74);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowClubEgdName(), gridBagConstraints75);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowClubAbbreviateName(), gridBagConstraints76);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowClub(), gridBagConstraints77);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistClubColumnAlignment(), gridBagConstraints78);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistShowLevels(), gridBagConstraints90);
            this.jPanelWalllist.add((Component)this.getJCheckBoxWalllistMarkPreliminaryRegisteredParticipants(), gridBagConstraints93);
        }
        return this.jPanelWalllist;
    }

    private JPanel getJPanelWalllistDummy() {
        if (this.jPanelWalllistDummy == null) {
            this.jPanelWalllistDummy = new JPanel();
            this.jPanelWalllistDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelWalllistDummy;
    }

    private JPanel getJPanelRegistration() {
        if (this.jPanelRegistration == null) {
            GridBagConstraints gridBagConstraints100 = new GridBagConstraints();
            gridBagConstraints100.fill = 3;
            gridBagConstraints100.gridy = 4;
            gridBagConstraints100.weightx = 1.0;
            gridBagConstraints100.anchor = 17;
            gridBagConstraints100.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints100.gridx = 1;
            GridBagConstraints gridBagConstraints99 = new GridBagConstraints();
            gridBagConstraints99.gridx = 0;
            gridBagConstraints99.anchor = 13;
            gridBagConstraints99.gridy = 4;
            this.jLabelRegistrationDefaultNationality = new JLabel();
            this.jLabelRegistrationDefaultNationality.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationDefaultNationalityLabel"));
            GridBagConstraints gridBagConstraints83 = new GridBagConstraints();
            gridBagConstraints83.gridx = 1;
            gridBagConstraints83.anchor = 17;
            gridBagConstraints83.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints83.gridy = 1;
            GridBagConstraints gridBagConstraints80 = new GridBagConstraints();
            gridBagConstraints80.gridx = 1;
            gridBagConstraints80.anchor = 17;
            gridBagConstraints80.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints80.gridy = 0;
            GridBagConstraints gridBagConstraints79 = new GridBagConstraints();
            gridBagConstraints79.gridx = 0;
            gridBagConstraints79.anchor = 13;
            gridBagConstraints79.gridy = 0;
            this.jLabelRegistrationEGDSupport = new JLabel();
            this.jLabelRegistrationEGDSupport.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationEGDLabel"));
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.gridx = 1;
            gridBagConstraints61.anchor = 17;
            gridBagConstraints61.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints61.gridy = 5;
            GridBagConstraints gridBagConstraints60 = new GridBagConstraints();
            gridBagConstraints60.gridx = 0;
            gridBagConstraints60.anchor = 13;
            gridBagConstraints60.gridy = 5;
            this.jLabelRegistrationDefaultAsianName = new JLabel();
            this.jLabelRegistrationDefaultAsianName.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationAsianNameLabel"));
            GridBagConstraints gridBagConstraints50 = new GridBagConstraints();
            gridBagConstraints50.fill = 3;
            gridBagConstraints50.gridy = 3;
            gridBagConstraints50.weightx = 1.0;
            gridBagConstraints50.anchor = 17;
            gridBagConstraints50.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints50.gridx = 1;
            GridBagConstraints gridBagConstraints49 = new GridBagConstraints();
            gridBagConstraints49.gridx = 0;
            gridBagConstraints49.anchor = 13;
            gridBagConstraints49.gridy = 3;
            this.jLabelRegistrationDefaultCountry = new JLabel();
            this.jLabelRegistrationDefaultCountry.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationDefaultCountryLabel"));
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.gridx = 1;
            gridBagConstraints34.fill = 0;
            gridBagConstraints34.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints34.weightx = 1.0;
            gridBagConstraints34.anchor = 17;
            gridBagConstraints34.gridy = 2;
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.anchor = 13;
            gridBagConstraints33.gridy = 2;
            this.jLabelRegistrationDefaultRegistration = new JLabel();
            this.jLabelRegistrationDefaultRegistration.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationDefaultLabel"));
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.weighty = 1.0;
            gridBagConstraints32.fill = 1;
            gridBagConstraints32.gridy = 6;
            this.jPanelRegistration = new JPanel();
            this.jPanelRegistration.setLayout(new GridBagLayout());
            this.jPanelRegistration.add((Component)this.getJPanelRegistrationDummy(), gridBagConstraints32);
            this.jPanelRegistration.add((Component)this.jLabelRegistrationDefaultRegistration, gridBagConstraints33);
            this.jPanelRegistration.add((Component)this.getJPanelRegistrationDefaultRegistration(), gridBagConstraints34);
            this.jPanelRegistration.add((Component)this.jLabelRegistrationDefaultCountry, gridBagConstraints49);
            this.jPanelRegistration.add(this.getJComboBoxRegistrationDefaultCountry(), gridBagConstraints50);
            this.jPanelRegistration.add((Component)this.jLabelRegistrationDefaultAsianName, gridBagConstraints60);
            this.jPanelRegistration.add((Component)this.getJCheckBoxRegistrationDefaultAsianName(), gridBagConstraints61);
            this.jPanelRegistration.add((Component)this.jLabelRegistrationEGDSupport, gridBagConstraints79);
            this.jPanelRegistration.add((Component)this.getJCheckBoxRegistrationEGDSupport(), gridBagConstraints80);
            this.jPanelRegistration.add((Component)this.getJCheckBoxRegistrationSearchEGDByPin(), gridBagConstraints83);
            this.jPanelRegistration.add((Component)this.jLabelRegistrationDefaultNationality, gridBagConstraints99);
            this.jPanelRegistration.add(this.getJComboBoxRegistrationDefaultNationality(), gridBagConstraints100);
        }
        return this.jPanelRegistration;
    }

    private JPanel getJPanelRegistrationDummy() {
        if (this.jPanelRegistrationDummy == null) {
            this.jPanelRegistrationDummy = new JPanel();
            this.jPanelRegistrationDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelRegistrationDummy;
    }

    private JPanel getJPanelRegistrationDefaultRegistration() {
        if (this.jPanelRegistrationDefaultRegistration == null) {
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 1;
            gridBagConstraints36.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints36.gridy = 0;
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.anchor = 17;
            this.jPanelRegistrationDefaultRegistration = new JPanel();
            this.jPanelRegistrationDefaultRegistration.setLayout(new GridBagLayout());
            this.jPanelRegistrationDefaultRegistration.add((Component)this.getJRadioButtonRegistrationDefaultRegistrationPreliminary(), gridBagConstraints35);
            this.jPanelRegistrationDefaultRegistration.add((Component)this.getJRadioButtonRegistrationDefaultRegistrationFinal(), gridBagConstraints36);
        }
        return this.jPanelRegistrationDefaultRegistration;
    }

    private JRadioButton getJRadioButtonRegistrationDefaultRegistrationPreliminary() {
        if (this.jRadioButtonRegistrationDefaultRegistrationPreliminary == null) {
            this.jRadioButtonRegistrationDefaultRegistrationPreliminary = new JRadioButton();
            this.jRadioButtonRegistrationDefaultRegistrationPreliminary.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationPreliminaryRadioButton"));
        }
        return this.jRadioButtonRegistrationDefaultRegistrationPreliminary;
    }

    private JRadioButton getJRadioButtonRegistrationDefaultRegistrationFinal() {
        if (this.jRadioButtonRegistrationDefaultRegistrationFinal == null) {
            this.jRadioButtonRegistrationDefaultRegistrationFinal = new JRadioButton();
            this.jRadioButtonRegistrationDefaultRegistrationFinal.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationFinalRadioButton"));
        }
        return this.jRadioButtonRegistrationDefaultRegistrationFinal;
    }

    private JCheckBox getJCheckBoxHandicapIncludeHandicapInTieBreakers() {
        if (this.jCheckBoxHandicapIncludeHandicapInTieBreakers == null) {
            this.jCheckBoxHandicapIncludeHandicapInTieBreakers = new JCheckBox();
            this.jCheckBoxHandicapIncludeHandicapInTieBreakers.setText(Messages.getString("EditTournamentSettingsDialog.HandicapIncludeInTieBreakersCheckBox"));
        }
        return this.jCheckBoxHandicapIncludeHandicapInTieBreakers;
    }

    private JPanel getJPanelSortCriteriaSortCriteria() {
        if (this.jPanelSortCriteriaSortCriteria == null) {
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.gridx = 0;
            gridBagConstraints44.gridwidth = 2;
            gridBagConstraints44.anchor = 17;
            gridBagConstraints44.gridy = 2;
            this.jLabelSortKriteriaHint = new JLabel();
            this.jLabelSortKriteriaHint.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaHintLabel"));
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
            gridBagConstraints43.gridx = 1;
            gridBagConstraints43.gridy = 0;
            this.jLabelSortCriteriaAvailable = new JLabel();
            this.jLabelSortCriteriaAvailable.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaAvailableLabel"));
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.gridy = 0;
            this.jLabelSortCriteriaActive = new JLabel();
            this.jLabelSortCriteriaActive.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaActiveLabel"));
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 1;
            gridBagConstraints41.weighty = 1.0;
            gridBagConstraints41.gridy = 1;
            gridBagConstraints41.weightx = 1.0;
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.fill = 1;
            gridBagConstraints40.gridy = 1;
            gridBagConstraints40.weightx = 1.0;
            gridBagConstraints40.weighty = 1.0;
            gridBagConstraints40.gridx = 0;
            this.jPanelSortCriteriaSortCriteria = new JPanel();
            this.jPanelSortCriteriaSortCriteria.setLayout(new GridBagLayout());
            this.jPanelSortCriteriaSortCriteria.setPreferredSize(new Dimension(100, 150));
            this.jPanelSortCriteriaSortCriteria.add((Component)this.getJScrollPaneWalllistSortCriteriaActive(), gridBagConstraints40);
            this.jPanelSortCriteriaSortCriteria.add((Component)this.getJScrollPaneWalllistSortCriteriaAvailable(), gridBagConstraints41);
            this.jPanelSortCriteriaSortCriteria.add((Component)this.jLabelSortCriteriaActive, gridBagConstraints42);
            this.jPanelSortCriteriaSortCriteria.add((Component)this.jLabelSortCriteriaAvailable, gridBagConstraints43);
            this.jPanelSortCriteriaSortCriteria.add((Component)this.jLabelSortKriteriaHint, gridBagConstraints44);
        }
        return this.jPanelSortCriteriaSortCriteria;
    }

    private JScrollPane getJScrollPaneWalllistSortCriteriaActive() {
        if (this.jScrollPaneWalllistSortCriteriaActive == null) {
            this.jScrollPaneWalllistSortCriteriaActive = new JScrollPane();
            this.jScrollPaneWalllistSortCriteriaActive.setHorizontalScrollBarPolicy(31);
            this.jScrollPaneWalllistSortCriteriaActive.setViewportView(this.getJListSortCriteriaActive());
        }
        return this.jScrollPaneWalllistSortCriteriaActive;
    }

    private JList<Walllist.SortCriterionDescriptor> getJListSortCriteriaActive() {
        if (this.jListSortCriteriaActive == null) {
            this.jListSortCriteriaActive = new JList<Walllist.SortCriterionDescriptor>(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    int index = this.locationToIndex(e.getPoint());
                    if (index >= 0) {
                        return ((Walllist.SortCriterionDescriptor)this.getModel().getElementAt(index)).getExplanation();
                    }
                    return null;
                }
            };
            this.jListSortCriteriaActive.setSelectionMode(0);
        }
        return this.jListSortCriteriaActive;
    }

    private JScrollPane getJScrollPaneWalllistSortCriteriaAvailable() {
        if (this.jScrollPaneWalllistSortCriteriaAvailable == null) {
            this.jScrollPaneWalllistSortCriteriaAvailable = new JScrollPane();
            this.jScrollPaneWalllistSortCriteriaAvailable.setHorizontalScrollBarPolicy(31);
            this.jScrollPaneWalllistSortCriteriaAvailable.setViewportView(this.getJListSortCriteriaAvailable());
        }
        return this.jScrollPaneWalllistSortCriteriaAvailable;
    }

    private JList<Walllist.SortCriterionDescriptor> getJListSortCriteriaAvailable() {
        if (this.jListSortCriteriaAvailable == null) {
            this.jListSortCriteriaAvailable = new JList<Walllist.SortCriterionDescriptor>(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    int index = this.locationToIndex(e.getPoint());
                    if (index >= 0) {
                        return ((Walllist.SortCriterionDescriptor)this.getModel().getElementAt(index)).getExplanation();
                    }
                    return null;
                }
            };
            this.jListSortCriteriaAvailable.setSelectionMode(0);
        }
        return this.jListSortCriteriaAvailable;
    }

    private JCheckBox getJCheckBoxWalllistShowColors() {
        if (this.jCheckBoxWalllistShowColors == null) {
            this.jCheckBoxWalllistShowColors = new JCheckBox();
            this.jCheckBoxWalllistShowColors.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowColorsCheckBox"));
        }
        return this.jCheckBoxWalllistShowColors;
    }

    private JCheckBox getJCheckBoxWalllistShowHandicap() {
        if (this.jCheckBoxWalllistShowHandicap == null) {
            this.jCheckBoxWalllistShowHandicap = new JCheckBox();
            this.jCheckBoxWalllistShowHandicap.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowHandicapCheckBox"));
        }
        return this.jCheckBoxWalllistShowHandicap;
    }

    private JCheckBox getJCheckBoxWalllistMarkResultsByReferee() {
        if (this.jCheckBoxWalllistMarkResultsByReferee == null) {
            this.jCheckBoxWalllistMarkResultsByReferee = new JCheckBox();
            this.jCheckBoxWalllistMarkResultsByReferee.setText(Messages.getString("EditTournamentSettingsDialog.WalllistMarkResultsByRefereeCheckBox"));
        }
        return this.jCheckBoxWalllistMarkResultsByReferee;
    }

    private JComboBox<Country> getJComboBoxRegistrationDefaultCountry() {
        if (this.jComboBoxRegistrationDefaultCountry == null) {
            this.jComboBoxRegistrationDefaultCountry = new JComboBox();
            this.jComboBoxRegistrationDefaultCountry.setPreferredSize(new Dimension(300, 25));
        }
        return this.jComboBoxRegistrationDefaultCountry;
    }

    private JPanel getJPanelWalllistFontsize() {
        if (this.jPanelWalllistFontsize == null) {
            GridBagConstraints gridBagConstraints54 = new GridBagConstraints();
            gridBagConstraints54.gridx = 1;
            gridBagConstraints54.weightx = 1.0;
            gridBagConstraints54.anchor = 17;
            gridBagConstraints54.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints54.gridy = 0;
            this.jLabelWalllistFontsizePoints = new JLabel();
            this.jLabelWalllistFontsizePoints.setText(Messages.getString("EditTournamentSettingsDialog.WalllistFontsizePointsLabel"));
            GridBagConstraints gridBagConstraints53 = new GridBagConstraints();
            gridBagConstraints53.fill = 0;
            gridBagConstraints53.gridy = 0;
            gridBagConstraints53.weightx = 0.0;
            gridBagConstraints53.anchor = 17;
            gridBagConstraints53.gridx = 0;
            this.jPanelWalllistFontsize = new JPanel();
            this.jPanelWalllistFontsize.setLayout(new GridBagLayout());
            this.jPanelWalllistFontsize.add((Component)this.getJTextFieldWalllistFontsize(), gridBagConstraints53);
            this.jPanelWalllistFontsize.add((Component)this.jLabelWalllistFontsizePoints, gridBagConstraints54);
        }
        return this.jPanelWalllistFontsize;
    }

    private JTextField getJTextFieldWalllistFontsize() {
        if (this.jTextFieldWalllistFontsize == null) {
            this.jTextFieldWalllistFontsize = new JTextField();
            this.jTextFieldWalllistFontsize.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldWalllistFontsize.setPreferredSize(new Dimension(80, 20));
        }
        return this.jTextFieldWalllistFontsize;
    }

    private JPanel getJPanelPairings() {
        if (this.jPanelPairings == null) {
            GridBagConstraints gridBagConstraints113 = new GridBagConstraints();
            gridBagConstraints113.gridx = 1;
            gridBagConstraints113.anchor = 17;
            gridBagConstraints113.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints113.gridy = 1;
            GridBagConstraints gridBagConstraints109 = new GridBagConstraints();
            gridBagConstraints109.gridx = 1;
            gridBagConstraints109.anchor = 17;
            gridBagConstraints109.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints109.gridy = 2;
            GridBagConstraints gridBagConstraints108 = new GridBagConstraints();
            gridBagConstraints108.gridx = 1;
            gridBagConstraints108.anchor = 17;
            gridBagConstraints108.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints108.gridy = 4;
            GridBagConstraints gridBagConstraints98 = new GridBagConstraints();
            gridBagConstraints98.gridx = 1;
            gridBagConstraints98.anchor = 17;
            gridBagConstraints98.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints98.gridy = 7;
            GridBagConstraints gridBagConstraints92 = new GridBagConstraints();
            gridBagConstraints92.gridx = 1;
            gridBagConstraints92.anchor = 17;
            gridBagConstraints92.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints92.gridy = 5;
            GridBagConstraints gridBagConstraints73 = new GridBagConstraints();
            gridBagConstraints73.gridx = 1;
            gridBagConstraints73.anchor = 17;
            gridBagConstraints73.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints73.gridy = 6;
            GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
            gridBagConstraints72.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints72.gridx = 0;
            gridBagConstraints72.anchor = 13;
            gridBagConstraints72.gridy = 5;
            this.jLabelPairingsPlayerData = new JLabel();
            this.jLabelPairingsPlayerData.setText(Messages.getString("EditTournamentSettingsDialog.PairingsPlayerDataLabel"));
            this.jPanelPairings = new JPanel();
            GridBagLayout gbl_jPanelPairings = new GridBagLayout();
            gbl_jPanelPairings.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            gbl_jPanelPairings.columnWeights = new double[]{0.0, 1.0};
            this.jPanelPairings.setLayout(gbl_jPanelPairings);
            GridBagConstraints gbc_chckbxMarkFixedBoardnumbers = new GridBagConstraints();
            gbc_chckbxMarkFixedBoardnumbers.anchor = 17;
            gbc_chckbxMarkFixedBoardnumbers.insets = new Insets(0, 10, 5, 0);
            gbc_chckbxMarkFixedBoardnumbers.gridx = 1;
            gbc_chckbxMarkFixedBoardnumbers.gridy = 0;
            this.jPanelPairings.add((Component)this.getChckbxMarkFixedBoardnumbers(), gbc_chckbxMarkFixedBoardnumbers);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.insets = new Insets(0, 10, 5, 0);
            gbc_panel.fill = 1;
            gbc_panel.gridx = 1;
            gbc_panel.gridy = 3;
            this.jPanelPairings.add((Component)this.getPanel(), gbc_panel);
            GridBagConstraints gridBagConstraints55 = new GridBagConstraints();
            gridBagConstraints55.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints55.gridx = 0;
            gridBagConstraints55.anchor = 13;
            gridBagConstraints55.gridy = 8;
            this.jLabelPairingsFontsize = new JLabel();
            this.jLabelPairingsFontsize.setText(Messages.getString("EditTournamentSettingsDialog.PairingsFontsizeLabel"));
            this.jPanelPairings.add((Component)this.jLabelPairingsFontsize, gridBagConstraints55);
            GridBagConstraints gridBagConstraints56 = new GridBagConstraints();
            gridBagConstraints56.gridx = 1;
            gridBagConstraints56.fill = 1;
            gridBagConstraints56.weightx = 1.0;
            gridBagConstraints56.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints56.gridy = 8;
            this.jPanelPairings.add((Component)this.getJPanelPairingsFontsize(), gridBagConstraints56);
            this.jPanelPairings.add((Component)this.jLabelPairingsPlayerData, gridBagConstraints72);
            this.jPanelPairings.add((Component)this.getJCheckBoxPairingsShortLevel(), gridBagConstraints73);
            this.jPanelPairings.add((Component)this.getJCheckBoxPairingsShowLevels(), gridBagConstraints92);
            this.jPanelPairings.add((Component)this.getJCheckBoxPairingsShowScores(), gridBagConstraints98);
            this.jPanelPairings.add((Component)this.getJCheckBoxPairingsShowHandicaps(), gridBagConstraints108);
            this.jPanelPairings.add((Component)this.getJCheckBoxPairingsMarkWinner(), gridBagConstraints109);
            this.jPanelPairings.add((Component)this.getJCheckBoxPairingsMarkMissingResults(), gridBagConstraints113);
            GridBagConstraints gridBagConstraints59 = new GridBagConstraints();
            gridBagConstraints59.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints59.gridx = 0;
            gridBagConstraints59.fill = 1;
            gridBagConstraints59.weighty = 1.0;
            gridBagConstraints59.gridy = 9;
            this.jPanelPairings.add((Component)this.getJPanelPairingsDummy(), gridBagConstraints59);
        }
        return this.jPanelPairings;
    }

    private JPanel getJPanelPairingsFontsize() {
        if (this.jPanelPairingsFontsize == null) {
            GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
            gridBagConstraints58.gridx = 1;
            gridBagConstraints58.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints58.weightx = 1.0;
            gridBagConstraints58.anchor = 17;
            gridBagConstraints58.gridy = 0;
            this.jLabelPairingsFontsizePoints = new JLabel();
            this.jLabelPairingsFontsizePoints.setText(Messages.getString("EditTournamentSettingsDialog.PairingsFontsizePointsLabel"));
            GridBagConstraints gridBagConstraints57 = new GridBagConstraints();
            gridBagConstraints57.fill = 3;
            gridBagConstraints57.gridy = 0;
            gridBagConstraints57.weightx = 0.0;
            gridBagConstraints57.gridx = 0;
            this.jPanelPairingsFontsize = new JPanel();
            this.jPanelPairingsFontsize.setLayout(new GridBagLayout());
            this.jPanelPairingsFontsize.add((Component)this.getJTextFieldPairingsFontsize(), gridBagConstraints57);
            this.jPanelPairingsFontsize.add((Component)this.jLabelPairingsFontsizePoints, gridBagConstraints58);
        }
        return this.jPanelPairingsFontsize;
    }

    private JTextField getJTextFieldPairingsFontsize() {
        if (this.jTextFieldPairingsFontsize == null) {
            this.jTextFieldPairingsFontsize = new JTextField();
            this.jTextFieldPairingsFontsize.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldPairingsFontsize.setPreferredSize(new Dimension(80, 20));
        }
        return this.jTextFieldPairingsFontsize;
    }

    private JPanel getJPanelPairingsDummy() {
        if (this.jPanelPairingsDummy == null) {
            this.jPanelPairingsDummy = new JPanel();
            this.jPanelPairingsDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelPairingsDummy;
    }

    private JCheckBox getJCheckBoxRegistrationDefaultAsianName() {
        if (this.jCheckBoxRegistrationDefaultAsianName == null) {
            this.jCheckBoxRegistrationDefaultAsianName = new JCheckBox();
            this.jCheckBoxRegistrationDefaultAsianName.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationAsianNameCheckBox"));
        }
        return this.jCheckBoxRegistrationDefaultAsianName;
    }

    private JPanel getJPanelSortCriteria() {
        if (this.jPanelSortCriteria == null) {
            GridBagConstraints gridBagConstraints97 = new GridBagConstraints();
            gridBagConstraints97.gridx = 1;
            gridBagConstraints97.anchor = 17;
            gridBagConstraints97.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints97.gridy = 3;
            GridBagConstraints gridBagConstraints96 = new GridBagConstraints();
            gridBagConstraints96.gridx = 1;
            gridBagConstraints96.anchor = 17;
            gridBagConstraints96.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints96.gridy = 2;
            GridBagConstraints gridBagConstraints95 = new GridBagConstraints();
            gridBagConstraints95.gridx = 1;
            gridBagConstraints95.anchor = 17;
            gridBagConstraints95.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints95.gridy = 1;
            GridBagConstraints gridBagConstraints94 = new GridBagConstraints();
            gridBagConstraints94.gridx = 0;
            gridBagConstraints94.anchor = 13;
            gridBagConstraints94.gridy = 1;
            this.jLabelPlacementCriteriaSharedPlaces = new JLabel();
            this.jLabelPlacementCriteriaSharedPlaces.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaSharedPlacesLabel"));
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.fill = 2;
            gridBagConstraints39.gridwidth = 1;
            gridBagConstraints39.gridx = 1;
            gridBagConstraints39.gridy = 0;
            gridBagConstraints39.weightx = 1.0;
            gridBagConstraints39.weighty = 0.0;
            gridBagConstraints39.insets = new Insets(0, 10, 0, 0);
            GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
            gridBagConstraints38.anchor = 12;
            gridBagConstraints38.gridy = 0;
            gridBagConstraints38.gridx = 0;
            GridBagConstraints gridBagConstraints62 = new GridBagConstraints();
            gridBagConstraints62.gridx = 0;
            gridBagConstraints62.fill = 1;
            gridBagConstraints62.weighty = 1.0;
            gridBagConstraints62.gridy = 4;
            this.jPanelSortCriteria = new JPanel();
            this.jPanelSortCriteria.setLayout(new GridBagLayout());
            this.jLabelSortCriteria = new JLabel();
            this.jLabelSortCriteria.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaLabel"));
            this.jPanelSortCriteria.add((Component)this.jLabelSortCriteria, gridBagConstraints38);
            this.jPanelSortCriteria.add((Component)this.getJPanelSortCriteriaSortCriteria(), gridBagConstraints39);
            this.jPanelSortCriteria.add((Component)this.getJPanelSortCriteriaDummy(), gridBagConstraints62);
            this.jPanelSortCriteria.add((Component)this.jLabelPlacementCriteriaSharedPlaces, gridBagConstraints94);
            this.jPanelSortCriteria.add((Component)this.getJRadioButtonPlacementCriteriaWeakRankNameId(), gridBagConstraints95);
            this.jPanelSortCriteria.add((Component)this.getJRadioButtonPlacementCriteriaWeakNameId(), gridBagConstraints96);
            this.jPanelSortCriteria.add((Component)this.getJRadioButtonPlacementCriteriaWeakId(), gridBagConstraints97);
        }
        return this.jPanelSortCriteria;
    }

    private JPanel getJPanelSortCriteriaDummy() {
        if (this.jPanelSortCriteriaDummy == null) {
            this.jPanelSortCriteriaDummy = new JPanel();
            this.jPanelSortCriteriaDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelSortCriteriaDummy;
    }

    private JCheckBox getJCheckBoxWalllistShortLevel() {
        if (this.jCheckBoxWalllistShortLevel == null) {
            this.jCheckBoxWalllistShortLevel = new JCheckBox();
            this.jCheckBoxWalllistShortLevel.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShortLevelCheckBox"));
        }
        return this.jCheckBoxWalllistShortLevel;
    }

    private JCheckBox getJCheckBoxWalllistShowBarMembership() {
        if (this.jCheckBoxWalllistShowBarMembership == null) {
            this.jCheckBoxWalllistShowBarMembership = new JCheckBox();
            this.jCheckBoxWalllistShowBarMembership.setText(Messages.getString("EditTournamentSettingsDialog.WalllistBarMembershipCheckBox"));
        }
        return this.jCheckBoxWalllistShowBarMembership;
    }

    private JCheckBox getJCheckBoxWalllistShowWarningMissingPairing() {
        if (this.jCheckBoxWalllistShowWarningMissingPairing == null) {
            this.jCheckBoxWalllistShowWarningMissingPairing = new JCheckBox();
            this.jCheckBoxWalllistShowWarningMissingPairing.setText(Messages.getString("EditTournamentSettingsDialog.WalllistWarningMissingCheckBox"));
        }
        return this.jCheckBoxWalllistShowWarningMissingPairing;
    }

    private JCheckBox getJCheckBoxRatingAllowRatings() {
        if (this.jCheckBoxRatingAllowRatings == null) {
            this.jCheckBoxRatingAllowRatings = new JCheckBox();
            this.jCheckBoxRatingAllowRatings.setText(Messages.getString("EditTournamentSettingsDialog.MainAllowRatingsCheckBox"));
            this.jCheckBoxRatingAllowRatings.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (EditTournamentSettingsDialog.this.m_surpressCheckRatingAllowRatings == 0) {
                        EditTournamentSettingsDialog.this.checkRatingAllowRatings(false);
                    }
                }
            });
        }
        return this.jCheckBoxRatingAllowRatings;
    }

    private JCheckBox getJCheckBoxRatingDeterminesRank() {
        if (this.jCheckBoxRatingDeterminesRank == null) {
            this.jCheckBoxRatingDeterminesRank = new JCheckBox();
            this.jCheckBoxRatingDeterminesRank.setText(Messages.getString("EditTournamentSettingsDialog.MainRankByRatingCheckBox"));
        }
        return this.jCheckBoxRatingDeterminesRank;
    }

    private JPanel getJPanelRatingSettings() {
        if (this.jPanelRatingSettings == null) {
            GridBagConstraints gridBagConstraints69 = new GridBagConstraints();
            gridBagConstraints69.gridx = 0;
            gridBagConstraints69.gridwidth = 2;
            gridBagConstraints69.anchor = 17;
            gridBagConstraints69.gridy = 1;
            GridBagConstraints gridBagConstraints68 = new GridBagConstraints();
            gridBagConstraints68.fill = 0;
            gridBagConstraints68.gridy = 0;
            gridBagConstraints68.weightx = 1.0;
            gridBagConstraints68.anchor = 17;
            gridBagConstraints68.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints68.gridx = 1;
            GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
            gridBagConstraints67.gridx = 0;
            gridBagConstraints67.gridy = 0;
            this.jPanelRatingSettings = new JPanel();
            this.jPanelRatingSettings.setLayout(new GridBagLayout());
            this.jPanelRatingSettings.add((Component)this.getJCheckBoxRatingDeterminesRank(), gridBagConstraints67);
            this.jPanelRatingSettings.add((Component)this.getJTextFieldRatingLowestOneDanRating(), gridBagConstraints68);
            this.jPanelRatingSettings.add((Component)this.getJCheckBoxRatingDeterminesStartScore(), gridBagConstraints69);
        }
        return this.jPanelRatingSettings;
    }

    private JTextField getJTextFieldRatingLowestOneDanRating() {
        if (this.jTextFieldRatingLowestOneDanRating == null) {
            this.jTextFieldRatingLowestOneDanRating = new JTextField();
            this.jTextFieldRatingLowestOneDanRating.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldRatingLowestOneDanRating.setMinimumSize(this.jTextFieldRatingLowestOneDanRating.getPreferredSize());
        }
        return this.jTextFieldRatingLowestOneDanRating;
    }

    private JCheckBox getJCheckBoxRatingDeterminesStartScore() {
        if (this.jCheckBoxRatingDeterminesStartScore == null) {
            this.jCheckBoxRatingDeterminesStartScore = new JCheckBox();
            this.jCheckBoxRatingDeterminesStartScore.setText(Messages.getString("EditTournamentSettingsDialog.MainStartScoreByRatingCheckBox"));
            this.jCheckBoxRatingDeterminesStartScore.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (EditTournamentSettingsDialog.this.m_surpressCheckRatingAllowRatings == 0) {
                        EditTournamentSettingsDialog.this.checkRatingDeterminesScore(false);
                    }
                }
            });
        }
        return this.jCheckBoxRatingDeterminesStartScore;
    }

    private JCheckBox getJCheckBoxWalllistShowRating() {
        if (this.jCheckBoxWalllistShowRating == null) {
            this.jCheckBoxWalllistShowRating = new JCheckBox();
            this.jCheckBoxWalllistShowRating.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowRatingsCheckBox"));
        }
        return this.jCheckBoxWalllistShowRating;
    }

    private JCheckBox getJCheckBoxPairingsShortLevel() {
        if (this.jCheckBoxPairingsShortLevel == null) {
            this.jCheckBoxPairingsShortLevel = new JCheckBox();
            this.jCheckBoxPairingsShortLevel.setText(Messages.getString("EditTournamentSettingsDialog.PairingsShortLevelCheckBox"));
        }
        return this.jCheckBoxPairingsShortLevel;
    }

    private JCheckBox getJCheckBoxWalllistShowCountry() {
        if (this.jCheckBoxWalllistShowCountry == null) {
            this.jCheckBoxWalllistShowCountry = new JCheckBox();
            this.jCheckBoxWalllistShowCountry.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowCountryCheckBox"));
        }
        return this.jCheckBoxWalllistShowCountry;
    }

    private JCheckBox getJCheckBoxWalllistShowClubEgdName() {
        if (this.jCheckBoxWalllistShowClubEgdName == null) {
            this.jCheckBoxWalllistShowClubEgdName = new JCheckBox();
            this.jCheckBoxWalllistShowClubEgdName.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowEGDClubCheckBox"));
        }
        return this.jCheckBoxWalllistShowClubEgdName;
    }

    private JCheckBox getJCheckBoxWalllistShowClubAbbreviateName() {
        if (this.jCheckBoxWalllistShowClubAbbreviateName == null) {
            this.jCheckBoxWalllistShowClubAbbreviateName = new JCheckBox();
            this.jCheckBoxWalllistShowClubAbbreviateName.setText(Messages.getString("EditTournamentSettingsDialog.WalllistAbbreviateClubCheckBox"));
        }
        return this.jCheckBoxWalllistShowClubAbbreviateName;
    }

    private JCheckBox getJCheckBoxWalllistShowClub() {
        if (this.jCheckBoxWalllistShowClub == null) {
            this.jCheckBoxWalllistShowClub = new JCheckBox();
            this.jCheckBoxWalllistShowClub.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowClubCheckBox"));
        }
        return this.jCheckBoxWalllistShowClub;
    }

    private JCheckBox getJCheckBoxWalllistClubColumnAlignment() {
        if (this.jCheckBoxWalllistClubColumnAlignment == null) {
            this.jCheckBoxWalllistClubColumnAlignment = new JCheckBox();
            this.jCheckBoxWalllistClubColumnAlignment.setText(Messages.getString("EditTournamentSettingsDialog.WalllistClubAlignmentCheckBox"));
        }
        return this.jCheckBoxWalllistClubColumnAlignment;
    }

    private JCheckBox getJCheckBoxRegistrationEGDSupport() {
        if (this.jCheckBoxRegistrationEGDSupport == null) {
            this.jCheckBoxRegistrationEGDSupport = new JCheckBox();
            this.jCheckBoxRegistrationEGDSupport.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationEGDCheckBox"));
        }
        return this.jCheckBoxRegistrationEGDSupport;
    }

    private JCheckBox getJCheckBoxRegistrationSearchEGDByPin() {
        if (this.jCheckBoxRegistrationSearchEGDByPin == null) {
            this.jCheckBoxRegistrationSearchEGDByPin = new JCheckBox();
            this.jCheckBoxRegistrationSearchEGDByPin.setText(Messages.getString("EditTournamentSettingsDialog.RegistrationEGDByPinCheckBox"));
        }
        return this.jCheckBoxRegistrationSearchEGDByPin;
    }

    private JPanel getJPanelExport() {
        if (this.jPanelExport == null) {
            GridBagConstraints gridBagConstraints107 = new GridBagConstraints();
            gridBagConstraints107.fill = 3;
            gridBagConstraints107.gridy = 2;
            gridBagConstraints107.weightx = 1.0;
            gridBagConstraints107.anchor = 17;
            gridBagConstraints107.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints107.gridx = 1;
            GridBagConstraints gridBagConstraints106 = new GridBagConstraints();
            gridBagConstraints106.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints106.gridx = 0;
            gridBagConstraints106.anchor = 13;
            gridBagConstraints106.gridy = 2;
            this.jLabelExportEncoding = new JLabel();
            this.jLabelExportEncoding.setText(Messages.getString("EditTournamentSettingsDialog.ExportEncodingLabel"));
            GridBagConstraints gridBagConstraints101 = new GridBagConstraints();
            gridBagConstraints101.gridx = 1;
            gridBagConstraints101.gridwidth = 1;
            gridBagConstraints101.anchor = 17;
            gridBagConstraints101.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints101.gridy = 1;
            GridBagConstraints gridBagConstraints85 = new GridBagConstraints();
            gridBagConstraints85.gridx = 1;
            gridBagConstraints85.fill = 0;
            gridBagConstraints85.weightx = 1.0;
            gridBagConstraints85.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints85.anchor = 17;
            gridBagConstraints85.gridy = 0;
            GridBagConstraints gridBagConstraints84 = new GridBagConstraints();
            gridBagConstraints84.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints84.gridx = 0;
            gridBagConstraints84.gridy = 0;
            this.jLabelExportColumnDelimiter = new JLabel();
            this.jLabelExportColumnDelimiter.setText(Messages.getString("EditTournamentSettingsDialog.ExportColumnDelimiterLabel"));
            this.jPanelExport = new JPanel();
            GridBagLayout gbl_jPanelExport = new GridBagLayout();
            gbl_jPanelExport.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
            gbl_jPanelExport.columnWeights = new double[]{0.0, 0.0};
            this.jPanelExport.setLayout(gbl_jPanelExport);
            this.jPanelExport.add((Component)this.jLabelExportColumnDelimiter, gridBagConstraints84);
            this.jPanelExport.add((Component)this.getJPanelExportColumnDelimiter(), gridBagConstraints85);
            this.jPanelExport.add((Component)this.getJCheckBoxExportWalllistShowTournamentTitle(), gridBagConstraints101);
            this.jPanelExport.add((Component)this.jLabelExportEncoding, gridBagConstraints106);
            this.jPanelExport.add(this.getJComboBoxExportEncoding(), gridBagConstraints107);
            GridBagConstraints gridBagConstraints86 = new GridBagConstraints();
            gridBagConstraints86.gridx = 1;
            gridBagConstraints86.fill = 1;
            gridBagConstraints86.weightx = 0.0;
            gridBagConstraints86.weighty = 1.0;
            gridBagConstraints86.gridy = 3;
            this.jPanelExport.add((Component)this.getJPanelExportDummy(), gridBagConstraints86);
        }
        return this.jPanelExport;
    }

    private JPanel getJPanelExportColumnDelimiter() {
        if (this.jPanelExportColumnDelimiter == null) {
            GridBagConstraints gridBagConstraints89 = new GridBagConstraints();
            gridBagConstraints89.gridx = 2;
            gridBagConstraints89.insets = new Insets(0, 10, 0, 5);
            gridBagConstraints89.gridy = 0;
            GridBagConstraints gridBagConstraints88 = new GridBagConstraints();
            gridBagConstraints88.gridx = 1;
            gridBagConstraints88.insets = new Insets(0, 10, 0, 5);
            gridBagConstraints88.gridy = 0;
            GridBagConstraints gridBagConstraints87 = new GridBagConstraints();
            gridBagConstraints87.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints87.gridx = 0;
            gridBagConstraints87.gridy = 0;
            this.jPanelExportColumnDelimiter = new JPanel();
            this.jPanelExportColumnDelimiter.setLayout(new GridBagLayout());
            this.jPanelExportColumnDelimiter.add((Component)this.getJRadioButtonExportColumnDelimiterTab(), gridBagConstraints87);
            this.jPanelExportColumnDelimiter.add((Component)this.getJRadioButtonExportColumnDelimiterSemikolon(), gridBagConstraints88);
            this.jPanelExportColumnDelimiter.add((Component)this.getJRadioButtonExportColumnDelimiterPipe(), gridBagConstraints89);
            GridBagConstraints gbc_rdbtnUseFixedFormat = new GridBagConstraints();
            gbc_rdbtnUseFixedFormat.insets = new Insets(0, 10, 0, 0);
            gbc_rdbtnUseFixedFormat.gridx = 3;
            gbc_rdbtnUseFixedFormat.gridy = 0;
            this.jPanelExportColumnDelimiter.add((Component)this.getRdbtnUseFixedFormat(), gbc_rdbtnUseFixedFormat);
        }
        return this.jPanelExportColumnDelimiter;
    }

    private JPanel getJPanelExportDummy() {
        if (this.jPanelExportDummy == null) {
            this.jPanelExportDummy = new JPanel();
            this.jPanelExportDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelExportDummy;
    }

    private JRadioButton getJRadioButtonExportColumnDelimiterTab() {
        if (this.jRadioButtonExportColumnDelimiterTab == null) {
            this.jRadioButtonExportColumnDelimiterTab = new JRadioButton();
            this.jRadioButtonExportColumnDelimiterTab.setText("\\t");
        }
        return this.jRadioButtonExportColumnDelimiterTab;
    }

    private JRadioButton getJRadioButtonExportColumnDelimiterSemikolon() {
        if (this.jRadioButtonExportColumnDelimiterSemikolon == null) {
            this.jRadioButtonExportColumnDelimiterSemikolon = new JRadioButton();
            this.jRadioButtonExportColumnDelimiterSemikolon.setText(";");
        }
        return this.jRadioButtonExportColumnDelimiterSemikolon;
    }

    private JRadioButton getJRadioButtonExportColumnDelimiterPipe() {
        if (this.jRadioButtonExportColumnDelimiterPipe == null) {
            this.jRadioButtonExportColumnDelimiterPipe = new JRadioButton();
            this.jRadioButtonExportColumnDelimiterPipe.setText("|");
        }
        return this.jRadioButtonExportColumnDelimiterPipe;
    }

    private JCheckBox getJCheckBoxWalllistShowLevels() {
        if (this.jCheckBoxWalllistShowLevels == null) {
            this.jCheckBoxWalllistShowLevels = new JCheckBox();
            this.jCheckBoxWalllistShowLevels.setText(Messages.getString("EditTournamentSettingsDialog.WalllistShowLevelsCheckBox"));
        }
        return this.jCheckBoxWalllistShowLevels;
    }

    private JCheckBox getJCheckBoxPairingsShowLevels() {
        if (this.jCheckBoxPairingsShowLevels == null) {
            this.jCheckBoxPairingsShowLevels = new JCheckBox();
            this.jCheckBoxPairingsShowLevels.setText(Messages.getString("EditTournamentSettingsDialog.PairingsShowLevelsCheckBox"));
        }
        return this.jCheckBoxPairingsShowLevels;
    }

    private JCheckBox getJCheckBoxWalllistMarkPreliminaryRegisteredParticipants() {
        if (this.jCheckBoxWalllistMarkPreliminaryRegisteredParticipants == null) {
            this.jCheckBoxWalllistMarkPreliminaryRegisteredParticipants = new JCheckBox();
            this.jCheckBoxWalllistMarkPreliminaryRegisteredParticipants.setText(Messages.getString("EditTournamentSettingsDialog.WalllistMarkPreliminaryCheckBox"));
        }
        return this.jCheckBoxWalllistMarkPreliminaryRegisteredParticipants;
    }

    private JRadioButton getJRadioButtonPlacementCriteriaWeakRankNameId() {
        if (this.jRadioButtonPlacementCriteriaWeakRankNameId == null) {
            this.jRadioButtonPlacementCriteriaWeakRankNameId = new JRadioButton();
            this.jRadioButtonPlacementCriteriaWeakRankNameId.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaSharedPlacesOrderByRankNameId"));
        }
        return this.jRadioButtonPlacementCriteriaWeakRankNameId;
    }

    private JRadioButton getJRadioButtonPlacementCriteriaWeakNameId() {
        if (this.jRadioButtonPlacementCriteriaWeakNameId == null) {
            this.jRadioButtonPlacementCriteriaWeakNameId = new JRadioButton();
            this.jRadioButtonPlacementCriteriaWeakNameId.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaSharedPlacesOrderByNameId"));
        }
        return this.jRadioButtonPlacementCriteriaWeakNameId;
    }

    private JRadioButton getJRadioButtonPlacementCriteriaWeakId() {
        if (this.jRadioButtonPlacementCriteriaWeakId == null) {
            this.jRadioButtonPlacementCriteriaWeakId = new JRadioButton();
            this.jRadioButtonPlacementCriteriaWeakId.setText(Messages.getString("EditTournamentSettingsDialog.PlacementCriteriaSharedPlacesOrderById"));
        }
        return this.jRadioButtonPlacementCriteriaWeakId;
    }

    private JCheckBox getJCheckBoxByeSos() {
        if (this.jCheckBoxByeSos == null) {
            this.jCheckBoxByeSos = new JCheckBox();
            this.jCheckBoxByeSos.setText(Messages.getString("EditTournamentSettingsDialog.MainByeNoSOSCheckBox"));
        }
        return this.jCheckBoxByeSos;
    }

    private JCheckBox getJCheckBoxHalfScoreGroupsRoundDown() {
        if (this.jCheckBoxHalfScoreGroupsRoundDown == null) {
            this.jCheckBoxHalfScoreGroupsRoundDown = new JCheckBox();
            this.jCheckBoxHalfScoreGroupsRoundDown.setText(Messages.getString("EditTournamentSettingsDialog.MainHalfScoreGroupsRoundDownCheckBox"));
        }
        return this.jCheckBoxHalfScoreGroupsRoundDown;
    }

    private JCheckBox getJCheckBoxHalfScoreGroupsRoundDownNotJigo() {
        if (this.jCheckBoxHalfScoreGroupsRoundDownNotJigo == null) {
            this.jCheckBoxHalfScoreGroupsRoundDownNotJigo = new JCheckBox();
            this.jCheckBoxHalfScoreGroupsRoundDownNotJigo.setText(Messages.getString("EditTournamentSettingsDialog.MainHalfScoreGroupsRoundDownNotJigoCheckBox"));
        }
        return this.jCheckBoxHalfScoreGroupsRoundDownNotJigo;
    }

    private JCheckBox getJCheckBoxPairingsShowScores() {
        if (this.jCheckBoxPairingsShowScores == null) {
            this.jCheckBoxPairingsShowScores = new JCheckBox();
            this.jCheckBoxPairingsShowScores.setText(Messages.getString("EditTournamentSettingsDialog.PairingsShowScoresCheckBox"));
        }
        return this.jCheckBoxPairingsShowScores;
    }

    private JComboBox<Country> getJComboBoxRegistrationDefaultNationality() {
        if (this.jComboBoxRegistrationDefaultNationality == null) {
            this.jComboBoxRegistrationDefaultNationality = new JComboBox();
            this.jComboBoxRegistrationDefaultNationality.setPreferredSize(new Dimension(300, 25));
        }
        return this.jComboBoxRegistrationDefaultNationality;
    }

    private JCheckBox getJCheckBoxExportWalllistShowTournamentTitle() {
        if (this.jCheckBoxExportWalllistShowTournamentTitle == null) {
            this.jCheckBoxExportWalllistShowTournamentTitle = new JCheckBox();
            this.jCheckBoxExportWalllistShowTournamentTitle.setText(Messages.getString("EditTournamentSettingsDialog.ExportShowTournamentTitleCheckBox"));
        }
        return this.jCheckBoxExportWalllistShowTournamentTitle;
    }

    private JTextField getJTextFieldVersionCreated() {
        if (this.jTextFieldVersionCreated == null) {
            this.jTextFieldVersionCreated = new JTextField();
            this.jTextFieldVersionCreated.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldVersionCreated.setMinimumSize(this.jTextFieldVersionCreated.getPreferredSize());
            this.jTextFieldVersionCreated.setEditable(false);
        }
        return this.jTextFieldVersionCreated;
    }

    private JTextField getJTextFieldVersionSaved() {
        if (this.jTextFieldVersionSaved == null) {
            this.jTextFieldVersionSaved = new JTextField();
            this.jTextFieldVersionSaved.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldVersionSaved.setMinimumSize(this.jTextFieldVersionSaved.getPreferredSize());
            this.jTextFieldVersionSaved.setEditable(false);
        }
        return this.jTextFieldVersionSaved;
    }

    private JComboBox<String> getJComboBoxExportEncoding() {
        if (this.jComboBoxExportEncoding == null) {
            this.jComboBoxExportEncoding = new JComboBox();
            this.jComboBoxExportEncoding.setPreferredSize(new Dimension(200, 25));
        }
        return this.jComboBoxExportEncoding;
    }

    private JCheckBox getJCheckBoxPairingsShowHandicaps() {
        if (this.jCheckBoxPairingsShowHandicaps == null) {
            this.jCheckBoxPairingsShowHandicaps = new JCheckBox();
            this.jCheckBoxPairingsShowHandicaps.setText(Messages.getString("EditTournamentSettingsDialog.PairingsShowHandicapsCheckBox"));
        }
        return this.jCheckBoxPairingsShowHandicaps;
    }

    private JCheckBox getJCheckBoxPairingsMarkWinner() {
        if (this.jCheckBoxPairingsMarkWinner == null) {
            this.jCheckBoxPairingsMarkWinner = new JCheckBox();
            this.jCheckBoxPairingsMarkWinner.setText(Messages.getString("EditTournamentSettingsDialog.PairingsMarkWinnerCheckBox"));
        }
        return this.jCheckBoxPairingsMarkWinner;
    }

    private JCheckBox getJCheckBoxPairingsMarkMissingResults() {
        if (this.jCheckBoxPairingsMarkMissingResults == null) {
            this.jCheckBoxPairingsMarkMissingResults = new JCheckBox();
            this.jCheckBoxPairingsMarkMissingResults.setText(Messages.getString("EditTournamentSettingsDialog.PairingsMarkMissingResults"));
        }
        return this.jCheckBoxPairingsMarkMissingResults;
    }

    private JPanel getJPanelHandicapDummy() {
        if (this.jPanelHandicapDummy == null) {
            this.jPanelHandicapDummy = new JPanel();
        }
        return this.jPanelHandicapDummy;
    }

    private JRadioButton getRdbtnUseFixedFormat() {
        if (this.rdbtnUseFixedFormat == null) {
            this.rdbtnUseFixedFormat = new JRadioButton(Messages.getString("EditTournamentSettingsDialog.ExportUseFixedFormat"));
        }
        return this.rdbtnUseFixedFormat;
    }

    private JCheckBox getChckbxMarkFixedBoardnumbers() {
        if (this.chckbxMarkFixedBoardnumbers == null) {
            this.chckbxMarkFixedBoardnumbers = new JCheckBox(Messages.getString("EditTournamentSettingsDialog.PairingsMarkFixedBoardnumbers"));
        }
        return this.chckbxMarkFixedBoardnumbers;
    }

    private JCheckBox getChckbxMarkUnwantedPairings() {
        if (this.chckbxMarkUnwantedPairings == null) {
            this.chckbxMarkUnwantedPairings = new JCheckBox(Messages.getString("EditTournamentSettingsDialog.MarkUnwantedPairingsCheckBoxLabel"));
        }
        return this.chckbxMarkUnwantedPairings;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[6];
            gbl_panel.rowHeights = new int[2];
            gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            GridBagConstraints gbc_chckbxMarkUnwantedPairings = new GridBagConstraints();
            gbc_chckbxMarkUnwantedPairings.insets = new Insets(0, 0, 0, 5);
            gbc_chckbxMarkUnwantedPairings.gridx = 0;
            gbc_chckbxMarkUnwantedPairings.gridy = 0;
            this.panel.add((Component)this.getChckbxMarkUnwantedPairings(), gbc_chckbxMarkUnwantedPairings);
            GridBagConstraints gbc_panelUnwantedExample = new GridBagConstraints();
            gbc_panelUnwantedExample.insets = new Insets(0, 0, 0, 5);
            gbc_panelUnwantedExample.anchor = 17;
            gbc_panelUnwantedExample.gridx = 1;
            gbc_panelUnwantedExample.gridy = 0;
            this.panel.add((Component)this.getPanelUnwantedExample(), gbc_panelUnwantedExample);
            GridBagConstraints gbc_lblUnwanted = new GridBagConstraints();
            gbc_lblUnwanted.insets = new Insets(0, 0, 0, 5);
            gbc_lblUnwanted.gridx = 2;
            gbc_lblUnwanted.gridy = 0;
            this.panel.add((Component)this.getLblUnwanted(), gbc_lblUnwanted);
            GridBagConstraints gbc_panelForbiddenExample = new GridBagConstraints();
            gbc_panelForbiddenExample.insets = new Insets(0, 0, 0, 5);
            gbc_panelForbiddenExample.anchor = 17;
            gbc_panelForbiddenExample.gridx = 3;
            gbc_panelForbiddenExample.gridy = 0;
            this.panel.add((Component)this.getPanelForbiddenExample(), gbc_panelForbiddenExample);
            GridBagConstraints gbc_lblForbidden = new GridBagConstraints();
            gbc_lblForbidden.gridx = 4;
            gbc_lblForbidden.gridy = 0;
            this.panel.add((Component)this.getLblForbidden(), gbc_lblForbidden);
        }
        return this.panel;
    }

    private JPanel getPanelUnwantedExample() {
        if (this.panelUnwantedExample == null) {
            this.panelUnwantedExample = new JPanel();
            this.panelUnwantedExample.setBackground(new Color(255, 218, 0));
        }
        return this.panelUnwantedExample;
    }

    private JLabel getLblUnwanted() {
        if (this.lblUnwanted == null) {
            this.lblUnwanted = new JLabel(Messages.getString("EditTournamentSettingsDialog.UnwantedLabel"));
        }
        return this.lblUnwanted;
    }

    private JPanel getPanelForbiddenExample() {
        if (this.panelForbiddenExample == null) {
            this.panelForbiddenExample = new JPanel();
            this.panelForbiddenExample.setBackground(new Color(204, 0, 0));
        }
        return this.panelForbiddenExample;
    }

    private JLabel getLblForbidden() {
        if (this.lblForbidden == null) {
            this.lblForbidden = new JLabel(Messages.getString("EditTournamentSettingsDialog.ForbiddenLabel"));
        }
        return this.lblForbidden;
    }

    private JPanel getPanelImport() {
        if (this.panelImport == null) {
            this.panelImport = new JPanel();
            GridBagLayout gbl_panelImport = new GridBagLayout();
            gbl_panelImport.columnWidths = new int[3];
            gbl_panelImport.rowHeights = new int[2];
            gbl_panelImport.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelImport.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelImport.setLayout(gbl_panelImport);
            GridBagConstraints gbc_lblImportEncoding = new GridBagConstraints();
            gbc_lblImportEncoding.insets = new Insets(0, 0, 0, 5);
            gbc_lblImportEncoding.anchor = 13;
            gbc_lblImportEncoding.gridx = 0;
            gbc_lblImportEncoding.gridy = 0;
            this.panelImport.add((Component)this.getLblImportEncoding(), gbc_lblImportEncoding);
            GridBagConstraints gbc_comboBoxImportEncoding = new GridBagConstraints();
            gbc_comboBoxImportEncoding.fill = 2;
            gbc_comboBoxImportEncoding.gridx = 1;
            gbc_comboBoxImportEncoding.gridy = 0;
            this.panelImport.add(this.getComboBoxImportEncoding(), gbc_comboBoxImportEncoding);
        }
        return this.panelImport;
    }

    private JLabel getLblImportEncoding() {
        if (this.lblImportEncoding == null) {
            this.lblImportEncoding = new JLabel(Messages.getString("EditTournamentSettingsDialog.lblEncoding.text"));
        }
        return this.lblImportEncoding;
    }

    private JComboBox<String> getComboBoxImportEncoding() {
        if (this.comboBoxImportEncoding == null) {
            this.comboBoxImportEncoding = new JComboBox();
        }
        return this.comboBoxImportEncoding;
    }

    private static class SortCriterionTransferable
    implements Transferable {
        private static final DataFlavor[] s_supportedDataFlavors = new DataFlavor[]{s_sortCriterionDataFlavor};
        private Walllist.SortCriterionDescriptor m_data;

        public SortCriterionTransferable(Walllist.SortCriterionDescriptor data) {
            this.m_data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return s_supportedDataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == s_sortCriterionDataFlavor;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor != s_sortCriterionDataFlavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.m_data;
        }
    }
}

