/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DateFormatter;

public class EditPairingDialog {
    private MacMahonApplication m_application;
    private Pairing m_pairing;
    private boolean m_colorsSwapped;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JLabel jLabelBlack = null;
    private JTextField jTextFieldBlack = null;
    private JLabel jLabelWhite = null;
    private JTextField jTextFieldWhite = null;
    private JButton jButtonOk = null;
    private JButton jButtonSwapColors = null;
    private JCheckBox jCheckBoxAllowJigo = null;
    private JLabel jLabelResult = null;
    private JComboBox<Pairing.ResultDescriptor> jComboBoxResult = null;
    private JPanel jPanelResultSwitches = null;
    private JCheckBox jCheckBoxResultByReferree = null;
    private JLabel jLabelHandicap = null;
    private JTextField jTextFieldHandicap = null;
    private JPanel jPanelHandicap = null;
    private JLabel jLabelHandicapStones = null;
    private JLabel jLabelBoardNumber = null;
    private JTextField jTextFieldBoardNumber = null;
    private JPanel jPanelBoardNumber = null;
    private JCheckBox jCheckBoxBoardNumberFixed = null;
    private JButton jButtonDeletePairing = null;
    private JLabel jLabelComment = null;
    private JScrollPane jScrollPaneComment = null;
    private JTextArea jTextAreaComment = null;
    private JCheckBox jCheckBoxForcedPairing = null;
    private JLabel jLabelResultPoints = null;
    private JPanel jPanelResultPoints = null;
    private JTextField jTextFieldResultPoints = null;
    private JLabel jLabelResultPointsExplanation = null;
    private JPanel panel;
    private JLabel lblCreationTime;
    private JTextField textFieldCreationTime;
    private JPanel mainPanel;

    public EditPairingDialog(MacMahonApplication application, Pairing pairing) {
        this.m_application = application;
        this.m_pairing = pairing;
    }

    public void show(Component parent) {
        this.getJDialog();
        this.getJTextFieldBlack().setText(this.m_pairing.getBlack().getPairingDisplayString());
        if (this.m_pairing.isPairingWithBye()) {
            this.getJTextFieldWhite().setText(Pairing.BYE);
            this.getJButtonSwapColors().setEnabled(false);
            this.getJTextFieldHandicap().setEnabled(false);
            this.getJTextFieldHandicap().setEditable(false);
            this.getJCheckBoxAllowJigo().setEnabled(false);
            this.getJCheckBoxResultByReferree().setEnabled(false);
            this.getJComboBoxResult().setEnabled(false);
            this.getJTextFieldResultPoints().setEnabled(false);
            this.getJTextFieldResultPoints().setEditable(false);
        } else {
            this.getJTextFieldWhite().setText(this.m_pairing.getWhite().getPairingDisplayString());
            this.getJTextFieldHandicap().setText(Integer.toString(this.m_pairing.getHandicap()));
            this.getJCheckBoxAllowJigo().setSelected(this.m_pairing.getAllowJigo());
            this.getJCheckBoxResultByReferree().setSelected(this.m_pairing.getResultByReferee());
            DefaultComboBoxModel<Pairing.ResultDescriptor> resultModel = new DefaultComboBoxModel<Pairing.ResultDescriptor>(Pairing.ALL_RESULTS);
            this.getJComboBoxResult().setModel(resultModel);
            this.getJComboBoxResult().setSelectedItem(this.m_pairing.getResult());
            this.getJTextFieldResultPoints().setText(Integer.toString(this.m_pairing.getResultPoints()));
        }
        this.getJTextFieldBoardNumber().setText(Integer.toString(this.m_pairing.getBoardNumber()));
        this.getJCheckBoxBoardNumberFixed().setSelected(this.m_pairing.isBoardNumberFixed());
        this.getJCheckBoxForcedPairing().setSelected(this.m_pairing.getForcedPairing());
        this.getJCheckBoxForcedPairing().setEnabled(false);
        this.getJTextAreaComment().setText(this.m_pairing.getComment());
        try {
            this.getTextFieldCreationTime().setText(this.m_pairing.getCreationTime() == null ? "" : new DateFormatter(DateFormat.getDateTimeInstance()).valueToString(this.m_pairing.getCreationTime()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditPairingDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPairingDialog.this.getJScrollPaneComment().getVerticalScrollBar().setValue(0);
            }
        });
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setSize(new Dimension(664, 385));
            this.jDialog.setTitle(Messages.getString("EditPairingDialog.Title"));
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setModal(true);
            this.jDialog.setContentPane(this.getJContentPane());
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagLayout gbl_jContentPane = new GridBagLayout();
            gbl_jContentPane.rowWeights = new double[]{1.0};
            gbl_jContentPane.columnWeights = new double[]{1.0};
            this.jContentPane.setLayout(gbl_jContentPane);
            GridBagConstraints gbc_mainPanel = new GridBagConstraints();
            gbc_mainPanel.insets = new Insets(10, 10, 10, 10);
            gbc_mainPanel.fill = 1;
            gbc_mainPanel.gridx = 0;
            gbc_mainPanel.gridy = 0;
            this.jContentPane.add((Component)this.getMainPanel(), gbc_mainPanel);
        }
        return this.jContentPane;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("EditPairingDialog.OK"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean ok = true;
                    EditPairingDialog.this.m_pairing.setBoardNumber(Integer.parseInt(EditPairingDialog.this.getJTextFieldBoardNumber().getText()), EditPairingDialog.this.getJCheckBoxBoardNumberFixed().isSelected());
                    if (!EditPairingDialog.this.m_pairing.isPairingWithBye()) {
                        if (EditPairingDialog.this.m_colorsSwapped) {
                            EditPairingDialog.this.m_pairing.swapColors();
                        }
                        EditPairingDialog.this.m_pairing.setHandicap(Integer.parseInt(EditPairingDialog.this.getJTextFieldHandicap().getText()));
                        EditPairingDialog.this.m_pairing.setAllowJigo(EditPairingDialog.this.getJCheckBoxAllowJigo().isSelected());
                        EditPairingDialog.this.m_pairing.setResultByReferee(EditPairingDialog.this.getJCheckBoxResultByReferree().isSelected());
                        EditPairingDialog.this.m_pairing.setResult((Pairing.ResultDescriptor)EditPairingDialog.this.getJComboBoxResult().getSelectedItem());
                        EditPairingDialog.this.m_pairing.setResultPoints(Integer.parseInt(EditPairingDialog.this.getJTextFieldResultPoints().getText()));
                    }
                    EditPairingDialog.this.m_pairing.setComment(EditPairingDialog.this.getJTextAreaComment().getText());
                    if (ok) {
                        EditPairingDialog.this.getJDialog().dispose();
                    }
                }
            });
        }
        return this.jButtonOk;
    }

    private JTextField getJTextFieldBlack() {
        if (this.jTextFieldBlack == null) {
            this.jTextFieldBlack = new JTextField();
            this.jTextFieldBlack.setEditable(false);
        }
        return this.jTextFieldBlack;
    }

    private JTextField getJTextFieldWhite() {
        if (this.jTextFieldWhite == null) {
            this.jTextFieldWhite = new JTextField();
            this.jTextFieldWhite.setEditable(false);
        }
        return this.jTextFieldWhite;
    }

    private JButton getJButtonSwapColors() {
        if (this.jButtonSwapColors == null) {
            this.jButtonSwapColors = new JButton();
            this.jButtonSwapColors.setText(Messages.getString("EditPairingDialog.SwapColorsButton"));
            this.jButtonSwapColors.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String swapText = EditPairingDialog.this.getJTextFieldBlack().getText();
                    EditPairingDialog.this.getJTextFieldBlack().setText(EditPairingDialog.this.getJTextFieldWhite().getText());
                    EditPairingDialog.this.getJTextFieldWhite().setText(swapText);
                    Pairing.ResultDescriptor result = (Pairing.ResultDescriptor)EditPairingDialog.this.getJComboBoxResult().getSelectedItem();
                    EditPairingDialog.this.getJComboBoxResult().setSelectedItem(Pairing.getColorsSwappedResult(result));
                    EditPairingDialog.this.m_colorsSwapped = !EditPairingDialog.this.m_colorsSwapped;
                }
            });
        }
        return this.jButtonSwapColors;
    }

    private JCheckBox getJCheckBoxAllowJigo() {
        if (this.jCheckBoxAllowJigo == null) {
            this.jCheckBoxAllowJigo = new JCheckBox();
            this.jCheckBoxAllowJigo.setText(Messages.getString("EditPairingDialog.AllowJigoCheckBox"));
        }
        return this.jCheckBoxAllowJigo;
    }

    private JComboBox<Pairing.ResultDescriptor> getJComboBoxResult() {
        if (this.jComboBoxResult == null) {
            this.jComboBoxResult = new JComboBox();
            this.jComboBoxResult.setPreferredSize(new Dimension(100, 25));
            this.jComboBoxResult.setMinimumSize(new Dimension(100, 25));
        }
        return this.jComboBoxResult;
    }

    private JPanel getJPanelResultSwitches() {
        if (this.jPanelResultSwitches == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.fill = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 10;
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(0, 10, 0, 5);
            this.jPanelResultSwitches = new JPanel();
            this.jPanelResultSwitches.setLayout(new GridBagLayout());
            this.jPanelResultSwitches.add((Component)this.getJCheckBoxAllowJigo(), gridBagConstraints7);
            this.jPanelResultSwitches.add((Component)this.getJCheckBoxResultByReferree(), gridBagConstraints8);
            this.jPanelResultSwitches.add(this.getJComboBoxResult(), gridBagConstraints9);
        }
        return this.jPanelResultSwitches;
    }

    private JCheckBox getJCheckBoxResultByReferree() {
        if (this.jCheckBoxResultByReferree == null) {
            this.jCheckBoxResultByReferree = new JCheckBox();
            this.jCheckBoxResultByReferree.setText(Messages.getString("EditPairingDialog.RefereeDecisionCheckBox"));
        }
        return this.jCheckBoxResultByReferree;
    }

    private JTextField getJTextFieldHandicap() {
        if (this.jTextFieldHandicap == null) {
            this.jTextFieldHandicap = new JTextField();
            this.jTextFieldHandicap.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldHandicap.setMinimumSize(new Dimension(100, 20));
        }
        return this.jTextFieldHandicap;
    }

    private JPanel getJPanelHandicap() {
        if (this.jPanelHandicap == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints12.gridy = 0;
            this.jLabelHandicapStones = new JLabel();
            this.jLabelHandicapStones.setText(Messages.getString("EditPairingDialog.HandicapStonesLabel"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 0;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridx = 0;
            this.jPanelHandicap = new JPanel();
            this.jPanelHandicap.setLayout(new GridBagLayout());
            this.jPanelHandicap.add((Component)this.getJTextFieldHandicap(), gridBagConstraints11);
            this.jPanelHandicap.add((Component)this.jLabelHandicapStones, gridBagConstraints12);
        }
        return this.jPanelHandicap;
    }

    private JTextField getJTextFieldBoardNumber() {
        if (this.jTextFieldBoardNumber == null) {
            this.jTextFieldBoardNumber = new JTextField();
            this.jTextFieldBoardNumber.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldBoardNumber.setMinimumSize(new Dimension(100, 20));
        }
        return this.jTextFieldBoardNumber;
    }

    private JPanel getJPanelBoardNumber() {
        if (this.jPanelBoardNumber == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints15.gridy = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.anchor = 10;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.fill = 0;
            this.jPanelBoardNumber = new JPanel();
            this.jPanelBoardNumber.setLayout(new GridBagLayout());
            this.jPanelBoardNumber.add((Component)this.getJTextFieldBoardNumber(), gridBagConstraints14);
            this.jPanelBoardNumber.add((Component)this.getJCheckBoxBoardNumberFixed(), gridBagConstraints15);
        }
        return this.jPanelBoardNumber;
    }

    private JCheckBox getJCheckBoxBoardNumberFixed() {
        if (this.jCheckBoxBoardNumberFixed == null) {
            this.jCheckBoxBoardNumberFixed = new JCheckBox();
            this.jCheckBoxBoardNumberFixed.setText(Messages.getString("EditPairingDialog.BoardNumberFixedCheckBox"));
        }
        return this.jCheckBoxBoardNumberFixed;
    }

    private JButton getJButtonDeletePairing() {
        if (this.jButtonDeletePairing == null) {
            this.jButtonDeletePairing = new JButton();
            this.jButtonDeletePairing.setText(Messages.getString("EditPairingDialog.DeletePairingButton"));
            this.jButtonDeletePairing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditPairingDialog.this.m_application.pairingDelete(EditPairingDialog.this.m_pairing)) {
                        EditPairingDialog.this.getJDialog().dispose();
                    }
                }
            });
        }
        return this.jButtonDeletePairing;
    }

    private JScrollPane getJScrollPaneComment() {
        if (this.jScrollPaneComment == null) {
            this.jScrollPaneComment = new JScrollPane();
            this.jScrollPaneComment.setViewportView(this.getJTextAreaComment());
        }
        return this.jScrollPaneComment;
    }

    private JTextArea getJTextAreaComment() {
        if (this.jTextAreaComment == null) {
            this.jTextAreaComment = new JTextArea();
        }
        return this.jTextAreaComment;
    }

    private JCheckBox getJCheckBoxForcedPairing() {
        if (this.jCheckBoxForcedPairing == null) {
            this.jCheckBoxForcedPairing = new JCheckBox();
            this.jCheckBoxForcedPairing.setText(Messages.getString("EditPairingDialog.ForcedPairingCheckbox"));
        }
        return this.jCheckBoxForcedPairing;
    }

    private JPanel getJPanelResultPoints() {
        if (this.jPanelResultPoints == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 1;
            gridBagConstraints19.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints19.gridy = 0;
            this.jLabelResultPointsExplanation = new JLabel();
            this.jLabelResultPointsExplanation.setText(Messages.getString("EditPairingDialog.ResultPointsExplanation"));
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 2;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.gridx = 0;
            this.jPanelResultPoints = new JPanel();
            this.jPanelResultPoints.setLayout(new GridBagLayout());
            this.jPanelResultPoints.add((Component)this.getJTextFieldResultPoints(), gridBagConstraints18);
            this.jPanelResultPoints.add((Component)this.jLabelResultPointsExplanation, gridBagConstraints19);
        }
        return this.jPanelResultPoints;
    }

    private JTextField getJTextFieldResultPoints() {
        if (this.jTextFieldResultPoints == null) {
            this.jTextFieldResultPoints = new JTextField();
            this.jTextFieldResultPoints.setPreferredSize(new Dimension(80, 20));
        }
        return this.jTextFieldResultPoints;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[5];
            gbl_panel.rowHeights = new int[2];
            gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            GridBagConstraints gbc_lblCreationTime = new GridBagConstraints();
            gbc_lblCreationTime.insets = new Insets(0, 0, 0, 5);
            gbc_lblCreationTime.anchor = 13;
            gbc_lblCreationTime.gridx = 0;
            gbc_lblCreationTime.gridy = 0;
            this.panel.add((Component)this.getLblCreationTime(), gbc_lblCreationTime);
            GridBagConstraints gbc_textFieldCreationTime = new GridBagConstraints();
            gbc_textFieldCreationTime.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldCreationTime.fill = 2;
            gbc_textFieldCreationTime.gridx = 1;
            gbc_textFieldCreationTime.gridy = 0;
            this.panel.add((Component)this.getTextFieldCreationTime(), gbc_textFieldCreationTime);
            GridBagConstraints gbc_jCheckBoxForcedPairing = new GridBagConstraints();
            gbc_jCheckBoxForcedPairing.insets = new Insets(0, 0, 0, 5);
            gbc_jCheckBoxForcedPairing.gridx = 2;
            gbc_jCheckBoxForcedPairing.gridy = 0;
            this.panel.add((Component)this.getJCheckBoxForcedPairing(), gbc_jCheckBoxForcedPairing);
        }
        return this.panel;
    }

    private JLabel getLblCreationTime() {
        if (this.lblCreationTime == null) {
            this.lblCreationTime = new JLabel(Messages.getString("EditPairingDialog.CreationTimeLabel"));
        }
        return this.lblCreationTime;
    }

    private JTextField getTextFieldCreationTime() {
        if (this.textFieldCreationTime == null) {
            this.textFieldCreationTime = new JTextField();
            this.textFieldCreationTime.setEditable(false);
            this.textFieldCreationTime.setColumns(10);
        }
        return this.textFieldCreationTime;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            GridBagLayout gbl_mainPanel = new GridBagLayout();
            gbl_mainPanel.columnWidths = new int[1];
            gbl_mainPanel.rowHeights = new int[1];
            gbl_mainPanel.columnWeights = new double[]{Double.MIN_VALUE};
            gbl_mainPanel.rowWeights = new double[]{Double.MIN_VALUE};
            this.mainPanel.setLayout(gbl_mainPanel);
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.fill = 0;
            gridBagConstraints22.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints22.gridwidth = 2;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.weightx = 0.0;
            gridBagConstraints22.gridy = 5;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.anchor = 13;
            gridBagConstraints17.gridy = 5;
            this.jLabelResultPoints = new JLabel();
            this.jLabelResultPoints.setText(Messages.getString("EditPairingDialog.ResultPointsLabel"));
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.fill = 1;
            gridBagConstraints51.gridy = 7;
            gridBagConstraints51.weightx = 1.0;
            gridBagConstraints51.weighty = 1.0;
            gridBagConstraints51.gridwidth = 2;
            gridBagConstraints51.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints51.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.gridy = 7;
            this.jLabelComment = new JLabel();
            this.jLabelComment.setText(Messages.getString("EditPairingDialog.CommentLabel"));
            GridBagConstraints gridBagConstraints141 = new GridBagConstraints();
            gridBagConstraints141.gridx = 2;
            gridBagConstraints141.insets = new Insets(0, 10, 10, 0);
            gridBagConstraints141.gridy = 8;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.fill = 0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints13.gridy = 3;
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints111.gridx = 0;
            gridBagConstraints111.anchor = 13;
            gridBagConstraints111.gridy = 3;
            this.jLabelBoardNumber = new JLabel();
            this.jLabelBoardNumber.setText(Messages.getString("EditPairingDialog.BoardNumberLabel"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.fill = 0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints10.gridy = 2;
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            gridBagConstraints71.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints71.gridx = 0;
            gridBagConstraints71.anchor = 13;
            gridBagConstraints71.gridy = 2;
            this.jLabelHandicap = new JLabel();
            this.jLabelHandicap.setText(Messages.getString("EditPairingDialog.HandicapLabel"));
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridy = 4;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.anchor = 13;
            gridBagConstraints41.gridy = 4;
            this.jLabelResult = new JLabel();
            this.jLabelResult.setText(Messages.getString("EditPairingDialog.ResultLabel"));
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 2;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridheight = 2;
            gridBagConstraints21.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints21.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 3;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 9;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 0;
            this.jLabelBlack = new JLabel();
            this.jLabelBlack.setText(Messages.getString("EditPairingDialog.BlackLabel"));
            this.mainPanel.add((Component)this.jLabelBlack, gridBagConstraints);
            this.mainPanel.add((Component)this.getJTextFieldBlack(), gridBagConstraints1);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridy = 1;
            this.jLabelWhite = new JLabel();
            this.jLabelWhite.setText(Messages.getString("EditPairingDialog.WhiteLabel"));
            this.mainPanel.add((Component)this.jLabelWhite, gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints3.gridx = 1;
            this.mainPanel.add((Component)this.getJTextFieldWhite(), gridBagConstraints3);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.gridwidth = 2;
            gbc_panel.insets = new Insets(0, 10, 5, 0);
            gbc_panel.fill = 1;
            gbc_panel.gridx = 1;
            gbc_panel.gridy = 6;
            this.mainPanel.add((Component)this.getPanel(), gbc_panel);
            this.mainPanel.add((Component)this.getJButtonOk(), gridBagConstraints5);
            this.mainPanel.add((Component)this.getJButtonSwapColors(), gridBagConstraints21);
            this.mainPanel.add((Component)this.jLabelResult, gridBagConstraints41);
            this.mainPanel.add((Component)this.getJPanelResultSwitches(), gridBagConstraints6);
            this.mainPanel.add((Component)this.jLabelHandicap, gridBagConstraints71);
            this.mainPanel.add((Component)this.getJPanelHandicap(), gridBagConstraints10);
            this.mainPanel.add((Component)this.jLabelBoardNumber, gridBagConstraints111);
            this.mainPanel.add((Component)this.getJPanelBoardNumber(), gridBagConstraints13);
            this.mainPanel.add((Component)this.getJButtonDeletePairing(), gridBagConstraints141);
            this.mainPanel.add((Component)this.jLabelComment, gridBagConstraints4);
            this.mainPanel.add((Component)this.getJScrollPaneComment(), gridBagConstraints51);
            this.mainPanel.add((Component)this.jLabelResultPoints, gridBagConstraints17);
            this.mainPanel.add((Component)this.getJPanelResultPoints(), gridBagConstraints22);
        }
        return this.mainPanel;
    }
}

