/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.model.Walllist;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditMakePairingSettingsDialog {
    private Tournament m_tournament;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JButton jButtonOk = null;
    private JCheckBox jCheckBoxTopGroup = null;
    private JRadioButton jRadioButtonTopGroupAllTopBarMembers = null;
    private JRadioButton jRadioButtonTopGroupByNumberOfParticipants = null;
    private JTextField jTextFieldTopGroupNumberOfPlayers = null;
    private JCheckBox jCheckBoxTopGroupNumberOfPlayersAuto = null;
    private JRadioButton jRadioButtonTopGroupEverywhere = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelMainSettings = null;
    private JPanel jPanelMainSettingsDummy = null;
    private JPanel jPanelOutsideTopGroup = null;
    private JCheckBox jCheckBoxOutsideTopGroupAvoidSameCountry = null;
    private JCheckBox jCheckBoxOutsideTopGroupAvoidSameClub = null;
    private JCheckBox jCheckBoxOutsideTopGroupAvoidStrengthDifference = null;
    private JTextField jTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel = null;
    private JLabel jLabelOutsideTopGroupAvoidStrengthDifferenceLevel = null;
    private JCheckBox jCheckBoxOutsideTopGroupColorBalance = null;
    private JPanel jPanelOutsideTopGroupDummy = null;
    private JCheckBox jCheckBoxOutsideTopGroupWeakOddMan = null;
    private JCheckBox jCheckBoxOutsideTopGroupSeeding = null;
    private JCheckBox jCheckBoxTopGroupSeedingByRating = null;
    private JTextField jTextFieldTopGroupSeedingByRatingRound = null;
    private JCheckBox jCheckBoxOutsideTopGroupAvoidSameNationality = null;
    private JCheckBox jCheckBoxTopGroupUseSeeding = null;
    private JPanel jPanelSeedingByRating = null;
    private JPanel jPanelSeedingPlacementCriterion = null;
    private JLabel jLabelSeedingPlacementCriterion = null;
    private JComboBox<Walllist.SortCriterionDescriptor> jComboBoxSeedingPlacementCriterion = null;

    public EditMakePairingSettingsDialog(Tournament tournament) {
        this.m_tournament = tournament;
    }

    public void show(Component parent) {
        this.getJDialog();
        this.getJCheckBoxTopGroup().setSelected(this.m_tournament.getMakePairingTopGroup());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getJRadioButtonTopGroupEverywhere());
        bg.add(this.getJRadioButtonTopGroupAllTopBarMembers());
        bg.add(this.getJRadioButtonTopGroupByNumberOfParticipants());
        if (this.m_tournament.getMakePairingTopGroupEverywhere()) {
            this.getJRadioButtonTopGroupEverywhere().setSelected(true);
            this.setTopGroupNumberOfPlayersEnabled(false);
        } else if (this.m_tournament.getMakePairingTopGroupStrictlyByTopBar()) {
            this.getJRadioButtonTopGroupAllTopBarMembers().setSelected(true);
            this.setTopGroupNumberOfPlayersEnabled(false);
        } else {
            this.getJRadioButtonTopGroupByNumberOfParticipants().setSelected(true);
            this.setTopGroupNumberOfPlayersEnabled(true);
        }
        this.getJTextFieldTopGroupNumberOfPlayers().setText(Integer.toString(this.m_tournament.getMakePairingTopGroupByNumberOfPlayers()));
        this.getJCheckBoxTopGroupNumberOfPlayersAuto().setSelected(this.m_tournament.getMakePairingTopGroupByNumberOfPlayersAuto());
        this.setTopGroupEnabled(this.getJCheckBoxTopGroup().isSelected());
        this.getJCheckBoxTopGroupUseSeeding().setSelected(this.m_tournament.getMakePairingTopGroupSeeding());
        ArrayList<Walllist.SortCriterionDescriptor> seedingPlacementCriteria = new ArrayList<Walllist.SortCriterionDescriptor>();
        int i = 0;
        while (i < Walllist.s_availableSortCriteria.length) {
            if (Walllist.s_availableSortCriteria[i].isAllowedForSeeding()) {
                seedingPlacementCriteria.add(Walllist.s_availableSortCriteria[i]);
            }
            ++i;
        }
        DefaultComboBoxModel<Walllist.SortCriterionDescriptor> seedingPlacementCriterionModel = new DefaultComboBoxModel<Walllist.SortCriterionDescriptor>(seedingPlacementCriteria.toArray(new Walllist.SortCriterionDescriptor[0]));
        this.getJComboBoxSeedingPlacementCriterion().setModel(seedingPlacementCriterionModel);
        this.getJComboBoxSeedingPlacementCriterion().setSelectedItem(this.m_tournament.getMakePairingSeedingPlacementCriterion());
        this.getJCheckBoxTopGroupSeedingByRating().setSelected(this.m_tournament.getMakePairingTopGroupSeedingByRating());
        this.getJTextFieldTopGroupSeedingByRatingRound().setText(Integer.toString(this.m_tournament.getMakePairingTopGroupSeedingByRatingRound()));
        this.setSeedingEnabled(this.getJCheckBoxTopGroupUseSeeding().isSelected());
        this.getJCheckBoxOutsideTopGroupAvoidSameCountry().setSelected(this.m_tournament.getMakePairingOutsideTopGroupSameCountry());
        this.getJCheckBoxOutsideTopGroupAvoidSameClub().setSelected(this.m_tournament.getMakePairingOutsideTopGroupSameClub());
        this.getJCheckBoxOutsideTopGroupAvoidSameNationality().setSelected(this.m_tournament.getMakePairingOutsideTopGroupSameNationality());
        this.getJCheckBoxOutsideTopGroupAvoidStrengthDifference().setSelected(this.m_tournament.getMakePairingOutsideTopGroupStrengthDifference());
        this.getJTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel().setText(Integer.toString(this.m_tournament.getMakePairingOutsideTopGroupStrengthDifferenceValue()));
        this.getJCheckBoxOutsideTopGroupColorBalance().setSelected(this.m_tournament.getMakePairingOutsideTopGroupColorBalance());
        this.getJCheckBoxOutsideTopGroupWeakOddMan().setSelected(this.m_tournament.getMakePairingOutsideTopGroupWeakOddMan());
        this.getJCheckBoxOutsideTopGroupSeeding().setSelected(!this.m_tournament.getMakePairingOutsideTopGroupSeeding());
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditMakePairingSettingsDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    private void setTopGroupEnabled(boolean enabled) {
        this.getJRadioButtonTopGroupEverywhere().setEnabled(enabled);
        this.getJRadioButtonTopGroupAllTopBarMembers().setEnabled(enabled);
        this.getJRadioButtonTopGroupByNumberOfParticipants().setEnabled(enabled);
        this.getJCheckBoxTopGroupNumberOfPlayersAuto().setEnabled(enabled);
        this.setTopGroupNumberOfPlayersEnabled(enabled);
    }

    private void setTopGroupNumberOfPlayersEnabled(boolean enabled) {
        this.getJCheckBoxTopGroupNumberOfPlayersAuto().setEnabled(enabled && this.getJRadioButtonTopGroupByNumberOfParticipants().isSelected());
        this.getJTextFieldTopGroupNumberOfPlayers().setEnabled(enabled && this.getJRadioButtonTopGroupByNumberOfParticipants().isSelected() && !this.getJCheckBoxTopGroupNumberOfPlayersAuto().isSelected());
    }

    private void setSeedingEnabled(boolean enabled) {
        this.getJComboBoxSeedingPlacementCriterion().setEnabled(enabled);
        this.getJCheckBoxTopGroupSeedingByRating().setEnabled(enabled);
        this.getJTextFieldTopGroupSeedingByRatingRound().setEnabled(enabled);
        this.jLabelSeedingPlacementCriterion.setEnabled(enabled);
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setSize(new Dimension(553, 280));
            this.jDialog.setModal(true);
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setContentPane(this.getJContentPane());
            this.jDialog.setTitle(Messages.getString("EditMakePairingSettingsDialog.Title"));
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 1;
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.gridy = 5;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.gridwidth = 3;
            gridBagConstraints24.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.anchor = 17;
            gridBagConstraints110.gridx = 0;
            gridBagConstraints110.gridy = 4;
            gridBagConstraints110.gridwidth = 3;
            gridBagConstraints110.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridheight = 3;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 3;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJButtonOk(), gridBagConstraints);
            this.jContentPane.add((Component)this.getJTabbedPane(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("EditMakePairingSettingsDialog.OK"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroup(EditMakePairingSettingsDialog.this.getJCheckBoxTopGroup().isSelected());
                    if (EditMakePairingSettingsDialog.this.m_tournament.getMakePairingTopGroup()) {
                        EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupEverywhere(EditMakePairingSettingsDialog.this.getJRadioButtonTopGroupEverywhere().isSelected());
                        EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupStrictlyByTopBar(EditMakePairingSettingsDialog.this.getJRadioButtonTopGroupAllTopBarMembers().isSelected());
                        EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupByNumberOfPlayersAuto(EditMakePairingSettingsDialog.this.getJCheckBoxTopGroupNumberOfPlayersAuto().isSelected());
                        if (!EditMakePairingSettingsDialog.this.m_tournament.getMakePairingTopGroupByNumberOfPlayersAuto()) {
                            EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupByNumberOfPlayers(Integer.parseInt(EditMakePairingSettingsDialog.this.getJTextFieldTopGroupNumberOfPlayers().getText()));
                        }
                    }
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupSeeding(EditMakePairingSettingsDialog.this.getJCheckBoxTopGroupUseSeeding().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingSeedingPlacementCriterion((Walllist.SortCriterionDescriptor)EditMakePairingSettingsDialog.this.getJComboBoxSeedingPlacementCriterion().getSelectedItem());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupSeedingByRating(EditMakePairingSettingsDialog.this.getJCheckBoxTopGroupSeedingByRating().isSelected());
                    int round = 0;
                    try {
                        round = Integer.parseInt(EditMakePairingSettingsDialog.this.getJTextFieldTopGroupSeedingByRatingRound().getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (round < 0) {
                        round = 0;
                    }
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingTopGroupSeedingByRatingRound(round);
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupSameCountry(EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupAvoidSameCountry().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupSameClub(EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupAvoidSameClub().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupSameNationality(EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupAvoidSameNationality().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupStrengthDifference(EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupAvoidStrengthDifference().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupStrengthDifferenceValue(Integer.parseInt(EditMakePairingSettingsDialog.this.getJTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel().getText()));
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupColorBalance(EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupColorBalance().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupWeakOddMan(EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupWeakOddMan().isSelected());
                    EditMakePairingSettingsDialog.this.m_tournament.setMakePairingOutsideTopGroupSeeding(!EditMakePairingSettingsDialog.this.getJCheckBoxOutsideTopGroupSeeding().isSelected());
                    EditMakePairingSettingsDialog.this.getJDialog().dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JCheckBox getJCheckBoxTopGroup() {
        if (this.jCheckBoxTopGroup == null) {
            this.jCheckBoxTopGroup = new JCheckBox();
            this.jCheckBoxTopGroup.setText(Messages.getString("EditMakePairingSettingsDialog.UseTopGroupCheckBox"));
            this.jCheckBoxTopGroup.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditMakePairingSettingsDialog.this.setTopGroupEnabled(EditMakePairingSettingsDialog.this.jCheckBoxTopGroup.isSelected());
                }
            });
        }
        return this.jCheckBoxTopGroup;
    }

    private JRadioButton getJRadioButtonTopGroupAllTopBarMembers() {
        if (this.jRadioButtonTopGroupAllTopBarMembers == null) {
            this.jRadioButtonTopGroupAllTopBarMembers = new JRadioButton();
            this.jRadioButtonTopGroupAllTopBarMembers.setText(Messages.getString("EditMakePairingSettingsDialog.TopBarInTopGroupRadioButton"));
            this.jRadioButtonTopGroupAllTopBarMembers.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditMakePairingSettingsDialog.this.setTopGroupNumberOfPlayersEnabled(!EditMakePairingSettingsDialog.this.jRadioButtonTopGroupAllTopBarMembers.isSelected());
                }
            });
        }
        return this.jRadioButtonTopGroupAllTopBarMembers;
    }

    private JRadioButton getJRadioButtonTopGroupByNumberOfParticipants() {
        if (this.jRadioButtonTopGroupByNumberOfParticipants == null) {
            this.jRadioButtonTopGroupByNumberOfParticipants = new JRadioButton();
            this.jRadioButtonTopGroupByNumberOfParticipants.setText(Messages.getString("EditMakePairingSettingsDialog.TopGroupByNumberRadioButton"));
            this.jRadioButtonTopGroupByNumberOfParticipants.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditMakePairingSettingsDialog.this.setTopGroupNumberOfPlayersEnabled(EditMakePairingSettingsDialog.this.jRadioButtonTopGroupByNumberOfParticipants.isSelected());
                }
            });
        }
        return this.jRadioButtonTopGroupByNumberOfParticipants;
    }

    private JTextField getJTextFieldTopGroupNumberOfPlayers() {
        if (this.jTextFieldTopGroupNumberOfPlayers == null) {
            this.jTextFieldTopGroupNumberOfPlayers = new JTextField();
            this.jTextFieldTopGroupNumberOfPlayers.setMinimumSize(new Dimension(50, 20));
            this.jTextFieldTopGroupNumberOfPlayers.setPreferredSize(new Dimension(50, 20));
        }
        return this.jTextFieldTopGroupNumberOfPlayers;
    }

    private JCheckBox getJCheckBoxTopGroupNumberOfPlayersAuto() {
        if (this.jCheckBoxTopGroupNumberOfPlayersAuto == null) {
            this.jCheckBoxTopGroupNumberOfPlayersAuto = new JCheckBox();
            this.jCheckBoxTopGroupNumberOfPlayersAuto.setText(Messages.getString("EditMakePairingSettingsDialog.TopGroupByNumberAutoCheckBox"));
            this.jCheckBoxTopGroupNumberOfPlayersAuto.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditMakePairingSettingsDialog.this.getJTextFieldTopGroupNumberOfPlayers().setEnabled(!EditMakePairingSettingsDialog.this.jCheckBoxTopGroupNumberOfPlayersAuto.isSelected());
                }
            });
        }
        return this.jCheckBoxTopGroupNumberOfPlayersAuto;
    }

    private JRadioButton getJRadioButtonTopGroupEverywhere() {
        if (this.jRadioButtonTopGroupEverywhere == null) {
            this.jRadioButtonTopGroupEverywhere = new JRadioButton();
            this.jRadioButtonTopGroupEverywhere.setText(Messages.getString("EditMakePairingSettingsDialog.TopGroupAllPlayersRadioButton"));
        }
        return this.jRadioButtonTopGroupEverywhere;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab(Messages.getString("EditMakePairingSettingsDialog.MainSettingsTabTitle"), null, this.getJPanelMainSettings(), null);
            this.jTabbedPane.addTab(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupTabTitle"), null, this.getJPanelOutsideTopGroup(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelMainSettings() {
        if (this.jPanelMainSettings == null) {
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.fill = 0;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.weighty = 1.0;
            gridBagConstraints20.gridwidth = 3;
            gridBagConstraints20.insets = new Insets(0, 22, 0, 0);
            gridBagConstraints20.gridy = 5;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.fill = 0;
            gridBagConstraints22.weightx = 0.0;
            gridBagConstraints22.weighty = 0.0;
            gridBagConstraints22.gridwidth = 3;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints22.gridy = 6;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridy = 0;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.fill = 3;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridwidth = 3;
            gridBagConstraints18.gridy = 4;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridwidth = 3;
            gridBagConstraints8.gridy = 7;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 3;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            this.jPanelMainSettings = new JPanel();
            GridBagLayout gbl_jPanelMainSettings = new GridBagLayout();
            gbl_jPanelMainSettings.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            gbl_jPanelMainSettings.columnWeights = new double[]{0.0, 0.0, 0.0};
            this.jPanelMainSettings.setLayout(gbl_jPanelMainSettings);
            this.jPanelMainSettings.add((Component)this.getJCheckBoxTopGroup(), gridBagConstraints2);
            this.jPanelMainSettings.add((Component)this.getJRadioButtonTopGroupEverywhere(), gridBagConstraints3);
            this.jPanelMainSettings.add((Component)this.getJRadioButtonTopGroupAllTopBarMembers(), gridBagConstraints4);
            this.jPanelMainSettings.add((Component)this.getJRadioButtonTopGroupByNumberOfParticipants(), gridBagConstraints5);
            this.jPanelMainSettings.add((Component)this.getJTextFieldTopGroupNumberOfPlayers(), gridBagConstraints6);
            this.jPanelMainSettings.add((Component)this.getJCheckBoxTopGroupNumberOfPlayersAuto(), gridBagConstraints7);
            this.jPanelMainSettings.add((Component)this.getJPanelMainSettingsDummy(), gridBagConstraints8);
            this.jPanelMainSettings.add((Component)this.getJCheckBoxTopGroupUseSeeding(), gridBagConstraints18);
            this.jPanelMainSettings.add((Component)this.getJPanelSeedingByRating(), gridBagConstraints22);
            this.jPanelMainSettings.add((Component)this.getJPanelSeedingPlacementCriterion(), gridBagConstraints20);
        }
        return this.jPanelMainSettings;
    }

    private JPanel getJPanelMainSettingsDummy() {
        if (this.jPanelMainSettingsDummy == null) {
            this.jPanelMainSettingsDummy = new JPanel();
            this.jPanelMainSettingsDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelMainSettingsDummy;
    }

    private JPanel getJPanelOutsideTopGroup() {
        if (this.jPanelOutsideTopGroup == null) {
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.anchor = 17;
            gridBagConstraints23.gridwidth = 3;
            gridBagConstraints23.gridy = 2;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.gridwidth = 3;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 6;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.gridwidth = 3;
            gridBagConstraints16.gridy = 5;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.gridwidth = 3;
            gridBagConstraints15.gridy = 7;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.gridwidth = 3;
            gridBagConstraints14.gridy = 4;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 2;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints13.gridy = 3;
            this.jLabelOutsideTopGroupAvoidStrengthDifferenceLevel = new JLabel();
            this.jLabelOutsideTopGroupAvoidStrengthDifferenceLevel.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupAvoidStrengthDifferenceLevelLabel"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 3;
            gridBagConstraints12.gridy = 3;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridwidth = 3;
            gridBagConstraints10.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridwidth = 3;
            gridBagConstraints9.gridy = 0;
            this.jPanelOutsideTopGroup = new JPanel();
            this.jPanelOutsideTopGroup.setLayout(new GridBagLayout());
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupAvoidSameCountry(), gridBagConstraints9);
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupAvoidSameClub(), gridBagConstraints10);
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupAvoidStrengthDifference(), gridBagConstraints11);
            this.jPanelOutsideTopGroup.add((Component)this.getJTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel(), gridBagConstraints12);
            this.jPanelOutsideTopGroup.add((Component)this.jLabelOutsideTopGroupAvoidStrengthDifferenceLevel, gridBagConstraints13);
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupColorBalance(), gridBagConstraints14);
            this.jPanelOutsideTopGroup.add((Component)this.getJPanelOutsideTopGroupDummy(), gridBagConstraints15);
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupWeakOddMan(), gridBagConstraints16);
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupSeeding(), gridBagConstraints17);
            this.jPanelOutsideTopGroup.add((Component)this.getJCheckBoxOutsideTopGroupAvoidSameNationality(), gridBagConstraints23);
        }
        return this.jPanelOutsideTopGroup;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupAvoidSameCountry() {
        if (this.jCheckBoxOutsideTopGroupAvoidSameCountry == null) {
            this.jCheckBoxOutsideTopGroupAvoidSameCountry = new JCheckBox();
            this.jCheckBoxOutsideTopGroupAvoidSameCountry.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupAvoidSameCountryCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupAvoidSameCountry;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupAvoidSameClub() {
        if (this.jCheckBoxOutsideTopGroupAvoidSameClub == null) {
            this.jCheckBoxOutsideTopGroupAvoidSameClub = new JCheckBox();
            this.jCheckBoxOutsideTopGroupAvoidSameClub.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupAvoidSameClubCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupAvoidSameClub;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupAvoidStrengthDifference() {
        if (this.jCheckBoxOutsideTopGroupAvoidStrengthDifference == null) {
            this.jCheckBoxOutsideTopGroupAvoidStrengthDifference = new JCheckBox();
            this.jCheckBoxOutsideTopGroupAvoidStrengthDifference.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupAvoidStrengthDifferenceCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupAvoidStrengthDifference;
    }

    private JTextField getJTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel() {
        if (this.jTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel == null) {
            this.jTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel = new JTextField();
            this.jTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel.setMinimumSize(new Dimension(50, 20));
            this.jTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel.setPreferredSize(new Dimension(50, 20));
        }
        return this.jTextFieldOutsideTopGroupAvoidStrengthDifferenceLevel;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupColorBalance() {
        if (this.jCheckBoxOutsideTopGroupColorBalance == null) {
            this.jCheckBoxOutsideTopGroupColorBalance = new JCheckBox();
            this.jCheckBoxOutsideTopGroupColorBalance.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupBWBalanceCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupColorBalance;
    }

    private JPanel getJPanelOutsideTopGroupDummy() {
        if (this.jPanelOutsideTopGroupDummy == null) {
            this.jPanelOutsideTopGroupDummy = new JPanel();
            this.jPanelOutsideTopGroupDummy.setLayout(new GridBagLayout());
        }
        return this.jPanelOutsideTopGroupDummy;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupWeakOddMan() {
        if (this.jCheckBoxOutsideTopGroupWeakOddMan == null) {
            this.jCheckBoxOutsideTopGroupWeakOddMan = new JCheckBox();
            this.jCheckBoxOutsideTopGroupWeakOddMan.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupWeakOddManCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupWeakOddMan;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupSeeding() {
        if (this.jCheckBoxOutsideTopGroupSeeding == null) {
            this.jCheckBoxOutsideTopGroupSeeding = new JCheckBox();
            this.jCheckBoxOutsideTopGroupSeeding.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupSeedingCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupSeeding;
    }

    private JCheckBox getJCheckBoxTopGroupSeedingByRating() {
        if (this.jCheckBoxTopGroupSeedingByRating == null) {
            this.jCheckBoxTopGroupSeedingByRating = new JCheckBox();
            this.jCheckBoxTopGroupSeedingByRating.setText(Messages.getString("EditMakePairingSettingsDialog.TopGroupSeedingByRatingCheckBox"));
        }
        return this.jCheckBoxTopGroupSeedingByRating;
    }

    private JTextField getJTextFieldTopGroupSeedingByRatingRound() {
        if (this.jTextFieldTopGroupSeedingByRatingRound == null) {
            this.jTextFieldTopGroupSeedingByRatingRound = new JTextField();
            this.jTextFieldTopGroupSeedingByRatingRound.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldTopGroupSeedingByRatingRound.setPreferredSize(new Dimension(80, 20));
        }
        return this.jTextFieldTopGroupSeedingByRatingRound;
    }

    private JCheckBox getJCheckBoxOutsideTopGroupAvoidSameNationality() {
        if (this.jCheckBoxOutsideTopGroupAvoidSameNationality == null) {
            this.jCheckBoxOutsideTopGroupAvoidSameNationality = new JCheckBox();
            this.jCheckBoxOutsideTopGroupAvoidSameNationality.setText(Messages.getString("EditMakePairingSettingsDialog.OutsideTopGroupAvoidSameNationalityCheckBox"));
        }
        return this.jCheckBoxOutsideTopGroupAvoidSameNationality;
    }

    private JCheckBox getJCheckBoxTopGroupUseSeeding() {
        if (this.jCheckBoxTopGroupUseSeeding == null) {
            this.jCheckBoxTopGroupUseSeeding = new JCheckBox();
            this.jCheckBoxTopGroupUseSeeding.setText(Messages.getString("EditMakePairingSettingsDialog.TopGroupSeedingCheckBox"));
            this.jCheckBoxTopGroupUseSeeding.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditMakePairingSettingsDialog.this.setSeedingEnabled(EditMakePairingSettingsDialog.this.jCheckBoxTopGroupUseSeeding.isSelected());
                }
            });
        }
        return this.jCheckBoxTopGroupUseSeeding;
    }

    private JPanel getJPanelSeedingByRating() {
        if (this.jPanelSeedingByRating == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.gridy = 0;
            gridBagConstraints19.gridx = 0;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.gridy = 0;
            gridBagConstraints19.gridx = 1;
            this.jPanelSeedingByRating = new JPanel();
            this.jPanelSeedingByRating.setLayout(new GridBagLayout());
            this.jPanelSeedingByRating.add((Component)this.getJCheckBoxTopGroupSeedingByRating(), gridBagConstraints19);
            this.jPanelSeedingByRating.add((Component)this.getJTextFieldTopGroupSeedingByRatingRound(), gridBagConstraints21);
        }
        return this.jPanelSeedingByRating;
    }

    private JPanel getJPanelSeedingPlacementCriterion() {
        if (this.jPanelSeedingPlacementCriterion == null) {
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.anchor = 17;
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints26.gridx = 1;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.gridy = 0;
            this.jLabelSeedingPlacementCriterion = new JLabel();
            this.jLabelSeedingPlacementCriterion.setText(Messages.getString("EditMakePairingSettingsDialog.SeedingPlacementCriterionLabel"));
            this.jPanelSeedingPlacementCriterion = new JPanel();
            this.jPanelSeedingPlacementCriterion.setLayout(new GridBagLayout());
            this.jPanelSeedingPlacementCriterion.add((Component)this.jLabelSeedingPlacementCriterion, gridBagConstraints25);
            this.jPanelSeedingPlacementCriterion.add(this.getJComboBoxSeedingPlacementCriterion(), gridBagConstraints26);
        }
        return this.jPanelSeedingPlacementCriterion;
    }

    private JComboBox<Walllist.SortCriterionDescriptor> getJComboBoxSeedingPlacementCriterion() {
        if (this.jComboBoxSeedingPlacementCriterion == null) {
            this.jComboBoxSeedingPlacementCriterion = new JComboBox();
            this.jComboBoxSeedingPlacementCriterion.setMinimumSize(new Dimension(120, 25));
            this.jComboBoxSeedingPlacementCriterion.setPreferredSize(new Dimension(120, 25));
        }
        return this.jComboBoxSeedingPlacementCriterion;
    }
}

