/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.gui.DisplayMacMahonExceptionDialog;
import de.cgerlach.macmahon.gui.EditClubDialog;
import de.cgerlach.macmahon.gui.MacMahonApplication;
import de.cgerlach.macmahon.gui.SelectEgdPlayerRecordDialog;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.EgdService;
import de.cgerlach.macmahon.model.GoLevel;
import de.cgerlach.macmahon.model.IndividualParticipant;
import de.cgerlach.macmahon.model.Pairing;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditIndividualParticipantDialog {
    private static boolean s_openNewDialogOnOk = false;
    private MacMahonApplication m_application;
    private Tournament m_tournament;
    private IndividualParticipant m_individualParticipant;
    private Country m_country;
    private boolean m_isNewPlayer = false;
    private boolean m_ok = false;
    private boolean m_preliminaryRegistrationOldState;
    private List<JCheckBox> m_playingInRoundsCheckboxes = new ArrayList<JCheckBox>();
    private String m_rating;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JButton jButtonOk = null;
    private JLabel jLabelSurname = null;
    private JLabel jLabelFirstName = null;
    private JTextField jTextFieldFirstName = null;
    private JTextField jTextFieldSurname = null;
    private JLabel jLabelGoRank = null;
    private JTextField jTextFieldGoLevel = null;
    private JCheckBox jCheckBoxAsianName = null;
    private JLabel jLabelPlayingInRounds = null;
    private JPanel jPanelPlayingInRounds = null;
    private JPanel jPanelRank = null;
    private JCheckBox jCheckBoxScoreAdjustment = null;
    private JTextField jTextFieldScoreAdjustmentValue = null;
    private JCheckBox jCheckBoxJoker = null;
    private JLabel jLabelRegistration = null;
    private JPanel jPanelRegistration = null;
    private JRadioButton jRadioButtonRegistrationPreliminary = null;
    private JRadioButton jRadioButtonRegistrationFinal = null;
    private JLabel jLabelEgdPin = null;
    private JTextField jTextFieldEgdPin = null;
    private JLabel jLabelClub = null;
    private JComboBox<Club> jComboBoxClubs = null;
    private JLabel jLabelCountry = null;
    private JComboBox<Country> jComboBoxCountries = null;
    private JLabel jLabelComment = null;
    private JTextArea jTextAreaComment = null;
    private JScrollPane jScrollPaneComment = null;
    private JButton jButtonDeleteParticipant = null;
    private JCheckBox jCheckBoxOpenNewDialogOnOk = null;
    private JCheckBox jCheckBoxSuperBarMember = null;
    private JButton jButtonAddClub = null;
    private JLabel jLabelRating = null;
    private JTextField jTextFieldRating = null;
    private JPanel jPanelEGD = null;
    private JButton jButtonSearchEgdByPin = null;
    private JButton jButtonSearchEgdByName = null;
    private JLabel jLabelEGDPinMessage = null;
    private JPanel jPanelName = null;
    private JLabel jLabelSearchEgdByNameMessage = null;
    private JLabel jLabelNationality = null;
    private JComboBox<Country> jComboBoxNationality = null;
    private JPanel mainPanel;

    public EditIndividualParticipantDialog(MacMahonApplication application, Tournament tournament, IndividualParticipant individualParticipant, boolean isNewPlayer) {
        this.m_application = application;
        this.m_tournament = tournament;
        this.m_individualParticipant = individualParticipant;
        this.m_isNewPlayer = isNewPlayer;
    }

    public void show(Component parent) {
        this.getJDialog();
        this.jLabelEGDPinMessage.setText(null);
        this.jLabelEGDPinMessage.setForeground(Color.RED);
        this.jLabelEGDPinMessage.setVisible(this.m_tournament.getOnlineEgdSupport() && this.m_tournament.getOnlineEgdSupportByPin());
        this.getJButtonSearchEgdByPin().setVisible(this.m_tournament.getOnlineEgdSupport() && this.m_tournament.getOnlineEgdSupportByPin());
        this.getJTextFieldEgdPin().setEditable(this.m_tournament.getOnlineEgdSupport() && this.m_tournament.getOnlineEgdSupportByPin());
        this.getJTextFieldEgdPin().setText(this.m_individualParticipant.getGoPlayer().getEgdPinDisplayString());
        this.jLabelSearchEgdByNameMessage.setText(null);
        this.jLabelSearchEgdByNameMessage.setForeground(Color.RED);
        this.getJButtonSearchEgdByName().setVisible(this.m_tournament.getOnlineEgdSupport());
        if (this.m_tournament.getOnlineEgdSupport()) {
            ActionListener searchEgdListener = new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    if (EditIndividualParticipantDialog.this.getJTextFieldEgdPin().hasFocus() && EditIndividualParticipantDialog.this.m_tournament.getOnlineEgdSupportByPin()) {
                        EditIndividualParticipantDialog.this.searchEgdByPin();
                    } else {
                        EditIndividualParticipantDialog.this.searchEgdByName();
                    }
                }
            };
            KeyStroke searchEgdKeyStroke = KeyStroke.getKeyStroke(70, 128, false);
            this.getJDialog().getRootPane().registerKeyboardAction(searchEgdListener, searchEgdKeyStroke, 1);
        }
        if (this.m_individualParticipant.getGoPlayer().getFirstName() != null) {
            this.getJTextFieldFirstName().setText(this.m_individualParticipant.getGoPlayer().getFirstName());
        }
        if (this.m_individualParticipant.getGoPlayer().getSurname() != null) {
            this.getJTextFieldSurname().setText(this.m_individualParticipant.getGoPlayer().getSurname());
        }
        if (this.m_tournament.getRatingAllowed()) {
            this.getJTextFieldRating().setText(Integer.toString(this.m_individualParticipant.getGoPlayer().getRating()));
        } else {
            this.jLabelRating.setVisible(false);
            this.getJTextFieldRating().setVisible(false);
        }
        this.getJCheckBoxAsianName().setSelected(this.m_individualParticipant.getGoPlayer().isAsianName());
        this.m_rating = Integer.toString(this.m_individualParticipant.getGoPlayer().getRating());
        this.getJTextFieldRating().setText(this.m_rating);
        if (this.m_individualParticipant.getGoLevel() != null) {
            this.getJTextFieldGoLevel().setText(this.m_individualParticipant.getGoLevel().getDisplayString());
        }
        this.getJCheckBoxScoreAdjustment().setSelected(this.m_individualParticipant.getScoreAdjustment());
        this.getJTextFieldScoreAdjustmentValue().setEnabled(this.m_individualParticipant.getScoreAdjustment());
        this.getJTextFieldScoreAdjustmentValue().setText(Double.toString((double)(this.m_individualParticipant.getScoreAdjustmentValue() >> 1) / 2.0));
        this.getJComboBoxClubs().setEnabled(false);
        this.getJButtonAddClub().setEnabled(false);
        DefaultComboBoxModel<Country> nationalityModel = new DefaultComboBoxModel<Country>(this.m_tournament.getCountries().toArray(new Country[0]));
        nationalityModel.insertElementAt(null, 0);
        this.getJComboBoxNationality().setModel(nationalityModel);
        this.getJComboBoxNationality().setSelectedItem(this.m_individualParticipant.getGoPlayer().getNationality());
        DefaultComboBoxModel<Country> countriesModel = new DefaultComboBoxModel<Country>(this.m_tournament.getCountries().toArray(new Country[0]));
        countriesModel.insertElementAt(null, 0);
        this.getJComboBoxCountries().setModel(countriesModel);
        this.getJComboBoxCountries().setSelectedItem(this.m_individualParticipant.getGoPlayer().getCountry());
        this.setComboBoxClubsByCountry(this.m_individualParticipant.getGoPlayer().getCountry());
        this.getJTextAreaComment().setText(this.m_individualParticipant.getComment());
        ButtonGroup bgRegistration = new ButtonGroup();
        bgRegistration.add(this.getJRadioButtonRegistrationPreliminary());
        bgRegistration.add(this.getJRadioButtonRegistrationFinal());
        this.m_preliminaryRegistrationOldState = this.m_individualParticipant.getPreliminaryRegistration();
        if (this.m_preliminaryRegistrationOldState) {
            this.getJRadioButtonRegistrationPreliminary().setSelected(true);
        } else {
            this.getJRadioButtonRegistrationFinal().setSelected(true);
        }
        this.setPlayingInRoundsEnabled(!this.m_preliminaryRegistrationOldState);
        if (!this.m_individualParticipant.getPreliminaryRegistrationMayBeChanged()) {
            this.getJRadioButtonRegistrationPreliminary().setEnabled(false);
            this.getJRadioButtonRegistrationFinal().setEnabled(false);
        }
        this.getJCheckBoxSuperBarMember().setEnabled(this.m_individualParticipant.isUpperBarMember());
        this.getJCheckBoxSuperBarMember().setSelected(this.m_individualParticipant.isSuperBarMember());
        this.getJCheckBoxJoker().setSelected(this.m_individualParticipant.getJoker());
        this.jDialog.setSize(new Dimension(this.jDialog.getSize().width, this.jDialog.getSize().height + Math.round(this.m_individualParticipant.getNumberOfRounds() / 5) * 25));
        this.getJButtonDeleteParticipant().setVisible(!this.m_isNewPlayer);
        this.getJCheckBoxOpenNewDialogOnOk().setSelected(s_openNewDialogOnOk);
        this.getJCheckBoxOpenNewDialogOnOk().setVisible(this.m_isNewPlayer);
        ActionListener escapeKeyListener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditIndividualParticipantDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(escapeKeyListener, escapeKeyStroke, 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditIndividualParticipantDialog.this.getJScrollPaneComment().getVerticalScrollBar().setValue(0);
                if (EditIndividualParticipantDialog.this.m_tournament.getOnlineEgdSupport() && EditIndividualParticipantDialog.this.m_tournament.getOnlineEgdSupportByPin() && EditIndividualParticipantDialog.this.m_isNewPlayer) {
                    EditIndividualParticipantDialog.this.getJTextFieldEgdPin().requestFocusInWindow();
                } else {
                    EditIndividualParticipantDialog.this.getJTextFieldSurname().requestFocusInWindow();
                }
                EditIndividualParticipantDialog.this.getJComboBoxClubs().setMinimumSize(EditIndividualParticipantDialog.this.getJComboBoxCountries().getSize());
            }
        });
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    public void setComboBoxClubsByCountry(Country country) {
        if (this.m_country != country) {
            this.m_country = country;
            if (this.m_country == null) {
                DefaultComboBoxModel<Object> clubsModel = new DefaultComboBoxModel<Object>();
                clubsModel.insertElementAt(null, 0);
                this.getJComboBoxClubs().setModel(clubsModel);
                this.getJComboBoxClubs().setSelectedItem(null);
                this.getJComboBoxClubs().setEnabled(false);
                this.getJButtonAddClub().setEnabled(false);
            } else {
                DefaultComboBoxModel<Club> clubsModel = new DefaultComboBoxModel<Club>(this.m_country.getClubs().toArray(new Club[0]));
                clubsModel.insertElementAt(null, 0);
                this.getJComboBoxClubs().setModel(clubsModel);
                if (this.m_individualParticipant.getGoPlayer().getCountry() == this.m_country) {
                    this.getJComboBoxClubs().setSelectedItem(this.m_individualParticipant.getGoPlayer().getClub());
                } else {
                    this.getJComboBoxClubs().setSelectedItem(null);
                }
                this.getJComboBoxClubs().setEnabled(true);
                this.getJButtonAddClub().setEnabled(true);
            }
        }
    }

    private void setPlayingInRoundsEnabled(boolean enabled) {
        Iterator<JCheckBox> iterator = this.m_playingInRoundsCheckboxes.iterator();
        int i = 0;
        boolean deletable = true;
        while (iterator.hasNext()) {
            JCheckBox cb = iterator.next();
            cb.setEnabled(enabled && (this.m_individualParticipant.getPairingInRound(i + 1) == null || this.m_individualParticipant.getPairingInRound(i + 1) == Pairing.NOT_PLAYING));
            if (this.m_individualParticipant.getPairingInRound(i + 1) != null && this.m_individualParticipant.getPairingInRound(i + 1) != Pairing.NOT_PLAYING) {
                deletable = false;
            }
            if (!enabled) {
                cb.setSelected(false);
            } else if (this.m_preliminaryRegistrationOldState) {
                cb.setSelected(i + 1 >= this.m_tournament.getCurrentRoundNumber());
            }
            ++i;
        }
        this.m_preliminaryRegistrationOldState = !enabled;
        this.getJButtonDeleteParticipant().setEnabled(deletable);
    }

    public boolean getOpenNewDialogOnOk() {
        return s_openNewDialogOnOk;
    }

    private void confirmApplyEgdPlayerRecord(EgdService.EgdPlayerRecord playerRecord) {
        Object message = Messages.getString("EditIndividualParticipantDialog.ConfirmEGDPlayerFromEGDLabel");
        message = (String)message + "\n\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDPinLabel") + "=" + playerRecord.m_pinPlayer + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDSurnameLabel") + "=" + playerRecord.m_lastName + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDFirstNameLabel") + "=" + playerRecord.m_name + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDRatingLabel") + "=" + playerRecord.m_gor + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDRankLabel") + "=" + playerRecord.m_grade + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDCountryLabel") + "=" + playerRecord.m_countryCode + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDClubLabel") + "=" + playerRecord.m_club + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDLastAppearanceLabel") + "=" + playerRecord.m_lastAppearence + "\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDTotalTournamentsLabel") + "=" + playerRecord.m_totalTournaments + "\n\n";
        message = (String)message + Messages.getString("EditIndividualParticipantDialog.ConfirmEGDAppyDataLabel");
        int result = JOptionPane.showConfirmDialog(this.getJDialog(), message, Messages.getString("EditIndividualParticipantDialog.ConfirmEGDTitle"), 0);
        if (result == 0) {
            this.applyEgdPlayerRecord(playerRecord);
        }
    }

    private void applyEgdPlayerRecord(EgdService.EgdPlayerRecord playerRecord) {
        this.getJTextFieldEgdPin().setText(playerRecord.m_pinPlayer);
        this.getJTextFieldSurname().setText(playerRecord.m_lastName);
        this.getJTextFieldFirstName().setText(playerRecord.m_name);
        this.getJTextFieldGoLevel().setText(playerRecord.m_grade);
        this.getJTextFieldRating().setText(Integer.toString(Math.max(0, Integer.parseInt(playerRecord.m_gor) + (this.m_tournament.getRatingLowestOneDanRating() - 2050))));
        this.textFieldRatingLostFocus();
        Country country = this.m_tournament.findCountry(playerRecord.m_countryCode);
        this.getJComboBoxCountries().setSelectedItem(country);
        if (country != null) {
            int result;
            Club club = country.findClubByEgdName(playerRecord.m_club);
            if (club == null && !playerRecord.m_club.toLowerCase().matches("x+") && (result = JOptionPane.showConfirmDialog(this.getJDialog(), Messages.getString("EditIndividualParticipantDialog.MessageEGDClubNotRecognized", playerRecord.m_club, country.getInternetCode()), Messages.getString("EditIndividualParticipantDialog.ConfirmAddClubTitle"), 0)) == 0) {
                club = new Club(country, playerRecord.m_club, playerRecord.m_club);
                country.addClub(club);
                DefaultComboBoxModel<Club> clubsModel = new DefaultComboBoxModel<Club>(this.m_country.getClubs().toArray(new Club[0]));
                clubsModel.insertElementAt(null, 0);
                this.getJComboBoxClubs().setModel(clubsModel);
            }
            this.getJComboBoxClubs().setSelectedItem(club);
        }
    }

    private void searchEgdByPin() {
        this.jLabelEGDPinMessage.setText(null);
        this.jLabelSearchEgdByNameMessage.setText(null);
        if (this.getJTextFieldEgdPin().getText() != null && this.getJTextFieldEgdPin().getText().length() > 0) {
            int egdPin = 0;
            try {
                egdPin = Integer.parseInt(this.getJTextFieldEgdPin().getText());
                try {
                    this.getJDialog().setCursor(Cursor.getPredefinedCursor(3));
                    EgdService.EgdPlayerRecord playerRecord = EgdService.instance().getPlayerByPin(egdPin);
                    this.getJDialog().setCursor(null);
                    if (playerRecord == null) {
                        this.jLabelEGDPinMessage.setText(Messages.getString("EditIndividualParticipantDialog.MessageEGDNoPlayerByPin"));
                    } else {
                        this.confirmApplyEgdPlayerRecord(playerRecord);
                    }
                }
                catch (MacMahonException exception) {
                    this.getJDialog().setCursor(null);
                    new DisplayMacMahonExceptionDialog(exception).show(this.getJDialog());
                }
            }
            catch (NumberFormatException exception) {
                this.jLabelEGDPinMessage.setText(Messages.getString("EditIndividualParticipantDialog.MessageEGDPinFormat"));
            }
        } else {
            this.jLabelEGDPinMessage.setText(Messages.getString("EditIndividualParticipantDialog.MessageEGDPinMissing"));
        }
    }

    private void searchEgdByName() {
        this.jLabelEGDPinMessage.setText(null);
        this.jLabelSearchEgdByNameMessage.setText(null);
        if (this.getJTextFieldSurname().getText() != null && this.getJTextFieldSurname().getText().length() > 0) {
            try {
                String surname = this.getJTextFieldSurname().getText();
                String firstname = this.getJTextFieldFirstName().getText();
                Country country = (Country)this.getJComboBoxCountries().getSelectedItem();
                Club club = (Club)this.getJComboBoxClubs().getSelectedItem();
                this.getJDialog().setCursor(Cursor.getPredefinedCursor(3));
                List<EgdService.EgdPlayerRecord> playerRecords = EgdService.instance().getPlayerByData(surname, firstname != null && firstname.length() > 0 ? firstname : null, country == null ? null : country.getInternetCode(), club == null ? null : club.getEgdName());
                this.getJDialog().setCursor(null);
                if (playerRecords.isEmpty()) {
                    this.jLabelSearchEgdByNameMessage.setText(Messages.getString("EditIndividualParticipantDialog.MessageEGDNoPlayerFound"));
                } else if (playerRecords.size() == 1) {
                    this.confirmApplyEgdPlayerRecord(playerRecords.get(0));
                } else {
                    SelectEgdPlayerRecordDialog dialog = new SelectEgdPlayerRecordDialog(playerRecords);
                    dialog.show(this.getJDialog());
                    if (dialog.getSelectedEgdPlayerRecord() != null) {
                        this.applyEgdPlayerRecord(dialog.getSelectedEgdPlayerRecord());
                    }
                }
            }
            catch (MacMahonException exception) {
                this.getJDialog().setCursor(null);
                new DisplayMacMahonExceptionDialog(exception).show(this.getJDialog());
            }
        } else {
            this.jLabelSearchEgdByNameMessage.setText(Messages.getString("EditIndividualParticipantDialog.MessageEGDSurnameMandatory"));
        }
    }

    private void textFieldRatingLostFocus() {
        if (this.m_tournament.getRatingAllowed() && this.m_tournament.getRatingDeterminesRank() && !this.m_rating.equals(this.jTextFieldRating.getText())) {
            this.m_rating = this.jTextFieldRating.getText();
            int rating = 0;
            try {
                rating = Integer.parseInt(this.m_rating);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            GoLevel goLevel = new GoLevel(rating, this.m_tournament.getRatingLowestOneDanRating());
            this.getJTextFieldGoLevel().setText(goLevel.getDisplayString());
            if (rating < GoLevel.getLowestRating(this.m_tournament.getRatingLowestOneDanRating())) {
                rating = GoLevel.getLowestRating(this.m_tournament.getRatingLowestOneDanRating());
                this.jTextFieldRating.setText(Integer.toString(rating));
            }
        }
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setTitle(Messages.getString("EditIndividualParticipantDialog.Title"));
            this.jDialog.setModal(true);
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setSize(new Dimension(718, 537));
            this.jDialog.setContentPane(this.getJContentPane());
            this.jDialog.setResizable(true);
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagLayout gbl_jContentPane = new GridBagLayout();
            gbl_jContentPane.rowWeights = new double[]{1.0};
            gbl_jContentPane.columnWeights = new double[]{1.0};
            this.jContentPane.setLayout(gbl_jContentPane);
            GridBagConstraints gbc_mainPanel = new GridBagConstraints();
            gbc_mainPanel.insets = new Insets(10, 10, 10, 10);
            gbc_mainPanel.fill = 1;
            gbc_mainPanel.gridx = 0;
            gbc_mainPanel.gridy = 0;
            this.jContentPane.add((Component)this.getMainPanel(), gbc_mainPanel);
        }
        return this.jContentPane;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("EditIndividualParticipantDialog.OK"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean ok = true;
                    if (EditIndividualParticipantDialog.this.jTextFieldRating.hasFocus()) {
                        EditIndividualParticipantDialog.this.textFieldRatingLostFocus();
                    }
                    int egdPin = 0;
                    try {
                        egdPin = Integer.parseInt(EditIndividualParticipantDialog.this.getJTextFieldEgdPin().getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setEgdPin(egdPin);
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setSurname(EditIndividualParticipantDialog.this.getJTextFieldSurname().getText());
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setFirstName(EditIndividualParticipantDialog.this.getJTextFieldFirstName().getText());
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setAsianName(EditIndividualParticipantDialog.this.getJCheckBoxAsianName().isSelected());
                    int rating = 0;
                    try {
                        rating = Integer.parseInt(EditIndividualParticipantDialog.this.getJTextFieldRating().getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setRating(rating);
                    try {
                        EditIndividualParticipantDialog.this.m_individualParticipant.setGoLevel(new GoLevel(EditIndividualParticipantDialog.this.getJTextFieldGoLevel().getText()));
                    }
                    catch (MacMahonException exception) {
                        new DisplayMacMahonExceptionDialog(exception).show(EditIndividualParticipantDialog.this.getJDialog());
                        ok = false;
                    }
                    EditIndividualParticipantDialog.this.m_individualParticipant.setScoreAdjustment(EditIndividualParticipantDialog.this.getJCheckBoxScoreAdjustment().isSelected());
                    if (EditIndividualParticipantDialog.this.getJCheckBoxScoreAdjustment().isSelected()) {
                        double scoreAdjustmentValue = 0.0;
                        try {
                            scoreAdjustmentValue = Double.parseDouble(EditIndividualParticipantDialog.this.getJTextFieldScoreAdjustmentValue().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        EditIndividualParticipantDialog.this.m_individualParticipant.setScoreAdjustmentValue((int)Math.round(scoreAdjustmentValue * 2.0) << 1);
                    }
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setNationality((Country)EditIndividualParticipantDialog.this.getJComboBoxNationality().getSelectedItem());
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setCountry((Country)EditIndividualParticipantDialog.this.getJComboBoxCountries().getSelectedItem());
                    EditIndividualParticipantDialog.this.m_individualParticipant.getGoPlayer().setClub((Club)EditIndividualParticipantDialog.this.getJComboBoxClubs().getSelectedItem());
                    EditIndividualParticipantDialog.this.m_individualParticipant.setComment(EditIndividualParticipantDialog.this.getJTextAreaComment().getText());
                    EditIndividualParticipantDialog.this.m_individualParticipant.setPreliminaryRegistration(EditIndividualParticipantDialog.this.getJRadioButtonRegistrationPreliminary().isSelected());
                    Iterator<JCheckBox> iterator = EditIndividualParticipantDialog.this.m_playingInRoundsCheckboxes.iterator();
                    int i = 1;
                    while (iterator.hasNext()) {
                        if (iterator.next().isSelected()) {
                            if (EditIndividualParticipantDialog.this.m_individualParticipant.getPairingInRound(i) == Pairing.NOT_PLAYING) {
                                EditIndividualParticipantDialog.this.m_individualParticipant.setPairingInRound(null, i);
                            }
                        } else if (EditIndividualParticipantDialog.this.m_individualParticipant.getPairingInRound(i) == null) {
                            EditIndividualParticipantDialog.this.m_individualParticipant.setPairingInRound(Pairing.NOT_PLAYING, i);
                        }
                        ++i;
                    }
                    EditIndividualParticipantDialog.this.m_individualParticipant.setSuperBarMember(EditIndividualParticipantDialog.this.getJCheckBoxSuperBarMember().isSelected());
                    EditIndividualParticipantDialog.this.m_individualParticipant.setJoker(EditIndividualParticipantDialog.this.getJCheckBoxJoker().isSelected());
                    EditIndividualParticipantDialog.this.m_tournament.getCurrentRound().doSort();
                    if (ok) {
                        EditIndividualParticipantDialog.this.m_ok = true;
                        s_openNewDialogOnOk = EditIndividualParticipantDialog.this.getJCheckBoxOpenNewDialogOnOk().isSelected();
                        EditIndividualParticipantDialog.this.getJDialog().dispose();
                    }
                }
            });
        }
        return this.jButtonOk;
    }

    private JTextField getJTextFieldFirstName() {
        if (this.jTextFieldFirstName == null) {
            this.jTextFieldFirstName = new JTextField();
        }
        return this.jTextFieldFirstName;
    }

    private JTextField getJTextFieldSurname() {
        if (this.jTextFieldSurname == null) {
            this.jTextFieldSurname = new JTextField();
        }
        return this.jTextFieldSurname;
    }

    private JTextField getJTextFieldGoLevel() {
        if (this.jTextFieldGoLevel == null) {
            this.jTextFieldGoLevel = new JTextField();
            this.jTextFieldGoLevel.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldGoLevel.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldGoLevel;
    }

    public boolean isOk() {
        return this.m_ok;
    }

    private JCheckBox getJCheckBoxAsianName() {
        if (this.jCheckBoxAsianName == null) {
            this.jCheckBoxAsianName = new JCheckBox();
            this.jCheckBoxAsianName.setText(Messages.getString("EditIndividualParticipantDialog.AsianNameCheckBox"));
        }
        return this.jCheckBoxAsianName;
    }

    private JPanel getJPanelPlayingInRounds() {
        if (this.jPanelPlayingInRounds == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 0;
            this.jPanelPlayingInRounds = new JPanel();
            this.jPanelPlayingInRounds.setLayout(new GridBagLayout());
            int i = 0;
            while (i < this.m_individualParticipant.getNumberOfRounds()) {
                JCheckBox roundCheckBox = new JCheckBox();
                roundCheckBox.setText(Tournament.ROUND + " " + (i + 1));
                GridBagConstraints gbConstraints = new GridBagConstraints();
                gbConstraints.gridx = i - Math.round(i / 5) * 5;
                gbConstraints.gridy = Math.round(i / 5);
                gbConstraints.anchor = 18;
                roundCheckBox.setSelected(this.m_individualParticipant.getPairingInRound(i + 1) != Pairing.NOT_PLAYING);
                this.m_playingInRoundsCheckboxes.add(roundCheckBox);
                this.jPanelPlayingInRounds.add((Component)roundCheckBox, gbConstraints);
                ++i;
            }
        }
        return this.jPanelPlayingInRounds;
    }

    private JPanel getJPanelRank() {
        if (this.jPanelRank == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints9.gridwidth = 1;
            gridBagConstraints9.ipadx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.ipadx = 0;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.fill = 0;
            this.jPanelRank = new JPanel();
            this.jPanelRank.setLayout(new GridBagLayout());
            this.jPanelRank.add((Component)this.getJTextFieldGoLevel(), gridBagConstraints6);
            this.jPanelRank.add((Component)this.getJCheckBoxScoreAdjustment(), gridBagConstraints8);
            this.jPanelRank.add((Component)this.getJTextFieldScoreAdjustmentValue(), gridBagConstraints9);
        }
        return this.jPanelRank;
    }

    private JCheckBox getJCheckBoxScoreAdjustment() {
        if (this.jCheckBoxScoreAdjustment == null) {
            this.jCheckBoxScoreAdjustment = new JCheckBox();
            this.jCheckBoxScoreAdjustment.setText(Messages.getString("EditIndividualParticipantDialog.AdjustLevelCheckBox"));
            this.jCheckBoxScoreAdjustment.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditIndividualParticipantDialog.this.getJTextFieldScoreAdjustmentValue().setEnabled(EditIndividualParticipantDialog.this.jCheckBoxScoreAdjustment.isSelected());
                }
            });
        }
        return this.jCheckBoxScoreAdjustment;
    }

    private JTextField getJTextFieldScoreAdjustmentValue() {
        if (this.jTextFieldScoreAdjustmentValue == null) {
            this.jTextFieldScoreAdjustmentValue = new JTextField();
            this.jTextFieldScoreAdjustmentValue.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldScoreAdjustmentValue.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldScoreAdjustmentValue;
    }

    private JCheckBox getJCheckBoxJoker() {
        if (this.jCheckBoxJoker == null) {
            this.jCheckBoxJoker = new JCheckBox();
            this.jCheckBoxJoker.setText(Messages.getString("EditIndividualParticipantDialog.JokerCheckBox"));
        }
        return this.jCheckBoxJoker;
    }

    private JPanel getJPanelRegistration() {
        if (this.jPanelRegistration == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridy = 0;
            this.jPanelRegistration = new JPanel();
            this.jPanelRegistration.setLayout(new GridBagLayout());
            this.jPanelRegistration.add((Component)this.getJRadioButtonRegistrationPreliminary(), gridBagConstraints10);
            this.jPanelRegistration.add((Component)this.getJRadioButtonRegistrationFinal(), gridBagConstraints12);
        }
        return this.jPanelRegistration;
    }

    private JRadioButton getJRadioButtonRegistrationPreliminary() {
        if (this.jRadioButtonRegistrationPreliminary == null) {
            this.jRadioButtonRegistrationPreliminary = new JRadioButton();
            this.jRadioButtonRegistrationPreliminary.setText(Messages.getString("EditIndividualParticipantDialog.PreliminaryRadioButton"));
            this.jRadioButtonRegistrationPreliminary.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditIndividualParticipantDialog.this.setPlayingInRoundsEnabled(!EditIndividualParticipantDialog.this.jRadioButtonRegistrationPreliminary.isSelected());
                }
            });
        }
        return this.jRadioButtonRegistrationPreliminary;
    }

    private JRadioButton getJRadioButtonRegistrationFinal() {
        if (this.jRadioButtonRegistrationFinal == null) {
            this.jRadioButtonRegistrationFinal = new JRadioButton();
            this.jRadioButtonRegistrationFinal.setText(Messages.getString("EditIndividualParticipantDialog.FinalRadioButton"));
        }
        return this.jRadioButtonRegistrationFinal;
    }

    private JTextField getJTextFieldEgdPin() {
        if (this.jTextFieldEgdPin == null) {
            this.jTextFieldEgdPin = new JTextField();
            this.jTextFieldEgdPin.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldEgdPin.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldEgdPin.setEditable(false);
        }
        return this.jTextFieldEgdPin;
    }

    private JComboBox<Club> getJComboBoxClubs() {
        if (this.jComboBoxClubs == null) {
            this.jComboBoxClubs = new JComboBox();
            this.jComboBoxClubs.setPreferredSize(new Dimension(300, 25));
        }
        return this.jComboBoxClubs;
    }

    private JComboBox<Country> getJComboBoxCountries() {
        if (this.jComboBoxCountries == null) {
            this.jComboBoxCountries = new JComboBox();
            this.jComboBoxCountries.setPreferredSize(new Dimension(300, 25));
            this.jComboBoxCountries.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditIndividualParticipantDialog.this.setComboBoxClubsByCountry((Country)EditIndividualParticipantDialog.this.jComboBoxCountries.getSelectedItem());
                }
            });
        }
        return this.jComboBoxCountries;
    }

    private JTextArea getJTextAreaComment() {
        if (this.jTextAreaComment == null) {
            this.jTextAreaComment = new JTextArea();
            this.jTextAreaComment.setWrapStyleWord(true);
            this.jTextAreaComment.setLineWrap(true);
        }
        return this.jTextAreaComment;
    }

    private JScrollPane getJScrollPaneComment() {
        if (this.jScrollPaneComment == null) {
            this.jScrollPaneComment = new JScrollPane();
            this.jScrollPaneComment.setViewportView(this.getJTextAreaComment());
        }
        return this.jScrollPaneComment;
    }

    private JButton getJButtonDeleteParticipant() {
        if (this.jButtonDeleteParticipant == null) {
            this.jButtonDeleteParticipant = new JButton();
            this.jButtonDeleteParticipant.setText(Messages.getString("EditIndividualParticipantDialog.DeleteParticipantButton"));
            this.jButtonDeleteParticipant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditIndividualParticipantDialog.this.m_application.participantDelete(EditIndividualParticipantDialog.this.m_individualParticipant, EditIndividualParticipantDialog.this.getJDialog())) {
                        EditIndividualParticipantDialog.this.getJDialog().dispose();
                    }
                }
            });
        }
        return this.jButtonDeleteParticipant;
    }

    private JCheckBox getJCheckBoxOpenNewDialogOnOk() {
        if (this.jCheckBoxOpenNewDialogOnOk == null) {
            this.jCheckBoxOpenNewDialogOnOk = new JCheckBox();
            this.jCheckBoxOpenNewDialogOnOk.setText(Messages.getString("EditIndividualParticipantDialog.OpenAgainCheckBox"));
        }
        return this.jCheckBoxOpenNewDialogOnOk;
    }

    private JCheckBox getJCheckBoxSuperBarMember() {
        if (this.jCheckBoxSuperBarMember == null) {
            this.jCheckBoxSuperBarMember = new JCheckBox();
            this.jCheckBoxSuperBarMember.setText(Messages.getString("EditIndividualParticipantDialog.SuperBarMemberCheckBox"));
        }
        return this.jCheckBoxSuperBarMember;
    }

    private JButton getJButtonAddClub() {
        if (this.jButtonAddClub == null) {
            this.jButtonAddClub = new JButton();
            this.jButtonAddClub.setText(Messages.getString("EditIndividualParticipantDialog.AddClubButton"));
            this.jButtonAddClub.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Country country = (Country)EditIndividualParticipantDialog.this.getJComboBoxCountries().getSelectedItem();
                    Club newClub = new Club(country, null, null);
                    EditClubDialog dialog = new EditClubDialog(newClub);
                    dialog.show(EditIndividualParticipantDialog.this.getJDialog());
                    if (dialog.wasOk()) {
                        country.addClub(newClub);
                        DefaultComboBoxModel<Club> clubsModel = new DefaultComboBoxModel<Club>(EditIndividualParticipantDialog.this.m_country.getClubs().toArray(new Club[0]));
                        clubsModel.insertElementAt(null, 0);
                        EditIndividualParticipantDialog.this.getJComboBoxClubs().setModel(clubsModel);
                        EditIndividualParticipantDialog.this.getJComboBoxClubs().setSelectedItem(newClub);
                    }
                }
            });
        }
        return this.jButtonAddClub;
    }

    private JTextField getJTextFieldRating() {
        if (this.jTextFieldRating == null) {
            this.jTextFieldRating = new JTextField();
            this.jTextFieldRating.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldRating.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldRating.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    EditIndividualParticipantDialog.this.textFieldRatingLostFocus();
                }
            });
        }
        return this.jTextFieldRating;
    }

    private JPanel getJPanelEGD() {
        if (this.jPanelEGD == null) {
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 1;
            gridBagConstraints23.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints23.gridy = 0;
            this.jLabelEGDPinMessage = new JLabel();
            this.jLabelEGDPinMessage.setText("Message");
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.gridy = 0;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.fill = 0;
            this.jPanelEGD = new JPanel();
            this.jPanelEGD.setLayout(new GridBagLayout());
            this.jPanelEGD.add((Component)this.getJTextFieldEgdPin(), gridBagConstraints20);
            this.jPanelEGD.add((Component)this.jLabelEGDPinMessage, gridBagConstraints23);
        }
        return this.jPanelEGD;
    }

    private JButton getJButtonSearchEgdByPin() {
        if (this.jButtonSearchEgdByPin == null) {
            this.jButtonSearchEgdByPin = new JButton();
            this.jButtonSearchEgdByPin.setText(Messages.getString("EditIndividualParticipantDialog.EGDSearchPinButton"));
            this.jButtonSearchEgdByPin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditIndividualParticipantDialog.this.searchEgdByPin();
                }
            });
        }
        return this.jButtonSearchEgdByPin;
    }

    private JButton getJButtonSearchEgdByName() {
        if (this.jButtonSearchEgdByName == null) {
            this.jButtonSearchEgdByName = new JButton();
            this.jButtonSearchEgdByName.setText(Messages.getString("EditIndividualParticipantDialog.EGDSearchButton"));
            this.jButtonSearchEgdByName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditIndividualParticipantDialog.this.searchEgdByName();
                }
            });
        }
        return this.jButtonSearchEgdByName;
    }

    private JPanel getJPanelName() {
        if (this.jPanelName == null) {
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 1;
            gridBagConstraints30.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints30.gridy = 0;
            this.jLabelSearchEgdByNameMessage = new JLabel();
            this.jLabelSearchEgdByNameMessage.setText("Message");
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.anchor = 17;
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.gridy = 0;
            gridBagConstraints29.insets = new Insets(0, 0, 0, 0);
            this.jPanelName = new JPanel();
            this.jPanelName.setLayout(new GridBagLayout());
            this.jPanelName.add((Component)this.getJCheckBoxAsianName(), gridBagConstraints29);
            this.jPanelName.add((Component)this.jLabelSearchEgdByNameMessage, gridBagConstraints30);
        }
        return this.jPanelName;
    }

    private JComboBox<Country> getJComboBoxNationality() {
        if (this.jComboBoxNationality == null) {
            this.jComboBoxNationality = new JComboBox();
            this.jComboBoxNationality.setPreferredSize(new Dimension(300, 25));
        }
        return this.jComboBoxNationality;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            GridBagLayout gbl_mainPanel = new GridBagLayout();
            gbl_mainPanel.columnWidths = new int[1];
            gbl_mainPanel.rowHeights = new int[1];
            gbl_mainPanel.columnWeights = new double[]{Double.MIN_VALUE};
            gbl_mainPanel.rowWeights = new double[]{Double.MIN_VALUE};
            this.mainPanel.setLayout(gbl_mainPanel);
            GridBagConstraints gridBagConstraints210 = new GridBagConstraints();
            gridBagConstraints210.fill = 3;
            gridBagConstraints210.gridy = 8;
            gridBagConstraints210.weightx = 1.0;
            gridBagConstraints210.anchor = 17;
            gridBagConstraints210.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints210.gridx = 1;
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints111.gridx = 0;
            gridBagConstraints111.anchor = 13;
            gridBagConstraints111.gridy = 8;
            this.jLabelNationality = new JLabel();
            this.jLabelNationality.setText(Messages.getString("EditIndividualParticipantDialog.NationalityLabel"));
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridx = 1;
            gridBagConstraints110.fill = 0;
            gridBagConstraints110.anchor = 17;
            gridBagConstraints110.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints110.gridy = 3;
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
            gridBagConstraints43.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints43.gridx = 2;
            gridBagConstraints43.fill = 2;
            gridBagConstraints43.gridy = 3;
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints34.gridy = 0;
            gridBagConstraints34.fill = 2;
            gridBagConstraints34.gridx = 2;
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            gridBagConstraints28.fill = 0;
            gridBagConstraints28.gridwidth = 1;
            gridBagConstraints28.anchor = 17;
            gridBagConstraints28.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints28.gridy = 0;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridwidth = 2;
            gridBagConstraints27.fill = 3;
            gridBagConstraints27.gridy = 4;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.anchor = 17;
            gridBagConstraints27.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints27.gridx = 1;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.anchor = 13;
            gridBagConstraints19.gridy = 4;
            this.jLabelRating = new JLabel();
            this.jLabelRating.setText(Messages.getString("EditIndividualParticipantDialog.RatingLabel"));
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints26.gridx = 2;
            gridBagConstraints26.fill = 2;
            gridBagConstraints26.gridy = 7;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridwidth = 2;
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints21.gridy = 11;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.gridwidth = 3;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 15;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 2;
            gridBagConstraints17.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridy = 14;
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.fill = 1;
            gridBagConstraints33.gridy = 13;
            gridBagConstraints33.weightx = 1.0;
            gridBagConstraints33.weighty = 1.0;
            gridBagConstraints33.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints33.gridwidth = 2;
            gridBagConstraints33.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.anchor = 12;
            gridBagConstraints16.gridy = 13;
            this.jLabelComment = new JLabel();
            this.jLabelComment.setText(Messages.getString("EditIndividualParticipantDialog.CommentLabel"));
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 0;
            gridBagConstraints25.gridy = 6;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints25.gridwidth = 1;
            gridBagConstraints25.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.anchor = 13;
            gridBagConstraints15.gridy = 6;
            this.jLabelCountry = new JLabel();
            this.jLabelCountry.setText(Messages.getString("EditIndividualParticipantDialog.CountryLabel"));
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 0;
            gridBagConstraints24.gridy = 7;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints24.gridwidth = 1;
            gridBagConstraints24.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.gridy = 7;
            this.jLabelClub = new JLabel();
            this.jLabelClub.setText(Messages.getString("EditIndividualParticipantDialog.ClubLabel"));
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.anchor = 13;
            gridBagConstraints13.gridy = 0;
            this.jLabelEgdPin = new JLabel();
            this.jLabelEgdPin.setText(Messages.getString("EditIndividualParticipantDialog.EGDPinLabel"));
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridwidth = 2;
            gridBagConstraints32.gridx = 1;
            gridBagConstraints32.fill = 1;
            gridBagConstraints32.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints32.gridy = 9;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.anchor = 13;
            gridBagConstraints22.gridy = 9;
            this.jLabelRegistration = new JLabel();
            this.jLabelRegistration.setText(Messages.getString("EditIndividualParticipantDialog.RegistrationLabel"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 12;
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 1;
            gridBagConstraints42.weightx = 0.0;
            gridBagConstraints42.weighty = 0.0;
            gridBagConstraints42.fill = 1;
            gridBagConstraints42.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints42.gridwidth = 2;
            gridBagConstraints42.gridy = 5;
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.gridx = 1;
            gridBagConstraints61.anchor = 18;
            gridBagConstraints61.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints61.gridwidth = 2;
            gridBagConstraints61.fill = 3;
            gridBagConstraints61.gridy = 10;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.anchor = 12;
            gridBagConstraints41.insets = new Insets(4, 0, 5, 5);
            gridBagConstraints41.gridy = 10;
            this.jLabelPlayingInRounds = new JLabel();
            this.jLabelPlayingInRounds.setText(Messages.getString("EditIndividualParticipantDialog.PlayingInRoundsLabel"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridy = 5;
            this.jLabelGoRank = new JLabel();
            this.jLabelGoRank.setText(Messages.getString("EditIndividualParticipantDialog.RankLabel"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.ipadx = 0;
            gridBagConstraints4.ipady = 0;
            gridBagConstraints4.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 2;
            this.jLabelFirstName = new JLabel();
            this.jLabelFirstName.setText(Messages.getString("EditIndividualParticipantDialog.FirstNameLabel"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.gridy = 16;
            this.jLabelSurname = new JLabel();
            this.jLabelSurname.setText(Messages.getString("EditIndividualParticipantDialog.SurnameLabel"));
            this.mainPanel.add((Component)this.getJButtonOk(), gridBagConstraints1);
            this.mainPanel.add((Component)this.jLabelSurname, gridBagConstraints2);
            this.mainPanel.add((Component)this.jLabelFirstName, gridBagConstraints);
            this.mainPanel.add((Component)this.getJTextFieldFirstName(), gridBagConstraints3);
            this.mainPanel.add((Component)this.getJTextFieldSurname(), gridBagConstraints4);
            this.mainPanel.add((Component)this.jLabelGoRank, gridBagConstraints5);
            this.mainPanel.add((Component)this.jLabelPlayingInRounds, gridBagConstraints41);
            this.mainPanel.add((Component)this.getJPanelRank(), gridBagConstraints42);
            this.mainPanel.add((Component)this.getJPanelPlayingInRounds(), gridBagConstraints61);
            this.mainPanel.add((Component)this.getJCheckBoxJoker(), gridBagConstraints11);
            this.mainPanel.add((Component)this.jLabelRegistration, gridBagConstraints22);
            this.mainPanel.add((Component)this.getJPanelRegistration(), gridBagConstraints32);
            this.mainPanel.add((Component)this.jLabelEgdPin, gridBagConstraints13);
            this.mainPanel.add((Component)this.jLabelClub, gridBagConstraints14);
            this.mainPanel.add(this.getJComboBoxClubs(), gridBagConstraints24);
            this.mainPanel.add((Component)this.jLabelCountry, gridBagConstraints15);
            this.mainPanel.add(this.getJComboBoxCountries(), gridBagConstraints25);
            this.mainPanel.add((Component)this.jLabelComment, gridBagConstraints16);
            this.mainPanel.add((Component)this.getJScrollPaneComment(), gridBagConstraints33);
            this.mainPanel.add((Component)this.getJButtonDeleteParticipant(), gridBagConstraints17);
            this.mainPanel.add((Component)this.getJCheckBoxOpenNewDialogOnOk(), gridBagConstraints18);
            this.mainPanel.add((Component)this.getJCheckBoxSuperBarMember(), gridBagConstraints21);
            this.mainPanel.add((Component)this.getJButtonAddClub(), gridBagConstraints26);
            this.mainPanel.add((Component)this.jLabelRating, gridBagConstraints19);
            this.mainPanel.add((Component)this.getJTextFieldRating(), gridBagConstraints27);
            this.mainPanel.add((Component)this.getJPanelEGD(), gridBagConstraints28);
            this.mainPanel.add((Component)this.getJButtonSearchEgdByPin(), gridBagConstraints34);
            this.mainPanel.add((Component)this.getJButtonSearchEgdByName(), gridBagConstraints43);
            this.mainPanel.add((Component)this.getJPanelName(), gridBagConstraints110);
            this.mainPanel.add((Component)this.jLabelNationality, gridBagConstraints111);
            this.mainPanel.add(this.getJComboBoxNationality(), gridBagConstraints210);
        }
        return this.mainPanel;
    }
}

