/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.gui.EditClubDialog;
import de.cgerlach.macmahon.model.Club;
import de.cgerlach.macmahon.model.Country;
import de.cgerlach.macmahon.model.Tournament;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditClubsDialog {
    private Tournament m_tournament;
    private Country m_country;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JButton jButtonOk = null;
    private JLabel jLabelCountry = null;
    private JComboBox<Country> jComboBoxCountries = null;
    private JLabel jLabelClubs = null;
    private JPanel jPanelClubs = null;
    private JScrollPane jScrollPaneClubs = null;
    private JList<Club> jListClubs = null;
    private JButton jButtonAddClub = null;
    private JButton jButtonEditClub = null;
    private JButton jButtonRemoveClub = null;

    public EditClubsDialog(Tournament tournament) {
        this.m_tournament = tournament;
    }

    public void show(Component parent) {
        this.getJDialog();
        DefaultComboBoxModel<Country> countriesModel = new DefaultComboBoxModel<Country>(this.m_tournament.getCountries().toArray(new Country[0]));
        this.getJComboBoxCountries().setModel(countriesModel);
        if (this.m_tournament.getDefaultCountry() != null) {
            this.getJComboBoxCountries().setSelectedItem(this.m_tournament.getDefaultCountry());
        }
        this.setComboBoxClubsByCountry((Country)this.getJComboBoxCountries().getSelectedItem());
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditClubsDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    private void setComboBoxClubsByCountry(Country country) {
        if (this.m_country != country) {
            this.m_country = country;
            this.refreshClubs();
            if (this.m_country.getClubs().size() > 0) {
                this.getJListClubs().setSelectedValue(this.m_country.getClubs().get(0), true);
            }
            this.setButtonsEnabled();
        }
    }

    private void refreshClubs() {
        DefaultListModel<Club> clubsModel = new DefaultListModel<Club>();
        int i = 0;
        while (i < this.m_country.getClubs().size()) {
            clubsModel.addElement(this.m_country.getClubs().get(i));
            ++i;
        }
        this.getJListClubs().setModel(clubsModel);
    }

    private void setButtonsEnabled() {
        if (this.getJListClubs().getSelectedValue() == null) {
            this.getJButtonEditClub().setEnabled(false);
            this.getJButtonRemoveClub().setEnabled(false);
        } else {
            this.getJButtonEditClub().setEnabled(true);
            this.getJButtonRemoveClub().setEnabled(true);
        }
    }

    private void editClub(Club club) {
        EditClubDialog dialog = new EditClubDialog(club);
        dialog.show(this.getJDialog());
        if (dialog.wasOk()) {
            this.m_country.doSortClubs();
            this.refreshClubs();
            this.getJListClubs().setSelectedValue(club, true);
            this.m_tournament.clubNameChanged(club);
        }
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setSize(new Dimension(560, 361));
            this.jDialog.setTitle(Messages.getString("EditClubsDialog.Title"));
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setModal(true);
            this.jDialog.setContentPane(this.getJContentPane());
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weighty = 2.0;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 12;
            gridBagConstraints3.gridy = 1;
            this.jLabelClubs = new JLabel();
            this.jLabelClubs.setText(Messages.getString("EditClubsDialog.ClubsLabel"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.gridy = 0;
            this.jLabelCountry = new JLabel();
            this.jLabelCountry.setText(Messages.getString("EditClubsDialog.CountryLabel"));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = 3;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJButtonOk(), gridBagConstraints1);
            this.jContentPane.add((Component)this.jLabelCountry, gridBagConstraints11);
            this.jContentPane.add(this.getJComboBoxCountries(), gridBagConstraints2);
            this.jContentPane.add((Component)this.jLabelClubs, gridBagConstraints3);
            this.jContentPane.add((Component)this.getJPanelClubs(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("EditClubsDialog.OK"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditClubsDialog.this.getJDialog().dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JComboBox<Country> getJComboBoxCountries() {
        if (this.jComboBoxCountries == null) {
            this.jComboBoxCountries = new JComboBox();
            this.jComboBoxCountries.setPreferredSize(new Dimension(300, 25));
            this.jComboBoxCountries.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditClubsDialog.this.setComboBoxClubsByCountry((Country)EditClubsDialog.this.jComboBoxCountries.getSelectedItem());
                }
            });
        }
        return this.jComboBoxCountries;
    }

    private JPanel getJPanelClubs() {
        if (this.jPanelClubs == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.anchor = 11;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.anchor = 11;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.gridx = 0;
            this.jPanelClubs = new JPanel();
            this.jPanelClubs.setLayout(new GridBagLayout());
            this.jPanelClubs.add((Component)this.getJScrollPaneClubs(), gridBagConstraints);
            this.jPanelClubs.add((Component)this.getJButtonAddClub(), gridBagConstraints5);
            this.jPanelClubs.add((Component)this.getJButtonEditClub(), gridBagConstraints6);
            this.jPanelClubs.add((Component)this.getJButtonRemoveClub(), gridBagConstraints7);
        }
        return this.jPanelClubs;
    }

    private JScrollPane getJScrollPaneClubs() {
        if (this.jScrollPaneClubs == null) {
            this.jScrollPaneClubs = new JScrollPane();
            this.jScrollPaneClubs.setViewportView(this.getJListClubs());
        }
        return this.jScrollPaneClubs;
    }

    private JList<Club> getJListClubs() {
        if (this.jListClubs == null) {
            this.jListClubs = new JList();
            this.jListClubs.setSelectionMode(0);
            this.jListClubs.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditClubsDialog.this.setButtonsEnabled();
                }
            });
            this.jListClubs.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Club club;
                    if (e.getClickCount() == 2 && (club = EditClubsDialog.this.jListClubs.getSelectedValue()) != null) {
                        EditClubsDialog.this.editClub(club);
                    }
                }
            });
        }
        return this.jListClubs;
    }

    private JButton getJButtonAddClub() {
        if (this.jButtonAddClub == null) {
            this.jButtonAddClub = new JButton();
            this.jButtonAddClub.setText(Messages.getString("EditClubsDialog.AddClubButton"));
            this.jButtonAddClub.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Country country = (Country)EditClubsDialog.this.getJComboBoxCountries().getSelectedItem();
                    Club newClub = new Club(country, null, null);
                    EditClubDialog dialog = new EditClubDialog(newClub);
                    dialog.show(EditClubsDialog.this.getJDialog());
                    if (dialog.wasOk()) {
                        country.addClub(newClub);
                        EditClubsDialog.this.refreshClubs();
                        EditClubsDialog.this.getJListClubs().setSelectedValue(newClub, true);
                    }
                }
            });
        }
        return this.jButtonAddClub;
    }

    private JButton getJButtonEditClub() {
        if (this.jButtonEditClub == null) {
            this.jButtonEditClub = new JButton();
            this.jButtonEditClub.setText(Messages.getString("EditClubsDialog.EditClubButton"));
            this.jButtonEditClub.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Club club = EditClubsDialog.this.getJListClubs().getSelectedValue();
                    EditClubsDialog.this.editClub(club);
                }
            });
        }
        return this.jButtonEditClub;
    }

    private JButton getJButtonRemoveClub() {
        if (this.jButtonRemoveClub == null) {
            this.jButtonRemoveClub = new JButton();
            this.jButtonRemoveClub.setText(Messages.getString("EditClubsDialog.RemoveClubButton"));
            this.jButtonRemoveClub.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result;
                    Club club = EditClubsDialog.this.getJListClubs().getSelectedValue();
                    if (club != null && (result = JOptionPane.showConfirmDialog(null, Messages.getString("EditClubsDialog.ConfirmRemoveClub", club.getName(), club.getCountry().getInternetCode()), Messages.getString("EditClubsDialog.ConfirmRemoveClubTitle"), 0)) == 0) {
                        EditClubsDialog.this.m_tournament.removeClub(club);
                        ((DefaultListModel)EditClubsDialog.this.getJListClubs().getModel()).removeElement(club);
                        EditClubsDialog.this.setButtonsEnabled();
                    }
                }
            });
        }
        return this.jButtonRemoveClub;
    }
}

