/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.gui;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.resources.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DisplayMacMahonExceptionDialog {
    private MacMahonException m_exception;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private JLabel jLabelStacktrace = null;
    private JTextArea jTextAreaStacktrace = null;
    private JButton jButtonOk = null;
    private JScrollPane jScrollPaneStacktrace = null;
    private JLabel jLabelMessage = null;
    private JScrollPane jScrollPaneMessage = null;
    private JTextArea jTextAreaMessage = null;

    public DisplayMacMahonExceptionDialog(MacMahonException exception) {
        this.m_exception = exception;
    }

    public void show(Component parent) {
        this.getJDialog();
        this.getJTextAreaMessage().setText(this.m_exception.getInternalMessage());
        this.getJTextAreaStacktrace().setText(this.m_exception.getClientDisplayMessage());
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                DisplayMacMahonExceptionDialog.this.getJDialog().dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getJDialog().getRootPane().registerKeyboardAction(listener, keyStroke, 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DisplayMacMahonExceptionDialog.this.getJScrollPaneMessage().getVerticalScrollBar().setValue(0);
                DisplayMacMahonExceptionDialog.this.getJScrollPaneStacktrace().getVerticalScrollBar().setValue(0);
            }
        });
        this.getJDialog().setLocationRelativeTo(parent);
        this.getJDialog().getRootPane().setDefaultButton(this.getJButtonOk());
        this.getJDialog().setVisible(true);
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            this.jDialog = new JDialog();
            this.jDialog.setSize(new Dimension(552, 308));
            this.jDialog.setTitle(Messages.getString("DisplayMacMahonExceptionDialog.Title"));
            this.jDialog.setDefaultCloseOperation(2);
            this.jDialog.setModal(true);
            this.jDialog.setContentPane(this.getJContentPane());
        }
        return this.jDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 0.5;
            gridBagConstraints7.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints4.gridy = 0;
            this.jLabelMessage = new JLabel();
            this.jLabelMessage.setText(Messages.getString("DisplayMacMahonExceptionDialog.MessageLabel"));
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 10, 10, 10);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 0);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridy = 1;
            this.jLabelStacktrace = new JLabel();
            this.jLabelStacktrace.setText(Messages.getString("DisplayMacMahonExceptionDialog.StacktraceLabel"));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabelStacktrace, gridBagConstraints);
            this.jContentPane.add((Component)this.getJButtonOk(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJScrollPaneStacktrace(), gridBagConstraints21);
            this.jContentPane.add((Component)this.jLabelMessage, gridBagConstraints4);
            this.jContentPane.add((Component)this.getJScrollPaneMessage(), gridBagConstraints7);
        }
        return this.jContentPane;
    }

    private JTextArea getJTextAreaStacktrace() {
        if (this.jTextAreaStacktrace == null) {
            this.jTextAreaStacktrace = new JTextArea();
            this.jTextAreaStacktrace.setEditable(false);
            this.jTextAreaStacktrace.setTabSize(4);
            this.jTextAreaStacktrace.setFont(new Font("Dialog", 0, 10));
            this.jTextAreaStacktrace.setWrapStyleWord(true);
            this.jTextAreaStacktrace.setLineWrap(true);
        }
        return this.jTextAreaStacktrace;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(Messages.getString("DisplayMacMahonExceptionDialog.OK"));
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DisplayMacMahonExceptionDialog.this.getJDialog().dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JScrollPane getJScrollPaneStacktrace() {
        if (this.jScrollPaneStacktrace == null) {
            this.jScrollPaneStacktrace = new JScrollPane();
            this.jScrollPaneStacktrace.setViewportView(this.getJTextAreaStacktrace());
        }
        return this.jScrollPaneStacktrace;
    }

    private JScrollPane getJScrollPaneMessage() {
        if (this.jScrollPaneMessage == null) {
            this.jScrollPaneMessage = new JScrollPane();
            this.jScrollPaneMessage.setViewportView(this.getJTextAreaMessage());
        }
        return this.jScrollPaneMessage;
    }

    private JTextArea getJTextAreaMessage() {
        if (this.jTextAreaMessage == null) {
            this.jTextAreaMessage = new JTextArea();
            this.jTextAreaMessage.setEditable(false);
            this.jTextAreaMessage.setWrapStyleWord(true);
            this.jTextAreaMessage.setLineWrap(true);
        }
        return this.jTextAreaMessage;
    }
}

