/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.framework;

import de.cgerlach.macmahon.framework.MacMahonException;
import de.cgerlach.macmahon.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlPersistentObject {
    private static final SimpleDateFormat PERSISTENT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int m_xmlVersion;

    protected Element xmlCreateBooleanElement(Document document, String elementName, boolean value) {
        Element element = document.createElement(elementName);
        Text data = document.createTextNode(value ? "true" : "false");
        element.appendChild(data);
        return element;
    }

    protected Element xmlCreateCDataElement(Document document, String elementName, String cData) {
        Element element = document.createElement(elementName);
        CDATASection data = document.createCDATASection(cData);
        element.appendChild(data);
        return element;
    }

    protected Element xmlCreateDateElement(Document document, String elementName, Date dateValue) {
        Element element = document.createElement(elementName);
        Text data = document.createTextNode(PERSISTENT_DATE_FORMAT.format(dateValue));
        element.appendChild(data);
        return element;
    }

    protected Element xmlCreateIntegerElement(Document document, String elementName, int value) {
        return this.xmlCreateTextElement(document, elementName, Integer.toString(value));
    }

    protected Element xmlCreateTextElement(Document document, String elementName, String text) {
        Element element = document.createElement(elementName);
        Text data = document.createTextNode(text);
        element.appendChild(data);
        return element;
    }

    protected boolean xmlReadBooleanElement(Element parent, String elementName) {
        String text = this.xmlReadTextElement(parent, elementName);
        if (text == null) {
            return false;
        }
        return text.equals("true");
    }

    protected Date xmlReadDateElement(Element parent, String elementName) {
        String dateValueAsString = this.xmlReadTextElement(parent, elementName);
        if (dateValueAsString == null) {
            return null;
        }
        try {
            return PERSISTENT_DATE_FORMAT.parse(dateValueAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected int xmlReadIntegerElement(Element parent, String elementName) {
        String text = this.xmlReadTextElement(parent, elementName);
        if (text == null) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    protected List<Integer> xmlReadIntegerElements(Element parent, String elementName) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        NodeList nodes = parent.getElementsByTagName(elementName);
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getParentNode() == parent) {
                Text text = (Text)((Element)nodes.item(i)).getFirstChild();
                integers.add(Integer.parseInt(text.getNodeValue()));
            }
            ++i;
        }
        return integers;
    }

    protected String xmlReadTextElement(Element parent, String elementName) {
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() == 0 || nodes.item(0).getParentNode() != parent) {
            return null;
        }
        Text text = (Text)((Element)nodes.item(0)).getFirstChild();
        if (text == null) {
            return null;
        }
        return text.getNodeValue();
    }

    protected List<String> xmlReadTextElements(Element parent, String elementName) {
        ArrayList<String> strings = new ArrayList<String>();
        NodeList nodes = parent.getElementsByTagName(elementName);
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getParentNode() == parent) {
                Text text = (Text)((Element)nodes.item(i)).getFirstChild();
                strings.add(text.getNodeValue());
            }
            ++i;
        }
        return strings;
    }

    protected XmlPersistentObject xmlReadSinglePersistentObject(Element parent, String elementName, Class theClass) throws MacMahonException {
        XmlPersistentObject persistentObject;
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() == 0 || nodes.item(0).getParentNode() != parent) {
            return null;
        }
        try {
            persistentObject = (XmlPersistentObject)theClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MacMahonException("Exception on creating instance of '" + theClass.getName() + "'", e);
        }
        persistentObject.xmlRead((Element)nodes.item(0));
        return persistentObject;
    }

    protected List<XmlPersistentObject> xmlReadPersistentObjects(Element parent, String elementName, Class theClass) throws MacMahonException {
        ArrayList<XmlPersistentObject> objects = new ArrayList<XmlPersistentObject>();
        NodeList nodes = parent.getElementsByTagName(elementName);
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getParentNode() == parent) {
                XmlPersistentObject persistentObject;
                try {
                    persistentObject = (XmlPersistentObject)theClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new MacMahonException("Exception on creating instance of '" + theClass.getName() + "'", e);
                }
                persistentObject.xmlRead((Element)nodes.item(i));
                objects.add(persistentObject);
            }
            ++i;
        }
        return objects;
    }

    public abstract String xmlTagName();

    protected abstract int xmlTypeVersion();

    protected int xmlVersion() {
        return this.m_xmlVersion;
    }

    public void xmlRead(Element element) throws MacMahonException {
        this.m_xmlVersion = Integer.parseInt(element.getAttribute("typeversion"));
        if (this.m_xmlVersion > this.xmlTypeVersion()) {
            throw new MacMahonException(Messages.getString("XmlPersistentObject.AttemptToReadNewerFileVersionMessage", "MacMahon", "MacMahon", this.xmlTagName(), Integer.toString(this.xmlTypeVersion()), Integer.toString(this.m_xmlVersion)));
        }
    }

    public final Element xmlWrite(Document document) {
        return this.xmlWrite(this.xmlTagName(), document);
    }

    public final Element xmlWrite(String name, Document document) {
        this.m_xmlVersion = this.xmlTypeVersion();
        Element element = document.createElement(name);
        this.xmlWrite(element, document);
        return element;
    }

    protected void xmlWrite(Element element, Document document) {
        element.setAttribute("typeversion", Integer.toString(this.xmlVersion()));
    }
}

