/*
 * Decompiled with CFR 0.152.
 */
package de.cgerlach.macmahon.framework;

import de.cgerlach.macmahon.resources.Messages;
import java.io.PrintWriter;
import java.io.StringWriter;

public class MacMahonException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String m_internalMessage;

    public MacMahonException(String internalMessage) {
        super(internalMessage);
        this.m_internalMessage = internalMessage;
    }

    public MacMahonException(String internalMessage, Throwable cause) {
        super(internalMessage, cause);
        this.m_internalMessage = internalMessage;
    }

    public void appendClientDisplayMessage(PrintWriter pw) {
        pw.append(">>> MacMahon Exception <<<\n");
        pw.append(Messages.getString("MacMahonException.InternalMessageLabel")).append(" ").append(this.getInternalMessage());
        pw.append("\n").append(Messages.getString("MacMahonException.StacktraceLabel")).append("\n");
        this.printStackTrace(pw);
        if (this.getCause() != null) {
            pw.append("\n").append(Messages.getString("MacMahonException.CausedByLabel")).append("\n");
            if (this.getCause() instanceof MacMahonException) {
                ((MacMahonException)this.getCause()).appendClientDisplayMessage(pw);
            } else {
                this.getCause().printStackTrace(pw);
            }
        }
    }

    public String getClientDisplayMessage() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.appendClientDisplayMessage(pw);
        return sw.toString();
    }

    public String getInternalMessage() {
        return this.m_internalMessage;
    }
}

